package com.legalPersonMonitor.connections;

import com.legalPersonMonitor.config.ParameterConfig;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;


/**
 * @author gao
 */
public class SocketSender {

	public static byte[] sendSocketPackage(byte[] socketPackage) {
		DatagramPacket sendPacket = new DatagramPacket(socketPackage, socketPackage.length, ParameterConfig.ia, ParameterConfig.port);
		DatagramPacket receivePacket = new DatagramPacket(new byte[300], 300);
		try (DatagramSocket udpClient = new DatagramSocket()) {
			udpClient.send(sendPacket);
			udpClient.setSoTimeout(10000);
			udpClient.receive(receivePacket);
			return receivePacket.getData();
		} catch (SocketException e) {
			System.out.println("udpClient创建失败");
			e.printStackTrace();
		} catch (IOException e) {
			System.out.println("send/receive调用失败");
			e.printStackTrace();
		}
		return null;
	}

}
