package com.legalPersonMonitor.config;

import com.legalPersonMonitor.utils.FormatBytesUtil;

import java.net.InetAddress;
import java.net.UnknownHostException;

/**
 * Created by gaoxiang on 2018/1/22.
 */
public class ParameterConfig {
    public static final String strDN = "ywzd49";
    public static final String strDigestAlg = "sm3";

    // 终端号 2字节 共用
    public static final byte[] terminalId = new byte[] { 1, 2 };

    public static final byte[] certificateNumber = FormatBytesUtil.copyByteToAnother(new byte[32], new byte[] {121, 119, 122, 100, 52, 57 });

    // UDP Socket参数
    public static final String ip = "111.200.45.2";
    public static final int port = 8283;
    public static InetAddress ia = null;
    static {
        try {
            ia = InetAddress.getByName(ip);
        } catch (UnknownHostException e) {
            System.out.println("InetAddress 初始化失败，请检查Constans类中的host地址。");
            e.printStackTrace();
        }
    }
    /**
     *申请数据（ 经过签名）
     */
    public static final byte[] PREAUTH_BYTE=new byte[]{0, 1, 0, 0, 0, 0, 54, 0, 0, 0, 103, 116, 121, 120, 48, 49, 7, 8, 1, 2, 49, 52, 48, 51, 118, 49, 46, 48, 118, 49, 46, 48, 121, 119, 122, 100, 52, 57, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 71, 48, 69, 2, 32, 102, -43, -75, 109, -123, -84, 50, 125, -123, 31, 72, -13, -30, -94, 118, -100, -61, 18, -78, -83, 67, 53, -34, -23, 24, -27, -33, 59, -49, -117, 33, 56, 2, 33, 0, -111, -57, -112, 33, 74, -30, 53, 0, 112, -88, 38, 79, 74, 96, -21, 123, -31, -99, 60, -79, -67, 97, 58, 121, 86, -55, -59, -22, 53, -91, -75, -13};
    /**
     * 验签数据
     */
    public static final byte[] VERIFICANTION_BYTE=new byte[]{0, 1, 1, 0, 0, 0, -111, 0, 0, 0, 103, 116, 121, 120, 48, 49, 7, 8, 1, 2, 49, 52, 48, 51, 65, 48, 50, 36, 55, 56, -104, 87, 40, 88, 0, 68, 56, 69, 48, 66, 67, 57, 54, 65, 56, 49, 49, 65, 56, 66, 68, 0, 38, 48, 68, 2, 32, 23, 116, 45, -41, -70, 68, 116, -76, -80, -123, -39, 94, -93, -39, -44, -89, 127, 4, 94, -57, 65, -2, 51, -69, -58, -127, 92, -37, -85, -26, -121, 36, 2, 32, 34, -116, 9, 53, 89, -61, 101, -83, -20, 86, 75, -14, 9, 102, -85, -103, -125, -98, 107, -59, 50, -120, -111, -38, -102, -99, -51, 69, -75, 35, -30, -78, 114, 122, 102, 119, 48, 49, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 72, 48, 70, 2, 33, 0, -30, -37, 74, 44, 6, -12, 34, -114, -121, 19, 93, -104, -44, -49, 79, 51, 40, -118, 112, 92, -97, 21, 12, -101, 51, -74, -80, 10, 99, -116, -40, 125, 2, 33, 0, -35, 35, -79, -63, -49, -102, -114, -60, 9, -86, -85, -77, -46, -40, 101, -104, -52, 61, -116, 37, -20, -5, 23, 78, -47, 74, -15, -113, -84, -99, -110, -93, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

    /**
     *申请参数
     */
    public static final String PREAUTH_JSONSTR ="{\n" +
            "        \"appName\": \"国投盈信\",\n" +
            "        \"authCodeControlVersion\": \"v1.0.0.1\",\n" +
            "        \"authMode\": \"0x1F\",\n" +
            "        \"cardReaderVersion\": \"v1.0.0.1\",\n" +
            "        \"customerNumber\": \"gtyx01\",\n" +
            "        \"liveDetectionControlVersion\": \"v1.0.0.1\",\n" +
            "        \"timeStamp\": \"140322323233325\"\n" +
            "    }";
    public static final String AUTH_JSONSTR="{\n" +
            "     \"customerNumber\":\"gtyx01\",\n" +
            "     \"appName\":\"国投盈信\",\n" +
            "     \"timeStamp\":\"1516341838068\",\n" +
            "     \"businessSerialNumber\":\"413034243240499C2D\",\n" +
            "     \"authMode\":\"0x4f\",\n" +
            "     \"authApplyRetainData\":\n" +
            "\t      {\"name\":\"刘主雪\",\n" +
            "\t       \"idNumber\":\"142625199212162428\",\n" +
            "            \"enableDate\":\"20090716\",\n" +
            "            \"expireDate\":\"20190716\"},\n" +
            "     \"idcardAuthData\":\"0300F6A5BFC3ADCA157217E103C86BE0174B1CFBCBFA782CBF0DC0C8C249E2BB4BD5323031363034313831303434343039393301016C51895BE8902C7B004E1478767A40620020002000200020002000200020320030003100360030003400310038003200300031003900300037003100360090819995EE809BD6E9649F1BAC033AE23856DD281EA70670038A6740203500E2F6A5BFC3ADCA157217E103C86BE0174B1CFBCBFA782CBF0DC0C8C249E2BB4BD51FBED509A60453B82C41607299E0B5141E3BC7733CBDD5C9CB656A67D4EF66B8000130460221008F47E438B75E537763BA0F04533213C6BA4CBC411C182605481DDCE4A0C24A36022100B28185507A7D745A91DFAA5DB9D4316C06EB445D60E7241C533C7EAFF4BC2EBB4D4949423241594B4B6F45637A31554741515143413643434163677767674845416745414D5948524D49484F416745414D4430774D54454C4D416B474131554542684D43513034784554415042674E5642416F544345644D5131524A524441784D513877445159445651514445775A4854454E424D444543434839367753726955436E504D41304743537142484D395641594974417755414248737765514968414F56446453376E566A46466D4F676F4C626F2B32696C38596E3073424D4E38532B48634D347652707968784169425833326C385554782F693079565A4E3161672B432F675835342F345974464E7669734D344358526E6C4B515167724E5945486F37527A7869493032707A6C67725A6F613854754966426353736F2B476A487A76574A5863304545436A4D3043563465767951656F4171366A32724952517767656F4743697142484D39564267454541674577435159484B6F45637A3155426149434230497470753546596D4A6B7556544B516863413237584B58624A59474F3176582B48334869676942414838376542536C676E70577A6D5738455969613064725658514F362B3463587A6869614C6269446B687A4A6D36785559495A3978455757444A6E493757565539416B527A49365172436A347A396A54772F534232725446594B6A492F694A7058397138615561584C48444237586D65412B793534652B357764746974796D72556679577945773331315448383530517673793849496478346A78364367563956326B6858796938463077536F777A652B3053744F4C7739736A6C6C70356F6450316567376E37526871365A6B396C36414A61664E4A31714D626B6C7979654E682B494434364775417361456D75673D\",\n" +
            "      \"authCode\":\"B8014D4949425267594B4B6F45637A31554741515143413643434154597767674579416745414D5948524D49484F416745414D4430774D54454C4D416B474131554542684D43513034784554415042674E5642416F544345644D5131524A524441784D513877445159445651514445775A4854454E424D444543434839367753726955436E504D41304743537142484D395641594974417755414248737765514967655A476B705077427839706F6754666B464C554F322B444B6F52676E49566F3466676678646A574B716C634349514362756573732F6C702F54516E4C56366B5A55374B796C33764E6A7255585550325463457A345777552F32515167684E704F41426E4354436E49516A5A6E57747032654245574F434435327550514F6A56314E7462543541514545454F42355045356F797673616A58752B78315050386B775751594B4B6F45637A315547415151434154414A4267637167527A505651466F674544636D386732346D326936556E4B41316342536D456A6F4E587846336567715435432F476F436E674B2B4A6A506C566B634147535034654F6E70554C46696749697664785369563544575862787A516C4B58466278340000\",\n" +
            "     \"photoData\":\"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\"\n" +
            "     }";



}
