package com.legalPersonMonitor.auth;


import com.legalPersonMonitor.config.AuthModeConfig;
import com.legalPersonMonitor.config.ParameterConfig;
import com.legalPersonMonitor.config.TaskConfig;
import com.legalPersonMonitor.data.*;
import com.legalPersonMonitor.utils.FormatBytesUtil;
import sun.misc.BASE64Decoder;
import java.io.IOException;


/**
 * Created by gaoxiang on 2018/1/22.
 */

public class Authentication {
    /**
     * businessSerialNumberByte 流水号 byte[] 类型
     * customerId 客户号 8字节 共用
     * terminalId 终端号 2字节 共用     1.0写死   2.0用应用名称 FormatBytesUtil.hexStringToBytes(preAuthBean.getAppName());
     * certificateNumber 证书标识 or 业务站点
     * authApplyRetainData 客户端传入认证保留数据String
     * authRetainTwoDataDesign 传入1.0 认证平台认证保留 2项数据 ( 已加密)
     * authRetainFourDataDesign 传入1.0 认证平台认证保留 4项数据 ( 已加密)
     * idcardAuthDataBase64DecodeAfter 传入1.0 认证平台认证ID验证数据( 已加密)
     * pictureAuthDataBase64DecodeAfter 传入1.0 认证平台认证人像 ( 已加密)
     * authCodeDataBase64DecodeAfter 传入1.0 认证平台认证认证码数据 ( 已加密)
     * mode 认证模式
     * authDate 根据模式组合成的数据
     * version 协议版本 2字节 0x0001 共用
     * commandType 命令类型 1字节 0x00(请求)0x01(应答) 共用
     * command 命令 1字节 0x00(身份认证申请)0x01(身份认证) 修改值的内容为1
     * commandContent 命令内容 1字节 保留 0x00 共用
     * operation  操作 1字节 保留 0x00 共用
     * auSPData  身份认证  二包 Socket数据报文
     * authReturn  身份认证 1.0 平台二包 响应结果
     * checkSignResult 验签是否正确
     */
    private byte[] businessSerialNumberByte;
    private byte[] customerId;
    private byte[] terminalId;
    private byte[] timeStamp;
    private byte[] certificateNumber;
    private byte[] authRetainTwoDataDesign=null;
    private byte[] idcardAuthDataBase64DecodeAfter=null;
    private byte[] pictureAuthDataBase64DecodeAfter=null;
    private byte[] authCodeDataBase64DecodeAfter=null;
    private byte[] authDataBase64Decode=null;
    private byte[] authDate=null;
    private byte[] version=new byte[]{0, 1};
    private byte[] commandType = new byte[]{0};
    private byte[] command = new byte[]{1};
    private byte[] commandContent = new byte[]{0};
    private byte[] operation = new byte[]{0};
    private byte[] auSPData;
    private byte[] customerId_Length=new byte[] { 1, 2, 3, 4, 5, 6, 7, 8 };
    private byte[] timeStamp_Length=new byte[] { 1, 2,3,4};

    public  byte[] authExecute(AuthRequestBean authRequestBean){
        customerId= FormatBytesUtil.getBytesFromString(customerId_Length,authRequestBean.getCustomerNumber());
        terminalId= ParameterConfig.terminalId;
        timeStamp= FormatBytesUtil.getBytesFromString(timeStamp_Length,authRequestBean.getTimeStamp());
        businessSerialNumberByte=FormatBytesUtil.hexStringToBytes(authRequestBean.getBusinessSerialNumber());
        certificateNumber=ParameterConfig.certificateNumber;
        getauthRetainTwoDataDesign(authRequestBean.getAuthApplyRetainData());
        idcardAuthDataBase64DecodeAfter=dataProcessingBase64Decode(TaskConfig.TASK_ID_DATA,authRequestBean.getIdcardAuthData());
        authCodeDataBase64DecodeAfter=dataProcessingBase64Decode(TaskConfig.TASK_AUTHCODE_DATA,authRequestBean.getAuthCode());
        pictureAuthDataBase64DecodeAfter=dataProcessingBase64Decode(TaskConfig.TASK_PIC_DATA,authRequestBean.getPhotoData());
        AuthData au_0X4F = new AuthData(customerId, terminalId, timeStamp,businessSerialNumberByte, AuthModeConfig.IDENTITYMODEL_0X4F,
                        idcardAuthDataBase64DecodeAfter, authCodeDataBase64DecodeAfter, pictureAuthDataBase64DecodeAfter, authRetainTwoDataDesign, certificateNumber);
        authDate = au_0X4F.getAuthenticationData();
        SocketPackage auSP = new SocketPackage(version, commandType, command, commandContent, operation, authDate);
        auSPData = auSP.getSocketPackage();
        return auSPData;
    }

    public void getauthRetainTwoDataDesign(AuthApplyRetainBean retainDate){
        String name=retainDate.getName();
        String idNumber=retainDate.getIdNumber();
        authRetainTwoDataDesign = new RetainData(name, idNumber, null, null).getReservasionBytes();
    }
    private byte[] excuteBase64Decode(String encodeData) throws IOException {
       byte[] originalData= new BASE64Decoder().decodeBuffer(encodeData);
       return originalData;
    }
    private byte[] dataProcessingBase64Decode(String dataName,String data ){
        switch (dataName){
            case TaskConfig.TASK_ID_DATA:
                authDataBase64Decode=FormatBytesUtil.hexStringToBytes(data);
                break;
            case TaskConfig.TASK_AUTHCODE_DATA:
                authDataBase64Decode=FormatBytesUtil.hexStringToBytes(data);
                break;
            case TaskConfig.TASK_PIC_DATA:
                try {
                    authDataBase64Decode = excuteBase64Decode(data);
                } catch (IOException e) {
                    e.printStackTrace();
                }
                break;
        }
        return authDataBase64Decode;
    }
}
