/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.tsa.client;

import cn.com.jit.assp.css.client.util.Base64;
import cn.com.jit.assp.css.util.ResponseSet;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TSAVerifyResult {
    private static Log LOGGER = LogFactory.getLog(TSAVerifyResult.class);
    private ResponseSet response = null;

    protected TSAVerifyResult(ResponseSet response) {
        this.response = response;
    }

    public Date getSignedTime() {
        Map infoMap = this.response.getDsBaseInfoMap();
        try {
            if (infoMap != null && infoMap.get("signedTime".toLowerCase()) != null) {
                String t = (String)infoMap.get("signedTime".toLowerCase());
                SimpleDateFormat dateParser = new SimpleDateFormat("yyyyMMddHHmmssz", new DateFormatSymbols(Locale.ENGLISH));
                Date signedTime = dateParser.parse(t);
                return signedTime;
            }
        }
        catch (ParseException e) {
            LOGGER.error((Object)("Failure to parser signTime from: [" + (String)infoMap.get("signedTime".toLowerCase()) + "]"), (Throwable)e);
            throw new RuntimeException("Failure to parser signTime from: [" + (String)infoMap.get("signedTime".toLowerCase()) + "]");
        }
        return null;
    }

    public Date getSignedTimeByMS() {
        Map infoMap = this.response.getDsBaseInfoMap();
        try {
            if (infoMap != null && infoMap.get("signedTimeByMS".toLowerCase()) != null) {
                String t = (String)infoMap.get("signedTimeByMS".toLowerCase());
                SimpleDateFormat dateParser = new SimpleDateFormat("yyyyMMddHHmmssSSSS", new DateFormatSymbols(Locale.ENGLISH));
                Date signedTime = dateParser.parse(t);
                return signedTime;
            }
        }
        catch (ParseException e) {
            LOGGER.error((Object)("Failure to parser signedTimeByMS from: [" + (String)infoMap.get("signedTimeByMS".toLowerCase()) + "]"), (Throwable)e);
            throw new RuntimeException("Failure to parser signedTimeByMS from: [" + (String)infoMap.get("signedTimeByMS".toLowerCase()) + "]");
        }
        return null;
    }

    public String getSignerSubject() {
        HashMap map = this.response.getDsCertInfo();
        return (String)map.get("subjectdn");
    }

    public String getIssuer() {
        HashMap map = this.response.getDsCertInfo();
        return (String)map.get("issuerdn");
    }

    public String getDigestAlg() {
        Map infoMap = this.response.getDsBaseInfoMap();
        return (String)infoMap.get("digestalg");
    }

    public String getSignerCertSerialNumber() {
        HashMap infoMap = this.response.getDsCertInfo();
        return (String)infoMap.get("serialnumber");
    }

    public byte[] getData() {
        return Base64.decode(this.response.getPlainData());
    }
}

