/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.tsa.client;

import cn.com.jit.assp.css.client.CSSException;
import cn.com.jit.assp.css.client.communication.RequestClient;
import cn.com.jit.assp.css.client.log.ErrorProcess;
import cn.com.jit.assp.css.client.util.Base64;
import cn.com.jit.assp.css.client.util.SecurityUtil;
import cn.com.jit.assp.css.client.util.UtilTool;
import cn.com.jit.assp.css.util.ResponseSet;
import cn.com.jit.assp.css.util.parser.ResponseParser;
import cn.com.jit.tsa.client.TSAClient;
import cn.com.jit.tsa.client.TSAException;
import cn.com.jit.tsa.client.TSASignedResult;
import cn.com.jit.tsa.client.TSAVerifyResult;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpTSAClientImpl
extends TSAClient {
    private static Log LOGGER = LogFactory.getLog(HttpTSAClientImpl.class);
    private static final String VERSION_REQ_XML = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><DSignContext Version =\"2.0\"><Request svcid=\"doDigest\"><ParaInfo><PlainText>cGxhaW5UZXh0VGVzdA==</PlainText><DigestALG>MD5</DigestALG></ParaInfo></Request></DSignContext>";
    private String serverURL = null;
    private String tsaType;
    private ErrorProcess errprocess = null;

    public HttpTSAClientImpl(String serverURL) {
        this.serverURL = serverURL;
    }

    public void closeSession() throws TSAException {
    }

    public void openSession() throws TSAException {
    }

    public String getTsaType() {
        return this.tsaType;
    }

    public void setTsaType(String tsaType) {
        this.tsaType = tsaType;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getServerVersion() throws TSAException {
        String string;
        HttpURLConnection httpurlconnection;
        block18: {
            httpurlconnection = null;
            OutputStream outputstream = null;
            try {
                URL url = new URL(this.serverURL);
                httpurlconnection = (HttpURLConnection)url.openConnection();
                httpurlconnection.setDoOutput(true);
                httpurlconnection.setUseCaches(false);
                httpurlconnection.setRequestMethod("POST");
                httpurlconnection.setRequestProperty("Content-Type", "text/xml;charset=UTF-8");
                int i = VERSION_REQ_XML.getBytes("UTF-8").length;
                httpurlconnection.setRequestProperty("Content-Length", Integer.toString(i));
                outputstream = httpurlconnection.getOutputStream();
                outputstream.write(VERSION_REQ_XML.getBytes("UTF-8"));
                outputstream.flush();
            }
            catch (Exception e1) {
                try {
                    if (outputstream != null) {
                        outputstream.close();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                try {
                    if (httpurlconnection != null) {
                        httpurlconnection.disconnect();
                    }
                }
                catch (Exception e3) {
                    // empty catch block
                }
                LOGGER.error((Object)"errorCode: -10702003, errorMessage: \u53d1\u9001\u8bf7\u6c42\u8d85\u65f6\uff01", (Throwable)e1);
                throw new TSAException("-10702003", "\u53d1\u9001\u8bf7\u6c42\u8d85\u65f6\uff01", e1);
            }
            try {
                try {
                    String serverVersion;
                    InputStream in = httpurlconnection.getInputStream();
                    ByteArrayOutputStream bout = new ByteArrayOutputStream();
                    byte[] content = new byte[1024];
                    int length = -1;
                    while ((length = in.read(content)) > 0) {
                    }
                    string = serverVersion = httpurlconnection.getHeaderField("SS-Server-Version");
                    Object var10_14 = null;
                    if (outputstream == null) break block18;
                }
                catch (Exception e) {
                    LOGGER.error((Object)"errorCode: -10702003, errorMessage: \u53d1\u9001\u8bf7\u6c42\u8d85\u65f6\uff01", (Throwable)e);
                    throw new TSAException("-10702003", "\u53d1\u9001\u8bf7\u6c42\u8d85\u65f6\uff01", e);
                }
            }
            catch (Throwable throwable) {
                Object var10_15 = null;
                if (outputstream != null) {
                    try {
                        outputstream.close();
                    }
                    catch (IOException ioe) {
                        LOGGER.error((Object)"errorCode: -10702003, errorMessage: \u53d1\u9001\u8bf7\u6c42\u8d85\u65f6\uff01", (Throwable)ioe);
                        throw new TSAException("-10702003", "\u53d1\u9001\u8bf7\u6c42\u8d85\u65f6\uff01", ioe);
                    }
                }
                if (httpurlconnection == null) throw throwable;
                httpurlconnection.disconnect();
                throw throwable;
            }
            try {}
            catch (IOException ioe) {
                LOGGER.error((Object)"errorCode: -10702003, errorMessage: \u53d1\u9001\u8bf7\u6c42\u8d85\u65f6\uff01", (Throwable)ioe);
                throw new TSAException("-10702003", "\u53d1\u9001\u8bf7\u6c42\u8d85\u65f6\uff01", ioe);
            }
            outputstream.close();
        }
        if (httpurlconnection == null) return string;
        httpurlconnection.disconnect();
        return string;
    }

    public byte[] requestTimeStamp(String digestAlgorithm, byte[] source) throws TSAException {
        TSASignedResult result = this.signTimeStamp(digestAlgorithm, source);
        return result.getSignedData();
    }

    public TSASignedResult signTimeStamp(String digestAlgorithm, byte[] source) throws TSAException {
        return this.requestTimeStamp(digestAlgorithm, source, false);
    }

    public TSASignedResult signTimeStampByDigest(String digestAlgorithm, byte[] source) throws TSAException {
        return this.requestTimeStamp(digestAlgorithm, source, true);
    }

    private TSASignedResult requestTimeStamp(String digestAlgorithm, byte[] source, boolean isDigest) throws TSAException {
        byte[] sourceDigest;
        this.errprocess = ErrorProcess.getInstance();
        if ("rfc3161".equals(this.tsaType)) {
            if (!(isDigest || "SM3".equals(digestAlgorithm.toUpperCase()) || "".equals(digestAlgorithm))) {
                try {
                    sourceDigest = SecurityUtil.doDigest(source, digestAlgorithm);
                }
                catch (Exception e) {
                    LOGGER.error((Object)("TSA signature occuer error: do local digest TSAType [" + this.tsaType + "]"), (Throwable)e);
                    throw new TSAException("TSA signature occuer error: do local digest TSAType [" + this.tsaType + "]");
                }
            } else {
                sourceDigest = source;
            }
        } else {
            sourceDigest = source;
        }
        StringBuffer buf = new StringBuffer();
        buf.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>");
        buf.append("<DSignContext Version =\"1.0\">");
        buf.append("<Request svcid=\"doTsa\">");
        buf.append("<PlainData type=\"" + this.tsaType + "\">" + Base64.encodeBytes(sourceDigest) + "</PlainData>");
        buf.append("<DSDigestALG>" + digestAlgorithm + "</DSDigestALG>");
        buf.append("</Request>");
        buf.append("</DSignContext>");
        try {
            String responseXML = RequestClient.sendMessage(new URL(this.serverURL), buf.toString(), "");
            ResponseParser respParser = new ResponseParser();
            ResponseSet response = respParser.parserXML(responseXML);
            String errcode = response.getErrCode();
            boolean result = response.isSucceed();
            if (result) {
                String dsdata = response.getSignedData();
                try {
                    if (dsdata == null) {
                        dsdata = "";
                    }
                    byte[] signedData = Base64.decode(UtilTool.convertBase64(dsdata.getBytes()));
                    return new TSASignedResult(response.getTsaSid(), signedData);
                }
                catch (Exception ex1) {
                    LOGGER.error((Object)"errorCode: -10701007, errorMessage: Base64\u89e3\u7801\u65f6\u51fa\u73b0\u9519\u8bef", (Throwable)ex1);
                    throw new CSSException("-10701007", this.getClass().getName() + "." + "requestTimeStamp", "Base64\u89e3\u7801\u65f6\u51fa\u73b0\u9519\u8bef", ex1.toString());
                }
            }
            String errdic = this.errprocess.getErrDesc(errcode, ErrorProcess.vDefServerInfo);
            throw new CSSException(errcode, this.getClass().getName() + "." + "requestTimeStamp", errdic);
        }
        catch (CSSException e) {
            throw new TSAException(e.getCode(), e.getDescription(), e);
        }
        catch (MalformedURLException e) {
            throw new TSAException("-10702201", "\u53c2\u6570\u4e0d\u5408\u6cd5\uff0curl\u8f93\u5165\u4e3a\u7a7a\uff0c\u8bf7\u8f93\u5165url", e);
        }
    }

    public TSAVerifyResult verifyTimeStamp(byte[] tsaData) throws TSAException {
        this.errprocess = ErrorProcess.getInstance();
        StringBuffer buf = new StringBuffer();
        buf.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>");
        buf.append("<DSignContext Version =\"1.0\">");
        buf.append("<Request svcid=\"verifyTsa\">");
        buf.append("<TsaData type=\"" + this.tsaType + "\">" + Base64.encodeBytes(tsaData) + "</TsaData>");
        buf.append("<RequestRtnContent>");
        buf.append("<DSBaseInfo>");
        buf.append("<Item name=\"digestalg\"/>");
        buf.append("<Item name=\"plaindata\"/>");
        buf.append("</DSBaseInfo>");
        buf.append("<DSCertBaseInfo>");
        buf.append("<Item name=\"version\"/>");
        buf.append("<Item name=\"issuerdn\"/>");
        buf.append("<Item name=\"subjectdn\"/>");
        buf.append("<Item name=\"serialnumber\"/>");
        buf.append("</DSCertBaseInfo>");
        buf.append("</RequestRtnContent>");
        buf.append("</Request>");
        buf.append("</DSignContext>");
        try {
            String responseXML = RequestClient.sendMessage(new URL(this.serverURL), buf.toString(), "");
            ResponseParser respParser = new ResponseParser();
            ResponseSet response = respParser.parserXML(responseXML);
            String errcode = response.getErrCode();
            boolean result = response.isSucceed();
            if (result) {
                return new TSAVerifyResult(response);
            }
            String errdic = this.errprocess.getErrDesc(errcode, ErrorProcess.vDefServerInfo);
            throw new CSSException(errcode, this.getClass().getName() + "." + "requestTimeStamp", errdic);
        }
        catch (CSSException e) {
            throw new TSAException(e.getCode(), e.getDescription(), e);
        }
        catch (MalformedURLException e) {
            throw new TSAException("-10702201", "\u53c2\u6570\u4e0d\u5408\u6cd5\uff0curl\u8f93\u5165\u4e3a\u7a7a\uff0c\u8bf7\u8f93\u5165url", e);
        }
    }

    public byte[] findTimeStampByID(String tsaID) throws TSAException {
        this.errprocess = ErrorProcess.getInstance();
        StringBuffer buf = new StringBuffer();
        buf.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>");
        buf.append("<DSignContext Version =\"1.0\">");
        buf.append("<Request svcid=\"getTsa\">");
        buf.append("<Data type=\"sid\">" + tsaID + "</Data>");
        buf.append("</Request>");
        buf.append("</DSignContext>");
        try {
            String responseXML = RequestClient.sendMessage(new URL(this.serverURL), buf.toString(), "");
            ResponseParser respParser = new ResponseParser();
            ResponseSet response = respParser.parserXML(responseXML);
            String errcode = response.getErrCode();
            boolean result = response.isSucceed();
            if (result) {
                String dsdata = response.getSignedData();
                try {
                    if (dsdata == null) {
                        dsdata = "";
                    }
                    return Base64.decode(UtilTool.convertBase64(dsdata.getBytes()));
                }
                catch (Exception ex1) {
                    LOGGER.error((Object)"errorCode: -10701007, errorMessage: Base64\u89e3\u7801\u65f6\u51fa\u73b0\u9519\u8bef", (Throwable)ex1);
                    throw new CSSException("-10701007", this.getClass().getName() + "." + "findTimeStampByID", "Base64\u89e3\u7801\u65f6\u51fa\u73b0\u9519\u8bef", ex1.toString());
                }
            }
            String errdic = this.errprocess.getErrDesc(errcode, ErrorProcess.vDefServerInfo);
            throw new CSSException(errcode, this.getClass().getName() + "." + "requestTimeStamp", errdic);
        }
        catch (CSSException e) {
            throw new TSAException(e.getCode(), e.getDescription(), e);
        }
        catch (MalformedURLException e) {
            throw new TSAException("-10702201", "\u53c2\u6570\u4e0d\u5408\u6cd5\uff0curl\u8f93\u5165\u4e3a\u7a7a\uff0c\u8bf7\u8f93\u5165url", e);
        }
    }
}

