/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.assp.encrypt;

import cn.com.jit.assp.css.client.CSSException;
import cn.com.jit.assp.css.client.Config;
import cn.com.jit.assp.css.client.HttpRespResult;
import cn.com.jit.assp.css.client.HttpStreamClient;
import cn.com.jit.assp.css.client.SymmEncryptClient;
import cn.com.jit.assp.css.client.util.Base64;
import cn.com.jit.assp.css.client.util.CommUtil;
import cn.com.jit.assp.css.util.ResponseSet;
import cn.com.jit.assp.dsign.DSignTools;
import cn.com.jit.assp.encrypt.SymmEncryptRequestSet;
import cn.com.jit.assp.encrypt.SymmEncryptResponseSet;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SymmEncrypt {
    private static final Log log = LogFactory.getLog(SymmEncrypt.class);
    private static Config config;
    private SymmEncryptClient client;
    private String errorCode;
    private String errorMessage;

    public SymmEncrypt(String filePath) {
        try {
            if (config == null) {
                config = Config.getInstance();
                config.loadConfig(filePath, false);
            }
        }
        catch (CSSException e) {
            log.error((Object)("Initinize Config occure error" + e.getMessage()), (Throwable)e);
        }
        this.client = new SymmEncryptClient(config);
    }

    public static void reloadSymmEncrypt() {
        config = null;
    }

    public String symmEncrypt(byte[] symmKeyNo, String strFileNameIn, String strFileNameOut) {
        if (!this.encAlg()) {
            this.errorCode = "-10703217";
            this.errorMessage = "\u52a0\u5bc6\u64cd\u4f5c\uff1a\u5bc6\u94a5\u7b97\u6cd5\u914d\u7f6e\u4e0d\u6b63\u786e";
        }
        if (!this.encAlgsizs(symmKeyNo)) {
            this.errorCode = "-10703216";
            this.errorMessage = "\u52a0\u5bc6\u64cd\u4f5c\uff1a\u5bc6\u94a5\u957f\u5ea6\u4e0e\u914d\u7f6e\u6587\u4ef6\u4e0d\u540c";
        }
        if (symmKeyNo == null || symmKeyNo.length == 0) {
            this.errorCode = "-10703200";
            this.errorMessage = "\u52a0\u5bc6\u64cd\u4f5c\uff1a\u5bf9\u79f0\u5bc6\u94a5\u53f7\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (CommUtil.isNull(strFileNameIn)) {
            this.errorCode = "-10703214";
            this.errorMessage = "\u52a0\u5bc6\u64cd\u4f5c\uff1a\u52a0\u5bc6\u539f\u6587\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (this.errorCode != null && this.errorCode.trim().length() > 0) {
            return null;
        }
        int sizePerBlock = this.getSizePerBlock();
        try {
            if (sizePerBlock != 0) {
                this.bigSymmEncrypt(symmKeyNo, strFileNameIn, strFileNameOut);
            } else {
                this.symmEncryptDelivery(symmKeyNo, strFileNameIn, strFileNameOut);
            }
            if (this.errorCode != null) {
                return null;
            }
            return "";
        }
        catch (CSSException e) {
            this.errorCode = e.getCode();
            this.errorMessage = e.getDescription();
            return null;
        }
    }

    private String symmEncryptDelivery(byte[] symmKeyNo, String strFileNameIn, String strFileNameOut) {
        if (!this.encAlg()) {
            this.errorCode = "-10703217";
            this.errorMessage = "\u52a0\u5bc6\u64cd\u4f5c\uff1a\u5bc6\u94a5\u7b97\u6cd5\u914d\u7f6e\u4e0d\u6b63\u786e";
        }
        if (symmKeyNo == null || symmKeyNo.length == 0) {
            this.errorCode = "-10703200";
            this.errorMessage = "\u52a0\u5bc6\u64cd\u4f5c\uff1a\u5bf9\u79f0\u5bc6\u94a5\u53f7\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (CommUtil.isNull(strFileNameIn)) {
            this.errorCode = "-10703214";
            this.errorMessage = "\u52a0\u5bc6\u64cd\u4f5c\uff1a\u52a0\u5bc6\u539f\u6587\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (!this.encAlgsizs(symmKeyNo)) {
            this.errorCode = "-10703216";
            this.errorMessage = "\u52a0\u5bc6\u64cd\u4f5c\uff1a\u5bc6\u94a5\u957f\u5ea6\u4e0e\u914d\u7f6e\u6587\u4ef6\u4e0d\u540c";
        }
        if (this.errorCode != null && this.errorCode.trim().length() > 0) {
            return null;
        }
        ArrayList<String> alData = new ArrayList<String>();
        alData.add(strFileNameIn);
        byte[] symmEncryptResult = null;
        try {
            symmEncryptResult = this.symmEncryptFile(symmKeyNo, DSignTools.generateSignDataXmlSB(alData, "F").toString().getBytes());
            if (this.errorCode == null || "".equals(this.errorCode)) {
                if (null == strFileNameOut || 0 == strFileNameOut.length()) {
                    return null;
                }
                DSignTools.writeByteToFile(strFileNameOut, Base64.encode(symmEncryptResult));
                return "";
            }
            return null;
        }
        catch (CSSException e) {
            this.errorCode = e.getCode();
            this.errorMessage = e.getDescription();
            return null;
        }
    }

    public byte[] symmEncrypt(String symmKeyNo, byte[] plainData) {
        if (symmKeyNo == null || symmKeyNo.trim().length() == 0) {
            this.errorCode = "-10703200";
            this.errorMessage = "\u52a0\u5bc6\u64cd\u4f5c\uff1a\u5bf9\u79f0\u5bc6\u94a5\u53f7\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (plainData == null || plainData.length <= 0) {
            this.errorCode = "-10703201";
            this.errorMessage = "\u52a0\u5bc6\u64cd\u4f5c\uff1a\u52a0\u5bc6\u539f\u6587\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (this.errorCode != null && this.errorCode.trim().length() > 0) {
            return null;
        }
        if (plainData.length < config.getBigdataLimit()) {
            SymmEncryptRequestSet request = new SymmEncryptRequestSet();
            request.setSymmKeyNo(symmKeyNo);
            request.setPlainData(Base64.encodeBytes(plainData));
            ResponseSet response = this.client.requestSymmEncrypt(request);
            if (response instanceof SymmEncryptResponseSet) {
                SymmEncryptResponseSet symmResponse = (SymmEncryptResponseSet)response;
                String encryptData = symmResponse.getEncryptData();
                if (encryptData != null && encryptData.trim().length() > 0) {
                    return Base64.decode(encryptData);
                }
                this.errorCode = symmResponse.getErrorCode();
                this.errorMessage = symmResponse.getErrorMessage();
            } else {
                this.errorCode = response.getErrCode();
                this.errorMessage = response.getErrDesc();
            }
        } else {
            HttpStreamClient client = new HttpStreamClient();
            HttpRespResult result = null;
            HashMap<String, String> httpHeader = new HashMap<String, String>();
            httpHeader.put("connection", "Close");
            httpHeader.put("totallength", plainData.length + "");
            httpHeader.put("certversion", "1.0");
            httpHeader.put("businesstype", "symmencrypt");
            httpHeader.put("messagetype", "http");
            httpHeader.put("symmkeyid", symmKeyNo);
            try {
                result = client.SymmEncryptByHttpRespResult(httpHeader, plainData);
                return result.getRespBody();
            }
            catch (CSSException e) {
                this.errorCode = e.getCode();
                this.errorMessage = e.getDescription();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] symmEncryptFile(byte[] symmKeyNo, byte[] plainData) {
        if (symmKeyNo == null || symmKeyNo.length == 0) {
            this.errorCode = "-10703200";
            this.errorMessage = "\u52a0\u5bc6\u64cd\u4f5c\uff1a\u5bf9\u79f0\u5bc6\u94a5\u53f7\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (plainData == null || plainData.length <= 0) {
            this.errorCode = "-10703201";
            this.errorMessage = "\u52a0\u5bc6\u64cd\u4f5c\uff1a\u52a0\u5bc6\u539f\u6587\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (this.errorCode != null && this.errorCode.trim().length() > 0) {
            return null;
        }
        if (plainData.length < config.getBigdataLimit()) {
            SymmEncryptRequestSet request = new SymmEncryptRequestSet();
            request.setSymmKeyNo(new String(Base64.encode(symmKeyNo)));
            request.setPlainData(Base64.encodeBytes(plainData));
            request.setEncAlg(config.getEncAlg());
            request.setEncryptMode(config.getEncryptMode());
            ResponseSet response = this.client.requestSymmEncrypt(request);
            if (response instanceof SymmEncryptResponseSet) {
                SymmEncryptResponseSet symmResponse = (SymmEncryptResponseSet)response;
                String encryptData = symmResponse.getEncryptData();
                if (encryptData != null && encryptData.trim().length() > 0) {
                    return Base64.decode(encryptData);
                }
                this.errorCode = symmResponse.getErrorCode();
                this.errorMessage = symmResponse.getErrorMessage();
            } else {
                this.errorCode = response.getErrCode();
                this.errorMessage = response.getErrDesc();
            }
        } else {
            HttpStreamClient client = new HttpStreamClient();
            HttpRespResult result = null;
            HashMap<String, String> httpHeader = new HashMap<String, String>();
            httpHeader.put("connection", "Close");
            httpHeader.put("totallength", plainData.length + "");
            httpHeader.put("certversion", "1.0");
            httpHeader.put("businesstype", "symmencrypt");
            httpHeader.put("messagetype", "http");
            httpHeader.put("exportsymmkey", new String(Base64.encode(symmKeyNo)));
            httpHeader.put("symmalg", config.getEncAlg());
            httpHeader.put("encryptmode", config.getEncryptMode());
            try {
                result = client.SymmEncryptByHttpRespResult(httpHeader, plainData);
                byte[] encryptData = result.getRespBody();
                return encryptData;
            }
            catch (CSSException e) {
                this.errorCode = e.getCode();
                this.errorMessage = e.getDescription();
            }
        }
        return null;
    }

    private boolean encAlg() {
        if ("ecb".equalsIgnoreCase(config.getEncryptMode()) || "cbc".equalsIgnoreCase(config.getEncryptMode())) {
            return "des".equalsIgnoreCase(config.getEncAlg()) || "des3".equalsIgnoreCase(config.getEncAlg()) || "aes".equalsIgnoreCase(config.getEncAlg()) || "sm1".equalsIgnoreCase(config.getEncAlg()) || "sm4".equalsIgnoreCase(config.getEncAlg()) || "rc4".equalsIgnoreCase(config.getEncAlg());
        }
        return false;
    }

    private boolean encAlgsizs(byte[] symmKeyNo) {
        return !("des".equalsIgnoreCase(config.getEncAlg()) ? 8 != symmKeyNo.length : ("des3".equalsIgnoreCase(config.getEncAlg()) ? 24 != symmKeyNo.length : ("aes".equalsIgnoreCase(config.getEncAlg()) ? 16 != symmKeyNo.length : ("sm1".equalsIgnoreCase(config.getEncAlg()) ? 16 != symmKeyNo.length : ("sm4".equalsIgnoreCase(config.getEncAlg()) ? 16 != symmKeyNo.length : symmKeyNo.length % 8 != 0)))));
    }

    public String bigSymmEncrypt(byte[] symmKeyNo, String oriFilePath, String encryptFilePath) throws CSSException {
        long beginTime = System.currentTimeMillis();
        File oriFile = new File(oriFilePath);
        int sizePerBlock = this.getSizePerBlock();
        long blockNumber = this.getBlockNumber(oriFile, sizePerBlock);
        try {
            this.saveResToFile(encryptFilePath, this.getHeadContent(sizePerBlock, blockNumber), true);
        }
        catch (IOException e) {
            this.errorCode = "-10700001";
            this.errorMessage = "\u6ca1\u6709\u627e\u5230\u76f8\u5e94\u7684\u6587\u4ef6";
        }
        this.readAndWriteByBlock(symmKeyNo, oriFile, encryptFilePath, sizePerBlock, blockNumber);
        long endTime = System.currentTimeMillis();
        System.out.println("\u5bf9\u79f0\u52a0\u5bc6\u4e1a\u52a1\uff0c\u8017\u65f6\uff1a" + (endTime - beginTime) + " ms");
        return this.errorCode;
    }

    private void readAndWriteByBlock(byte[] symmKeyNo, File oriFile, String encryptFilePath, int sizePerBlock, long blockNumber) {
        RandomAccessFile reader = null;
        try {
            reader = new RandomAccessFile(oriFile.getPath(), "rw");
        }
        catch (FileNotFoundException e) {
            this.errorCode = "-10700001";
            this.errorMessage = "\u6ca1\u6709\u627e\u5230\u76f8\u5e94\u7684\u6587\u4ef6";
        }
        long lastBlockSize = oriFile.length() % (long)sizePerBlock;
        byte[] bytes = null;
        int j = 0;
        while ((long)j < blockNumber) {
            bytes = (long)j == blockNumber - 1L && lastBlockSize != 0L ? new byte[(int)lastBlockSize] : new byte[sizePerBlock];
            try {
                int len = reader.read(bytes);
                bytes = this.write2Bytes(bytes, len);
                byte[] resultData = this.symmEncryptFile(symmKeyNo, DSignTools.generatesymmDataXmlSB(bytes, oriFile.getName()).toString().getBytes());
                String base64Result = new String(Base64.encode(resultData));
                int length = base64Result.length();
                byte[] lv = this.genLvByte(length, base64Result);
                this.saveResToFile(encryptFilePath, lv, false);
            }
            catch (IOException e) {
                this.errorCode = "-10700002";
                this.errorMessage = "IO\u6d41\u9519\u8bef";
            }
            catch (CSSException e) {
                this.errorCode = "-10700002";
                this.errorMessage = "IO\u6d41\u9519\u8bef";
            }
            ++j;
        }
        try {
            reader.close();
        }
        catch (IOException e) {
            this.errorCode = "-10700002";
            this.errorMessage = "IO\u6d41\u9519\u8bef";
        }
    }

    private byte[] write2Bytes(byte[] bytes, int len) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(bytes, 0, len);
        baos.flush();
        baos.close();
        return bytes;
    }

    private long getBlockNumber(File oriFile, int sizePerBlock) {
        long fileLength = oriFile.length();
        long blockNumber = fileLength / (long)sizePerBlock;
        long tempNumber = fileLength % (long)sizePerBlock;
        if (tempNumber > 0L) {
            ++blockNumber;
        }
        return blockNumber;
    }

    private int getSizePerBlock() {
        int tempBlockSize = config.getPackageSize();
        int sizePerBlock = 0;
        if (tempBlockSize != 0) {
            sizePerBlock = tempBlockSize * 1024;
        }
        return sizePerBlock;
    }

    public byte[] getHeadContent(long sizePerBlock, long blockNumber) {
        if (blockNumber < 0L) {
            return null;
        }
        String head = "";
        String strSizePerBlock = String.valueOf(sizePerBlock);
        int sizePerBlockLength = strSizePerBlock.length();
        switch (sizePerBlockLength) {
            case 1: {
                head = "*000000";
                break;
            }
            case 2: {
                head = "*00000";
                break;
            }
            case 3: {
                head = "*0000";
                break;
            }
            case 4: {
                head = "*000";
                break;
            }
            case 5: {
                head = "*00";
                break;
            }
            case 6: {
                head = "*0";
                break;
            }
            case 7: {
                head = "*";
            }
        }
        head = head + strSizePerBlock;
        byte[] headByte = head.getBytes();
        String strBlockNumber = String.valueOf(blockNumber);
        int blockNumberLength = strBlockNumber.length();
        String addstr = "";
        switch (blockNumberLength) {
            case 1: {
                addstr = "0000000";
                break;
            }
            case 2: {
                addstr = "000000";
                break;
            }
            case 3: {
                addstr = "00000";
                break;
            }
            case 4: {
                addstr = "0000";
                break;
            }
            case 5: {
                addstr = "000";
                break;
            }
            case 6: {
                addstr = "00";
                break;
            }
            case 7: {
                addstr = "0";
            }
        }
        strBlockNumber = addstr + strBlockNumber;
        byte[] blockNumByte = new byte[8];
        blockNumByte = strBlockNumber.getBytes();
        byte[] headAndbLockNumByte = ArrayUtils.addAll((byte[])headByte, (byte[])blockNumByte);
        return headAndbLockNumByte;
    }

    private void saveResToFile(String strFileNameOut, byte[] value, boolean clearExist) throws IOException {
        File existFile;
        if (null == strFileNameOut) {
            return;
        }
        if (clearExist && (existFile = new File(strFileNameOut)).exists()) {
            existFile.delete();
        }
        RandomAccessFile raf = new RandomAccessFile(strFileNameOut, "rw");
        raf.seek(raf.length());
        raf.write(value);
        raf.close();
    }

    public byte[] genLvByte(int length, String content) {
        if (null == content || length < 0) {
            return null;
        }
        String len = String.valueOf(length);
        String addstr = "";
        switch (len.length()) {
            case 1: {
                addstr = "0000000";
                break;
            }
            case 2: {
                addstr = "000000";
                break;
            }
            case 3: {
                addstr = "00000";
                break;
            }
            case 4: {
                addstr = "0000";
                break;
            }
            case 5: {
                addstr = "000";
                break;
            }
            case 6: {
                addstr = "00";
                break;
            }
            case 7: {
                addstr = "0";
            }
        }
        len = addstr + len;
        byte[] lv = ArrayUtils.addAll((byte[])len.getBytes(), (byte[])content.getBytes());
        return lv;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }
}

