/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.assp.encrypt;

import cn.com.jit.assp.css.client.CSSException;
import cn.com.jit.assp.css.client.Config;
import cn.com.jit.assp.css.client.HttpRespResult;
import cn.com.jit.assp.css.client.HttpStreamClient;
import cn.com.jit.assp.css.client.SymmDecryptClient;
import cn.com.jit.assp.css.client.util.Base64;
import cn.com.jit.assp.css.client.util.CommUtil;
import cn.com.jit.assp.css.client.util.PlainOfFileModel;
import cn.com.jit.assp.css.client.util.UtilTool;
import cn.com.jit.assp.css.util.ResponseSet;
import cn.com.jit.assp.css.util.parser.ResponseParser;
import cn.com.jit.assp.css.util.parser.SimpleDOMParser;
import cn.com.jit.assp.css.util.parser.SimpleElement;
import cn.com.jit.assp.dsign.DSignTools;
import cn.com.jit.assp.encrypt.SymmDecryptRequestSet;
import cn.com.jit.assp.encrypt.SymmDecryptResponseSet;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SymmDecrypt {
    private static final Log log = LogFactory.getLog(SymmDecrypt.class);
    public static final String CLASS_NAME = ResponseParser.class.getName();
    private static Config config;
    private SymmDecryptClient client;
    private String errorCode;
    private String errorMessage;
    private String fileName = "";
    private byte[] filePlainData = null;

    public SymmDecrypt(String filePath) {
        try {
            if (config == null) {
                config = Config.getInstance();
                config.loadConfig(filePath, false);
            }
        }
        catch (CSSException e) {
            log.error((Object)("Initinize Config occure error" + e.getMessage()), (Throwable)e);
        }
        this.client = new SymmDecryptClient(config);
    }

    public static void reloadSymmDecrypt() {
        config = null;
    }

    public byte[] symmDecrypt(String symmKeyNo, byte[] encryptData) {
        if (symmKeyNo == null || symmKeyNo.trim().length() == 0) {
            this.errorCode = "-10703202";
            this.errorMessage = "\u89e3\u5bc6\u64cd\u4f5c\uff1a\u5bf9\u79f0\u5bc6\u94a5\u53f7\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (encryptData == null || encryptData.length <= 0) {
            this.errorCode = "-10703203";
            this.errorMessage = "\u89e3\u5bc6\u64cd\u4f5c\uff1a\u52a0\u5bc6\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (this.errorCode != null && this.errorCode.trim().length() > 0) {
            return null;
        }
        if (encryptData.length < config.getBigdataLimit()) {
            SymmDecryptRequestSet request = new SymmDecryptRequestSet();
            request.setSymmKeyNo(symmKeyNo);
            request.setEncryptData(Base64.encodeBytes(encryptData));
            ResponseSet response = this.client.requestSymmDecrypt(request);
            if (response instanceof SymmDecryptResponseSet) {
                SymmDecryptResponseSet symmResponse = (SymmDecryptResponseSet)response;
                String plainData = symmResponse.getPlainData();
                if (plainData != null && plainData.length() > 0) {
                    return Base64.decode(plainData);
                }
                this.errorCode = symmResponse.getErrorCode();
                this.errorMessage = symmResponse.getErrorMessage();
            } else {
                this.errorCode = response.getErrCode();
                this.errorMessage = response.getErrDesc();
            }
        } else {
            HttpStreamClient client = new HttpStreamClient();
            HttpRespResult result = null;
            HashMap<String, String> httpHeader = new HashMap<String, String>();
            httpHeader.put("connection", "Close");
            httpHeader.put("totallength", encryptData.length + "");
            httpHeader.put("certversion", "1.0");
            httpHeader.put("businesstype", "symmdecrypt");
            httpHeader.put("messagetype", "http");
            httpHeader.put("symmkeyid", symmKeyNo);
            try {
                result = client.SymmDecryptByHttpRespResult(httpHeader, encryptData);
                return result.getRespBody();
            }
            catch (CSSException e) {
                this.errorCode = e.getCode();
                this.errorMessage = e.getDescription();
            }
        }
        return null;
    }

    public byte[] symmDecryptFile(byte[] symmKeyNo, byte[] encryptData) {
        if (symmKeyNo == null || symmKeyNo.length == 0) {
            this.errorCode = "-10703202";
            this.errorMessage = "\u89e3\u5bc6\u64cd\u4f5c\uff1a\u5bf9\u79f0\u5bc6\u94a5\u53f7\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (encryptData == null || encryptData.length <= 0) {
            this.errorCode = "-10703203";
            this.errorMessage = "\u89e3\u5bc6\u64cd\u4f5c\uff1a\u52a0\u5bc6\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (this.errorCode != null && this.errorCode.trim().length() > 0) {
            return null;
        }
        if (encryptData.length < config.getBigdataLimit()) {
            SymmDecryptRequestSet request = new SymmDecryptRequestSet();
            request.setSymmKeyNo(new String(Base64.encode(symmKeyNo)));
            request.setEncryptData(Base64.encodeBytes(encryptData));
            request.setEncAlg(config.getEncAlg());
            request.setEncryptMode(config.getEncryptMode());
            ResponseSet response = this.client.requestSymmDecrypt(request);
            if (response instanceof SymmDecryptResponseSet) {
                SymmDecryptResponseSet symmResponse = (SymmDecryptResponseSet)response;
                String plainData = symmResponse.getPlainData();
                try {
                    this.fileName = new String(Base64.decode(symmResponse.getFileName()), config.getFileSystemCharSet());
                }
                catch (UnsupportedEncodingException e) {
                }
                catch (RuntimeException e) {
                    // empty catch block
                }
                if (plainData != null && plainData.length() > 0) {
                    return Base64.decode(plainData);
                }
                this.errorCode = symmResponse.getErrorCode();
                this.errorMessage = symmResponse.getErrorMessage();
            } else {
                this.errorCode = response.getErrCode();
                this.errorMessage = response.getErrDesc();
            }
        } else {
            HttpStreamClient client = new HttpStreamClient();
            HttpRespResult result = null;
            HashMap<String, String> httpHeader = new HashMap<String, String>();
            httpHeader.put("connection", "Close");
            httpHeader.put("totallength", encryptData.length + "");
            httpHeader.put("certversion", "1.0");
            httpHeader.put("businesstype", "symmdecrypt");
            httpHeader.put("messagetype", "http");
            httpHeader.put("exportsymmkey", new String(Base64.encode(symmKeyNo)));
            httpHeader.put("symmalg", config.getEncAlg());
            httpHeader.put("encryptmode", config.getEncryptMode());
            try {
                result = client.SymmDecryptByHttpRespResult(httpHeader, encryptData);
                PlainOfFileModel plain = UtilTool.buildFileName(result.getRespBody(), true);
                this.fileName = plain.getFileName();
                return Base64.decode(plain.getBase64PlainData());
            }
            catch (CSSException e) {
                this.errorCode = e.getCode();
                this.errorMessage = e.getDescription();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public long symmDecrypt(byte[] symmKeyNo, String strFileNameIn, String strFileDir) {
        long lRtnValue;
        block27: {
            RandomAccessFile reader;
            block24: {
                byte[] byteSaveFileContent;
                byte[] byteSignedFileInfoData;
                block25: {
                    long l;
                    block26: {
                        lRtnValue = 0L;
                        if (!this.encAlg()) {
                            this.errorCode = "-10703220";
                            this.errorMessage = "\u89e3\u5bc6\u64cd\u4f5c\uff1a\u5bc6\u94a5\u7b97\u6cd5\u914d\u7f6e\u4e0d\u6b63\u786e";
                        }
                        if (!this.encAlgsizs(symmKeyNo)) {
                            this.errorCode = "-10703219";
                            this.errorMessage = "\u89e3\u5bc6\u64cd\u4f5c\uff1a\u5bc6\u94a5\u957f\u5ea6\u4e0e\u914d\u7f6e\u6587\u4ef6\u4e0d\u540c";
                        }
                        if (symmKeyNo == null || symmKeyNo.length == 0) {
                            this.errorCode = "-10703202";
                            this.errorMessage = "\u89e3\u5bc6\u64cd\u4f5c\uff1a\u5bf9\u79f0\u5bc6\u94a5\u53f7\u4e0d\u80fd\u4e3a\u7a7a";
                        }
                        if (CommUtil.isNull(strFileNameIn)) {
                            this.errorCode = "-10703215";
                            this.errorMessage = "\u89e3\u5bc6\u64cd\u4f5c\uff1a\u52a0\u5bc6\u7ed3\u679c\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a";
                        }
                        if (this.errorCode != null && this.errorCode.trim().length() > 0) {
                            lRtnValue = UtilTool.convertStr2Long(this.errorCode, -10700000L);
                        }
                        byteSignedFileInfoData = null;
                        byteSaveFileContent = null;
                        reader = null;
                        reader = new RandomAccessFile(strFileNameIn, "rw");
                        byte[] headbyte = new byte[8];
                        reader.read(headbyte, 0, 8);
                        String headstr = new String(headbyte);
                        if (headstr.indexOf("*") == 0) {
                            byteSaveFileContent = this.bigSymmDecrypt(symmKeyNo, strFileNameIn, strFileDir, reader);
                            if (this.errorCode != null) {
                                lRtnValue = 1L;
                            }
                            break block24;
                        }
                        byteSignedFileInfoData = DSignTools.readFile(strFileNameIn);
                        if (Base64.decode(byteSignedFileInfoData) != null) break block25;
                        this.errorCode = "-10703221";
                        this.errorMessage = "\u89e3\u5bc6\u64cd\u4f5c\uff1a\u5bc6\u6587\u8f93\u5165\u9519\u8bef";
                        l = lRtnValue = UtilTool.convertStr2Long(this.errorCode, -10700000L);
                        Object var14_13 = null;
                        if (reader == null) break block26;
                        try {
                            reader.close();
                        }
                        catch (IOException e2) {
                            log.error((Object)e2);
                        }
                    }
                    return l;
                }
                try {
                    byteSaveFileContent = this.symmDecryptFile(symmKeyNo, Base64.decode(byteSignedFileInfoData));
                    if (this.errorCode == null || "".equals(this.errorCode)) {
                        this.setFilePlainData(byteSaveFileContent);
                        this.getFile(strFileDir);
                        break block24;
                    }
                    lRtnValue = 1L;
                }
                catch (Throwable throwable) {
                    Object var14_17 = null;
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException e2) {
                            log.error((Object)e2);
                        }
                    }
                    throw throwable;
                }
            }
            Object var14_14 = null;
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e2) {
                    log.error((Object)e2);
                }
            }
            break block27;
            {
                catch (CSSException e) {
                    lRtnValue = UtilTool.convertStr2Long(this.errorCode, -10700000L);
                    Object var14_15 = null;
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException e2) {
                            log.error((Object)e2);
                        }
                    }
                    break block27;
                }
                catch (IOException e) {
                    lRtnValue = UtilTool.convertStr2Long(this.errorCode, -10700000L);
                    Object var14_16 = null;
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException e2) {
                            log.error((Object)e2);
                        }
                    }
                }
            }
        }
        return lRtnValue;
    }

    /*
     * Loose catch block
     */
    public ResponseSet parserXML(InputStream _in) throws CSSException {
        ResponseSet vRespSet;
        block21: {
            InputStreamReader vInStreamReader;
            BufferedReader vBufferedReader;
            block19: {
                vBufferedReader = null;
                vInStreamReader = null;
                vRespSet = new ResponseSet();
                SimpleDOMParser vDOMParser = null;
                vInStreamReader = new InputStreamReader(_in, "UTF-8");
                vBufferedReader = new BufferedReader(vInStreamReader);
                vDOMParser = new SimpleDOMParser();
                SimpleElement tRootse = vDOMParser.parse(vBufferedReader);
                SimpleElement tSe = null;
                Object[] tObjse = tRootse.getChildElements();
                for (int i = 0; i < tObjse.length; ++i) {
                    tSe = (SimpleElement)tObjse[i];
                    this.parserSymmDecryptRespMsg(tSe);
                }
                tSe = null;
                tObjse = null;
                tRootse = null;
                vDOMParser.destroy();
                vDOMParser = null;
                Object var11_11 = null;
                if (vBufferedReader == null) break block19;
                try {
                    vBufferedReader.close();
                    vBufferedReader = null;
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
            if (vInStreamReader != null) {
                try {
                    vInStreamReader.close();
                    vInStreamReader = null;
                }
                catch (IOException ex2) {
                    // empty catch block
                }
            }
            if (_in != null) {
                try {
                    _in.close();
                    _in = null;
                }
                catch (IOException ex3) {}
            }
            break block21;
            {
                catch (IOException ex1) {
                    throw new CSSException("");
                }
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                if (vBufferedReader != null) {
                    try {
                        vBufferedReader.close();
                        vBufferedReader = null;
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                }
                if (vInStreamReader != null) {
                    try {
                        vInStreamReader.close();
                        vInStreamReader = null;
                    }
                    catch (IOException ex2) {
                        // empty catch block
                    }
                }
                if (_in != null) {
                    try {
                        _in.close();
                        _in = null;
                    }
                    catch (IOException ex3) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return vRespSet;
    }

    private void parserSymmDecryptRespMsg(SimpleElement se) {
        Object[] vObjse = se.getChildElements();
        SimpleElement vSimElement = null;
        for (int j = 0; j < vObjse.length; ++j) {
            vSimElement = (SimpleElement)vObjse[j];
            if (vSimElement == null) continue;
            if (vSimElement.getTagName().equals("name")) {
                this.setFileName(new String(Base64.decode(vSimElement.getText())));
                continue;
            }
            if (!vSimElement.getTagName().equals("content")) continue;
            this.setFilePlainData(Base64.decode(vSimElement.getText()));
        }
        vSimElement = null;
        vObjse = null;
    }

    public String getFile(String strSaveFilePath) {
        String strSaveFileName = null;
        byte[] byteSaveFileContent = null;
        String strSaveFileTotalPath = null;
        if (CommUtil.isNull(strSaveFilePath)) {
            return null;
        }
        strSaveFileName = this.getFileName();
        byteSaveFileContent = this.getFilePlainData();
        if (null != strSaveFileName && 0 != strSaveFileName.trim().length()) {
            strSaveFileTotalPath = strSaveFilePath.substring(strSaveFilePath.length() - 1).equals(File.separator) ? strSaveFilePath + strSaveFileName : strSaveFilePath + File.separator + strSaveFileName;
            try {
                DSignTools.writeByteToFile(strSaveFileTotalPath, byteSaveFileContent);
            }
            catch (CSSException e) {
                strSaveFileName = null;
            }
        } else {
            return "";
        }
        return strSaveFileName;
    }

    private boolean encAlg() {
        if ("ecb".equalsIgnoreCase(config.getEncryptMode()) || "cbc".equalsIgnoreCase(config.getEncryptMode())) {
            return "des".equalsIgnoreCase(config.getEncAlg()) || "des3".equalsIgnoreCase(config.getEncAlg()) || "aes".equalsIgnoreCase(config.getEncAlg()) || "sm1".equalsIgnoreCase(config.getEncAlg()) || "sm4".equalsIgnoreCase(config.getEncAlg()) || "rc4".equalsIgnoreCase(config.getEncAlg());
        }
        return false;
    }

    private boolean encAlgsizs(byte[] symmKeyNo) {
        return !("des".equalsIgnoreCase(config.getEncAlg()) ? 8 != symmKeyNo.length : ("des3".equalsIgnoreCase(config.getEncAlg()) ? 24 != symmKeyNo.length : ("aes".equalsIgnoreCase(config.getEncAlg()) ? 16 != symmKeyNo.length : ("sm1".equalsIgnoreCase(config.getEncAlg()) ? 16 != symmKeyNo.length : ("sm4".equalsIgnoreCase(config.getEncAlg()) ? 16 != symmKeyNo.length : symmKeyNo.length % 8 != 0)))));
    }

    private byte[] bigSymmDecrypt(byte[] symmKeyNo, String strFileNameIn, String strFileDir, RandomAccessFile reader) throws IOException {
        long beginTime = System.currentTimeMillis();
        byte[] packagenumByte = new byte[8];
        reader.read(packagenumByte, 0, 8);
        String packageNumStr = new String(packagenumByte);
        int packageNumInt = Integer.parseInt(packageNumStr);
        if (packageNumInt > 0) {
            for (int i = 0; i < packageNumInt; ++i) {
                byte[] lengthByte = new byte[8];
                reader.read(lengthByte, 0, 8);
                String lengthStr = new String(lengthByte);
                int lengthInt = Integer.parseInt(lengthStr);
                byte[] srcContentStr = null;
                String srcFileName = "";
                int count = 0;
                byte[] bytes = new byte[lengthInt];
                int len = 0;
                len = reader.read(bytes);
                if (len <= 0) continue;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                baos.write(bytes, 0, len);
                baos.flush();
                baos.close();
                ++count;
                byte[] byteSaveFileContent = this.symmDecryptFile(symmKeyNo, Base64.decode(bytes));
                this.setFilePlainData(byteSaveFileContent);
                srcContentStr = this.getFilePlainData();
                srcFileName = this.getFileName();
                boolean clearExist = false;
                if (i == 0) {
                    clearExist = true;
                }
                this.saveResToFile(strFileDir + "\\" + srcFileName, srcContentStr, clearExist);
            }
            reader.close();
        }
        long endTime = System.currentTimeMillis();
        System.out.println("\u5bf9\u79f0\u89e3\u5bc6\u4e1a\u52a1\uff0c\u8017\u65f6\uff1a" + (endTime - beginTime) + " ms");
        return packagenumByte;
    }

    private void saveResToFile(String strFileNameOut, byte[] value, boolean clearExist) throws IOException {
        File existFile;
        if (null == strFileNameOut) {
            return;
        }
        if (clearExist && (existFile = new File(strFileNameOut)).exists()) {
            existFile.delete();
        }
        RandomAccessFile raf = new RandomAccessFile(strFileNameOut, "rw");
        raf.seek(raf.length());
        raf.write(value);
        raf.close();
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public byte[] getFilePlainData() {
        return this.filePlainData;
    }

    public void setFilePlainData(byte[] filePlainData) {
        this.filePlainData = filePlainData;
    }
}

