/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.assp.dsign;

import cn.com.jit.assp.css.client.CSSException;
import cn.com.jit.ida.util.pki.PKIException;
import cn.com.jit.ida.util.pki.cipher.JCrypto;
import cn.com.jit.ida.util.pki.cipher.Session;
import cn.com.jit.ida.util.pki.cipher.param.P7Param;
import cn.com.jit.ida.util.pki.pkcs.PKCS7;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PkiToolUtils {
    private static final Log LOGGER = LogFactory.getLog(PkiToolUtils.class);

    private static Session initJSoftLib() {
        JCrypto jCrypto = JCrypto.getInstance();
        try {
            LOGGER.debug((Object)"Init PKITool by [JSOFT_LIB].");
            jCrypto.initialize("JSOFT_LIB", null);
            Session session = jCrypto.openSession("JSOFT_LIB");
            LOGGER.debug((Object)"Init PKITool by [JSOFT_LIB] success.");
            return session;
        }
        catch (Throwable t) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)"Init PKITool by [JSOFT_LIB] failed, the config or code of PKITool has errors.", t);
            }
            return null;
        }
    }

    public static P7Param getP7Param(byte[] srcSignedData) throws CSSException {
        PKCS7 p7 = new PKCS7(PkiToolUtils.initJSoftLib());
        try {
            p7.load(srcSignedData);
        }
        catch (Exception e) {
            throw new CSSException("-10709125", "\u7b7e\u540d\u7ed3\u679c\u4e0d\u662f\u5408\u6cd5\u53c2\u6570", e);
        }
        P7Param p7Param = null;
        try {
            p7Param = p7.GetP7Cnt();
        }
        catch (PKIException e) {
            throw new CSSException("-10709125", "\u7b7e\u540d\u7ed3\u679c\u4e0d\u662f\u5408\u6cd5\u53c2\u6570", e);
        }
        return p7Param;
    }
}

