/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.assp.dsign;

import cn.com.jit.assp.css.client.CSSException;
import cn.com.jit.assp.css.client.Config;
import cn.com.jit.assp.css.client.DSignClient;
import cn.com.jit.assp.css.client.HttpRespResult;
import cn.com.jit.assp.css.client.HttpStreamClient;
import cn.com.jit.assp.css.client.ResultSet;
import cn.com.jit.assp.css.client.util.CommUtil;
import cn.com.jit.assp.css.client.util.HelperUtil;
import cn.com.jit.assp.css.client.util.UtilTool;
import cn.com.jit.assp.css.util.EnvelopResponseSet;
import cn.com.jit.assp.css.util.parser.EnvelopSimpResponseParser;
import cn.com.jit.assp.dsign.DSignTools;
import cn.com.jit.assp.dsign.PkiToolUtils;
import cn.com.jit.ida.util.pki.asn1.ASN1InputStream;
import cn.com.jit.ida.util.pki.asn1.ASN1Sequence;
import cn.com.jit.ida.util.pki.asn1.ASN1Set;
import cn.com.jit.ida.util.pki.asn1.pkcs.pkcs7.ContentInfo;
import cn.com.jit.ida.util.pki.asn1.pkcs.pkcs7.EnvelopedData;
import cn.com.jit.ida.util.pki.asn1.pkcs.pkcs7.IssuerAndSerialNumber;
import cn.com.jit.ida.util.pki.asn1.pkcs.pkcs7.RecipientInfo;
import cn.com.jit.ida.util.pki.cipher.param.P7Param;
import cn.com.jit.ida.util.pki.encoders.Base64;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DSign {
    private static final Log LOGGER = LogFactory.getLog(DSign.class);
    private static Config config = null;
    private static boolean IS_INITED = false;
    private long longErrCode = 0L;
    private String strErrMsg = null;
    private ResultSet rs = null;
    private DSignClient dsclient = new DSignClient();
    private String digestAlgID = null;
    private String plainData = "";
    private byte[] plainByteData = null;
    public byte[] bigPlainData = null;
    private String rndigestAlgID = "";
    private byte[] filePlainData = null;
    private String fileName = "";
    private static final String VERSION_REQ_XML = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><DSignContext Version =\"2.0\"><Request svcid=\"doDigest\"><ParaInfo><PlainText>cGxhaW5UZXh0VGVzdA==</PlainText><DigestALG>MD5</DigestALG></ParaInfo></Request></DSignContext>";

    public byte[] getPlainByteData() {
        return this.plainByteData;
    }

    public void setPlainByteData(byte[] plainByteData) {
        this.plainByteData = plainByteData;
    }

    public static void setIS_INITED(boolean is_inited) {
        IS_INITED = is_inited;
    }

    public void setFilePlainData(byte[] filePlainData) {
        this.filePlainData = filePlainData;
    }

    public byte[] getFilePlainData() {
        return this.filePlainData;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getPlainData() {
        return this.plainData;
    }

    public void setPlainData(String plainData) {
        this.plainData = plainData;
    }

    public static Config getConfig() {
        return config;
    }

    public static void setConfig(Config config) {
        DSign.config = config;
    }

    public DSign() {
        config = Config.getInstance();
        this.rs = new ResultSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean init(String filePath) {
        Class<DSign> clazz = DSign.class;
        synchronized (DSign.class) {
            block15: {
                if (IS_INITED) return IS_INITED;
                try {
                    if (config == null) {
                        config = Config.getInstance();
                    }
                    config.loadConfig(filePath, false);
                    String state = config.getState();
                    if (state == null || state.equals("") || !state.equals("local")) break block15;
                    String localInitClass = config.getLocalInitClass();
                    String filePash = config.getLocalFilePath();
                    String classPath = config.getLocalClassFilePath();
                    Object o = null;
                    try {
                        o = Class.forName(localInitClass).newInstance();
                    }
                    catch (InstantiationException e) {
                        config.setState("");
                        LOGGER.error((Object)"errorMessageNumber: -10709970 errorMessage: \u7c7b\u52a0\u8f7d\u5931\u8d25", (Throwable)e);
                    }
                    catch (ClassNotFoundException e) {
                        LOGGER.error((Object)"errorMessageNumber: -10709972 errorMessage: \u6ca1\u6709\u627e\u5230class\u7c7b\u8def\u5f84", (Throwable)e);
                        config.setState("");
                    }
                    catch (IllegalAccessException e) {
                        config.setState("");
                        LOGGER.error((Object)"errorMessageNumber: -10709970 errorMessage: \u7c7b\u52a0\u8f7d\u5931\u8d25", (Throwable)e);
                    }
                    Class[] argTypes = new Class[]{String.class, String.class};
                    Method method = o.getClass().getMethod("init", argTypes);
                    Object[] argsOne = new Object[]{filePash, classPath};
                    method.invoke(o, argsOne);
                }
                catch (CSSException e) {
                    LOGGER.error((Object)"errorMessageNumber: -10709975 errorMessage: \u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6\u5931\u8d25", (Throwable)e);
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return false;
                }
                catch (SecurityException e) {
                    LOGGER.error((Object)"errorMessageNumber: -10709973 errorMessage: \u521d\u59cb\u5316\u65b9\u6cd5\u65f6\uff0c\u65b9\u6cd5\u540d\u6216\u53c2\u6570\u9519\u8bef", (Throwable)e);
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return false;
                }
                catch (NoSuchMethodException e) {
                    LOGGER.error((Object)"errorMessageNumber: -10709973 errorMessage: \u521d\u59cb\u5316\u65b9\u6cd5\u65f6\uff0c\u65b9\u6cd5\u540d\u6216\u53c2\u6570\u9519\u8bef", (Throwable)e);
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return false;
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error((Object)"errorMessageNumber: -10709974 errorMessage: \u6267\u884c\u521d\u59cb\u5316\u65b9\u6cd5\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return false;
                }
                catch (InvocationTargetException e) {
                    LOGGER.error((Object)"errorMessageNumber: -10709974 errorMessage: \u6267\u884c\u521d\u59cb\u5316\u65b9\u6cd5\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return false;
                }
                catch (IllegalAccessException e) {
                    LOGGER.error((Object)"errorMessageNumber: -10709970 errorMessage: \u7c7b\u52a0\u8f7d\u5931\u8d25", (Throwable)e);
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return false;
                }
            }
            IS_INITED = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return IS_INITED;
        }
    }

    public long getErrorCode() {
        return this.longErrCode;
    }

    public String getErrorMessage() {
        return this.strErrMsg;
    }

    public long setAlgorithm(String strSignType, String strEncType) {
        return 0L;
    }

    public String getData() {
        return this.plainData;
    }

    public byte[] getByteData() {
        return this.plainByteData;
    }

    public String getRndigestAlgID() {
        return this.rndigestAlgID;
    }

    public String getServerVersion() {
        HttpURLConnection httpurlconnection = null;
        OutputStream outputstream = null;
        try {
            URL url = config.getServerUrl();
            httpurlconnection = (HttpURLConnection)url.openConnection();
            httpurlconnection.setDoOutput(true);
            httpurlconnection.setUseCaches(false);
            httpurlconnection.setRequestMethod("POST");
            httpurlconnection.setRequestProperty("Content-Type", "text/xml;charset=UTF-8");
            int i = VERSION_REQ_XML.getBytes("UTF-8").length;
            httpurlconnection.setRequestProperty("Content-Length", Integer.toString(i));
            outputstream = httpurlconnection.getOutputStream();
            outputstream.write(VERSION_REQ_XML.getBytes("UTF-8"));
            outputstream.flush();
        }
        catch (Exception e1) {
            try {
                if (outputstream != null) {
                    outputstream.close();
                }
            }
            catch (Exception i) {
                // empty catch block
            }
            try {
                if (httpurlconnection != null) {
                    httpurlconnection.disconnect();
                }
            }
            catch (Exception i) {
                // empty catch block
            }
            this.strErrMsg = "\u53d1\u9001\u8bf7\u6c42\u8d85\u65f6\uff01";
            LOGGER.error((Object)("errorMessage: " + this.strErrMsg), (Throwable)e1);
        }
        try {
            String serverVersion;
            InputStream in = httpurlconnection.getInputStream();
            byte[] content = new byte[1024];
            while (in.read(content) > 0) {
            }
            String string = serverVersion = httpurlconnection.getHeaderField("SS-Server-Version");
            return string;
        }
        catch (Exception e) {
            this.strErrMsg = e.getMessage();
            LOGGER.error((Object)("errorMessage: " + this.strErrMsg), (Throwable)e);
        }
        finally {
            if (outputstream != null) {
                try {
                    outputstream.close();
                }
                catch (IOException ioe) {
                    this.strErrMsg = ioe.getMessage();
                }
            }
            if (httpurlconnection != null) {
                httpurlconnection.disconnect();
            }
        }
        return null;
    }

    public String digest(String plainText, String digestALG) {
        return this.digest(plainText, digestALG, null);
    }

    public String digest(String plainText, String digestALG, String charSet) {
        String lreturnValue = null;
        this.longErrCode = 0L;
        this.strErrMsg = null;
        EnvelopResponseSet eResSet = new EnvelopResponseSet();
        String serverResponseXml = null;
        try {
            if (CommUtil.isNull(digestALG)) {
                throw new CSSException("-10700101", "", "\u53c2\u6570\u4e3a\u7a7a\u6216\u4e0d\u5408\u6cd5");
            }
            if (plainText.length() < config.getBigdataLimit()) {
                serverResponseXml = charSet != null && !"".equals(charSet) ? this.dsclient.digest(plainText, digestALG, charSet) : this.dsclient.digest(plainText, digestALG);
                if (serverResponseXml != null && serverResponseXml.length() > 0) {
                    EnvelopSimpResponseParser esrp = new EnvelopSimpResponseParser();
                    eResSet = esrp.parserXML(serverResponseXml);
                    if (eResSet.isSucceed()) {
                        lreturnValue = eResSet.getPlainData();
                    } else {
                        this.longErrCode = Long.parseLong(eResSet.getErrCode());
                        lreturnValue = null;
                    }
                }
            } else {
                HttpStreamClient ds = new HttpStreamClient();
                HttpRespResult result = null;
                result = StringUtils.isNotBlank((String)charSet) ? ds.digestByHttpRespResult(plainText, digestALG, "digest", charSet) : ds.digestByHttpRespResult(plainText, digestALG, "digest", null);
                byte[] respBody = result.getRespBody();
                if (respBody != null) {
                    lreturnValue = new String(Base64.encode((byte[])respBody));
                }
                this.longErrCode = Long.parseLong(result.getRespHeader().get("errorcode"));
                this.strErrMsg = result.getRespHeader().get("errormsg");
            }
        }
        catch (CSSException e) {
            this.strErrMsg = e.getDescription();
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            this.longErrCode = UtilTool.convertStr2Long("-90900009", -10700000L);
            this.strErrMsg = "\u6458\u8981\u8fd0\u7b97\u51fa\u73b0\u9519\u8bef";
        }
        return lreturnValue;
    }

    public byte[] digest(byte[] plainText, String digestALG) {
        byte[] lreturnValue = null;
        this.longErrCode = 0L;
        this.strErrMsg = null;
        EnvelopResponseSet eResSet = new EnvelopResponseSet();
        Object serverResponseXml = null;
        try {
            if (CommUtil.isNull(digestALG)) {
                throw new CSSException("-10700101", "", "\u53c2\u6570\u4e3a\u7a7a\u6216\u4e0d\u5408\u6cd5");
            }
            HttpStreamClient ds = new HttpStreamClient();
            HttpRespResult result = null;
            result = ds.digestByHttpRespResult(plainText, digestALG, "digest");
            byte[] respBody = result.getRespBody();
            if (respBody != null) {
                lreturnValue = respBody;
            }
            this.longErrCode = Long.parseLong(result.getRespHeader().get("errorcode"));
            this.strErrMsg = result.getRespHeader().get("errormsg");
        }
        catch (CSSException e) {
            this.strErrMsg = e.getDescription();
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            this.longErrCode = UtilTool.convertStr2Long("-90900009", -10700000L);
            this.strErrMsg = "\u6458\u8981\u8fd0\u7b97\u51fa\u73b0\u9519\u8bef";
        }
        return lreturnValue;
    }

    public byte[] generateRandom(int length, String retType) {
        byte[] lreturnValue = null;
        this.longErrCode = 0L;
        this.strErrMsg = null;
        if (length < 1) {
            this.longErrCode = -10002060L;
            this.strErrMsg = "\u968f\u673a\u6570\u957f\u5ea6\u8981\u5927\u4e8e0\uff01";
            return lreturnValue;
        }
        try {
            String strValue = this.dsclient.genRandom(length);
            if (strValue == null || strValue.length() < 1) {
                this.longErrCode = -10002059L;
                this.strErrMsg = "\u83b7\u53d6\u968f\u673a\u6570\u5931\u8d25\uff01";
                lreturnValue = null;
                return lreturnValue;
            }
            lreturnValue = Base64.decode((String)strValue);
            if (retType != null && retType.equalsIgnoreCase("16")) {
                lreturnValue = HelperUtil.bytesToHexString(lreturnValue).getBytes();
            }
        }
        catch (CSSException e) {
            this.longErrCode = UtilTool.convertStr2Long(e.getCode(), -10700000L);
            this.strErrMsg = e.getDescription();
        }
        return lreturnValue;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String detachSign(String applayID, byte[] plainData) {
        this.longErrCode = 0L;
        this.strErrMsg = null;
        String strRtnValue = null;
        byte[] signedData = null;
        try {
            String state;
            if (CommUtil.isNull(plainData)) {
                throw new CSSException("-10700101", "", "\u53c2\u6570\u4e3a\u7a7a\u6216\u4e0d\u5408\u6cd5");
            }
            this.digestAlgID = config.getDigestAlg();
            if (this.digestAlgID != null) {
                this.digestAlgID.trim().length();
            }
            if ((state = config.getState()) != null && !state.equals("") && state.equals("local")) {
                Object o = Class.forName("cn.com.jit.assp.local.sign.DetachSign").newInstance();
                Class[] argTypes = new Class[]{String.class, byte[].class};
                Method method = o.getClass().getMethod("excuteSourceDataSign", argTypes);
                Object[] argsOne = new Object[]{applayID, plainData};
                this.rs = (ResultSet)method.invoke(o, argsOne);
                if (!this.rs.isSucceed()) {
                    this.longErrCode = UtilTool.convertStr2Long(this.rs.getErrcode(), -10700000L);
                    this.strErrMsg = this.rs.getErrDesc();
                    return "";
                }
                signedData = this.rs.getSignedData();
            } else if (plainData.length < config.getBigdataLimit()) {
                signedData = this.dsclient.doSign(plainData, false, true, false, this.digestAlgID, applayID);
                this.rs = this.dsclient.getRs();
            } else {
                HttpStreamClient dsclient = new HttpStreamClient();
                this.rs = dsclient.doSign(plainData, this.digestAlgID, applayID, "detachsign");
                signedData = this.rs.getData();
            }
            if (signedData == null) return strRtnValue;
            if (signedData.length <= 0) return strRtnValue;
            int packageSize = config.getPackageSize();
            if (packageSize != 0) return UtilTool.processBase64Code(new String(Base64.encode((byte[])signedData)));
            return new String(Base64.encode((byte[])signedData));
        }
        catch (CSSException e) {
            this.longErrCode = UtilTool.convertStr2Long(e.getCode(), -10700000L);
            this.strErrMsg = e.getDescription();
            return strRtnValue;
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            this.longErrCode = UtilTool.convertStr2Long("-10709280", -10700000L);
            this.strErrMsg = "\u5236\u4f5c\u7b7e\u540d\u4e1a\u52a1\u5931\u8d25";
        }
        return strRtnValue;
    }

    public long verifyDetachedSign(byte[] signedData, byte[] plainData) {
        this.longErrCode = 0L;
        this.strErrMsg = null;
        this.rs.clear();
        long lRtnValue = 0L;
        try {
            if (CommUtil.isNull(signedData)) {
                throw new CSSException("-10700101", "", "\u53c2\u6570\u4e3a\u7a7a\u6216\u4e0d\u5408\u6cd5");
            }
            if (CommUtil.isNull(plainData)) {
                throw new CSSException("-10700101", "", "\u53c2\u6570\u4e3a\u7a7a\u6216\u4e0d\u5408\u6cd5");
            }
            String state = config.getState();
            if (state != null && !state.equals("") && state.equals("local")) {
                Object o = Class.forName("cn.com.jit.assp.local.sign.DetachVSign").newInstance();
                Class[] argTypes = new Class[]{byte[].class, byte[].class};
                Method method = o.getClass().getMethod("verifySign", argTypes);
                Object[] argsOne = new Object[]{plainData, signedData};
                this.rs = (ResultSet)method.invoke(o, argsOne);
            } else if (plainData.length + signedData.length < config.getBigdataLimit()) {
                this.rs = this.dsclient.verifySign(plainData, Base64.decode((byte[])UtilTool.convertBase64(signedData)), config.getBaseInfo(), config.getCertBaseInfo(), config.getCertExtendInfo(), config.getTsaCertBaseInfo());
            } else {
                HttpStreamClient dsclient = new HttpStreamClient();
                this.rs = dsclient.verifySign(plainData, UtilTool.convertBase64(signedData), config.getDigestAlg(), null, "detachverifysign", true);
            }
            if (!this.rs.isSucceed()) {
                this.longErrCode = UtilTool.convertStr2Long(this.rs.getErrcode(), 10700000L);
                this.strErrMsg = this.rs.getErrDesc();
                return this.longErrCode;
            }
            this.rndigestAlgID = this.rs.getDigestAlgID();
            byte[] plaindata = this.rs.getPlainData();
            this.fileName = this.rs.getFileName();
            if (this.fileName.equals("")) {
                this.setPlainData(new String(plaindata));
                this.setPlainByteData(plaindata);
            } else {
                this.setFilePlainData(plaindata);
            }
            if (this.rs.getErrcode() != null && !"".equals(this.rs.getErrcode())) {
                lRtnValue = UtilTool.convertStr2Long(this.rs.getErrcode(), 10700000L);
                this.strErrMsg = this.rs.getErrDisc();
            }
        }
        catch (CSSException e) {
            this.longErrCode = lRtnValue = UtilTool.convertStr2Long(e.getCode(), -10700000L);
            this.strErrMsg = e.getDescription();
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            lRtnValue = this.longErrCode = UtilTool.convertStr2Long("-10709281", -10700000L);
            this.strErrMsg = "\u9a8c\u8bc1\u7b7e\u540d\u4e1a\u52a1\u5931\u8d25";
        }
        return lRtnValue;
    }

    public String p1Sign(String strDN, String strDigestAlg, byte[] strPlainData) {
        this.longErrCode = 0L;
        this.strErrMsg = null;
        String strRtnValue = null;
        byte[] signedData = null;
        try {
            String digest;
            if (CommUtil.isNull(strPlainData)) {
                throw new CSSException("-10700101", "", "\u53c2\u6570\u4e3a\u7a7a\u6216\u4e0d\u5408\u6cd5");
            }
            String appId = strDN;
            if (appId == null || appId.trim().length() == 0) {
                appId = config.getAppID();
            }
            if ((digest = strDigestAlg) == null || digest.trim().length() == 0) {
                digest = config.getDigestAlg();
            }
            this.dsclient.setP1(true);
            signedData = this.dsclient.doSign(strPlainData, false, false, false, digest, appId);
            this.rs = this.dsclient.getRs();
            if (signedData != null && signedData.length > 0) {
                strRtnValue = UtilTool.processBase64Code(new String(Base64.encode((byte[])signedData)));
            }
        }
        catch (CSSException e) {
            this.longErrCode = UtilTool.convertStr2Long(e.getCode(), -10700000L);
            this.strErrMsg = e.getDescription();
        }
        return strRtnValue;
    }

    public long p1Verify(String strIssuerAndSn, String strDigetsAlg, byte[] signedData, byte[] strOrgData) {
        this.longErrCode = 0L;
        this.strErrMsg = null;
        this.rs.clear();
        long lRtnValue = 0L;
        try {
            String digest = strDigetsAlg;
            if (digest == null || digest.trim().length() == 0) {
                digest = config.getDigestAlg();
            }
            if (CommUtil.isNull(signedData)) {
                throw new CSSException("-10700101", "", "\u53c2\u6570\u4e3a\u7a7a\u6216\u4e0d\u5408\u6cd5");
            }
            if (CommUtil.isNull(strOrgData)) {
                throw new CSSException("-10700101", "", "\u53c2\u6570\u4e3a\u7a7a\u6216\u4e0d\u5408\u6cd5");
            }
            String encryptAlg = config.getEncAlg();
            this.dsclient.setIssuerAndSn(UtilTool.convertBase64(strIssuerAndSn));
            this.dsclient.setDigestAlg(digest);
            this.dsclient.setEncryptAlg(encryptAlg);
            this.dsclient.setP1(true);
            this.rs = this.dsclient.verifySign(strOrgData, Base64.decode((byte[])UtilTool.convertBase64(signedData)), config.getBaseInfo(), config.getCertBaseInfo(), config.getCertExtendInfo(), config.getTsaCertBaseInfo());
            this.dsclient.setP1(false);
            if (!this.rs.isSucceed()) {
                this.longErrCode = lRtnValue = UtilTool.convertStr2Long(this.rs.getErrcode(), 10700000L);
                this.strErrMsg = this.rs.getErrDisc();
            } else {
                this.rndigestAlgID = this.rs.getDigestAlgID();
                byte[] plaindata = this.rs.getPlainData();
                this.fileName = this.rs.getFileName();
                if (this.fileName.equals("")) {
                    this.setPlainData(new String(plaindata));
                    this.setPlainByteData(plaindata);
                } else {
                    this.setFilePlainData(plaindata);
                }
            }
        }
        catch (CSSException e) {
            this.longErrCode = lRtnValue = UtilTool.convertStr2Long(e.getCode(), -10700000L);
            this.strErrMsg = e.getDescription();
        }
        return lRtnValue;
    }

    public String getCertInfo(String strCertType, int intInfoType, String strOID) {
        if (CommUtil.isNull(strCertType)) {
            return "";
        }
        if (strCertType.equalsIgnoreCase("VS")) {
            if (this.rs == null) {
                return "";
            }
            if (strOID == null || strOID.trim().length() == 0) {
                switch (intInfoType) {
                    case 0: {
                        return this.rs.getCertItemValue("subjectdn");
                    }
                    case 1: {
                        return this.rs.getCertItemValue("issuerdn");
                    }
                    case 2: {
                        return this.rs.getCertItemValue("serialnumber");
                    }
                    case 3: {
                        return this.rs.getCertItemValue("version");
                    }
                    case 4: {
                        return UtilTool.getMailFormDN(this.rs.getCertItemValue("subjectdn"));
                    }
                    case 5: {
                        return this.rs.getCertItemValue("notbefore");
                    }
                    case 6: {
                        return this.rs.getCertItemValue("notafter");
                    }
                    case 7: {
                        return this.rs.getBase64DsCert();
                    }
                }
                return "";
            }
            return this.rs.getCertItemValue(strOID);
        }
        return "";
    }

    public String encryptEnvelop(String[] strCertAlias, byte[] bOrgData) {
        String envelopData;
        block20: {
            String state;
            String encAlg;
            envelopData = null;
            byte[] envelopConet = null;
            this.longErrCode = 0L;
            this.strErrMsg = null;
            EnvelopResponseSet eResSet = new EnvelopResponseSet();
            String serverResponseXml = null;
            if (CommUtil.isNull(bOrgData)) {
                this.longErrCode = UtilTool.convertStr2Long("-10709370", -10700000L);
                this.strErrMsg = "\u5236\u4f5c\u4fe1\u5c01\u4e1a\u52a1\u5931\u8d25\uff0c\u539f\u6587\u4e3a\u7a7a";
                return "";
            }
            if (strCertAlias == null || strCertAlias.length <= 0) {
                String cas = config.getCertAlias();
                if (CommUtil.isNull(cas)) {
                    this.longErrCode = UtilTool.convertStr2Long("-10703102", -10700000L);
                    this.strErrMsg = "\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u8bc1\u4e66\u522b\u540d\u8f93\u5165\u4e3a\u7a7a\uff01";
                }
                strCertAlias = cas.split(";");
            }
            if (CommUtil.isNull(encAlg = null)) {
                encAlg = config.getEncAlg();
            }
            if ((state = config.getState()) != null && !state.equals("") && state.equals("local")) {
                try {
                    Object o = Class.forName("cn.com.jit.assp.local.envelop.EnvelopSign").newInstance();
                    Class[] argTypes = new Class[]{String[].class, byte[].class, String.class};
                    Method method = o.getClass().getMethod("encryptEnvelop", argTypes);
                    Object[] args1 = new Object[]{strCertAlias, bOrgData, encAlg};
                    this.rs = (ResultSet)method.invoke(o, args1);
                    if (this.rs.isSucceed()) {
                        envelopConet = this.rs.getPlainData();
                        envelopData = new String(Base64.encode((byte[])envelopConet));
                    }
                    this.longErrCode = UtilTool.convertStr2Long(this.rs.getErrcode(), -10700000L);
                    this.strErrMsg = this.rs.getErrDesc();
                }
                catch (Exception e) {
                    this.longErrCode = UtilTool.convertStr2Long("-10709371", -10700000L);
                    this.strErrMsg = "\u5236\u4f5c\u4fe1\u5c01\u4e1a\u52a1\u5931\u8d25";
                    return "";
                }
            } else {
                block21: {
                    block18: {
                        block19: {
                            if (bOrgData.length >= config.getBigdataLimit()) break block18;
                            serverResponseXml = this.dsclient.makeEnvelop(strCertAlias, bOrgData, encAlg);
                            if (serverResponseXml == null || serverResponseXml.length() <= 0) break block19;
                            EnvelopSimpResponseParser esrp = new EnvelopSimpResponseParser();
                            eResSet = esrp.parserXML(serverResponseXml);
                            if (eResSet.isSucceed()) {
                                envelopData = eResSet.getEnvelopData();
                                break block20;
                            }
                            this.longErrCode = UtilTool.convertStr2Long(eResSet.getErrCode(), -10700000L);
                            this.strErrMsg = eResSet.getErrDisc();
                            return "";
                        }
                        this.longErrCode = -10703108L;
                        this.strErrMsg = "\u670d\u52a1\u5668\u8fd4\u56de\u62a5\u6587\u4e3a\u7a7a";
                        return "";
                    }
                    StringBuffer sb = new StringBuffer();
                    String[] stringArray = strCertAlias;
                    int args1 = strCertAlias.length;
                    int method = 0;
                    while (method < args1) {
                        String certid = stringArray[method];
                        sb.append(certid).append(",");
                        ++method;
                    }
                    HttpStreamClient hc = new HttpStreamClient();
                    HashMap<String, String> httpHeader = new HashMap<String, String>();
                    httpHeader.put("businesstype", "envelop");
                    httpHeader.put("certid", sb.deleteCharAt(sb.length() - 1).toString());
                    httpHeader.put("symmalg", encAlg);
                    httpHeader.put("messagetype", "http");
                    httpHeader.put("totallength", String.valueOf(bOrgData.length));
                    HttpRespResult result = hc.makeEnvelopByHttpRespResult(httpHeader, bOrgData);
                    String errorCode = result.getRespHeader().get("errorcode");
                    String errorMsg = result.getRespHeader().get("errormsg");
                    if (result == null) break block21;
                    if (StringUtils.equals((String)errorCode, (String)"0")) {
                        envelopData = new String(Base64.encode((byte[])result.getRespBody()));
                        break block20;
                    }
                    this.longErrCode = UtilTool.convertStr2Long(eResSet.getErrCode(), -10700000L);
                    this.strErrMsg = eResSet.getErrDisc();
                    return "";
                }
                try {
                    this.longErrCode = -10703108L;
                    this.strErrMsg = "\u670d\u52a1\u5668\u8fd4\u56de\u62a5\u6587\u4e3a\u7a7a";
                    return "";
                }
                catch (CSSException e) {
                    this.longErrCode = UtilTool.convertStr2Long(e.getCode(), -10700000L);
                    this.strErrMsg = e.getDescription();
                    return "";
                }
                catch (Exception e) {
                    LOGGER.error((Object)e.getMessage(), (Throwable)e);
                    this.longErrCode = UtilTool.convertStr2Long("-10709371", -10700000L);
                    this.strErrMsg = "\u5236\u4f5c\u4fe1\u5c01\u4e1a\u52a1\u5931\u8d25";
                }
            }
        }
        return envelopData;
    }

    public long decryptEnvelop(byte[] bEnvelop) {
        long lRtnValue = 0L;
        this.rs.clear();
        try {
            if (CommUtil.isNull(bEnvelop)) {
                this.longErrCode = UtilTool.convertStr2Long("-10709372", -10700000L);
                this.strErrMsg = "\u89e3\u4fe1\u5c01\u4e1a\u52a1\u5931\u8d25\uff0c\u4fe1\u5c01\u7ed3\u679c\u4e3a\u7a7a";
                return this.longErrCode;
            }
            String state = config.getState();
            if (state != null && !state.equals("") && state.equals("local")) {
                try {
                    Object o = Class.forName("cn.com.jit.assp.local.envelop.VerifyEnvelopSign").newInstance();
                    Class[] argTypes = new Class[]{byte[].class};
                    Method method = o.getClass().getMethod("decryptEnvelop", argTypes);
                    Object[] args1 = new Object[]{bEnvelop};
                    this.rs = (ResultSet)method.invoke(o, args1);
                }
                catch (Exception e) {
                    this.longErrCode = UtilTool.convertStr2Long("-10709373", -10700000L);
                    this.strErrMsg = "\u89e3\u4fe1\u5c01\u4e1a\u52a1\u5931\u8d25";
                    return this.longErrCode;
                }
            } else if (bEnvelop.length < config.getBigdataLimit()) {
                this.rs = this.dsclient.unEnvelop(bEnvelop);
            } else {
                byte[] decode = Base64.decode((byte[])UtilTool.convertBase64(bEnvelop));
                P7Param p7Param = PkiToolUtils.getP7Param(decode);
                HttpStreamClient hc = new HttpStreamClient();
                HashMap<String, String> httpHeader = new HashMap<String, String>();
                httpHeader.put("businesstype", "decryptenvelop");
                httpHeader.put("messagetype", "http");
                httpHeader.put("totallength", String.valueOf(decode.length));
                httpHeader.put("certmode", "issuerdnandsn");
                httpHeader.put("certinfo", this.getIssueAndSerials(decode, ";", " "));
                httpHeader.put("symmalg", this.getEncAlg(p7Param));
                this.rs = hc.decryptEnvelop(httpHeader, decode);
            }
            if (!this.rs.isSucceed()) {
                this.longErrCode = UtilTool.convertStr2Long(this.rs.getErrcode(), 10700000L);
                this.strErrMsg = this.rs.getErrDesc();
                return this.longErrCode;
            }
            byte[] plaindata = this.rs.getPlainData();
            this.fileName = this.rs.getFileName();
            if (this.fileName.equals("")) {
                this.setPlainData(new String(plaindata));
                this.setPlainByteData(plaindata);
            } else {
                String fileSystemChartSet = Config.getInstance().getFileSystemCharSet();
                this.fileName = fileSystemChartSet == null || "default".equals(fileSystemChartSet) ? new String(Base64.decode((String)this.fileName)) : new String(Base64.decode((String)this.fileName), fileSystemChartSet);
                this.setFilePlainData(plaindata);
            }
        }
        catch (UnsupportedEncodingException e) {
            this.strErrMsg = "Encoding the fileName error!";
            this.longErrCode = UtilTool.convertStr2Long("-10709373", -10700000L);
            this.strErrMsg = "\u89e3\u4fe1\u5c01\u4e1a\u52a1\u5931\u8d25";
            return this.longErrCode;
        }
        catch (Exception e) {
            this.longErrCode = UtilTool.convertStr2Long("-10709373", -10700000L);
            this.strErrMsg = "\u89e3\u4fe1\u5c01\u4e1a\u52a1\u5931\u8d25";
            return this.longErrCode;
        }
        return lRtnValue;
    }

    private String unionList(List<String> list, String separater) {
        StringBuffer sb = new StringBuffer();
        for (String string : list) {
            sb.append(string).append(separater);
        }
        return sb.deleteCharAt(sb.length() - 1).toString();
    }

    private String getEncAlg(P7Param p7Param) {
        String encMech = p7Param.GetEncMech().getMechanismType();
        return encMech;
    }

    private String getIssueAndSerials(byte[] envelopDate, String separater, String lineSeparater) throws CSSException {
        ByteArrayInputStream bis = new ByteArrayInputStream(envelopDate);
        ASN1Sequence seq = null;
        ASN1InputStream ais = null;
        try {
            ais = new ASN1InputStream((InputStream)bis);
            seq = (ASN1Sequence)ais.readObject();
            ContentInfo contentInfo = ContentInfo.getInstance((Object)seq);
            EnvelopedData envelopedData = EnvelopedData.getInstance((Object)contentInfo.getContent());
            ASN1Set recipientInfos = envelopedData.getRecipientInfos();
            RecipientInfo recipientInfo = null;
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < recipientInfos.size()) {
                recipientInfo = new RecipientInfo((ASN1Sequence)recipientInfos.getObjectAt(i));
                IssuerAndSerialNumber recipienter = recipientInfo.getIssuerAndSerialNumber();
                String issue = recipienter.getName().toString();
                String serial = recipienter.getCertificateSerialNumber().getValue().toString(10);
                String issueAndSerila = String.valueOf(issue) + separater + serial.toUpperCase();
                sb.append(String.valueOf(issueAndSerila) + lineSeparater);
                ++i;
            }
            String string = sb.deleteCharAt(sb.length() - 1).toString();
            return string;
        }
        catch (Exception e) {
            throw new CSSException("-10709329", "\u89e3\u6790\u4fe1\u5c01\u7ed3\u679c\u9519\u8bef");
        }
        finally {
            if (ais != null) {
                try {
                    ais.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)e);
                }
            }
        }
    }

    public long verifySignedEnvelop(byte[] bEnvelop) {
        this.longErrCode = 0L;
        this.strErrMsg = null;
        long lRtnValue = 0L;
        this.rs.clear();
        try {
            this.rs = this.dsclient.unSignedEnvelop(bEnvelop);
            if (!this.rs.isSucceed()) {
                this.longErrCode = lRtnValue = UtilTool.convertStr2Long(this.rs.getErrcode(), 10700000L);
                this.strErrMsg = this.rs.getErrDisc();
            } else {
                this.plainData = new String(this.rs.getPlainData());
                byte[] plaindata = this.rs.getPlainData();
                this.fileName = this.rs.getFileName();
                if (this.fileName.equals("")) {
                    this.setPlainData(new String(plaindata));
                } else {
                    String fileSystemChartSet = config.getFileSystemCharSet();
                    if (!StringUtils.isNotBlank((String)fileSystemChartSet) || "default".equals(fileSystemChartSet)) {
                        fileSystemChartSet = config.getSystemCharSet();
                    }
                    this.fileName = new String(Base64.decode((String)this.fileName), fileSystemChartSet);
                    this.setFilePlainData(plaindata);
                }
            }
        }
        catch (CSSException e) {
            this.longErrCode = UtilTool.convertStr2Long(e.getCode(), 10700000L);
            this.strErrMsg = e.getDescription();
            return this.longErrCode;
        }
        catch (Exception e) {
            this.longErrCode = UtilTool.convertStr2Long("-10709373", -10700000L);
            this.strErrMsg = "\u89e3\u4fe1\u5c01\u4e1a\u52a1\u5931\u8d25";
        }
        return lRtnValue;
    }

    public long decryptEnvelop(String strFileNameIn) {
        byte[] byteEnvelopedFileInfoData = null;
        long longReturn = 0L;
        try {
            if (CommUtil.isNull(strFileNameIn)) {
                throw new CSSException("-10700101", "", "\u53c2\u6570\u4e3a\u7a7a\u6216\u4e0d\u5408\u6cd5");
            }
            byteEnvelopedFileInfoData = DSignTools.readFile(strFileNameIn);
        }
        catch (CSSException e) {
            this.longErrCode = longReturn = UtilTool.convertStr2Long(e.getCode(), -10700000L);
            this.strErrMsg = e.getDescription();
        }
        longReturn = this.decryptEnvelop(byteEnvelopedFileInfoData);
        return longReturn;
    }

    private byte[] getByteSignedData(String strFileNameIn) throws CSSException {
        byte[] signedData = null;
        try {
            FileInputStream fin = new FileInputStream(strFileNameIn);
            signedData = new byte[fin.available()];
            fin.read(signedData);
        }
        catch (FileNotFoundException e) {
            throw new CSSException("-10700001", ".", "\u6ca1\u6709\u627e\u5230\u76f8\u5e94\u7684\u6587\u4ef6", e.getMessage());
        }
        catch (IOException e) {
            throw new CSSException("-10700002", ".", "IO\u6d41\u9519\u8bef", e.getMessage());
        }
        return signedData;
    }

    public String getFile(String strSaveFilePath) {
        String strSaveFileName = null;
        byte[] byteSaveFileContent = null;
        String strSaveFileTotalPath = null;
        if (CommUtil.isNull(strSaveFilePath)) {
            this.longErrCode = -10703111L;
            this.strErrMsg = "\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u8fd8\u539f\u6587\u4ef6\u7684\u5b58\u50a8\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a\uff01";
            return null;
        }
        strSaveFileName = this.getFileName();
        byteSaveFileContent = this.getFilePlainData();
        if (strSaveFileName != null && strSaveFileName.trim().length() != 0) {
            strSaveFileTotalPath = strSaveFilePath.substring(strSaveFilePath.length() - 1).equals(File.separator) ? String.valueOf(strSaveFilePath) + strSaveFileName : String.valueOf(strSaveFilePath) + File.separator + strSaveFileName;
            try {
                DSignTools.writeByteToFile(strSaveFileTotalPath, byteSaveFileContent);
            }
            catch (CSSException e) {
                this.longErrCode = UtilTool.convertStr2Long(e.getCode(), -10700000L);
                this.strErrMsg = e.getDescription();
                strSaveFileName = null;
            }
        } else {
            return "";
        }
        return strSaveFileName;
    }

    public byte[] generateRandom(int length) {
        if (length < 0) {
            return null;
        }
        SecureRandom sRandom = new SecureRandom();
        byte[] data = new byte[length];
        sRandom.nextBytes(data);
        return data;
    }

    public byte[] genLvByte(int length, String content) {
        if (content == null || length < 0) {
            return null;
        }
        String len = String.valueOf(length);
        String addstr = "";
        switch (len.length()) {
            case 1: {
                addstr = "0000000";
                break;
            }
            case 2: {
                addstr = "000000";
                break;
            }
            case 3: {
                addstr = "00000";
                break;
            }
            case 4: {
                addstr = "0000";
                break;
            }
            case 5: {
                addstr = "000";
                break;
            }
            case 6: {
                addstr = "00";
                break;
            }
            case 7: {
                addstr = "0";
            }
        }
        len = String.valueOf(addstr) + len;
        byte[] lv = ArrayUtils.addAll((byte[])len.getBytes(), (byte[])content.getBytes());
        return lv;
    }

    public byte[] genHeadAndBlockNumByte(long pnum) {
        if (pnum < 0L) {
            return null;
        }
        int packageSize = config.getPackageSize() * 1024;
        String head = "";
        String strSize = String.valueOf(packageSize);
        switch (strSize.length()) {
            case 1: {
                head = "*000000";
                break;
            }
            case 2: {
                head = "*00000";
                break;
            }
            case 3: {
                head = "*0000";
                break;
            }
            case 4: {
                head = "*000";
                break;
            }
            case 5: {
                head = "*00";
                break;
            }
            case 6: {
                head = "*0";
                break;
            }
            case 7: {
                head = "*";
            }
        }
        head = String.valueOf(head) + strSize;
        byte[] headByte = head.getBytes();
        String blockNum = String.valueOf(pnum);
        String addstr = "";
        switch (blockNum.length()) {
            case 1: {
                addstr = "0000000";
                break;
            }
            case 2: {
                addstr = "000000";
                break;
            }
            case 3: {
                addstr = "00000";
                break;
            }
            case 4: {
                addstr = "0000";
                break;
            }
            case 5: {
                addstr = "000";
                break;
            }
            case 6: {
                addstr = "00";
                break;
            }
            case 7: {
                addstr = "0";
            }
        }
        blockNum = String.valueOf(addstr) + blockNum;
        byte[] blockNumByte = new byte[8];
        blockNumByte = blockNum.getBytes();
        byte[] headAndbLockNumByte = ArrayUtils.addAll((byte[])headByte, (byte[])blockNumByte);
        return headAndbLockNumByte;
    }

    public String genxml(String fileName, String content) {
        StringBuffer bufSignData = new StringBuffer();
        bufSignData.append("<?xml version=\"1.0\" encoding=\"GB2312\" standalone=\"no\"?>\r\n");
        bufSignData.append("<DSign>");
        bufSignData.append("\r\n\t");
        bufSignData.append("<File>");
        bufSignData.append("\r\n\t\t");
        bufSignData.append("<name>");
        bufSignData.append(fileName);
        bufSignData.append("</name>");
        bufSignData.append("\r\n\t\t");
        bufSignData.append("<content>");
        bufSignData.append(UtilTool.processBase64Code(content));
        bufSignData.append("</content>");
        bufSignData.append("\r\n\t");
        bufSignData.append("</File>");
        bufSignData.append("\r\n");
        bufSignData.append("</DSign>");
        return bufSignData.toString();
    }

    public void setTimeout(String timeout) {
        Config.getInstance().setTimeout(timeout);
    }

    public void setConnectTimeOut(String connectTimeOut) {
        Config.getInstance().setConnectTimeOut(connectTimeOut);
    }

    public String getTsaCertInfo(String itemName) {
        return this.rs.getTsaValue(itemName);
    }

    public Date getTsaTime() {
        return this.rs.getTsaTime();
    }

    public Date getTsaTimeByMS() {
        return this.rs.getTsaTimeByMS();
    }
}

