/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.assp.css.util.parser;

import cn.com.jit.assp.css.util.parser.SimpleElement;
import java.io.IOException;
import java.io.Reader;
import java.util.Stack;

public class SimpleDOMParser {
    private static final int[] cdata_start = new int[]{60, 33, 91, 67, 68, 65, 84, 65, 91};
    private static final int[] cdata_end = new int[]{93, 93, 62};
    private Reader reader;
    private Stack elements = new Stack();
    private SimpleElement currentElement = null;

    public SimpleElement parse(Reader reader) throws IOException {
        SimpleElement element;
        this.reader = reader;
        this.skipPrologs();
        while (true) {
            String tagName;
            String currentTag;
            if ((currentTag = this.readTag().trim()).startsWith("</")) {
                tagName = currentTag.substring(2, currentTag.length() - 1);
                if (this.currentElement == null) {
                    throw new IOException("Got close tag '" + tagName + "' without open tag.");
                }
                if (!tagName.equals(this.currentElement.getTagName())) {
                    throw new IOException("Expected close tag for '" + this.currentElement.getTagName() + "' but got '" + tagName + "'.");
                }
                if (this.elements.empty()) {
                    return this.currentElement;
                }
                this.currentElement = (SimpleElement)this.elements.pop();
                continue;
            }
            int index = currentTag.indexOf(" ");
            if (index < 0) {
                if (currentTag.endsWith("/>")) {
                    tagName = currentTag.substring(1, currentTag.length() - 2);
                    currentTag = "/>";
                } else {
                    tagName = currentTag.substring(1, currentTag.length() - 1);
                    currentTag = "";
                }
            } else {
                tagName = currentTag.substring(1, index);
                currentTag = currentTag.substring(index + 1);
            }
            element = new SimpleElement(tagName.trim());
            boolean isTagClosed = false;
            while (currentTag.length() > 0) {
                if ((currentTag = currentTag.trim()).equals("/>")) {
                    isTagClosed = true;
                    break;
                }
                if (currentTag.equals(">")) break;
                index = currentTag.indexOf("=");
                if (index < 0) {
                    throw new IOException("Invalid attribute for tag '" + tagName + "'.");
                }
                String attributeName = currentTag.substring(0, index);
                currentTag = currentTag.substring(index + 1);
                boolean isQuoted = true;
                if (currentTag.startsWith("\"")) {
                    index = currentTag.indexOf(34, 1);
                } else if (currentTag.startsWith("'")) {
                    index = currentTag.indexOf(39, 1);
                } else {
                    isQuoted = false;
                    index = currentTag.indexOf(32);
                    if (index < 0 && (index = currentTag.indexOf(62)) < 0) {
                        index = currentTag.indexOf(47);
                    }
                }
                if (index < 0) {
                    throw new IOException("Invalid attribute for tag '" + tagName + "'.");
                }
                String attributeValue = isQuoted ? currentTag.substring(1, index) : currentTag.substring(0, index);
                element.setAttribute(attributeName.trim(), attributeValue.trim());
                currentTag = currentTag.substring(index + 1);
            }
            if (!isTagClosed) {
                element.setText(this.readText().trim());
            }
            if (this.currentElement != null) {
                this.currentElement.addChildElement(element);
            }
            if (!isTagClosed) {
                if (this.currentElement != null) {
                    this.elements.push(this.currentElement);
                }
                this.currentElement = element;
                continue;
            }
            if (this.currentElement == null) break;
        }
        return element;
    }

    private int peek() throws IOException {
        this.reader.mark(1);
        int result = this.reader.read();
        this.reader.reset();
        return result;
    }

    private void peek(int[] buffer) throws IOException {
        this.reader.mark(buffer.length);
        for (int i = 0; i < buffer.length; ++i) {
            buffer[i] = this.reader.read();
        }
        this.reader.reset();
    }

    private void skipWhitespace() throws IOException {
        while (Character.isWhitespace((char)this.peek())) {
            this.reader.read();
        }
    }

    private void skipProlog() throws IOException {
        this.reader.skip(2L);
        while (true) {
            int next;
            if ((next = this.peek()) == 62) break;
            if (next == 60) {
                this.skipProlog();
                continue;
            }
            this.reader.read();
        }
        this.reader.read();
    }

    private void skipPrologs() throws IOException {
        while (true) {
            this.skipWhitespace();
            int[] next = new int[2];
            this.peek(next);
            if (next[0] != 60) {
                throw new IOException("Expected '<' but got '" + (char)next[0] + "'.");
            }
            if (next[1] != 63 && next[1] != 33) break;
            this.skipProlog();
        }
    }

    private String readTag() throws IOException {
        this.skipWhitespace();
        StringBuffer sb = new StringBuffer();
        int next = this.peek();
        if (next != 60) {
            throw new IOException("Expected < but got " + (char)next);
        }
        sb.append((char)this.reader.read());
        while (this.peek() != 62) {
            sb.append((char)this.reader.read());
        }
        sb.append((char)this.reader.read());
        return sb.toString();
    }

    private String readText() throws IOException {
        StringBuffer sb;
        block4: {
            sb = new StringBuffer();
            int[] next = new int[cdata_start.length];
            this.peek(next);
            if (this.compareIntArrays(next, cdata_start)) {
                this.reader.skip(next.length);
                int[] buffer = new int[cdata_end.length];
                while (true) {
                    this.peek(buffer);
                    if (this.compareIntArrays(buffer, cdata_end)) {
                        this.reader.skip(buffer.length);
                        break block4;
                    }
                    sb.append((char)this.reader.read());
                }
            }
            while (this.peek() != 60) {
                sb.append((char)this.reader.read());
            }
        }
        return sb.toString();
    }

    private boolean compareIntArrays(int[] a1, int[] a2) {
        if (a1.length != a2.length) {
            return false;
        }
        for (int i = 0; i < a1.length; ++i) {
            if (a1[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    public void destroy() {
        this.elements = null;
        this.reader = null;
    }
}

