/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.assp.css.util.parser;

import cn.com.jit.angel.response.WSDelCertTrustListResponseSet;
import cn.com.jit.angel.response.WSParseXMLSignedDataResponseSet;
import cn.com.jit.angel.response.WSPriKeyDecryptResponseSet;
import cn.com.jit.angel.response.WSPubKeyEncryptResponseSet;
import cn.com.jit.angel.response.WSQueryCertTrustListAltNamesResponseSet;
import cn.com.jit.angel.response.WSQueryCertTrustListResponseSet;
import cn.com.jit.angel.response.WSResponseSet;
import cn.com.jit.angel.response.WSSetCertTrustListResponseSet;
import cn.com.jit.angel.response.WSValidateCertResponseSet;
import cn.com.jit.assp.css.client.CSSException;
import cn.com.jit.assp.css.client.Config;
import cn.com.jit.assp.css.client.util.Base64;
import cn.com.jit.assp.css.util.ResponseSet;
import cn.com.jit.assp.css.util.parser.SimpleDOMParser;
import cn.com.jit.assp.css.util.parser.SimpleElement;
import cn.com.jit.assp.encrypt.SymmDecryptResponseSet;
import cn.com.jit.assp.encrypt.SymmEncryptResponseSet;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResponseParser {
    private static final Log log = LogFactory.getLog(ResponseParser.class);
    public static final String CLASS_NAME = ResponseParser.class.getName();
    static char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String ToHexString(byte[] bytes) {
        char[] chars = new char[bytes.length * 2];
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            chars[i * 2] = hexDigits[b >> 4];
            chars[i * 2 + 1] = hexDigits[b & 0xF];
        }
        return new String(chars);
    }

    public ResponseSet parserXML(String _xmlStr) throws CSSException {
        if (_xmlStr == null || _xmlStr.trim().length() == 0) {
            return null;
        }
        ByteArrayInputStream vByteArrayInputStream = null;
        try {
            vByteArrayInputStream = new ByteArrayInputStream(_xmlStr.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return this.parserXML(vByteArrayInputStream);
    }

    /*
     * Loose catch block
     */
    public ResponseSet parserXML(InputStream _in) throws CSSException {
        ResponseSet vRespSet;
        block81: {
            InputStreamReader vInStreamReader;
            BufferedReader vBufferedReader;
            block79: {
                String METHOD_NAME = "parserXML(InputStream _in)";
                vBufferedReader = null;
                vInStreamReader = null;
                vRespSet = new ResponseSet();
                SimpleDOMParser vDOMParser = null;
                vInStreamReader = new InputStreamReader(_in, "UTF-8");
                vBufferedReader = new BufferedReader(vInStreamReader);
                vDOMParser = new SimpleDOMParser();
                SimpleElement tRootse = vDOMParser.parse(vBufferedReader);
                SimpleElement tSe = null;
                String tStr = null;
                Object[] tObjse = tRootse.getChildElements();
                int i = 0;
                if (i < tObjse.length) {
                    tSe = (SimpleElement)tObjse[i];
                    if (tSe != null && tSe.getTagName().equals("Response")) {
                        tStr = tSe.getAttribute("svcid");
                        if (tStr == null || tStr.length() == 0) {
                            throw new CSSException("-10700104", CLASS_NAME + "." + "parserXML(InputStream _in)", "\u62a5\u6587\u4e2d\u672a\u53d6\u5230\u670d\u52a1\u8bf7\u6c42ID\uff01");
                        }
                        vRespSet.setSvcName(tStr);
                        if (tStr.equals("doDSign")) {
                            vRespSet.setSid(1);
                            this.parserDSignRespMsg(tSe, vRespSet);
                        } else if (tStr.equals("verifyDSign")) {
                            vRespSet.setSid(2);
                            this.parserVerifySignRespMsg(tSe, vRespSet);
                        } else if (tStr.equals("errBussiness")) {
                            this.parserErrorRespMsg(tSe, vRespSet);
                        } else if (tStr.equals("doDigest")) {
                            vRespSet.setSid(3);
                            this.parserDigestMsg(tSe, vRespSet);
                        } else if (tStr.equals("genRandom")) {
                            vRespSet.setSid(3);
                            this.parserRandomMsg(tSe, vRespSet);
                        } else if (tStr.equals("doTsa")) {
                            vRespSet.setSid(1);
                            this.parserTSASignRespMsg(tSe, vRespSet);
                        } else if (tStr.equals("verifyTsa")) {
                            vRespSet.setSid(2);
                            this.parserVerifyTsaRespMsg(tSe, vRespSet);
                        } else if (tStr.equals("getTsa")) {
                            vRespSet.setSid(1);
                            this.parserTSASignRespMsg(tSe, vRespSet);
                        } else if (tStr.equals("doSymEncrypt")) {
                            vRespSet = new SymmEncryptResponseSet();
                            this.parserSymmEncryptRespMsg(tSe, vRespSet);
                        } else if (tStr.equals("doSymDecrypt")) {
                            vRespSet = new SymmDecryptResponseSet();
                            this.parserSymmDecryptRespMsg(tSe, vRespSet);
                        } else if (tStr.equals("WSsetSignMethod")) {
                            vRespSet = new WSResponseSet();
                            this.parserSetSignMethod(tSe, vRespSet);
                        } else if (tStr.equals("WSgetSignMethod")) {
                            vRespSet = new WSResponseSet();
                            this.parserGetSignMethod(tSe, vRespSet);
                        } else if (tStr.equals("WSsetEncryptMethod")) {
                            vRespSet = new WSResponseSet();
                            this.parserSetEncryptMethod(tSe, vRespSet);
                        } else if (tStr.equals("WSgetEncryptMethod")) {
                            vRespSet = new WSResponseSet();
                            this.parserGetEncryptMethod(tSe, vRespSet);
                        } else if (tStr.equals("WSgetServerCertificate")) {
                            vRespSet = new WSResponseSet();
                            this.parserGetServerCertificate(tSe, vRespSet);
                        } else if (tStr.equals("WSgetCertInfo")) {
                            vRespSet = new WSResponseSet();
                            this.parserGetCertInfo(tSe, vRespSet);
                        } else if (tStr.equals("WSgetCertInfoByOid")) {
                            vRespSet = new WSResponseSet();
                            this.parserGetCertInfoByOid(tSe, vRespSet);
                        } else if (tStr.equals("WSgetP7SignDataInfo")) {
                            vRespSet = new WSResponseSet();
                            this.parserGetP7SignDataInfo(tSe, vRespSet);
                        } else if (tStr.equals("WSparseTimeStamp")) {
                            vRespSet = new WSResponseSet();
                            this.parseTimeStamp(tSe, vRespSet);
                        } else if (tStr.equals("WSpubKeyEncrypt")) {
                            vRespSet = new WSPubKeyEncryptResponseSet();
                            this.parserWSpubKeyEncrypt(tSe, vRespSet);
                        } else if (tStr.equals("WSpriKeyDecrypt")) {
                            vRespSet = new WSPriKeyDecryptResponseSet();
                            this.parserWSpriKeyDecrypt(tSe, vRespSet);
                        } else if (tStr.equals("WSvalidateCert")) {
                            vRespSet = new WSValidateCertResponseSet();
                            this.parserValidateCert(tSe, vRespSet);
                        } else if (tStr.equals("WScreateTimeStampRequest")) {
                            vRespSet = new WSResponseSet();
                            this.parserCreateTimeStampRequest(tSe, vRespSet);
                        } else if (tStr.equals("WScreateTimeStampResponse")) {
                            vRespSet = new WSResponseSet();
                            this.parserCreateTimeStampResponse(tSe, vRespSet);
                        } else if (tStr.equals("WSparseXMLSign")) {
                            vRespSet = new WSParseXMLSignedDataResponseSet();
                            this.parserWSparseXMLSign(tSe, vRespSet);
                        } else if (tStr.equals("WSsetCTL")) {
                            vRespSet = new WSSetCertTrustListResponseSet();
                            this.parserWSsetCTL(tSe, vRespSet);
                        } else if (tStr.equals("WSqueryCTLAltNames")) {
                            vRespSet = new WSQueryCertTrustListAltNamesResponseSet();
                            this.parserWSqueryCTLAltNames(tSe, vRespSet);
                        } else if (tStr.equals("WSqueryCTL")) {
                            vRespSet = new WSQueryCertTrustListResponseSet();
                            this.parserWSqueryCTL(tSe, vRespSet);
                        } else if (tStr.equals("WSdelCTL")) {
                            vRespSet = new WSDelCertTrustListResponseSet();
                            this.parserWSdelCTL(tSe, vRespSet);
                        }
                    } else {
                        throw new CSSException("-10700104", CLASS_NAME + "." + "parserXML(InputStream _in)", "\u62a5\u6587\u4e2d\u672a\u53d6\u5230\u670d\u52a1\u8bf7\u6c42ID\uff01");
                    }
                }
                tSe = null;
                tObjse = null;
                tRootse = null;
                vDOMParser.destroy();
                vDOMParser = null;
                Object var13_13 = null;
                if (vBufferedReader == null) break block79;
                try {
                    vBufferedReader.close();
                    vBufferedReader = null;
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
            if (vInStreamReader != null) {
                try {
                    vInStreamReader.close();
                    vInStreamReader = null;
                }
                catch (IOException ex2) {
                    // empty catch block
                }
            }
            if (_in != null) {
                try {
                    _in.close();
                    _in = null;
                }
                catch (IOException ex3) {}
            }
            break block81;
            {
                catch (IOException ex1) {
                    throw new CSSException("");
                }
            }
            catch (Throwable throwable) {
                Object var13_14 = null;
                if (vBufferedReader != null) {
                    try {
                        vBufferedReader.close();
                        vBufferedReader = null;
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                }
                if (vInStreamReader != null) {
                    try {
                        vInStreamReader.close();
                        vInStreamReader = null;
                    }
                    catch (IOException ex2) {
                        // empty catch block
                    }
                }
                if (_in != null) {
                    try {
                        _in.close();
                        _in = null;
                    }
                    catch (IOException ex3) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return vRespSet;
    }

    private void parserWSparseXMLSign(SimpleElement se, ResponseSet respSet) {
        Object[] vObjse = se.getChildElements();
        SimpleElement vSimElement = null;
        for (int j = 0; j < vObjse.length; ++j) {
            String tStr = null;
            vSimElement = (SimpleElement)vObjse[j];
            if (vSimElement == null) continue;
            if (vSimElement.getTagName().equals("WSparseXMLSignResult")) {
                tStr = vSimElement.getAttribute("status");
                boolean tBoolResult = new Boolean(tStr);
                ((WSParseXMLSignedDataResponseSet)respSet).setSucceed(tBoolResult);
                if (tBoolResult) continue;
                tStr = vSimElement.getAttribute("errcode");
                ((WSParseXMLSignedDataResponseSet)respSet).setErrCode(tStr);
                return;
            }
            if (!vSimElement.getTagName().equals("XMLSignData")) continue;
            try {
                ((WSParseXMLSignedDataResponseSet)respSet).setParsedInfo(new String(Base64.decode(vSimElement.getText()), "UTF-8"));
                continue;
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                continue;
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
        vSimElement = null;
        vObjse = null;
    }

    private void parserRandomMsg(SimpleElement se, ResponseSet respSet) throws CSSException {
        String METHOD_NAME = "parserRandomMsg(SimpleElement se, ResponseSet respSet)";
        Object[] vObjse = se.getChildElements();
        SimpleElement vSimElement = null;
        for (int j = 0; j < vObjse.length; ++j) {
            vSimElement = (SimpleElement)vObjse[j];
            String tStr = null;
            if (vSimElement == null) continue;
            if (vSimElement.getTagName().equals("genRandomResult")) {
                tStr = vSimElement.getAttribute("status");
                boolean tBoolResult = new Boolean(tStr);
                respSet.setSucceed(tBoolResult);
                if (tBoolResult) continue;
                tStr = vSimElement.getAttribute("errcode");
                respSet.setErrCode(tStr);
                return;
            }
            if (vSimElement.getTagName().equals("RandomData")) {
                String randomData = vSimElement.getText();
                respSet.setRandomData(randomData);
                continue;
            }
            throw new CSSException("-10706101", ".parserRandomMsg(SimpleElement se, ResponseSet respSet)", "\u89e3\u6790\u6458\u8981\u5e94\u7b54\u62a5\u6587\u5177\u4f53\u5185\u5bb9\u65f6\u51fa\u9519");
        }
        vSimElement = null;
        vObjse = null;
    }

    private void parserSymmEncryptRespMsg(SimpleElement se, ResponseSet respSet) {
        Object[] vObjse = se.getChildElements();
        SimpleElement vSimElement = null;
        for (int j = 0; j < vObjse.length; ++j) {
            String tStr = null;
            vSimElement = (SimpleElement)vObjse[j];
            if (vSimElement == null) continue;
            if (vSimElement.getTagName().equals("doSymEncryptResult")) {
                tStr = vSimElement.getAttribute("status");
                boolean tBoolResult = new Boolean(tStr);
                respSet.setSucceed(tBoolResult);
                if (tBoolResult) continue;
                tStr = vSimElement.getAttribute("errcode");
                ((SymmEncryptResponseSet)respSet).setErrorCode(tStr);
                tStr = vSimElement.getAttribute("errdesc");
                ((SymmEncryptResponseSet)respSet).setErrorMessage(tStr);
                return;
            }
            if (!vSimElement.getTagName().equals("EncryptedData")) continue;
            ((SymmEncryptResponseSet)respSet).setEncryptData(vSimElement.getText());
        }
        vSimElement = null;
        vObjse = null;
    }

    private void parserSetSignMethod(SimpleElement se, ResponseSet respSet) {
        Object[] vObjse = se.getChildElements();
        SimpleElement vSimElement = null;
        for (int j = 0; j < vObjse.length; ++j) {
            String tStr = null;
            vSimElement = (SimpleElement)vObjse[j];
            if (vSimElement == null || !vSimElement.getTagName().equals("WSsetSignMethodResult")) continue;
            tStr = vSimElement.getAttribute("status");
            boolean tBoolResult = new Boolean(tStr);
            respSet.setSucceed(tBoolResult);
            if (tBoolResult) continue;
            tStr = vSimElement.getAttribute("errcode");
            ((WSResponseSet)respSet).setErrorCode(tStr);
            tStr = vSimElement.getAttribute("errdesc");
            ((WSResponseSet)respSet).setErrorMessage(tStr);
            return;
        }
        vSimElement = null;
        vObjse = null;
    }

    private void parserSetEncryptMethod(SimpleElement se, ResponseSet respSet) {
        Object[] vObjse = se.getChildElements();
        SimpleElement vSimElement = null;
        for (int j = 0; j < vObjse.length; ++j) {
            String tStr = null;
            vSimElement = (SimpleElement)vObjse[j];
            if (vSimElement == null || !vSimElement.getTagName().equals("WSsetEncryptMethodResult")) continue;
            tStr = vSimElement.getAttribute("status");
            boolean tBoolResult = new Boolean(tStr);
            respSet.setSucceed(tBoolResult);
            if (tBoolResult) continue;
            tStr = vSimElement.getAttribute("errcode");
            ((WSResponseSet)respSet).setErrorCode(tStr);
            tStr = vSimElement.getAttribute("errdesc");
            ((WSResponseSet)respSet).setErrorMessage(tStr);
            return;
        }
        vSimElement = null;
        vObjse = null;
    }

    private void parserGetSignMethod(SimpleElement se, ResponseSet respSet) throws CSSException {
        String METHOD_NAME = "getSignMethod(SimpleElement se, ResponseSet respSet)";
        Object[] vObjse = se.getChildElements();
        SimpleElement vSimElement = null;
        for (int j = 0; j < vObjse.length; ++j) {
            String tStr = null;
            vSimElement = (SimpleElement)vObjse[j];
            if (vSimElement == null) continue;
            if (vSimElement.getTagName().equals("WSgetSignMethodResult")) {
                tStr = vSimElement.getAttribute("status");
                boolean tBoolResult = new Boolean(tStr);
                respSet.setSucceed(tBoolResult);
                if (tBoolResult) continue;
                tStr = vSimElement.getAttribute("errcode");
                ((WSResponseSet)respSet).setErrorCode(tStr);
                tStr = vSimElement.getAttribute("errdesc");
                ((WSResponseSet)respSet).setErrorMessage(tStr);
                return;
            }
            if (vSimElement.getTagName().equals("SignMethodData")) {
                ((WSResponseSet)respSet).setSignMethodData(vSimElement.getText());
                continue;
            }
            throw new CSSException("-10706101", ".getSignMethod(SimpleElement se, ResponseSet respSet)", "\u89e3\u6790\u6458\u8981\u5e94\u7b54\u62a5\u6587\u5177\u4f53\u5185\u5bb9\u65f6\u51fa\u9519");
        }
        vSimElement = null;
        vObjse = null;
    }

    private void parserGetEncryptMethod(SimpleElement se, ResponseSet respSet) throws CSSException {
        String METHOD_NAME = "getEncryptMethod(SimpleElement se, ResponseSet respSet)";
        Object[] vObjse = se.getChildElements();
        SimpleElement vSimElement = null;
        for (int j = 0; j < vObjse.length; ++j) {
            String tStr = null;
            vSimElement = (SimpleElement)vObjse[j];
            if (vSimElement == null) continue;
            if (vSimElement.getTagName().equals("WSgetEncryptMethodResult")) {
                tStr = vSimElement.getAttribute("status");
                boolean tBoolResult = new Boolean(tStr);
                respSet.setSucceed(tBoolResult);
                if (tBoolResult) continue;
                tStr = vSimElement.getAttribute("errcode");
                ((WSResponseSet)respSet).setErrorCode(tStr);
                tStr = vSimElement.getAttribute("errdesc");
                ((WSResponseSet)respSet).setErrorMessage(tStr);
                return;
            }
            if (vSimElement.getTagName().equals("GetEncryptMethodData")) {
                ((WSResponseSet)respSet).setEncryptMethodData(vSimElement.getText());
                continue;
            }
            throw new CSSException("-10706101", ".getEncryptMethod(SimpleElement se, ResponseSet respSet)", "\u89e3\u6790\u6458\u8981\u5e94\u7b54\u62a5\u6587\u5177\u4f53\u5185\u5bb9\u65f6\u51fa\u9519");
        }
        vSimElement = null;
        vObjse = null;
    }

    private void parserGetServerCertificate(SimpleElement se, ResponseSet respSet) throws CSSException {
        String METHOD_NAME = "getServerCertificate(SimpleElement se, ResponseSet respSet)";
        Object[] vObjse = se.getChildElements();
        SimpleElement vSimElement = null;
        for (int j = 0; j < vObjse.length; ++j) {
            String tStr = null;
            vSimElement = (SimpleElement)vObjse[j];
            if (vSimElement == null) continue;
            if (vSimElement.getTagName().equals("WSgetServerCertificateResult")) {
                tStr = vSimElement.getAttribute("status");
                boolean tBoolResult = new Boolean(tStr);
                respSet.setSucceed(tBoolResult);
                if (tBoolResult) continue;
                tStr = vSimElement.getAttribute("errcode");
                ((WSResponseSet)respSet).setErrorCode(tStr);
                tStr = vSimElement.getAttribute("errdesc");
                ((WSResponseSet)respSet).setErrorMessage(tStr);
                return;
            }
            if (vSimElement.getTagName().equals("ServerCertificateData")) {
                ((WSResponseSet)respSet).setServerCertificateData(vSimElement.getText());
                continue;
            }
            throw new CSSException("-10706101", ".getServerCertificate(SimpleElement se, ResponseSet respSet)", "\u89e3\u6790\u6458\u8981\u5e94\u7b54\u62a5\u6587\u5177\u4f53\u5185\u5bb9\u65f6\u51fa\u9519");
        }
        vSimElement = null;
        vObjse = null;
    }

    private void parserGetCertInfo(SimpleElement se, ResponseSet respSet) throws CSSException {
        String METHOD_NAME = "getEncryptMethod(SimpleElement se, ResponseSet respSet)";
        Object[] vObjse = se.getChildElements();
        SimpleElement vSimElement = null;
        for (int j = 0; j < vObjse.length; ++j) {
            String tStr = null;
            vSimElement = (SimpleElement)vObjse[j];
            if (vSimElement == null) continue;
            if (vSimElement.getTagName().equals("WSgetCertInfoResult")) {
                tStr = vSimElement.getAttribute("status");
                boolean tBoolResult = new Boolean(tStr);
                respSet.setSucceed(tBoolResult);
                if (tBoolResult) continue;
                tStr = vSimElement.getAttribute("errcode");
                ((WSResponseSet)respSet).setErrorCode(tStr);
                tStr = vSimElement.getAttribute("errdesc");
                ((WSResponseSet)respSet).setErrorMessage(tStr);
                return;
            }
            if (vSimElement.getTagName().equals("CertInfo")) {
                ((WSResponseSet)respSet).setCertInfo(vSimElement.getText());
                continue;
            }
            throw new CSSException("-10706101", ".getEncryptMethod(SimpleElement se, ResponseSet respSet)", "\u89e3\u6790\u6458\u8981\u5e94\u7b54\u62a5\u6587\u5177\u4f53\u5185\u5bb9\u65f6\u51fa\u9519");
        }
        vSimElement = null;
        vObjse = null;
    }

    private void parserGetP7SignDataInfo(SimpleElement se, ResponseSet respSet) throws CSSException {
        String METHOD_NAME = "getP7SignDataInfo(SimpleElement se, ResponseSet respSet)";
        Object[] vObjse = se.getChildElements();
        SimpleElement vSimElement = null;
        for (int j = 0; j < vObjse.length; ++j) {
            String tStr = null;
            vSimElement = (SimpleElement)vObjse[j];
            if (vSimElement == null) continue;
            if (vSimElement.getTagName().equals("WSgetCertInfoByOidResult")) {
                tStr = vSimElement.getAttribute("status");
                boolean tBoolResult = new Boolean(tStr);
                respSet.setSucceed(tBoolResult);
                if (tBoolResult) continue;
                tStr = vSimElement.getAttribute("errcode");
                ((WSResponseSet)respSet).setErrorCode(tStr);
                tStr = vSimElement.getAttribute("errdesc");
                ((WSResponseSet)respSet).setErrorMessage(tStr);
                return;
            }
            if (vSimElement.getTagName().equals("ResultData")) {
                ((WSResponseSet)respSet).setResultData(vSimElement.getText());
                continue;
            }
            throw new CSSException("-10706101", ".getP7SignDataInfo(SimpleElement se, ResponseSet respSet)", "\u89e3\u6790\u6458\u8981\u5e94\u7b54\u62a5\u6587\u5177\u4f53\u5185\u5bb9\u65f6\u51fa\u9519");
        }
        vSimElement = null;
        vObjse = null;
    }

    private void parseTimeStamp(SimpleElement se, ResponseSet respSet) throws CSSException {
        String METHOD_NAME = "parseTimeStamp(SimpleElement se, ResponseSet respSet)";
        Object[] vObjse = se.getChildElements();
        SimpleElement vSimElement = null;
        for (int j = 0; j < vObjse.length; ++j) {
            String tStr = null;
            vSimElement = (SimpleElement)vObjse[j];
            if (vSimElement == null) continue;
            if (vSimElement.getTagName().equals("WSparseTimeStamp")) {
                tStr = vSimElement.getAttribute("status");
                boolean tBoolResult = new Boolean(tStr);
                respSet.setSucceed(tBoolResult);
                if (tBoolResult) continue;
                tStr = vSimElement.getAttribute("errcode");
                ((WSResponseSet)respSet).setErrorCode(tStr);
                tStr = vSimElement.getAttribute("errdesc");
                ((WSResponseSet)respSet).setErrorMessage(tStr);
                return;
            }
            if (vSimElement.getTagName().equals("ResultData")) {
                ((WSResponseSet)respSet).setResultData(vSimElement.getText());
                continue;
            }
            throw new CSSException("-10706101", ".parseTimeStamp(SimpleElement se, ResponseSet respSet)", "\u89e3\u6790\u6458\u8981\u5e94\u7b54\u62a5\u6587\u5177\u4f53\u5185\u5bb9\u65f6\u51fa\u9519");
        }
        vSimElement = null;
        vObjse = null;
    }

    private void parserGetCertInfoByOid(SimpleElement se, ResponseSet respSet) throws CSSException {
        String METHOD_NAME = "getCertInfoByOid(SimpleElement se, ResponseSet respSet)";
        Object[] vObjse = se.getChildElements();
        SimpleElement vSimElement = null;
        for (int j = 0; j < vObjse.length; ++j) {
            String tStr = null;
            vSimElement = (SimpleElement)vObjse[j];
            if (vSimElement == null) continue;
            if (vSimElement.getTagName().equals("WSgetCertInfoByOidResult")) {
                tStr = vSimElement.getAttribute("status");
                boolean tBoolResult = new Boolean(tStr);
                respSet.setSucceed(tBoolResult);
                if (tBoolResult) continue;
                tStr = vSimElement.getAttribute("errcode");
                ((WSResponseSet)respSet).setErrorCode(tStr);
                tStr = vSimElement.getAttribute("errdesc");
                ((WSResponseSet)respSet).setErrorMessage(tStr);
                return;
            }
            if (vSimElement.getTagName().equals("CertInfoByOid")) {
                ((WSResponseSet)respSet).setCertInfoByOid(vSimElement.getText());
                continue;
            }
            throw new CSSException("-10706101", ".getCertInfoByOid(SimpleElement se, ResponseSet respSet)", "\u89e3\u6790\u6458\u8981\u5e94\u7b54\u62a5\u6587\u5177\u4f53\u5185\u5bb9\u65f6\u51fa\u9519");
        }
        vSimElement = null;
        vObjse = null;
    }

    private void parserCreateTimeStampRequest(SimpleElement se, ResponseSet respSet) throws CSSException {
        String METHOD_NAME = "parserCreateTimeStampRequest(SimpleElement se, ResponseSet respSet)";
        Object[] vObjse = se.getChildElements();
        SimpleElement vSimElement = null;
        for (int j = 0; j < vObjse.length; ++j) {
            String tStr = null;
            vSimElement = (SimpleElement)vObjse[j];
            if (vSimElement == null) continue;
            if (vSimElement.getTagName().equals("WScreateTimeStampRequestResult")) {
                tStr = vSimElement.getAttribute("status");
                boolean tBoolResult = new Boolean(tStr);
                respSet.setSucceed(tBoolResult);
                if (tBoolResult) continue;
                tStr = vSimElement.getAttribute("errcode");
                ((WSResponseSet)respSet).setErrorCode(tStr);
                tStr = vSimElement.getAttribute("errdesc");
                ((WSResponseSet)respSet).setErrorMessage(tStr);
                return;
            }
            if (vSimElement.getTagName().equals("TimeStampRequest")) {
                ((WSResponseSet)respSet).setTimeStampRequest(vSimElement.getText());
                continue;
            }
            throw new CSSException("-10706101", ".parserCreateTimeStampRequest(SimpleElement se, ResponseSet respSet)", "\u89e3\u6790\u6458\u8981\u5e94\u7b54\u62a5\u6587\u5177\u4f53\u5185\u5bb9\u65f6\u51fa\u9519");
        }
        vSimElement = null;
        vObjse = null;
    }

    private void parserCreateTimeStampResponse(SimpleElement se, ResponseSet respSet) throws CSSException {
        String METHOD_NAME = "parserCreateTimeStampResponse(SimpleElement se, ResponseSet respSet)";
        Object[] vObjse = se.getChildElements();
        SimpleElement vSimElement = null;
        for (int j = 0; j < vObjse.length; ++j) {
            String tStr = null;
            vSimElement = (SimpleElement)vObjse[j];
            if (vSimElement == null) continue;
            if (vSimElement.getTagName().equals("WScreateTimeStampResponseResult")) {
                tStr = vSimElement.getAttribute("status");
                boolean tBoolResult = new Boolean(tStr);
                respSet.setSucceed(tBoolResult);
                if (tBoolResult) continue;
                tStr = vSimElement.getAttribute("errcode");
                ((WSResponseSet)respSet).setErrorCode(tStr);
                tStr = vSimElement.getAttribute("errdesc");
                ((WSResponseSet)respSet).setErrorMessage(tStr);
                return;
            }
            if (vSimElement.getTagName().equals("TimeStampResponse")) {
                ((WSResponseSet)respSet).setTimeStampResponse(vSimElement.getText());
                continue;
            }
            throw new CSSException("-10706101", ".parserCreateTimeStampResponse(SimpleElement se, ResponseSet respSet)", "\u89e3\u6790\u6458\u8981\u5e94\u7b54\u62a5\u6587\u5177\u4f53\u5185\u5bb9\u65f6\u51fa\u9519");
        }
        vSimElement = null;
        vObjse = null;
    }

    private void parserSymmDecryptRespMsg(SimpleElement se, ResponseSet respSet) {
        Object[] vObjse = se.getChildElements();
        SimpleElement vSimElement = null;
        for (int j = 0; j < vObjse.length; ++j) {
            String tStr = null;
            vSimElement = (SimpleElement)vObjse[j];
            if (vSimElement == null) continue;
            if (vSimElement.getTagName().equals("dosymDecryptResult")) {
                tStr = vSimElement.getAttribute("status");
                boolean tBoolResult = new Boolean(tStr);
                respSet.setSucceed(tBoolResult);
                if (tBoolResult) continue;
                tStr = vSimElement.getAttribute("errcode");
                ((SymmDecryptResponseSet)respSet).setErrorCode(tStr);
                tStr = vSimElement.getAttribute("errdesc");
                ((SymmDecryptResponseSet)respSet).setErrorMessage(tStr);
                return;
            }
            if (vSimElement.getTagName().equals("PlainData")) {
                ((SymmDecryptResponseSet)respSet).setPlainData(vSimElement.getText());
                continue;
            }
            if (!vSimElement.getTagName().equals("ReturnContent")) continue;
            Object[] dataObjse = vSimElement.getChildElements();
            for (int i = 0; i < dataObjse.length; ++i) {
                SimpleElement deryptSimElement = (SimpleElement)dataObjse[i];
                if (!"plaindata".equals(deryptSimElement.getAttribute("name"))) continue;
                ((SymmDecryptResponseSet)respSet).setFileName(deryptSimElement.getAttribute("fileName"));
                ((SymmDecryptResponseSet)respSet).setPlainData(deryptSimElement.getText());
            }
        }
        vSimElement = null;
        vObjse = null;
    }

    private void parserWSpubKeyEncrypt(SimpleElement se, ResponseSet respSet) {
        Object[] vObjse = se.getChildElements();
        SimpleElement vSimElement = null;
        for (int j = 0; j < vObjse.length; ++j) {
            String tStr = null;
            vSimElement = (SimpleElement)vObjse[j];
            if (vSimElement == null) continue;
            if (vSimElement.getTagName().equals("WSpubKeyEncryptResult")) {
                tStr = vSimElement.getAttribute("status");
                boolean tBoolResult = new Boolean(tStr);
                respSet.setSucceed(tBoolResult);
                if (tBoolResult) continue;
                tStr = vSimElement.getAttribute("errcode");
                ((WSPubKeyEncryptResponseSet)respSet).setErrorCode(tStr);
                tStr = vSimElement.getAttribute("errdesc");
                ((WSPubKeyEncryptResponseSet)respSet).setErrorMessage(tStr);
                return;
            }
            if (!vSimElement.getTagName().equals("CipherText")) continue;
            ((WSPubKeyEncryptResponseSet)respSet).setPubKeyEncrypt(vSimElement.getText());
        }
        vSimElement = null;
        vObjse = null;
    }

    private void parserWSpriKeyDecrypt(SimpleElement se, ResponseSet respSet) {
        Object[] vObjse = se.getChildElements();
        SimpleElement vSimElement = null;
        for (int j = 0; j < vObjse.length; ++j) {
            String tStr = null;
            vSimElement = (SimpleElement)vObjse[j];
            if (vSimElement == null) continue;
            if (vSimElement.getTagName().equals("WSpriKeyDecryptResult")) {
                tStr = vSimElement.getAttribute("status");
                boolean tBoolResult = new Boolean(tStr);
                respSet.setSucceed(tBoolResult);
                if (tBoolResult) continue;
                tStr = vSimElement.getAttribute("errcode");
                ((WSPriKeyDecryptResponseSet)respSet).setErrorCode(tStr);
                tStr = vSimElement.getAttribute("errdesc");
                ((WSPriKeyDecryptResponseSet)respSet).setErrorMessage(tStr);
                return;
            }
            if (!vSimElement.getTagName().equals("PlainText")) continue;
            ((WSPriKeyDecryptResponseSet)respSet).setPriKeyDecrypt(Base64.decode(vSimElement.getText().getBytes()));
        }
        vSimElement = null;
        vObjse = null;
    }

    private void parserWSsetCTL(SimpleElement se, ResponseSet respSet) {
        Object[] vObjse = se.getChildElements();
        SimpleElement vSimElement = null;
        for (int j = 0; j < vObjse.length; ++j) {
            String tStr = null;
            vSimElement = (SimpleElement)vObjse[j];
            if (vSimElement == null) continue;
            if (vSimElement.getTagName().equals("WSsetCTL")) {
                tStr = vSimElement.getAttribute("status");
                boolean tBoolResult = new Boolean(tStr);
                respSet.setSucceed(tBoolResult);
                if (tBoolResult) continue;
                tStr = vSimElement.getAttribute("errcode");
                ((WSSetCertTrustListResponseSet)respSet).setErrorCode(tStr);
                tStr = vSimElement.getAttribute("errdesc");
                ((WSSetCertTrustListResponseSet)respSet).setErrorMessage(tStr);
                return;
            }
            if (!vSimElement.getTagName().equals("ctlResult")) continue;
            ((WSSetCertTrustListResponseSet)respSet).setCtlResult(vSimElement.getAttribute("status"));
        }
        vSimElement = null;
        vObjse = null;
    }

    private void parserWSqueryCTLAltNames(SimpleElement se, ResponseSet respSet) {
        Object[] vObjse = se.getChildElements();
        SimpleElement vSimElement = null;
        for (int j = 0; j < vObjse.length; ++j) {
            String tStr = null;
            vSimElement = (SimpleElement)vObjse[j];
            if (vSimElement == null) continue;
            if (vSimElement.getTagName().equals("WSqueryCTLAltNames")) {
                tStr = vSimElement.getAttribute("status");
                boolean tBoolResult = new Boolean(tStr);
                respSet.setSucceed(tBoolResult);
                if (tBoolResult) continue;
                tStr = vSimElement.getAttribute("errcode");
                ((WSQueryCertTrustListAltNamesResponseSet)respSet).setErrorCode(tStr);
                tStr = vSimElement.getAttribute("errdesc");
                ((WSQueryCertTrustListAltNamesResponseSet)respSet).setErrorMessage(tStr);
                return;
            }
            if (!vSimElement.getTagName().equals("ctlAltNames")) continue;
            ((WSQueryCertTrustListAltNamesResponseSet)respSet).setQueryCertTrustListAltNames(Base64.decode(vSimElement.getText()));
        }
        vSimElement = null;
        vObjse = null;
    }

    private void parserWSqueryCTL(SimpleElement se, ResponseSet respSet) {
        Object[] vObjse = se.getChildElements();
        SimpleElement vSimElement = null;
        for (int j = 0; j < vObjse.length; ++j) {
            String tStr = null;
            vSimElement = (SimpleElement)vObjse[j];
            if (vSimElement == null) continue;
            if (vSimElement.getTagName().equals("WSqueryCTL")) {
                tStr = vSimElement.getAttribute("status");
                boolean tBoolResult = new Boolean(tStr);
                respSet.setSucceed(tBoolResult);
                if (tBoolResult) continue;
                tStr = vSimElement.getAttribute("errcode");
                ((WSQueryCertTrustListResponseSet)respSet).setErrorCode(tStr);
                tStr = vSimElement.getAttribute("errdesc");
                ((WSQueryCertTrustListResponseSet)respSet).setErrorMessage(tStr);
                return;
            }
            if (!vSimElement.getTagName().equals("ctlContent")) continue;
            ((WSQueryCertTrustListResponseSet)respSet).setQueryCertTrustList(vSimElement.getText());
        }
        vSimElement = null;
        vObjse = null;
    }

    private void parserWSdelCTL(SimpleElement se, ResponseSet respSet) {
        Object[] vObjse = se.getChildElements();
        SimpleElement vSimElement = null;
        for (int j = 0; j < vObjse.length; ++j) {
            String tStr = null;
            vSimElement = (SimpleElement)vObjse[j];
            if (vSimElement == null) continue;
            if (vSimElement.getTagName().equals("WSdelCTL")) {
                tStr = vSimElement.getAttribute("status");
                boolean tBoolResult = new Boolean(tStr);
                respSet.setSucceed(tBoolResult);
                if (tBoolResult) continue;
                tStr = vSimElement.getAttribute("errcode");
                ((WSDelCertTrustListResponseSet)respSet).setErrorCode(tStr);
                tStr = vSimElement.getAttribute("errdesc");
                ((WSDelCertTrustListResponseSet)respSet).setErrorMessage(tStr);
                return;
            }
            if (!vSimElement.getTagName().equals("ctlResult")) continue;
            ((WSDelCertTrustListResponseSet)respSet).setDelCertTrustList(vSimElement.getAttribute("status"));
        }
        vSimElement = null;
        vObjse = null;
    }

    private void parserValidateCert(SimpleElement se, ResponseSet respSet) {
        Object[] vObjse = se.getChildElements();
        SimpleElement vSimElement = null;
        for (int j = 0; j < vObjse.length; ++j) {
            String tStr = null;
            vSimElement = (SimpleElement)vObjse[j];
            if (vSimElement == null) continue;
            if (vSimElement.getTagName().equals("WSvalidateCert")) {
                tStr = vSimElement.getAttribute("status");
                boolean tBoolResult = new Boolean(tStr);
                respSet.setSucceed(tBoolResult);
                if (tBoolResult) continue;
                tStr = vSimElement.getAttribute("errcode");
                ((WSPriKeyDecryptResponseSet)respSet).setErrorCode(tStr);
                tStr = vSimElement.getAttribute("errdesc");
                ((WSPriKeyDecryptResponseSet)respSet).setErrorMessage(tStr);
                return;
            }
            if (!vSimElement.getTagName().equals("WSvalidateCertType")) continue;
            ((WSValidateCertResponseSet)respSet).setValidateCert(new String(Base64.decode(vSimElement.getText())));
        }
        vSimElement = null;
        vObjse = null;
    }

    public void parserRtnInfo(SimpleElement _selement, ResponseSet _response) {
        Object[] tobjse = _selement.getChildElements();
        SimpleElement ttse = null;
        for (int j = 0; j < tobjse.length; ++j) {
            ttse = (SimpleElement)tobjse[j];
            if (ttse == null) continue;
            if (ttse.getTagName().equals("DSInfo")) {
                _response.setDsBaseInfo(this.getItemMap(ttse));
                continue;
            }
            if (ttse.getTagName().equals("DSCertInfo")) {
                _response.setDsCertInfo(this.getItemMap(ttse));
                continue;
            }
            if (ttse.getTagName().equals("TSACertInfo")) {
                _response.setTsaInfo(this.getItemMap(ttse));
                continue;
            }
            if (!ttse.getTagName().equals("ExpandInfo")) continue;
            _response.setErrCode(ttse.getText());
        }
        ttse = null;
        tobjse = null;
    }

    public void parserRtnCertInfo(SimpleElement _selement, ResponseSet _response) {
        Object[] tobjse = _selement.getChildElements();
        SimpleElement ttse = null;
        for (int j = 0; j < tobjse.length; ++j) {
            ttse = (SimpleElement)tobjse[j];
            if (ttse == null || !ttse.getTagName().equals("DSCertInfo")) continue;
            _response.setDsCertInfo(this.getItemMap(ttse));
        }
        ttse = null;
        tobjse = null;
    }

    private HashMap getItemMap(SimpleElement _selement) {
        HashMap<String, String> tmap = null;
        Object[] tobjse = _selement.getChildElements();
        SimpleElement ttse = null;
        String tname = null;
        String tvalue = null;
        if (tobjse != null && tobjse.length > 0) {
            tmap = new HashMap<String, String>(tobjse.length);
            for (int j = 0; j < tobjse.length; ++j) {
                ttse = (SimpleElement)tobjse[j];
                if (ttse == null || !ttse.getTagName().equals("Item")) continue;
                tname = ttse.getAttribute("name");
                if (tname != null && tname.length() > 0) {
                    tvalue = ttse.getText();
                    tmap.put(tname.toLowerCase(), tvalue);
                }
                if ((tname = ttse.getAttribute("fileName")) == null || tname.length() <= 0) continue;
                try {
                    String fileSystemChartSet = Config.getInstance().getFileSystemCharSet();
                    String systemCharSet = Config.getInstance().getSystemCharSet();
                    if (null == fileSystemChartSet || "default".equals(fileSystemChartSet)) {
                        String tempStr = new String(Base64.decode(tname));
                        tmap.put("fileName", tempStr);
                        continue;
                    }
                    tmap.put("fileName", new String(Base64.decode(tname), fileSystemChartSet));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    log.error((Object)"Encoding the fileName error!", (Throwable)e);
                }
            }
        }
        return tmap;
    }

    public void parserDSignRespMsg(SimpleElement _selement, ResponseSet _response) {
        Object[] vObjse = _selement.getChildElements();
        SimpleElement vSimElement = null;
        for (int j = 0; j < vObjse.length; ++j) {
            String tStr = null;
            vSimElement = (SimpleElement)vObjse[j];
            if (vSimElement == null) continue;
            if (vSimElement.getTagName().equals("doDSignResult")) {
                tStr = vSimElement.getAttribute("status");
                boolean tBoolResult = new Boolean(tStr);
                _response.setSucceed(tBoolResult);
                if (tBoolResult) continue;
                tStr = vSimElement.getAttribute("errcode");
                _response.setErrCode(tStr);
                tStr = vSimElement.getAttribute("errdesc");
                _response.setErrDesc(tStr);
                return;
            }
            if (vSimElement.getTagName().equals("DSignData")) {
                _response.setSignedData(vSimElement.getText());
                continue;
            }
            if (!vSimElement.getTagName().equals("ReturnContent")) continue;
            this.parserRtnInfo(vSimElement, _response);
        }
        vSimElement = null;
        vObjse = null;
    }

    public void parserTSASignRespMsg(SimpleElement _selement, ResponseSet _response) {
        Object[] vObjse = _selement.getChildElements();
        SimpleElement vSimElement = null;
        for (int j = 0; j < vObjse.length; ++j) {
            String tStr = null;
            vSimElement = (SimpleElement)vObjse[j];
            if (vSimElement == null) continue;
            if (vSimElement.getTagName().equals("doDSignResult")) {
                tStr = vSimElement.getAttribute("status");
                boolean tBoolResult = new Boolean(tStr);
                _response.setSucceed(tBoolResult);
                if (tBoolResult) continue;
                tStr = vSimElement.getAttribute("errcode");
                _response.setErrCode(tStr);
                tStr = vSimElement.getAttribute("errdesc");
                _response.setErrDesc(tStr);
                return;
            }
            if (vSimElement.getTagName().equals("DTsaData")) {
                _response.setSignedData(vSimElement.getText());
                continue;
            }
            if (!vSimElement.getTagName().equals("DTsaSid")) continue;
            _response.setTsaSid(vSimElement.getText());
        }
        vSimElement = null;
        vObjse = null;
    }

    public void parserVerifySignRespMsg(SimpleElement _selement, ResponseSet _response) {
        Object[] vObjse = _selement.getChildElements();
        SimpleElement vSimElement = null;
        for (int j = 0; j < vObjse.length; ++j) {
            vSimElement = (SimpleElement)vObjse[j];
            String tStr = null;
            if (vSimElement == null) continue;
            if (vSimElement.getTagName().equals("verifyDSignResult")) {
                tStr = vSimElement.getAttribute("status");
                boolean tBoolResult = new Boolean(tStr);
                _response.setSucceed(tBoolResult);
                if (tBoolResult) continue;
                tStr = vSimElement.getAttribute("errcode");
                _response.setErrCode(tStr);
                tStr = vSimElement.getAttribute("errdesc");
                _response.setErrDesc(tStr);
                return;
            }
            if (!vSimElement.getTagName().equals("ReturnContent")) continue;
            this.parserRtnInfo(vSimElement, _response);
        }
        vSimElement = null;
        vObjse = null;
    }

    public void parserVerifyTsaRespMsg(SimpleElement _selement, ResponseSet _response) {
        Object[] vObjse = _selement.getChildElements();
        SimpleElement vSimElement = null;
        for (int j = 0; j < vObjse.length; ++j) {
            vSimElement = (SimpleElement)vObjse[j];
            String tStr = null;
            if (vSimElement == null) continue;
            if (vSimElement.getTagName().equals("verifyDSignResult")) {
                tStr = vSimElement.getAttribute("status");
                boolean tBoolResult = new Boolean(tStr);
                _response.setSucceed(tBoolResult);
                if (tBoolResult) continue;
                tStr = vSimElement.getAttribute("errcode");
                _response.setErrCode(tStr);
                tStr = vSimElement.getAttribute("errdesc");
                _response.setErrDesc(tStr);
                return;
            }
            if (!vSimElement.getTagName().equals("ReturnContent")) continue;
            this.parserRtnInfo(vSimElement, _response);
        }
        vSimElement = null;
        vObjse = null;
    }

    public void parserDigestMsg(SimpleElement _selement, ResponseSet _response) throws CSSException {
        String METHOD_NAME = "parserDigestMsg(SimpleElement _selement,EnvelopResponseSet _response)";
        Object[] vObjse = _selement.getChildElements();
        SimpleElement vSimElement = null;
        for (int j = 0; j < vObjse.length; ++j) {
            vSimElement = (SimpleElement)vObjse[j];
            String tStr = null;
            if (vSimElement == null) continue;
            if (vSimElement.getTagName().equals("doDigestResult")) {
                tStr = vSimElement.getAttribute("status");
                boolean tBoolResult = new Boolean(tStr);
                _response.setSucceed(tBoolResult);
                if (tBoolResult) continue;
                tStr = vSimElement.getAttribute("errcode");
                _response.setErrCode(tStr);
                return;
            }
            if (vSimElement.getTagName().equals("DigestData")) {
                String plaintext = vSimElement.getText();
                _response.setPlainData(plaintext);
                continue;
            }
            throw new CSSException("-10706101", ".parserDigestMsg(SimpleElement _selement,EnvelopResponseSet _response)", "\u89e3\u6790\u6458\u8981\u5e94\u7b54\u62a5\u6587\u5177\u4f53\u5185\u5bb9\u65f6\u51fa\u9519");
        }
        vSimElement = null;
        vObjse = null;
    }

    public void parserErrorRespMsg(SimpleElement _selement, ResponseSet _response) {
        Object[] vObjse = _selement.getChildElements();
        SimpleElement vSimElement = null;
        for (int j = 0; j < vObjse.length; ++j) {
            vSimElement = (SimpleElement)vObjse[j];
            String tStr = null;
            if (vSimElement == null || !vSimElement.getTagName().equals("Exception")) continue;
            tStr = vSimElement.getAttribute("errcode");
            _response.setErrCode(tStr);
            _response.setSucceed(false);
        }
        vSimElement = null;
        vObjse = null;
    }
}

