/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.assp.css.util;

import cn.com.jit.assp.css.client.Config;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class RequestSet
implements Serializable {
    private String signedData;
    private String plainData;
    private int dsignMode;
    private int signedDataType;
    private int plainDataType;
    private String svcName;
    private int sid = 0;
    private String digestAlg;
    private String version = "";
    private int dsCertIODType = 0;
    private int verifyMode = 0;
    private List dsBaseParaInfoList = new ArrayList(0);
    private List dsCertBaseParaInfoList = new ArrayList(0);
    private List tsaCertBaseParaInfoList;
    private List dsCertExtParaInfoList = new ArrayList(0);
    private String dsCert = "";
    private String dsAlg = "";
    private boolean returnPlainData = false;
    private boolean returnDsCert = false;
    private boolean returnDsAlg = false;
    private boolean returnDigestAlg = false;
    private boolean returnDigestData = false;
    private boolean containPlainData = false;
    private boolean containDsCert = false;
    private boolean returnDefCertInfo = false;
    private String applyID = "";
    private String issuerAndSn;
    private String encryptAlg;
    private int randomLength;

    public RequestSet() {
        this.tsaCertBaseParaInfoList = new ArrayList(0);
    }

    public void setReturnPlainData(boolean _value) {
        this.returnPlainData = _value;
    }

    public boolean isReturnPlainData() {
        return this.returnPlainData;
    }

    public void setReturnDigestData(boolean _value) {
        this.returnDigestData = _value;
    }

    public boolean isReturnDigestData() {
        return this.returnDigestData;
    }

    public void setReturnDigestAlg(boolean _value) {
        this.returnDigestAlg = _value;
    }

    public boolean isReturnDigestAlg() {
        return this.returnDigestAlg;
    }

    public void setReturnDsCert(boolean _value) {
        this.returnDsCert = _value;
    }

    public boolean isReturnDsCert() {
        return this.returnDsCert;
    }

    public boolean isContainDsCert() {
        return this.containDsCert;
    }

    public boolean isContainPlainData() {
        return this.containPlainData;
    }

    public void setReturnDsAlg(boolean _value) {
        this.returnDsAlg = _value;
    }

    public boolean isReturnDsAlg() {
        return this.returnDsAlg;
    }

    public void setSignedData(String _data) {
        this.signedData = _data;
    }

    public String getSignedData() {
        return this.signedData;
    }

    public void setPlainData(String _data) {
        this.plainData = _data;
    }

    public String getPlainData() {
        return this.plainData;
    }

    public String getEncryptAlg() {
        return this.encryptAlg;
    }

    public void setEncryptAlg(String encryptAlg) {
        this.encryptAlg = encryptAlg;
    }

    public String getIssuerAndSn() {
        return this.issuerAndSn;
    }

    public void setIssuerAndSn(String issuerAndSn) {
        this.issuerAndSn = issuerAndSn;
    }

    public void setDSignMode(int _type) {
        this.dsignMode = _type;
        switch (_type) {
            case 0: {
                this.containDsCert = false;
                this.containPlainData = false;
                break;
            }
            case 1: {
                this.containDsCert = true;
                this.containPlainData = false;
                break;
            }
            case 2: {
                this.containDsCert = false;
                this.containPlainData = true;
                break;
            }
            case 3: {
                this.containDsCert = true;
                this.containPlainData = true;
                break;
            }
            default: {
                this.containDsCert = false;
                this.containPlainData = false;
            }
        }
    }

    public int getSignedDataType() {
        return this.signedDataType;
    }

    public void setSignedDataType(int _value) {
        this.signedDataType = _value;
    }

    public void setPlainDataType(int _srctype) {
        this.plainDataType = _srctype;
    }

    public int getPlainDataType() {
        return this.plainDataType;
    }

    public void setVerifyMode(int _verifyMode) {
        if (_verifyMode == 2) {
            this.returnDigestAlg = true;
            this.returnDigestData = true;
        }
        this.verifyMode = _verifyMode;
    }

    public int getVerifyMode() {
        return this.verifyMode;
    }

    public void setSid(int _sid) {
        this.sid = _sid;
    }

    public int getSid() {
        return this.sid;
    }

    public void setSvcName(String _svcname) {
        this.svcName = _svcname;
    }

    public String getSvcName() {
        return this.svcName;
    }

    public void setVersion(String _version) {
        this.version = _version;
    }

    public String getVersion() {
        return this.version;
    }

    public void setDsAlg(String _alg) {
        this.dsAlg = _alg;
    }

    public String getDsAlg() {
        return this.dsAlg;
    }

    public void setDsCert(String _cert) {
        this.dsCert = _cert;
    }

    public String getDsCert() {
        return this.dsCert;
    }

    public void setReqCertBaseKeys(List _list) {
        this.dsCertBaseParaInfoList = _list;
    }

    public void setReqTsaCertBaseKeys(List _list) {
        this.tsaCertBaseParaInfoList = _list;
    }

    public List getReqCertBaseKeys() {
        return this.dsCertBaseParaInfoList;
    }

    public void setReqCertExtKeys(List _list) {
        this.dsCertExtParaInfoList = _list;
    }

    public int getDsCertOidType() {
        return this.dsCertIODType;
    }

    public void setDsCertOidType(int _value) {
        this.dsCertIODType = _value;
    }

    public List getReqCertExtKeys() {
        return this.dsCertExtParaInfoList;
    }

    public void setReqDSBaseKeys(List _list) {
        this.dsBaseParaInfoList = _list;
        if (_list != null) {
            this.dsBaseParaInfoList = _list;
            if (_list.contains("plaindata")) {
                this.returnPlainData = true;
            }
            if (_list.contains("dscert")) {
                this.returnDsCert = true;
            }
            if (_list.contains("dsalg")) {
                this.returnDsAlg = true;
            }
            if (_list.contains("digestalg")) {
                this.returnDigestAlg = true;
            }
            if (_list.contains("digestdata")) {
                this.returnDigestData = true;
            }
        }
    }

    public List getReqDSBaseKeys() {
        return this.dsBaseParaInfoList;
    }

    public void destroy() {
        if (this.dsCertBaseParaInfoList != null) {
            this.dsCertBaseParaInfoList.clear();
            this.dsCertBaseParaInfoList = null;
        }
        if (this.tsaCertBaseParaInfoList != null) {
            this.tsaCertBaseParaInfoList.clear();
            this.tsaCertBaseParaInfoList = null;
        }
        if (this.dsCertExtParaInfoList != null) {
            this.dsCertExtParaInfoList.clear();
            this.dsCertExtParaInfoList = null;
        }
        if (this.dsBaseParaInfoList != null) {
            this.dsBaseParaInfoList.clear();
            this.dsBaseParaInfoList = null;
        }
    }

    public String toXMLString() {
        StringBuffer stringbuffer = new StringBuffer();
        stringbuffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\r");
        stringbuffer.append("<DSignContext Version =\"1.0\">");
        if (this.sid == 1) {
            int i;
            stringbuffer.append("<Request svcid=\"doDSign\">");
            stringbuffer.append("<ApplyID>").append(this.applyID).append("</ApplyID>");
            stringbuffer.append("<PlainData type=\"").append(this.plainDataType).append("\">").append(this.plainData).append("</PlainData>");
            stringbuffer.append("<DSignMode>").append(this.dsignMode).append("</DSignMode>");
            if (this.digestAlg != null) {
                stringbuffer.append("<DSDigestALG>").append(this.digestAlg).append("</DSDigestALG>");
            }
            stringbuffer.append("<RequestRtnContent>");
            String tmpStr = null;
            if (this.dsBaseParaInfoList != null && this.dsBaseParaInfoList.size() > 0) {
                stringbuffer.append("<DSBaseInfo>");
                for (i = 0; i < this.dsBaseParaInfoList.size(); ++i) {
                    tmpStr = (String)this.dsBaseParaInfoList.get(i);
                    if (tmpStr == null) continue;
                    stringbuffer.append("<Item name=\"").append(tmpStr.toLowerCase()).append("\"/>");
                }
                stringbuffer.append("</DSBaseInfo>");
            }
            if (this.dsCertBaseParaInfoList != null && this.dsCertBaseParaInfoList.size() > 0) {
                stringbuffer.append("<DSCertBaseInfo>");
                for (i = 0; i < this.dsCertBaseParaInfoList.size(); ++i) {
                    tmpStr = (String)this.dsCertBaseParaInfoList.get(i);
                    if (this.dsCertBaseParaInfoList.get(i) == null) continue;
                    stringbuffer.append("<Item name=\"").append(tmpStr.trim().toLowerCase()).append("\"/>");
                }
                stringbuffer.append("</DSCertBaseInfo>");
            }
            if (this.tsaCertBaseParaInfoList != null && this.tsaCertBaseParaInfoList.size() > 0) {
                stringbuffer.append("<TSACertBaseInfo>");
                for (i = 0; i < this.tsaCertBaseParaInfoList.size(); ++i) {
                    tmpStr = (String)this.tsaCertBaseParaInfoList.get(i);
                    if (this.tsaCertBaseParaInfoList.get(i) == null) continue;
                    stringbuffer.append("<Item name=\"").append(tmpStr.trim().toLowerCase()).append("\"/>");
                }
                stringbuffer.append("</TSACertBaseInfo>");
            }
            if (this.dsCertExtParaInfoList != null) {
                stringbuffer.append("<DSCertExtInfo>");
                for (i = 0; i < this.dsCertExtParaInfoList.size(); ++i) {
                    tmpStr = (String)this.dsCertExtParaInfoList.get(i);
                    if (tmpStr == null) continue;
                    stringbuffer.append("<Item name=\"").append(tmpStr.toLowerCase()).append("\"/>");
                }
                stringbuffer.append("</DSCertExtInfo>");
            }
            stringbuffer.append("</RequestRtnContent>");
        } else if (this.sid == 2) {
            int i;
            stringbuffer.append("<Request svcid=\"verifyDSign\">");
            if (this.plainData != null && this.plainData.length() > 0) {
                stringbuffer.append("<PlainData>").append(this.plainData).append("</PlainData>");
            }
            stringbuffer.append("<DSignData verifyMode=\"").append(this.verifyMode).append("\">").append(this.signedData).append("</DSignData>");
            if (this.verifyMode == 3) {
                stringbuffer.append("<VerifySignCertIssuerAndSN paramType=\"").append(Config.getInstance().getP1VerifyCertId()).append("\">");
                stringbuffer.append(this.issuerAndSn);
                stringbuffer.append("</VerifySignCertIssuerAndSN>");
                stringbuffer.append("<DSDigestALG>");
                stringbuffer.append(this.digestAlg);
                stringbuffer.append("</DSDigestALG>");
                stringbuffer.append("<EncAlg>");
                stringbuffer.append(this.encryptAlg);
                stringbuffer.append("</EncAlg>");
            }
            stringbuffer.append("<RequestRtnContent>");
            String tmpStr = null;
            if (this.dsBaseParaInfoList != null && this.dsBaseParaInfoList.size() > 0) {
                stringbuffer.append("<DSBaseInfo>");
                for (i = 0; i < this.dsBaseParaInfoList.size(); ++i) {
                    tmpStr = (String)this.dsBaseParaInfoList.get(i);
                    if (tmpStr == null) continue;
                    stringbuffer.append("<Item name=\"").append(tmpStr.toLowerCase()).append("\"/>");
                }
                stringbuffer.append("</DSBaseInfo>");
            }
            if (this.dsCertBaseParaInfoList != null && this.dsCertBaseParaInfoList.size() > 0) {
                stringbuffer.append("<DSCertBaseInfo>");
                for (i = 0; i < this.dsCertBaseParaInfoList.size(); ++i) {
                    tmpStr = (String)this.dsCertBaseParaInfoList.get(i);
                    if (this.dsCertBaseParaInfoList.get(i) == null) continue;
                    stringbuffer.append("<Item name=\"").append(tmpStr.trim().toLowerCase()).append("\"/>");
                }
                stringbuffer.append("</DSCertBaseInfo>");
            }
            if (this.tsaCertBaseParaInfoList != null && this.tsaCertBaseParaInfoList.size() > 0) {
                stringbuffer.append("<TSACertBaseInfo>");
                for (i = 0; i < this.tsaCertBaseParaInfoList.size(); ++i) {
                    tmpStr = (String)this.tsaCertBaseParaInfoList.get(i);
                    if (this.tsaCertBaseParaInfoList.get(i) == null) continue;
                    stringbuffer.append("<Item name=\"").append(tmpStr.trim().toLowerCase()).append("\"/>");
                }
                stringbuffer.append("</TSACertBaseInfo>");
            }
            if (this.dsCertExtParaInfoList != null) {
                stringbuffer.append("<DSCertExtInfo>");
                for (i = 0; i < this.dsCertExtParaInfoList.size(); ++i) {
                    tmpStr = (String)this.dsCertExtParaInfoList.get(i);
                    if (tmpStr == null) continue;
                    stringbuffer.append("<Item name=\"").append(tmpStr.toLowerCase()).append("\"/>");
                }
                stringbuffer.append("</DSCertExtInfo>");
            }
            stringbuffer.append("</RequestRtnContent>");
            Object var2_3 = null;
        } else if (this.sid == 3) {
            stringbuffer.append("<Request svcid=\"genRandom\">");
            stringbuffer.append("<ParaInfo>");
            stringbuffer.append("<Length>").append(this.randomLength).append("</Length>");
            stringbuffer.append("</ParaInfo>");
        }
        stringbuffer.append("</Request>");
        stringbuffer.append("</DSignContext>");
        return stringbuffer.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(50);
        if (this.plainData != null) {
            sb.append("srcData:").append(this.plainData).append("\n");
        } else {
            sb.append("srcData:").append("\n");
        }
        if (this.signedData != null) {
            sb.append("signedData:").append(this.signedData).append("\n");
        } else {
            sb.append("signedData:").append("\n");
        }
        if (this.svcName != null) {
            sb.append("svcName:").append(this.svcName).append("\n");
        } else {
            sb.append("svcName:").append("\n");
        }
        if (this.digestAlg != null) {
            sb.append("dsDigestAlg:").append(this.digestAlg).append("\n");
        } else {
            sb.append("dsDigestAlg:").append("\n");
        }
        if (this.dsCertBaseParaInfoList != null && this.dsCertBaseParaInfoList.size() > 0) {
            sb.append("dsCertBaseParaInfo:").append((String)this.dsCertBaseParaInfoList.get(0));
            for (int i = 1; i < this.dsCertBaseParaInfoList.size(); ++i) {
                sb.append(";");
                sb.append((String)this.dsCertBaseParaInfoList.get(i));
            }
            sb.append("\n");
        } else {
            sb.append("dsCertBaseParaInfo:").append("\n");
        }
        sb.append("verifyMode:").append(this.verifyMode).append("\n");
        sb.append("signedDataType:").append(this.signedDataType).append("\n");
        return sb.toString();
    }

    public String getDigestAlg() {
        return this.digestAlg;
    }

    public void setDigestAlg(String digestAlg) {
        this.digestAlg = digestAlg;
    }

    public boolean isReturnDefCertInfo() {
        return this.returnDefCertInfo;
    }

    public void setReturnDefCertInfo(boolean returnDefCertInfo) {
        this.returnDefCertInfo = returnDefCertInfo;
    }

    public String getApplyID() {
        return this.applyID;
    }

    public void setApplyID(String applyID) {
        this.applyID = applyID;
    }

    public int getRandomLength() {
        return this.randomLength;
    }

    public void setRandomLength(int randomLength) {
        this.randomLength = randomLength;
    }
}

