/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.assp.css.client.util;

import cn.com.jit.assp.css.client.Config;
import cn.com.jit.assp.css.client.util.PlainOfFileModel;
import cn.com.jit.assp.css.util.parser.SimpleDOMParser;
import cn.com.jit.assp.css.util.parser.SimpleElement;
import cn.com.jit.ida.util.pki.encoders.Base64;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UtilTool {
    private static final Log LOGGER = LogFactory.getLog(UtilTool.class);

    public static String[] splitStr(String srcstr, String sepstr) {
        StringTokenizer stringToken;
        int iCount;
        String[] tokens = null;
        if (srcstr == null || srcstr.length() == 0) {
            return tokens;
        }
        if (sepstr == null || sepstr.length() == 0 || srcstr.length() == 0) {
            tokens = new String[]{srcstr};
        }
        if ((iCount = (stringToken = new StringTokenizer(srcstr, sepstr)).countTokens()) > 0) {
            tokens = new String[iCount];
            int i = 0;
            while (stringToken.hasMoreTokens()) {
                tokens[i] = stringToken.nextToken();
                ++i;
            }
        }
        return tokens;
    }

    public static byte[] convertBase64(byte[] data) {
        byte tmp;
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] rtnbytes = null;
        while ((tmp = (byte)bis.read()) != -1) {
            if (tmp == 10 || tmp == 13) continue;
            bos.write(tmp);
        }
        rtnbytes = bos.toByteArray();
        try {
            bos.close();
        }
        catch (IOException e1) {
            // empty catch block
        }
        try {
            bis.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        return rtnbytes;
    }

    public static String convertBase64(String data) {
        if (data == null || data.trim().length() == 0) {
            return null;
        }
        String rtnStr = null;
        rtnStr = UtilTool.delStrFromStr(data, "\r\n");
        rtnStr = UtilTool.delStrFromStr(rtnStr, "\r");
        rtnStr = UtilTool.delStrFromStr(rtnStr, "\n");
        return rtnStr;
    }

    public static String delStrFromStr(String srcStr, String delStr) {
        if (srcStr == null || srcStr.trim().length() == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer(srcStr);
        int iStartPos = 0;
        int iEndPos = 0;
        iStartPos = sb.indexOf(delStr);
        if (iStartPos == 0) {
            return srcStr;
        }
        while ((iStartPos = sb.indexOf(delStr, iEndPos)) > 0) {
            sb.delete(iStartPos, iStartPos + delStr.length());
            iEndPos = iStartPos;
        }
        return sb.toString();
    }

    public static String processBase64Code(String strBase64Data) {
        StringBuffer sb = new StringBuffer();
        String strSub = "";
        if (strBase64Data == null) {
            return "";
        }
        if (strBase64Data.length() > 64) {
            int count = strBase64Data.length() / 64;
            for (int i = 0; i < count; ++i) {
                if (strBase64Data.length() - i * 64 > 64) {
                    sb.append(strBase64Data.substring(i * 64, (i + 1) * 64)).append("\r\n");
                    continue;
                }
                sb.append(strBase64Data.substring(i * 64, (i + 1) * 64));
            }
            sb.append(strBase64Data.substring(count * 64, strBase64Data.length()));
            return sb.toString();
        }
        if (strBase64Data.length() > 0) {
            sb.append(strBase64Data);
        }
        return sb.toString();
    }

    public static long convertStr2Long(String str, long defaultnum) {
        long lRtnValue = 0L;
        try {
            lRtnValue = Long.parseLong(str);
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            lRtnValue = defaultnum;
        }
        return lRtnValue;
    }

    public static int convertStr2Int(String str, int defaultnum) {
        int iRtnValue = 0;
        try {
            iRtnValue = Integer.parseInt(str);
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            iRtnValue = defaultnum;
        }
        return iRtnValue;
    }

    public static String getMailFormDN(String strDN) {
        if (strDN == null || strDN.trim().length() == 0) {
            return "";
        }
        StringTokenizer commaToker = new StringTokenizer(strDN, ",");
        String[] result = new String[commaToker.countTokens()];
        int k = 0;
        while (commaToker.hasMoreTokens()) {
            result[k] = commaToker.nextToken();
            ++k;
        }
        for (int i = 0; i < result.length; ++i) {
            if (result[i].indexOf("E=") < 0 || result[i].indexOf("@") < 0) continue;
            return result[i].trim().substring(2);
        }
        return null;
    }

    public static String[] convertListToStrArray(List _list) {
        String[] strArray = null;
        if (_list != null && _list.size() > 0) {
            strArray = (String[])_list.toArray();
        }
        return strArray;
    }

    public static ArrayList convertStrArrayToList(String[] strArray) {
        ArrayList<String> al = null;
        if (strArray != null && strArray.length > 0) {
            al = new ArrayList<String>();
            for (int i = 0; i < strArray.length; ++i) {
                al.add(strArray[i]);
            }
        }
        return al;
    }

    public static String removeODOA(String strBase64Data) {
        return strBase64Data.replaceAll(System.getProperty("line.separator"), "");
    }

    public static PlainOfFileModel buildFileName(byte[] plainData, boolean decodeFileName) {
        PlainOfFileModel result = new PlainOfFileModel();
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(plainData);
            InputStreamReader vInStreamReader = new InputStreamReader((InputStream)in, "UTF-8");
            BufferedReader vBufferedReader = new BufferedReader(vInStreamReader);
            SimpleDOMParser xmlParser = new SimpleDOMParser();
            SimpleElement element = xmlParser.parse(vBufferedReader);
            Object[] tObjse = element.getChildElements();
            String fileSystemChartSet = Config.getInstance().getFileSystemCharSet();
            String systemCharSet = Config.getInstance().getSystemCharSet();
            SimpleElement e = (SimpleElement)element.getChildElements()[0];
            if (e.getTagName().equalsIgnoreCase("File")) {
                SimpleElement fileContentElement;
                SimpleElement fileNameElement = (SimpleElement)e.getChildElements()[0];
                if (fileNameElement.getTagName().equalsIgnoreCase("name")) {
                    String fileName = fileNameElement.getText();
                    if (decodeFileName) {
                        fileName = null == fileSystemChartSet || "default".equals(fileSystemChartSet) ? new String(Base64.decode((String)fileName)) : new String(Base64.decode((String)fileName), fileSystemChartSet);
                    }
                    if (!StringUtils.isEmpty((String)fileName)) {
                        result.setFileName(fileName);
                    }
                }
                if ((fileContentElement = (SimpleElement)e.getChildElements()[1]).getTagName().equalsIgnoreCase("content")) {
                    String fileContent = fileContentElement.getText();
                    result.setBase64PlainData(fileContent);
                }
            } else {
                result.setBase64PlainData(new String(Base64.encode((byte[])plainData)));
            }
        }
        catch (Exception e) {
            result.setBase64PlainData(new String(Base64.encode((byte[])plainData)));
        }
        return result;
    }
}

