/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.assp.css.client.util;

import cn.com.jit.assp.css.client.util.Base64;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SecurityUtil {
    private static final Log LOGGER = LogFactory.getLog(SecurityUtil.class);

    public static byte[] doDigest(byte[] _srcData, String _hashAlgId) throws NoSuchAlgorithmException {
        if (_srcData == null || _srcData.length == 0) {
            return null;
        }
        if (_hashAlgId == null || _hashAlgId.trim().length() == 0) {
            return null;
        }
        MessageDigest mdigest = null;
        mdigest = MessageDigest.getInstance(_hashAlgId);
        return mdigest.digest(_srcData);
    }

    /*
     * Loose catch block
     */
    public static byte[] doDigest(InputStream _srcData, String _hashAlgId) throws NoSuchAlgorithmException, IOException {
        MessageDigest mdigest;
        byte[] rtnbuffer;
        byte[] tmpbuffer;
        byte[] buffer;
        block19: {
            int readedlen;
            int reallen;
            block16: {
                byte[] byArray;
                block17: {
                    if (_hashAlgId == null || _hashAlgId.trim().length() == 0) {
                        return null;
                    }
                    buffer = null;
                    tmpbuffer = null;
                    rtnbuffer = null;
                    mdigest = null;
                    reallen = 0;
                    readedlen = 0;
                    if (_srcData != null && _srcData.available() > 0) break block16;
                    byArray = null;
                    Object var10_10 = null;
                    if (_srcData == null) break block17;
                    try {
                        _srcData.close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    _srcData = null;
                }
                return byArray;
            }
            mdigest = MessageDigest.getInstance(_hashAlgId);
            buffer = new byte[1024];
            while ((reallen = _srcData.read(buffer, readedlen, buffer.length)) != -1) {
                if (reallen < buffer.length) {
                    if (tmpbuffer != null) {
                        tmpbuffer = null;
                    }
                    tmpbuffer = new byte[reallen];
                    System.arraycopy(buffer, 0, tmpbuffer, 0, reallen);
                    mdigest.update(tmpbuffer);
                    continue;
                }
                mdigest.update(buffer);
            }
            Object var10_11 = null;
            if (_srcData == null) break block19;
            try {
                _srcData.close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            _srcData = null;
            {
                break block19;
                catch (IOException ioe) {
                    throw ioe;
                }
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                if (_srcData != null) {
                    try {
                        _srcData.close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    _srcData = null;
                }
                throw throwable;
            }
        }
        rtnbuffer = mdigest.digest();
        if (tmpbuffer != null) {
            tmpbuffer = null;
        }
        if (buffer != null) {
            buffer = null;
        }
        return rtnbuffer;
    }

    public static X509Certificate getX509Cert(String base64CertStr) {
        CertificateFactory certfactory = null;
        byte[] tbyte = null;
        ByteArrayInputStream in = null;
        if (base64CertStr == null || base64CertStr.length() == 0) {
            return null;
        }
        try {
            tbyte = Base64.encode(base64CertStr.getBytes());
            in = new ByteArrayInputStream(tbyte);
            certfactory = CertificateFactory.getInstance("X.509");
            return (X509Certificate)certfactory.generateCertificate(in);
        }
        catch (CertificateException ex) {
            LOGGER.error((Object)ex.getMessage(), (Throwable)ex);
            return null;
        }
        catch (Exception ex1) {
            LOGGER.error((Object)ex1.getMessage(), (Throwable)ex1);
            return null;
        }
    }
}

