/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.assp.css.client.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class Base64 {
    public static final int NO_OPTIONS = 0;
    public static final int ENCODE = 1;
    public static final int DECODE = 0;
    public static final int GZIP = 2;
    public static final int DO_BREAK_LINES = 8;
    public static final int URL_SAFE = 16;
    public static final int ORDERED = 32;
    private static final int MAX_LINE_LENGTH = 64;
    private static final byte EQUALS_SIGN = 61;
    private static final byte NEW_LINE = 10;
    private static final String PREFERRED_ENCODING = "UTF-8";
    private static final byte WHITE_SPACE_ENC = -5;
    private static final byte EQUALS_SIGN_ENC = -1;
    private static final byte[] _STANDARD_ALPHABET = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    private static final byte[] _STANDARD_DECODABET = new byte[]{-9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -5, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, 62, -9, -9, -9, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -9, -9, -9, -1, -9, -9, -9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -9, -9, -9, -9, -9, -9, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -9, -9, -9, -9};
    private static final byte[] _URL_SAFE_ALPHABET = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 45, 95};
    private static final byte[] _URL_SAFE_DECODABET = new byte[]{-9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -5, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, 62, -9, -9, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -9, -9, -9, -1, -9, -9, -9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -9, -9, -9, -9, 63, -9, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -9, -9, -9, -9};
    private static final byte[] _ORDERED_ALPHABET = new byte[]{45, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 95, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122};
    private static final byte[] _ORDERED_DECODABET = new byte[]{-9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -5, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, 0, -9, -9, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, -9, -9, -9, -1, -9, -9, -9, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, -9, -9, -9, -9, 37, -9, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, -9, -9, -9, -9};

    private static final byte[] getAlphabet(int options) {
        if ((options & 0x10) == 16) {
            return _URL_SAFE_ALPHABET;
        }
        if ((options & 0x20) == 32) {
            return _ORDERED_ALPHABET;
        }
        return _STANDARD_ALPHABET;
    }

    private static final byte[] getDecodabet(int options) {
        if ((options & 0x10) == 16) {
            return _URL_SAFE_DECODABET;
        }
        if ((options & 0x20) == 32) {
            return _ORDERED_DECODABET;
        }
        return _STANDARD_DECODABET;
    }

    private Base64() {
    }

    private static byte[] encode3to4(byte[] b4, byte[] threeBytes, int numSigBytes, int options) {
        Base64.encode3to4(threeBytes, 0, numSigBytes, b4, 0, options);
        return b4;
    }

    private static byte[] encode3to4(byte[] source, int srcOffset, int numSigBytes, byte[] destination, int destOffset, int options) {
        byte[] ALPHABET = Base64.getAlphabet(options);
        int inBuff = (numSigBytes > 0 ? source[srcOffset] << 24 >>> 8 : 0) | (numSigBytes > 1 ? source[srcOffset + 1] << 24 >>> 16 : 0) | (numSigBytes > 2 ? source[srcOffset + 2] << 24 >>> 24 : 0);
        switch (numSigBytes) {
            case 3: {
                destination[destOffset] = ALPHABET[inBuff >>> 18];
                destination[destOffset + 1] = ALPHABET[inBuff >>> 12 & 0x3F];
                destination[destOffset + 2] = ALPHABET[inBuff >>> 6 & 0x3F];
                destination[destOffset + 3] = ALPHABET[inBuff & 0x3F];
                return destination;
            }
            case 2: {
                destination[destOffset] = ALPHABET[inBuff >>> 18];
                destination[destOffset + 1] = ALPHABET[inBuff >>> 12 & 0x3F];
                destination[destOffset + 2] = ALPHABET[inBuff >>> 6 & 0x3F];
                destination[destOffset + 3] = 61;
                return destination;
            }
            case 1: {
                destination[destOffset] = ALPHABET[inBuff >>> 18];
                destination[destOffset + 1] = ALPHABET[inBuff >>> 12 & 0x3F];
                destination[destOffset + 2] = 61;
                destination[destOffset + 3] = 61;
                return destination;
            }
        }
        return destination;
    }

    public static void encode(ByteBuffer raw, ByteBuffer encoded) {
        byte[] raw3 = new byte[3];
        byte[] enc4 = new byte[4];
        while (raw.hasRemaining()) {
            int rem = Math.min(3, raw.remaining());
            raw.get(raw3, 0, rem);
            Base64.encode3to4(enc4, raw3, rem, 0);
            encoded.put(enc4);
        }
    }

    public static void encode(ByteBuffer raw, CharBuffer encoded) {
        byte[] raw3 = new byte[3];
        byte[] enc4 = new byte[4];
        while (raw.hasRemaining()) {
            int rem = Math.min(3, raw.remaining());
            raw.get(raw3, 0, rem);
            Base64.encode3to4(enc4, raw3, rem, 0);
            for (int i = 0; i < 4; ++i) {
                encoded.put((char)(enc4[i] & 0xFF));
            }
        }
    }

    public static String encodeObject(Serializable serializableObject) throws IOException {
        return Base64.encodeObject(serializableObject, 0);
    }

    /*
     * Loose catch block
     */
    public static String encodeObject(Serializable serializableObject, int options) throws IOException {
        ByteArrayOutputStream baos;
        block18: {
            if (serializableObject == null) {
                throw new NullPointerException("Cannot serialize a null object.");
            }
            baos = null;
            java.io.OutputStream b64os = null;
            ObjectOutputStream oos = null;
            baos = new ByteArrayOutputStream();
            b64os = new OutputStream(baos, 1 | options);
            oos = new ObjectOutputStream(b64os);
            oos.writeObject(serializableObject);
            Object var7_5 = null;
            try {
                oos.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                b64os.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                baos.close();
            }
            catch (Exception e) {}
            break block18;
            {
                catch (IOException e) {
                    throw e;
                }
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                try {
                    oos.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    b64os.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    baos.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            return new String(baos.toByteArray(), PREFERRED_ENCODING);
        }
        catch (UnsupportedEncodingException uue) {
            return new String(baos.toByteArray());
        }
    }

    public static String encodeBytes(byte[] source) {
        String encoded = null;
        try {
            encoded = Base64.encodeBytes(source, 0, source.length, 0);
        }
        catch (IOException ex) {
            ex.getMessage();
        }
        return encoded;
    }

    public static byte[] encode(byte[] source) {
        String encoded = null;
        try {
            encoded = Base64.encodeBytes(source, 0, source.length, 0);
        }
        catch (IOException ex) {
            ex.getMessage();
        }
        return encoded.getBytes();
    }

    public static String encodeBytes(byte[] source, int options) throws IOException {
        return Base64.encodeBytes(source, 0, source.length, options);
    }

    public static String encodeBytes(byte[] source, int off, int len) {
        String encoded = null;
        try {
            encoded = Base64.encodeBytes(source, off, len, 0);
        }
        catch (IOException ex) {
            ex.getMessage();
        }
        return encoded;
    }

    public static String encodeBytes(byte[] source, int off, int len, int options) throws IOException {
        byte[] encoded = Base64.encodeBytesToBytes(source, off, len, options);
        try {
            return new String(encoded, PREFERRED_ENCODING);
        }
        catch (UnsupportedEncodingException uue) {
            return new String(encoded);
        }
    }

    public static byte[] encodeBytesToBytes(byte[] source) {
        byte[] encoded = null;
        try {
            encoded = Base64.encodeBytesToBytes(source, 0, source.length, 0);
        }
        catch (IOException ex) {
            ex.getMessage();
        }
        return encoded;
    }

    /*
     * Loose catch block
     */
    public static byte[] encodeBytesToBytes(byte[] source, int off, int len, int options) throws IOException {
        block22: {
            ByteArrayOutputStream baos;
            block23: {
                if (source == null) {
                    throw new NullPointerException("Cannot serialize a null array.");
                }
                if (off < 0) {
                    throw new IllegalArgumentException("Cannot have negative offset: " + off);
                }
                if (len < 0) {
                    throw new IllegalArgumentException("Cannot have length offset: " + len);
                }
                if (off + len > source.length) {
                    throw new IllegalArgumentException("Cannot have offset of " + off + " and length of " + len + " with array of length " + source.length);
                }
                if ((options & 2) <= 0) break block22;
                baos = null;
                DeflaterOutputStream gzos = null;
                OutputStream b64os = null;
                baos = new ByteArrayOutputStream();
                b64os = new OutputStream(baos, 1 | options);
                gzos = new GZIPOutputStream(b64os);
                ((GZIPOutputStream)gzos).write(source, off, len);
                gzos.close();
                Object var9_10 = null;
                try {
                    gzos.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    b64os.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    baos.close();
                }
                catch (Exception e) {}
                break block23;
                {
                    catch (IOException e) {
                        throw e;
                    }
                }
                catch (Throwable throwable) {
                    Object var9_11 = null;
                    try {
                        gzos.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    try {
                        b64os.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    try {
                        baos.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            return baos.toByteArray();
        }
        boolean breakLines = (options & 8) > 0;
        int len43 = len * 4 / 3;
        byte[] outBuff = new byte[len43 + (len % 3 > 0 ? 4 : 0) + (breakLines ? len43 / 64 : 0)];
        int d = 0;
        int e = 0;
        int len2 = len - 2;
        int lineLength = 0;
        while (d < len2) {
            Base64.encode3to4(source, d + off, 3, outBuff, e, options);
            if (breakLines && (lineLength += 4) == 64) {
                outBuff[e + 4] = 10;
                ++e;
                lineLength = 0;
            }
            d += 3;
            e += 4;
        }
        if (d < len) {
            Base64.encode3to4(source, d + off, len - d, outBuff, e, options);
            e += 4;
        }
        byte[] finalOut = new byte[e];
        System.arraycopy(outBuff, 0, finalOut, 0, e);
        return finalOut;
    }

    private static int decode4to3(byte[] source, int srcOffset, byte[] destination, int destOffset, int options) {
        if (source == null) {
            throw new NullPointerException("Source array was null.");
        }
        if (destination == null) {
            throw new NullPointerException("Destination array was null.");
        }
        if (srcOffset < 0 || srcOffset + 3 >= source.length) {
            throw new IllegalArgumentException("Source array with length " + source.length + " cannot have offset of " + srcOffset + " and still process four bytes.");
        }
        if (destOffset < 0 || destOffset + 2 >= destination.length) {
            throw new IllegalArgumentException("Destination array with length " + destination.length + "cannot have offset of " + destOffset + "and still store three bytes.");
        }
        byte[] DECODABET = Base64.getDecodabet(options);
        if (source[srcOffset + 2] == 61) {
            int outBuff = (DECODABET[source[srcOffset]] & 0xFF) << 18 | (DECODABET[source[srcOffset + 1]] & 0xFF) << 12;
            destination[destOffset] = (byte)(outBuff >>> 16);
            return 1;
        }
        if (source[srcOffset + 3] == 61) {
            int outBuff = (DECODABET[source[srcOffset]] & 0xFF) << 18 | (DECODABET[source[srcOffset + 1]] & 0xFF) << 12 | (DECODABET[source[srcOffset + 2]] & 0xFF) << 6;
            destination[destOffset] = (byte)(outBuff >>> 16);
            destination[destOffset + 1] = (byte)(outBuff >>> 8);
            return 2;
        }
        int outBuff = (DECODABET[source[srcOffset]] & 0xFF) << 18 | (DECODABET[source[srcOffset + 1]] & 0xFF) << 12 | (DECODABET[source[srcOffset + 2]] & 0xFF) << 6 | DECODABET[source[srcOffset + 3]] & 0xFF;
        destination[destOffset] = (byte)(outBuff >> 16);
        destination[destOffset + 1] = (byte)(outBuff >> 8);
        destination[destOffset + 2] = (byte)outBuff;
        return 3;
    }

    public static byte[] decode(byte[] source) {
        byte[] decoded = null;
        try {
            decoded = Base64.decode(source, 0, source.length, 0);
        }
        catch (RuntimeException ex) {
            ex.getMessage();
        }
        return decoded;
    }

    public static byte[] decode(byte[] source, int off, int len, int options) throws RuntimeException {
        if (source == null) {
            throw new NullPointerException("Cannot decode null source array.");
        }
        if (off < 0 || off + len > source.length) {
            throw new IllegalArgumentException("Source array with length " + source.length + " cannot have offset of " + off + " and process " + len + " bytes.");
        }
        if (len == 0) {
            return new byte[0];
        }
        if (len < 4) {
            throw new IllegalArgumentException("Base64-encoded string must have at least four characters, but length specified was " + len);
        }
        byte[] DECODABET = Base64.getDecodabet(options);
        int len34 = len * 3 / 4;
        byte[] outBuff = new byte[len34];
        int outBuffPosn = 0;
        byte[] b4 = new byte[4];
        int b4Posn = 0;
        int i = 0;
        byte sbiCrop = 0;
        byte sbiDecode = 0;
        for (i = off; i < off + len; ++i) {
            sbiCrop = (byte)(source[i] & 0x7F);
            sbiDecode = DECODABET[sbiCrop];
            if (sbiDecode >= -5) {
                if (sbiDecode < -1) continue;
                b4[b4Posn++] = sbiCrop;
                if (b4Posn <= 3) continue;
                outBuffPosn += Base64.decode4to3(b4, 0, outBuff, outBuffPosn, options);
                b4Posn = 0;
                if (sbiCrop != 61) continue;
                break;
            }
            throw new RuntimeException("Bad Base64 input character '" + source[i] + "' in array position i");
        }
        byte[] out = new byte[outBuffPosn];
        System.arraycopy(outBuff, 0, out, 0, outBuffPosn);
        return out;
    }

    public static byte[] decode(String s) throws RuntimeException {
        return Base64.decode(s, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static byte[] decode(String s, int options) throws RuntimeException {
        byte[] bytes;
        block25: {
            int head;
            if (s == null) {
                throw new NullPointerException("Input string was null.");
            }
            try {
                bytes = s.getBytes(PREFERRED_ENCODING);
            }
            catch (UnsupportedEncodingException uee) {
                bytes = s.getBytes();
            }
            bytes = Base64.decode(bytes, 0, bytes.length, options);
            if (bytes != null && bytes.length >= 4 && 35615 == (head = bytes[0] & 0xFF | bytes[1] << 8 & 0xFF00)) {
                ByteArrayInputStream bais = null;
                GZIPInputStream gzis = null;
                ByteArrayOutputStream baos = null;
                byte[] buffer = new byte[2048];
                int length = 0;
                baos = new ByteArrayOutputStream();
                bais = new ByteArrayInputStream(bytes);
                gzis = new GZIPInputStream(bais);
                while ((length = gzis.read(buffer)) >= 0) {
                    baos.write(buffer, 0, length);
                }
                bytes = baos.toByteArray();
                Object var11_10 = null;
                try {
                    baos.close();
                }
                catch (Exception e2) {
                    // empty catch block
                }
                try {
                    gzis.close();
                }
                catch (Exception e2) {
                    // empty catch block
                }
                try {
                    bais.close();
                }
                catch (Exception e2) {}
                break block25;
                {
                    catch (IOException e) {
                        Object var11_11 = null;
                        try {
                            baos.close();
                        }
                        catch (Exception e2) {
                            // empty catch block
                        }
                        try {
                            gzis.close();
                        }
                        catch (Exception e2) {
                            // empty catch block
                        }
                        try {
                            bais.close();
                        }
                        catch (Exception e2) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var11_12 = null;
                    try {
                        baos.close();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    try {
                        gzis.close();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    try {
                        bais.close();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        return bytes;
    }

    /*
     * Loose catch block
     */
    public static Object decodeToObject(String encodedObject) throws IOException, ClassNotFoundException {
        Object obj;
        block12: {
            byte[] objBytes = Base64.decode(encodedObject);
            ByteArrayInputStream bais = null;
            ObjectInputStream ois = null;
            obj = null;
            bais = new ByteArrayInputStream(objBytes);
            ois = new ObjectInputStream(bais);
            obj = ois.readObject();
            Object var7_5 = null;
            try {
                bais.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                ois.close();
            }
            catch (Exception e) {}
            break block12;
            {
                catch (IOException e) {
                    throw e;
                }
                catch (ClassNotFoundException e) {
                    throw e;
                }
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                try {
                    bais.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    ois.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return obj;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void encodeToFile(byte[] dataToEncode, String filename) throws IOException {
        if (dataToEncode == null) {
            throw new NullPointerException("Data to encode was null.");
        }
        OutputStream bos = null;
        try {
            bos = new OutputStream(new FileOutputStream(filename), 1);
            bos.write(dataToEncode);
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            try {
                bos.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        bos.close();
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void decodeToFile(String dataToDecode, String filename) throws IOException {
        OutputStream bos = null;
        try {
            bos = new OutputStream(new FileOutputStream(filename), 0);
            bos.write(dataToDecode.getBytes(PREFERRED_ENCODING));
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            try {
                bos.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        bos.close();
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] decodeFromFile(String filename) throws IOException {
        byte[] decodedData = null;
        FilterInputStream bis = null;
        try {
            File file = new File(filename);
            byte[] buffer = null;
            int length = 0;
            int numBytes = 0;
            if (file.length() > Integer.MAX_VALUE) {
                throw new IOException("File is too big for this convenience method (" + file.length() + " bytes).");
            }
            buffer = new byte[(int)file.length()];
            bis = new InputStream(new BufferedInputStream(new FileInputStream(file)), 0);
            while ((numBytes = ((InputStream)bis).read(buffer, length, 4096)) >= 0) {
                length += numBytes;
            }
            decodedData = new byte[length];
            System.arraycopy(buffer, 0, decodedData, 0, length);
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                bis.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        bis.close();
        return decodedData;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String encodeFromFile(String filename) throws IOException {
        String encodedData = null;
        FilterInputStream bis = null;
        try {
            File file = new File(filename);
            byte[] buffer = new byte[Math.max((int)((double)file.length() * 1.4), 40)];
            int length = 0;
            int numBytes = 0;
            bis = new InputStream(new BufferedInputStream(new FileInputStream(file)), 1);
            while ((numBytes = ((InputStream)bis).read(buffer, length, 4096)) >= 0) {
                length += numBytes;
            }
            encodedData = new String(buffer, 0, length, PREFERRED_ENCODING);
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                bis.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        bis.close();
        return encodedData;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void encodeFileToFile(String infile, String outfile) throws IOException {
        String encoded = Base64.encodeFromFile(infile);
        java.io.OutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(outfile));
            out.write(encoded.getBytes("US-ASCII"));
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            try {
                out.close();
                throw throwable;
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception ex) {}
        out.close();
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void decodeFileToFile(String infile, String outfile) throws IOException {
        byte[] decoded = Base64.decodeFromFile(infile);
        java.io.OutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(outfile));
            out.write(decoded);
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            try {
                out.close();
                throw throwable;
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception ex) {}
        out.close();
        return;
    }

    public static void main(String[] args) throws Exception {
        String b64Encoded = "MS4gaW5jbHVkZdPvvuQgDQogICBjOiAgIGluY2x1ZGUgInN0ZGlvLmgiDQogICBjKys6IGluY2x1ZGUgPHN0ZGlvPg0KDQoyLmNvbnN0DQogICBj1tC1xGNvbnN0sbvIz86qysfSu7/psrvE3LjEseS1xLTmtKLH+NPyo6zL+dLUY9bQo7oNCiAgICAgY29uc3QgaW50IGJ1ZmZlcnNpemUgPSAxMDA7DQogICAgIGNoYXIgYnVmW2J1ZmZlcnNpemVdOw0KICAg1eLKx7K7us+3qLXEo6zU2rHg0uvG2rzk08nT2mJ1ZmZlcnNpemXVvNPD0ru/6bTmtKKjrMv50tSx4NLrxvcNCiAgILK71qq1wMv8tcTWtaOsyrnTwyNkZWZpbmUNCiAgIGMrK9bQxKzIz7K7uPhjb25zdLfWxeS05rSio6zH0srHxNqyv8GsvdOjrGPW0MSsyM/N4rK/way906OsYysr08MNCiAgIGV4dGVybse/1sa4xLHkzqrN4rK/way90w0KMy5uZXcgZGVsZXRlDQo0LrHkwb/J+cP3tcTOu9bDICAgDQoNCiAgICBD1tCjrLHkwb/J+cP3us20+sLryse31r+qtcSjrLHY0OvU2rqvyv2/qsq8tKbJ+cP3oaNDKyvW0KOsseTBv7/J0tTU2sjO0uK0psn5w/eju8D9yOejumZvcihpbnQgaT0wO2k8MTA7aSsrKdTaQysr1tC/ydLUo6y1q9TaQ9bQseTBv2nSqtTazeLD5rao0uWhow0KDQo1LnN0cnVjdL3hubnM5be9w+YNCg0KICAg08NzdHJ1Y3S2qNLlseTBvyAgDQoNCnN0cnVjdCBteXN0cnVjdCAgIA0KDQp7ICAgICBpbnQgaTsgICAgIA0KDQogICAgICBmbG9hdCB4OyAgDQoNCn0gICDU2mPW0Mn5w/dzdHJ1Y3Sx5MG/0qrV4sO00LSjunN0cnVjdCBteXN0cnVjdCBhOyAgINTaQysr1tDHsMPmsrvTw7zTc3RydWN0o7pteXN0cnVjdCBhOyAgDQoNCtK71ta85sjdtcTTw7eoysejuiANCg0KdHlwZWRlZiBzdHJ1Y3QgX215c3RydWN0DQoNCnsgICAgIGludCBpOw0KDQogICAgICBmbG9hdCB4OyANCg0KfSBteXN0cnVjdDsgICDIu7rz08NteXN0cnVjdCC2qNLlseTBvw0KDQo2LtTaQysr1tCjrHN0cnVjdL3hubnM5dans9azydSxuq/K/bXEtqjS5aOsQ9bQsrvQ0MHtzeKjrEMrK9bQs8nUsbqvyv21xMSsyM+3w87Ky7XD97f7zqpwdWJsaWMs1eLSu7Xjus3A4LK7zayjrMDgtcTErMjPt8POysu1w/e3+86qcHJpdmF0ZS4gyP2hokMrK9bQ09Bib29sICi78mJvb2xlYW7A4NDNo6mju0PW0L/Jw7vT0NXi0fm1xGJvb2zA4NDNo6y++c6qyv3WtcDg0M2joSAgDQoNCjcuYysr1tDT0NL908PA4NDNo6xj1tDWu9PQ1rjV6w0KOC5jb3V0IHByaW50Zg0KOS5j1tC199PDuq/K/cewv8nS1LK7ysLPyMn5w/ejrLHg0uvG97vhzai5/dXiuPa199PDssKy4rqvyv21xLao0uUsyOejug0KICAgtffTwyB2b2lkIGZ1bihpbnQpOyC1q8q1vMrKx3ZvaWQgZnVuKGZsb2F0KSy74bL6yfpidWcNCiAgYysr1tCx2NDrz8jJ+cP3uvO199PDDQoxMC7Uy8vjt/u1xNbY1NgNCg0KDQpsaXpleHBlcnRpc2VuZXcgbWljcm9zb2Z0DQpsaXpleHBlcnRpc2Vfa291YmVpQHNvaHUuY29tIG1pY2t5Lm5ldA0KNTg2ODIwNzUNCjE1MDAxMDg4NTEyDQo1ODY4MzM1Mw0KY2dkYy5jb20uY24NCg0K";
        byte[] result = Base64.decode(b64Encoded);
        FileOutputStream out = new FileOutputStream(new File("/tmp/abc.bin"));
        ((java.io.OutputStream)out).write(result);
        ((java.io.OutputStream)out).close();
    }

    public static class OutputStream
    extends FilterOutputStream {
        private boolean encode;
        private int position;
        private byte[] buffer;
        private int bufferLength;
        private int lineLength;
        private boolean breakLines;
        private byte[] b4;
        private boolean suspendEncoding;
        private int options;
        private byte[] alphabet;
        private byte[] decodabet;

        public OutputStream(java.io.OutputStream out) {
            this(out, 1);
        }

        public OutputStream(java.io.OutputStream out, int options) {
            super(out);
            this.breakLines = (options & 8) > 0;
            this.encode = (options & 1) > 0;
            this.bufferLength = this.encode ? 3 : 4;
            this.buffer = new byte[this.bufferLength];
            this.position = 0;
            this.lineLength = 0;
            this.suspendEncoding = false;
            this.b4 = new byte[4];
            this.options = options;
            this.alphabet = Base64.getAlphabet(options);
            this.decodabet = Base64.getDecodabet(options);
        }

        public void write(int theByte) throws IOException {
            if (this.suspendEncoding) {
                this.out.write(theByte);
                return;
            }
            if (this.encode) {
                this.buffer[this.position++] = (byte)theByte;
                if (this.position >= this.bufferLength) {
                    this.out.write(Base64.encode3to4(this.b4, this.buffer, this.bufferLength, this.options));
                    this.lineLength += 4;
                    if (this.breakLines && this.lineLength >= 64) {
                        this.out.write(10);
                        this.lineLength = 0;
                    }
                    this.position = 0;
                }
            } else if (this.decodabet[theByte & 0x7F] > -5) {
                this.buffer[this.position++] = (byte)theByte;
                if (this.position >= this.bufferLength) {
                    int len = Base64.decode4to3(this.buffer, 0, this.b4, 0, this.options);
                    this.out.write(this.b4, 0, len);
                    this.position = 0;
                }
            } else if (this.decodabet[theByte & 0x7F] != -5) {
                throw new IOException("Invalid character in Base64 data.");
            }
        }

        public void write(byte[] theBytes, int off, int len) throws IOException {
            if (this.suspendEncoding) {
                this.out.write(theBytes, off, len);
                return;
            }
            for (int i = 0; i < len; ++i) {
                this.write(theBytes[off + i]);
            }
        }

        public void flushBase64() throws IOException {
            if (this.position > 0) {
                if (this.encode) {
                    this.out.write(Base64.encode3to4(this.b4, this.buffer, this.position, this.options));
                    this.position = 0;
                } else {
                    throw new IOException("Base64 input not properly padded.");
                }
            }
        }

        public void flush() throws IOException {
            this.flushBase64();
            super.flush();
        }

        public void close() throws IOException {
            this.flush();
            super.close();
            this.buffer = null;
            this.out = null;
        }

        public void suspendEncoding() throws IOException {
            this.flushBase64();
            this.suspendEncoding = true;
        }

        public void resumeEncoding() {
            this.suspendEncoding = false;
        }
    }

    public static class InputStream
    extends FilterInputStream {
        private boolean encode;
        private int position;
        private byte[] buffer;
        private int bufferLength;
        private int numSigBytes;
        private int lineLength;
        private boolean breakLines;
        private int options;
        private byte[] alphabet;
        private byte[] decodabet;

        public InputStream(java.io.InputStream in) {
            this(in, 0);
        }

        public InputStream(java.io.InputStream in, int options) {
            super(in);
            this.options = options;
            this.breakLines = (options & 8) > 0;
            this.encode = (options & 1) > 0;
            this.bufferLength = this.encode ? 4 : 3;
            this.buffer = new byte[this.bufferLength];
            this.position = -1;
            this.lineLength = 0;
            this.alphabet = Base64.getAlphabet(options);
            this.decodabet = Base64.getDecodabet(options);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public int read() throws IOException {
            if (this.position < 0) {
                if (this.encode) {
                    int b;
                    byte[] b3 = new byte[3];
                    int numBinaryBytes = 0;
                    for (int i = 0; i < 3 && (b = this.in.read()) >= 0; ++i) {
                        b3[i] = (byte)b;
                        ++numBinaryBytes;
                    }
                    if (numBinaryBytes <= 0) return -1;
                    Base64.encode3to4(b3, 0, numBinaryBytes, this.buffer, 0, this.options);
                    this.position = 0;
                    this.numSigBytes = 4;
                } else {
                    byte[] b4 = new byte[4];
                    int i = 0;
                    for (i = 0; i < 4; ++i) {
                        int b = 0;
                        while ((b = this.in.read()) >= 0 && this.decodabet[b & 0x7F] <= -5) {
                        }
                        if (b < 0) break;
                        b4[i] = (byte)b;
                    }
                    if (i == 4) {
                        this.numSigBytes = Base64.decode4to3(b4, 0, this.buffer, 0, this.options);
                        this.position = 0;
                    } else {
                        if (i != 0) throw new IOException("Improperly padded Base64 input.");
                        return -1;
                    }
                }
            }
            if (this.position < 0) throw new IOException("Error in Base64 code reading stream.");
            if (this.position >= this.numSigBytes) {
                return -1;
            }
            if (this.encode && this.breakLines && this.lineLength >= 64) {
                this.lineLength = 0;
                return 10;
            }
            ++this.lineLength;
            byte b = this.buffer[this.position++];
            if (this.position < this.bufferLength) return b & 0xFF;
            this.position = -1;
            return b & 0xFF;
        }

        public int read(byte[] dest, int off, int len) throws IOException {
            int i;
            for (i = 0; i < len; ++i) {
                int b = this.read();
                if (b < 0) {
                    if (i != 0) break;
                    return -1;
                }
                dest[off + i] = (byte)b;
            }
            return i;
        }
    }
}

