/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.assp.css.client.communication;

import cn.com.jit.assp.css.client.CSSException;
import cn.com.jit.assp.css.client.Config;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.SSLProtocolSocketFactory;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RequestClient {
    private static final Log LOGGER = LogFactory.getLog(RequestClient.class);

    public static String sendMessage(URL url, String xmlStr, String certpath) throws CSSException {
        String METHOD_NAME = "sendMessage(URL url, String xmlStr, String certpath)";
        if (url == null) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)"Message is null!");
            }
            throw new CSSException("-10702201", ".sendMessage(URL url, String xmlStr, String certpath)", "\u53c2\u6570\u4e0d\u5408\u6cd5\uff0curl\u8f93\u5165\u4e3a\u7a7a\uff0c\u8bf7\u8f93\u5165url");
        }
        if (xmlStr == null || xmlStr.trim().length() == 0) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)"Url is null!");
            }
            throw new CSSException("-10702202", ".sendMessage(URL url, String xmlStr, String certpath)", "\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u53d1\u9001\u62a5\u6587\u8f93\u5165\u4e3a\u7a7a\uff01");
        }
        String protocol = url.getProtocol();
        if (protocol.equalsIgnoreCase("http")) {
            return RequestClient.send(url, xmlStr);
        }
        if (protocol.equalsIgnoreCase("https")) {
            return RequestClient.secureSend(url, xmlStr, certpath);
        }
        throw new CSSException("-10702203", ".sendMessage(URL url, String xmlStr, String certpath)", "\u53d1\u9001\u62a5\u6587\u51fa\u73b0\u672a\u77e5\u9519\u8bef\uff01");
    }

    public static String send(URL url, String xmlStr) throws CSSException {
        String string;
        String METHOD_NAME = "send(URL url, String xmlStr)";
        if (xmlStr == null || xmlStr.trim().length() == 0) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)"Message is null!");
            }
            throw new CSSException("-10702001", ".send(URL url, String xmlStr)", "\u53c2\u6570\u4e0d\u5408\u6cd5\uff0curl\u8f93\u5165\u4e3a\u7a7a\uff01");
        }
        if (url == null) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)"Url is null!");
            }
            throw new CSSException("-10702002", ".send(URL url, String xmlStr)", "\u53c2\u6570\u4e0d\u5408\u6cd5\uff0cxml\u62a5\u6587\u8f93\u5165\u4e3a\u7a7a\uff01");
        }
        HttpURLConnection httpurlconnection = null;
        OutputStream outputstream = null;
        String m_RtnString = "";
        long beginTime = System.currentTimeMillis();
        try {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)"Begin to get httpurlconnection object, open connection.");
            }
            httpurlconnection = (HttpURLConnection)url.openConnection();
            httpurlconnection.setRequestProperty("Connection", "Close");
            String timeout = Config.getInstance().getTimeout();
            if (null != timeout && !"".equals(timeout)) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info((Object)("From the configuration for reading in timeout, set the timeout value is " + timeout + " ms"));
                }
            } else {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info((Object)"The timeout value is null , set the timeout with default value is 10000 ms");
                }
                timeout = "10000";
            }
            httpurlconnection.setReadTimeout(Integer.parseInt(timeout));
            String connectTimeOut = Config.getInstance().getConnectTimeOut();
            if (null != connectTimeOut && !"".equals(connectTimeOut)) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info((Object)("From the configuration for reading in connectTimeout, set the connectTimeout value is " + connectTimeOut + " ms"));
                }
            } else {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info((Object)"The connectTimeOut value is null , set the connectTimeout with default value is 10000 ms");
                }
                connectTimeOut = "10000";
            }
            httpurlconnection.setConnectTimeout(Integer.parseInt(connectTimeOut));
            httpurlconnection.setDoOutput(true);
            httpurlconnection.setUseCaches(false);
            httpurlconnection.setRequestMethod("POST");
            httpurlconnection.setRequestProperty("Content-Type", "text/xml;charset=UTF-8");
            int i = xmlStr.getBytes("UTF-8").length;
            httpurlconnection.setRequestProperty("Content-Length", Integer.toString(i));
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)"Begin to send request....");
            }
            outputstream = httpurlconnection.getOutputStream();
            outputstream.write(xmlStr.getBytes("UTF-8"));
            outputstream.flush();
            if (LOGGER.isInfoEnabled()) {
                long endTime = System.currentTimeMillis() - beginTime;
                LOGGER.info((Object)("Send request complete, total time is " + endTime + " ms."));
            }
        }
        catch (Exception e1) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)"Send request is failed.", (Throwable)e1);
                LOGGER.error((Object)"errorCode: -10702003, errorMessage: \u53d1\u9001\u8bf7\u6c42\u8d85\u65f6\uff01", (Throwable)e1);
            }
            RequestClient.closeOutputStream(outputstream);
            RequestClient.closeHttpUrlConnection(httpurlconnection);
            throw new CSSException("-10702003", ".send(URL url, String xmlStr)", "\u53d1\u9001\u8bf7\u6c42\u8d85\u65f6\uff01", e1.toString());
        }
        InputStream in = null;
        long beginTime1 = System.currentTimeMillis();
        try {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)"Begin to Receive response....");
            }
            in = httpurlconnection.getInputStream();
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)"Receive response is failed.");
                LOGGER.error((Object)"errorCode: -10702020, errorMessage: \u83b7\u53d6\u8fd4\u56de\u62a5\u6587\u8d85\u65f6\uff01", (Throwable)e);
            }
            RequestClient.closeOutputStream(outputstream);
            RequestClient.closeInputStream(in);
            RequestClient.closeHttpUrlConnection(httpurlconnection);
            throw new CSSException("-10702020", ".send(URL url, String xmlStr)", "\u83b7\u53d6\u8fd4\u56de\u62a5\u6587\u8d85\u65f6\uff01");
        }
        ByteArrayOutputStream bout = null;
        try {
            bout = new ByteArrayOutputStream();
            byte[] content = new byte[1024];
            int length = -1;
            while ((length = in.read(content)) > 0) {
                bout.write(content, 0, length);
            }
            content = bout.toByteArray();
            m_RtnString = new String(content, "UTF-8");
            if (LOGGER.isInfoEnabled()) {
                long endTime1 = System.currentTimeMillis() - beginTime1;
                LOGGER.info((Object)("Receive response complete, total time is " + endTime1 + " ms."));
            }
            string = m_RtnString;
            Object var17_20 = null;
        }
        catch (Exception exception) {
            try {
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.error((Object)"errorCode: -10702004, errorMessage: \u83b7\u53d6\u8fd4\u56de\u62a5\u6587\u5931\u8d25\uff01", (Throwable)exception);
                }
                throw new CSSException("-10702004", ".send(URL url, String xmlStr)", "\u83b7\u53d6\u8fd4\u56de\u62a5\u6587\u5931\u8d25\uff01");
            }
            catch (Throwable throwable) {
                Object var17_21 = null;
                RequestClient.closeOutputStream(bout);
                RequestClient.closeInputStream(in);
                RequestClient.closeOutputStream(outputstream);
                RequestClient.closeHttpUrlConnection(httpurlconnection);
                throw throwable;
            }
        }
        RequestClient.closeOutputStream(bout);
        RequestClient.closeInputStream(in);
        RequestClient.closeOutputStream(outputstream);
        RequestClient.closeHttpUrlConnection(httpurlconnection);
        return string;
    }

    private static void closeInputStream(InputStream inputstream) {
        block3: {
            try {
                if (inputstream != null) {
                    inputstream.close();
                }
            }
            catch (IOException e) {
                if (!LOGGER.isErrorEnabled()) break block3;
                LOGGER.error((Object)"Close inputstream is exception.", (Throwable)e);
            }
        }
    }

    private static void closeOutputStream(OutputStream outputstream) {
        block3: {
            try {
                if (outputstream != null) {
                    outputstream.close();
                }
            }
            catch (IOException e) {
                if (!LOGGER.isErrorEnabled()) break block3;
                LOGGER.error((Object)"Close outputstream is exception.", (Throwable)e);
            }
        }
    }

    private static void closeHttpUrlConnection(HttpURLConnection httpurlconnection) {
        block3: {
            try {
                if (httpurlconnection != null) {
                    httpurlconnection.disconnect();
                }
            }
            catch (Exception e) {
                if (!LOGGER.isErrorEnabled()) break block3;
                LOGGER.error((Object)"Disconnect http url connection is exception.", (Throwable)e);
            }
        }
    }

    /*
     * Loose catch block
     */
    public static Object sendByObj(URL url, Object object) throws CSSException {
        Object object2;
        OutputStream outputstream;
        HttpURLConnection httpurlconnection;
        block18: {
            String METHOD_NAME = "sendByObj(URL url, Object object)";
            if (object == null) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info((Object)"Object is null!");
                }
                throw new CSSException("-10702005", ".sendByObj(URL url, Object object)", "\u53c2\u6570\u4e0d\u5408\u6cd5\uff0cobject\u62a5\u6587\u8f93\u5165\u4e3a\u7a7a\uff01");
            }
            if (url == null) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info((Object)"Url is null!");
                }
                throw new CSSException("-10702006", ".sendByObj(URL url, Object object)", "\u53c2\u6570\u4e0d\u5408\u6cd5\uff0curl\u8f93\u5165\u4e3a\u7a7a\uff01");
            }
            httpurlconnection = null;
            outputstream = null;
            ObjectOutputStream out = null;
            httpurlconnection = (HttpURLConnection)url.openConnection();
            httpurlconnection.setDoOutput(true);
            httpurlconnection.setUseCaches(false);
            httpurlconnection.setRequestMethod("POST");
            httpurlconnection.setRequestProperty("Content-Type", "text/xml;charset=UTF-8");
            outputstream = httpurlconnection.getOutputStream();
            out = new ObjectOutputStream(outputstream);
            out.writeObject(object);
            out.flush();
            object2 = null;
            try {
                if (out != null) {
                    out.close();
                }
                out = null;
            }
            catch (IOException e2) {}
            break block18;
            {
                catch (Exception e1) {
                    if (LOGGER.isErrorEnabled()) {
                        LOGGER.error((Object)"Send request is failed.", (Throwable)e1);
                        LOGGER.error((Object)"errorCode: -10702007, errorMessage: \u53d1\u9001\u8bf7\u6c42\u5931\u8d25\uff01", (Throwable)e1);
                    }
                    RequestClient.closeOutputStream(outputstream);
                    RequestClient.closeHttpUrlConnection(httpurlconnection);
                    throw new CSSException("-10702007", ".sendByObj(URL url, Object object)", "\u53d1\u9001\u8bf7\u6c42\u5931\u8d25\uff01");
                }
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                try {
                    if (out != null) {
                        out.close();
                    }
                    out = null;
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        ObjectInputStream ois = null;
        InputStream in = null;
        try {
            in = httpurlconnection.getInputStream();
            ois = new ObjectInputStream(in);
            object2 = ois.readObject();
            Object var11_15 = null;
        }
        catch (Exception exception2) {
            try {
                LOGGER.error((Object)"errorCode: -10702008, errorMessage: \u83b7\u53d6\u8fd4\u56de\u62a5\u6587\u5931\u8d25\uff01", (Throwable)exception2);
                throw new CSSException("-10702008", ".sendByObj(URL url, Object object)", "\u83b7\u53d6\u8fd4\u56de\u62a5\u6587\u5931\u8d25\uff01");
            }
            catch (Throwable throwable) {
                Object var11_16 = null;
                RequestClient.closeInputStream(ois);
                RequestClient.closeInputStream(in);
                RequestClient.closeOutputStream(outputstream);
                RequestClient.closeHttpUrlConnection(httpurlconnection);
                throw throwable;
            }
        }
        RequestClient.closeInputStream(ois);
        RequestClient.closeInputStream(in);
        RequestClient.closeOutputStream(outputstream);
        RequestClient.closeHttpUrlConnection(httpurlconnection);
        return object2;
    }

    public static String secureSend(URL url, String xmlStr, String certPathStr) throws CSSException {
        String string;
        block12: {
            String METHOD_NAME = "secureSend(URL url, String xmlStr, String certPathStr)";
            if (xmlStr == null || xmlStr.trim().length() == 0) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info((Object)"Message is null!");
                }
                throw new CSSException("-10702009", ".secureSend(URL url, String xmlStr, String certPathStr)", "\u53c2\u6570\u8f93\u5165\u4e0d\u5408\u6cd5\uff0cxml\u62a5\u6587\u8f93\u5165\u4e3a\u7a7a\uff01");
            }
            if (url == null) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info((Object)"Url is null!");
                }
                throw new CSSException("-10702010", ".secureSend(URL url, String xmlStr, String certPathStr)", "\u53c2\u6570\u4e0d\u5408\u6cd5\uff0curl\u8f93\u5165\u4e3a\u7a7a\uff01");
            }
            SSLProtocolSocketFactory sslsocketfactory = new SSLProtocolSocketFactory();
            Protocol myhttps = new Protocol("https", (SecureProtocolSocketFactory)sslsocketfactory, url.getPort());
            if (certPathStr != null && certPathStr.trim().length() > 0) {
                System.setProperty("javax.net.ssl.trustStore", certPathStr);
            }
            PostMethod httppost = null;
            HttpClient httpclient = new HttpClient();
            try {
                httpclient.getHostConfiguration().setHost(url.getHost(), url.getPort(), myhttps);
                String uristr = url.getPath();
                if (url.getQuery() != null && url.getQuery().length() > 0) {
                    uristr = uristr + "?" + url.getQuery();
                }
                httppost = new PostMethod(uristr);
                httppost.setRequestContentLength(xmlStr.getBytes("UTF-8").length);
                httppost.addRequestHeader("Content-Type", "text/html; charset=UTF-8");
                httppost.setRequestBody((InputStream)new ByteArrayInputStream(xmlStr.getBytes("UTF-8")));
                try {
                    httpclient.executeMethod((HttpMethod)httppost);
                }
                catch (IOException ex1) {
                    throw new CSSException("-10702011", ".secureSend(URL url, String xmlStr, String certPathStr)", "\u53d1\u9001\u8bf7\u6c42\u5931\u8d25\uff01");
                }
                byte[] certsAsbyte = httppost.getResponseBody();
                string = new String(certsAsbyte, "UTF-8");
                Object var12_13 = null;
                if (httppost == null) break block12;
            }
            catch (IOException ie) {
                try {
                    throw new CSSException("-10702012", ".secureSend(URL url, String xmlStr, String certPathStr)", "\u83b7\u53d6\u8fd4\u56de\u62a5\u6587\u5931\u8d25\uff01");
                }
                catch (Throwable throwable) {
                    block13: {
                        Object var12_14 = null;
                        if (httppost == null) break block13;
                        httppost.releaseConnection();
                        httppost = null;
                    }
                    throw throwable;
                }
            }
            httppost.releaseConnection();
            httppost = null;
        }
        return string;
    }
}

