/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.assp.css.client;

import cn.com.jit.assp.css.client.Config;
import cn.com.jit.assp.css.client.log.ErrorProcess;
import cn.com.jit.assp.css.client.util.Base64;
import cn.com.jit.assp.css.client.util.UtilTool;
import cn.com.jit.assp.css.util.ResponseSet;
import java.io.Serializable;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResultSet
implements Serializable {
    private static final Log LOGGER = LogFactory.getLog(ResultSet.class);
    public static final String SIGN_ALG = "alg";
    private boolean succeed = false;
    private int svcId = -1;
    private String svcName = "";
    private String errcode = "";
    private String errdesc = "";
    private byte[] signedData = null;
    private String base64SignedData = null;
    private String signAlgID = null;
    private String base64DsCert = null;
    private byte[] digestedData = null;
    private String digestAlgID = null;
    private String base64PlainData = null;
    private HashMap certInfo = null;
    private HashMap tsaInfo = null;
    private String fileName = "";
    private byte[] data;

    public ResultSet() {
        this.certInfo = new HashMap(1);
    }

    public ResultSet(ResponseSet respSet) {
        String tmpStr = null;
        if (respSet != null) {
            this.svcName = respSet.getSvcName();
            this.certInfo = respSet.getDsCertInfo();
            this.succeed = respSet.isSucceed();
            this.base64SignedData = respSet.getSignedData() == null ? null : respSet.getSignedData();
            this.base64PlainData = respSet.getPlainData();
            this.digestAlgID = respSet.getDigestAlg();
            tmpStr = respSet.getDigestDataFromMap();
            if (tmpStr != null && tmpStr.trim().length() > 0) {
                this.digestedData = Base64.decode(tmpStr.trim());
            }
            this.base64DsCert = respSet.getDSCertFromMap();
            this.errcode = respSet.getErrCode();
            this.errdesc = respSet.getErrDesc();
            this.fileName = respSet.getFileName();
            this.tsaInfo = respSet.getTsaInfo();
        }
    }

    public HashMap getCertInfo() {
        return this.certInfo;
    }

    public void setCertInfo(HashMap certInfo) {
        this.certInfo = certInfo;
    }

    public String getDigestAlgID() {
        return this.digestAlgID;
    }

    public void setDigestAlgID(String digestAlgID) {
        this.digestAlgID = digestAlgID;
    }

    public byte[] getDigestedData() {
        return this.digestedData;
    }

    public void setDigestedData(String digestedData) {
        this.digestedData = this.base64toByteArray(digestedData);
    }

    public String getSignAlgID() {
        return this.signAlgID;
    }

    public void setSignAlgID(String signAlgID) {
        this.signAlgID = signAlgID;
    }

    public byte[] getSignedData() {
        this.signedData = Base64.decode(this.base64SignedData == null ? null : this.base64SignedData);
        return this.signedData;
    }

    public void setSignedData(String signedData) {
        this.signedData = this.base64toByteArray(signedData);
    }

    public String getBase64DsCert() {
        return this.base64DsCert;
    }

    public void setBase64DsCert(String signPubCertBase64Str) {
        this.base64DsCert = signPubCertBase64Str;
    }

    public byte[] getPlainData() {
        Config config = Config.getInstance();
        if (config.isCompatible()) {
            return this.base64PlainData == null ? null : Base64.decode(UtilTool.removeODOA(this.base64PlainData));
        }
        return this.base64PlainData == null ? null : Base64.decode(this.base64PlainData);
    }

    public boolean isSucceed() {
        return this.succeed;
    }

    public void setSucceed(boolean succeed) {
        this.succeed = succeed;
    }

    public int getSvcId() {
        return this.svcId;
    }

    public void setSvcName(String svcName) {
        if (svcName != null) {
            this.svcName = svcName;
            if (svcName.equals("doDSign")) {
                this.svcId = 1;
            } else if (svcName.equals("verifyDSign")) {
                this.svcId = 2;
            } else if (svcName.equals("doDigest")) {
                this.svcId = 3;
            }
        }
    }

    public String getSvcName() {
        return this.svcName;
    }

    public String getCertItemValue(String itemName) {
        if (this.certInfo != null && this.certInfo.containsKey(itemName)) {
            return (String)this.certInfo.get(itemName);
        }
        return "";
    }

    public String getTsaValue(String itemName) {
        if (this.tsaInfo != null && this.tsaInfo.containsKey(itemName = itemName.toLowerCase())) {
            return (String)this.tsaInfo.get(itemName);
        }
        return "";
    }

    public Date getTsaTime() {
        if (this.tsaInfo != null) {
            String t = (String)this.tsaInfo.get("signedtime");
            SimpleDateFormat dateParser = new SimpleDateFormat("yyyyMMddHHmmssz", new DateFormatSymbols(Locale.ENGLISH));
            try {
                Date signedTime = dateParser.parse(t);
                return signedTime;
            }
            catch (ParseException e) {
                LOGGER.error((Object)("Failure to parser signedTime from: [" + (String)this.tsaInfo.get("signedTime") + "]"), (Throwable)e);
                throw new RuntimeException("Failure to parser signedTime from: [" + (String)this.tsaInfo.get("signedTime") + "]");
            }
        }
        return null;
    }

    public Date getTsaTimeByMS() {
        if (this.tsaInfo != null) {
            String t = (String)this.tsaInfo.get("signedtimebyms");
            SimpleDateFormat dateParser = new SimpleDateFormat("yyyyMMddHHmmssSSSS", new DateFormatSymbols(Locale.ENGLISH));
            try {
                Date signedTime = dateParser.parse(t);
                return signedTime;
            }
            catch (ParseException e) {
                LOGGER.error((Object)("Failure to parser signedTimeByMS from: [" + (String)this.tsaInfo.get("signedTimeByMS") + "]"), (Throwable)e);
                throw new RuntimeException("Failure to parser signedTimeByMS from: [" + (String)this.tsaInfo.get("signedTimeByMS") + "]");
            }
        }
        return null;
    }

    private byte[] base64toByteArray(String base64str) {
        byte[] tbyte = null;
        if (base64str != null && base64str.length() > 0) {
            try {
                tbyte = Base64.decode(UtilTool.convertBase64(base64str.getBytes()));
            }
            catch (Exception ex) {
                LOGGER.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        return tbyte;
    }

    public String getErrcode() {
        return this.errcode;
    }

    public void setErrcode(String errcode) {
        this.errcode = errcode;
    }

    public String getErrDesc() {
        return this.errdesc;
    }

    public void setErrDesc(String errdesc) {
        this.errdesc = errdesc;
    }

    public String getErrDisc() {
        if (this.errcode != null && this.errcode.length() > 0) {
            return ErrorProcess.getInstance().getErrDesc(this.errcode, ErrorProcess.vDefServerInfo);
        }
        return "";
    }

    public void clear() {
        this.succeed = false;
        int svcId = -1;
        String svcLable = "";
        String errcode = "";
        String errdesc = "";
        this.signedData = null;
        this.base64SignedData = null;
        this.signAlgID = null;
        this.base64DsCert = null;
        this.digestedData = null;
        this.digestAlgID = null;
        this.base64PlainData = null;
        if (this.certInfo != null) {
            this.certInfo.clear();
        }
        this.fileName = "";
    }

    public String getBase64SignedData() {
        return this.base64SignedData;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getBase64PlainData() {
        return this.base64PlainData;
    }

    public void setBase64PlainData(String base64PlainData) {
        this.base64PlainData = base64PlainData;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }
}

