/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.assp.css.client;

import cn.com.jit.assp.css.client.CSSException;
import cn.com.jit.assp.css.client.Config;
import cn.com.jit.assp.css.client.HttpRespResult;
import cn.com.jit.assp.css.client.log.ErrorProcess;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpStreamSender {
    private static final Log LOGGER = LogFactory.getLog(HttpStreamSender.class);
    public static final String CLASS_NAME = HttpStreamSender.class.getName();
    private static Config config = Config.getInstance();
    private static ErrorProcess errprocess = ErrorProcess.getInstance();
    private static int sendSize = config.getSendSize();

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static HttpRespResult streamSend(Map<String, String> httpHeader, byte[] plainData, byte[] signedData) throws CSSException {
        String METHOD_NAME = "streamSend(Map<String, String> httpHeader, byte[] plainData, byte[] signedData)";
        int totalLength = HttpStreamSender.getTotalDataLength(plainData, signedData);
        byte[] totolByteArr = new byte[]{};
        PostMethod httppost = null;
        HttpClient httpclient = null;
        int totalReceiveNum = 0;
        int totalSendNum = 0;
        HttpRespResult result = new HttpRespResult();
        try {
            String urlStr = Config.getInstance().getServerURLStr();
            URL url = new URL(urlStr);
            httpclient = new HttpClient();
            HttpStreamSender.initHttpClient(httpclient, url);
            httppost = HttpStreamSender.getPostMethod(url);
            HttpStreamSender.putHeaders(httpHeader, httppost);
            byte[] temp = new byte[sendSize];
            int num = 0;
            for (int i = 0; i <= totalLength - 1; i += sendSize, ++num) {
                temp = HttpStreamSender.putBody(plainData, signedData, httppost, temp, num, i);
                LOGGER.info((Object)("send url:" + url.toString()));
                LOGGER.info((Object)("send num:" + (num + 1)));
                totalSendNum = HttpStreamSender.increamTotalSendLength(plainData, signedData, totalSendNum, i);
                HttpStreamSender.printAllHeaderParams(httppost.getRequestHeaders(), "send");
                int statusCode = httpclient.executeMethod((HttpMethod)httppost);
                result = HttpStreamSender.formRespHeader(httppost, result);
                HttpStreamSender.printAllHeaderParams(httppost.getResponseHeaders(), "receive");
                HttpStreamSender.checkErrorResult("streamSend(Map<String, String> httpHeader, byte[] plainData, byte[] signedData)", result, statusCode);
                byte[] responseBody = httppost.getResponseBody();
                if (responseBody == null) {
                    responseBody = new byte[]{};
                }
                totolByteArr = HttpStreamSender.pushReceiveBody(totolByteArr, totalReceiveNum, result, responseBody);
                totalReceiveNum = HttpStreamSender.increamTotalReceiveLength(responseBody, totalReceiveNum);
            }
            LOGGER.info((Object)("total send:" + totalSendNum));
            LOGGER.info((Object)("total receive:" + totalReceiveNum));
        }
        catch (CSSException e) {
            try {
                throw e;
                catch (Throwable e2) {
                    throw new CSSException("-10701105", CLASS_NAME + "." + "streamSend(Map<String, String> httpHeader, byte[] plainData, byte[] signedData)", "\u7b7e\u540d\u65f6\u5411\u670d\u52a1\u5668\u53d1\u9001\u8bf7\u6c42\u62a5\u6587\u65f6\u4ea7\u751f\u5f02\u5e38\uff01");
                }
            }
            catch (Throwable throwable) {
                HttpStreamSender.closeHttpPost(httppost, httpclient);
                throw throwable;
            }
        }
        HttpStreamSender.closeHttpPost(httppost, httpclient);
        result.setRespBody(totolByteArr);
        return result;
    }

    private static byte[] pushReceiveBody(byte[] totolByteArr, int totalReceiveNum, HttpRespResult result, byte[] responseBody) throws IOException {
        String resultLength = HttpStreamSender.getHeaderParam(result, "datalength");
        String contentLength = HttpStreamSender.getHeaderParam(result, "content-length");
        if (StringUtils.isBlank((String)resultLength) && !StringUtils.equals((String)contentLength, (String)"0")) {
            byte[] newTotalByte = new byte[totolByteArr.length + Integer.parseInt(contentLength)];
            HttpStreamSender.fill(totolByteArr, totolByteArr.length, newTotalByte, 0);
            HttpStreamSender.fill(responseBody, contentLength.length(), newTotalByte, totolByteArr.length);
            totolByteArr = newTotalByte;
        }
        if (totolByteArr.length == 0 && StringUtils.isNotBlank((String)resultLength) && !StringUtils.equals((String)resultLength, (String)"0")) {
            totolByteArr = new byte[Integer.parseInt(resultLength)];
        }
        if (totolByteArr != null) {
            HttpStreamSender.writeByte(totolByteArr, responseBody, totalReceiveNum);
        }
        return totolByteArr;
    }

    private static int increamTotalReceiveLength(byte[] responseBody, int totalReceiveNum) {
        return totalReceiveNum += responseBody.length;
    }

    private static int increamTotalSendLength(byte[] plainData, byte[] signedData, int totalSendNum, int sendedDataLength) {
        int resetNum;
        int totalDataLength = HttpStreamSender.getTotalDataLength(plainData, signedData);
        totalSendNum = totalDataLength <= sendSize ? (totalSendNum += totalDataLength) : ((resetNum = totalDataLength - sendedDataLength) <= sendSize ? (totalSendNum += resetNum) : (totalSendNum += sendSize));
        return totalSendNum;
    }

    private static int getTotalDataLength(byte[] plainData, byte[] sigedData) {
        return plainData.length + sigedData.length;
    }

    private static void initHttpClient(HttpClient httpclient, URL url) {
        httpclient.getHostConfiguration().setHost(url.getHost(), url.getPort());
        httpclient.getHttpConnectionManager().getParams().setConnectionTimeout(Integer.valueOf(config.getConnectTimeOut()).intValue());
        httpclient.getHttpConnectionManager().getParams().setSoTimeout(Integer.valueOf(config.getTimeout()).intValue());
    }

    private static void printAllHeaderParams(Header[] headers, String method) {
        for (Header header : headers) {
            LOGGER.info((Object)(method + " header param:" + header.getName() + ":" + header.getValue()));
        }
    }

    private static PostMethod getPostMethod(URL url) {
        String uristr = url.getPath();
        if (url.getQuery() != null && url.getQuery().length() > 0) {
            uristr = uristr + "?" + url.getQuery();
        }
        PostMethod httppost = new PostMethod(uristr);
        return httppost;
    }

    private static void putHeaders(Map<String, String> httpHeader, PostMethod httppost) {
        for (Map.Entry<String, String> headerProperty : httpHeader.entrySet()) {
            String key = headerProperty.getKey();
            String value = headerProperty.getValue();
            httppost.setRequestHeader(key, value);
        }
    }

    private static HttpRespResult formRespHeader(PostMethod httppost, HttpRespResult result) {
        Header[] responseHeaders;
        for (Header header : responseHeaders = httppost.getResponseHeaders()) {
            String value = header.getValue();
            result.getRespHeader().put(header.getName().toLowerCase(), value);
        }
        return result;
    }

    private static byte[] putBody(byte[] plainData, byte[] signedData, PostMethod httppost, byte[] temp, int num, int sendedDataLength) {
        int resetNum = 0;
        int totalDataLength = HttpStreamSender.getTotalDataLength(plainData, signedData);
        if (totalDataLength <= sendSize) {
            temp = HttpStreamSender.formBodyBySmallData(plainData, signedData, totalDataLength);
            httppost.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(temp));
            httppost.setRequestHeader("content-length", temp.length + "");
            return temp;
        }
        resetNum = totalDataLength - sendedDataLength;
        if (resetNum <= sendSize) {
            temp = new byte[resetNum];
            HttpStreamSender.formNormalBodyByBigData(plainData, signedData, temp, resetNum, sendedDataLength);
        } else {
            HttpStreamSender.formNormalBodyByBigData(plainData, signedData, temp, sendSize, sendedDataLength);
        }
        httppost.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(temp));
        httppost.setRequestHeader("content-length", temp.length + "");
        return temp;
    }

    private static byte[] formBodyBySmallData(byte[] plainData, byte[] sigedData, int totalDataLength) {
        byte[] temp = new byte[totalDataLength];
        System.arraycopy(sigedData, 0, temp, 0, sigedData.length);
        System.arraycopy(plainData, 0, temp, sigedData.length, plainData.length);
        return temp;
    }

    private static void formNormalBodyByBigData(byte[] plainData, byte[] signedData, byte[] temp, int sendSize, int sendedDataLength) {
        int criticalIndex = signedData.length - sendedDataLength;
        if (criticalIndex > 0 && criticalIndex < sendSize) {
            System.arraycopy(signedData, sendedDataLength, temp, 0, criticalIndex);
            System.arraycopy(plainData, 0, temp, criticalIndex, sendSize - criticalIndex);
        } else if (criticalIndex >= sendSize) {
            System.arraycopy(signedData, sendedDataLength, temp, 0, sendSize);
        } else if (criticalIndex <= 0) {
            System.arraycopy(plainData, sendedDataLength - signedData.length, temp, 0, sendSize);
        }
    }

    private static String getHeaderParam(HttpRespResult result, String paramName) {
        return result.getRespHeader().get(paramName);
    }

    private static void checkErrorResult(String METHOD_NAME, HttpRespResult result, int statusCode) throws CSSException {
        if (statusCode != 200) {
            throw new CSSException("-10701105", CLASS_NAME + "." + METHOD_NAME, "\u7b7e\u540d\u65f6\u5411\u670d\u52a1\u5668\u53d1\u9001\u8bf7\u6c42\u62a5\u6587\u65f6\u4ea7\u751f\u5f02\u5e38\uff01");
        }
        String errorcode = HttpStreamSender.getHeaderParam(result, "errorcode");
        String errdic = errprocess.getErrDesc(errorcode, ErrorProcess.vDefServerInfo);
        if (!(errorcode != null && errorcode.equals("0") || errdic.equals(""))) {
            throw new CSSException(errorcode, CLASS_NAME + "." + METHOD_NAME, errdic);
        }
    }

    private static void writeByte(byte[] totolByteArr, byte[] responseBody, int totalReceiveNum) throws IOException {
        HttpStreamSender.fill(responseBody, responseBody.length, totolByteArr, totalReceiveNum);
    }

    private static void fill(byte[] src, int srcLength, byte[] dst, int dstPos) {
        for (int j = 0; j < srcLength; ++j) {
            dst[dstPos + j] = src[j];
        }
    }

    private static void closeHttpPost(PostMethod httppost, HttpClient client) {
        block3: {
            try {
                if (httppost != null) {
                    httppost.releaseConnection();
                    client.getHttpConnectionManager().closeIdleConnections(0L);
                    httppost = null;
                }
            }
            catch (Exception e) {
                if (!LOGGER.isErrorEnabled()) break block3;
                LOGGER.error((Object)"Disconnect http url connection is exception.", (Throwable)e);
            }
        }
    }
}

