/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.assp.css.client;

import cn.com.jit.assp.css.client.CSSException;
import cn.com.jit.assp.css.client.Config;
import cn.com.jit.assp.css.client.HttpRespResult;
import cn.com.jit.assp.css.client.HttpStreamSender;
import cn.com.jit.assp.css.client.ResultSet;
import cn.com.jit.assp.css.client.log.ErrorProcess;
import cn.com.jit.assp.css.client.util.CommUtil;
import cn.com.jit.assp.css.client.util.PlainOfFileModel;
import cn.com.jit.assp.css.client.util.UtilTool;
import cn.com.jit.assp.dsign.PkiToolUtils;
import cn.com.jit.ida.util.pki.cert.X509Cert;
import cn.com.jit.ida.util.pki.cipher.param.P7Param;
import cn.com.jit.ida.util.pki.encoders.Base64;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpStreamClient {
    private static final Log LOGGER = LogFactory.getLog(HttpStreamClient.class);
    public static final String CLASS_NAME = HttpStreamClient.class.getName();
    private static Config config = Config.getInstance();
    private static ErrorProcess errprocess = ErrorProcess.getInstance();

    public ResultSet decryptEnvelop(Map<String, String> httpHeader, byte[] signedData) throws CSSException {
        HttpRespResult result = this.decryptEnvelopByHttpRespResult(httpHeader, signedData);
        ResultSet rs = this.formResultSetByDecryptEnvelop(result);
        return rs;
    }

    private ResultSet formResultSetByDecryptEnvelop(HttpRespResult result) {
        ResultSet rs = new ResultSet();
        String errorCode = result.getRespHeader().get("errorcode");
        this.formVerifyCertInfo(result, rs);
        if (StringUtils.equals((String)errorCode, (String)"0")) {
            rs.setSucceed(true);
        }
        rs.setErrcode(this.getHeaderParam(result, "errorcode"));
        rs.setErrDesc(this.getHeaderParam(result, "errormsg"));
        PlainOfFileModel plain = UtilTool.buildFileName(result.getRespBody(), false);
        rs.setFileName(plain.getFileName());
        rs.setBase64PlainData(plain.getBase64PlainData());
        return rs;
    }

    public HttpRespResult decryptEnvelopByHttpRespResult(Map<String, String> httpHeader, byte[] signedData) throws CSSException {
        HttpRespResult result = HttpStreamSender.streamSend(httpHeader, signedData, new byte[0]);
        ArrayList<String> base64Params = new ArrayList<String>();
        base64Params.add("dn");
        base64Params.add("issdn");
        this.DecodeBase64Params(result, base64Params);
        return result;
    }

    public HttpRespResult makeEnvelopByHttpRespResult(Map<String, String> httpHeader, byte[] encryptData) throws CSSException {
        HttpRespResult result = HttpStreamSender.streamSend(httpHeader, new byte[0], encryptData);
        return result;
    }

    public HttpRespResult SymmDecryptByHttpRespResult(Map<String, String> httpHeader, byte[] encryptData) throws CSSException {
        String METHOD_NAME = "SymmDecryptByHttpRespResult(Map<String, String> httpHeader, byte[] encryptData)";
        if (CommUtil.isNull(encryptData)) {
            throw new CSSException("-10701001", CLASS_NAME + "." + "SymmDecryptByHttpRespResult(Map<String, String> httpHeader, byte[] encryptData)", "\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u539f\u6587\u8f93\u5165\u4e3a\u7a7a\uff01");
        }
        HttpRespResult result = HttpStreamSender.streamSend(httpHeader, new byte[0], encryptData);
        return result;
    }

    private Map<String, String> formSymmDecryptRequestHeader(byte[] plainData, String symmKeyNo, String businessType) {
        HashMap<String, String> httpHeader = new HashMap<String, String>();
        httpHeader.put("connection", "Close");
        httpHeader.put("totallength", plainData.length + "");
        httpHeader.put("certversion", "1.0");
        httpHeader.put("businesstype", businessType);
        httpHeader.put("messagetype", "http");
        httpHeader.put("symmkeyid", symmKeyNo);
        return httpHeader;
    }

    public HttpRespResult SymmEncryptByHttpRespResult(Map<String, String> httpHeader, byte[] plainData) throws CSSException {
        String METHOD_NAME = "SymmEncryptByHttpRespResult(Map<String,String> httpHeader, byte[] plainData)";
        if (CommUtil.isNull(plainData)) {
            throw new CSSException("-10701001", CLASS_NAME + "." + "SymmEncryptByHttpRespResult(Map<String,String> httpHeader, byte[] plainData)", "\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u539f\u6587\u8f93\u5165\u4e3a\u7a7a\uff01");
        }
        HttpRespResult result = HttpStreamSender.streamSend(httpHeader, plainData, new byte[0]);
        return result;
    }

    public String digest(String plainText, String digestALG, String charSet) throws CSSException {
        HttpRespResult result = this.digestByHttpRespResult(plainText, digestALG, "digest", charSet);
        byte[] respBody = result.getRespBody();
        return new String(Base64.encode((byte[])respBody));
    }

    public HttpRespResult digestByHttpRespResult(String plainText, String digestALG, String businessType, String charSet) throws CSSException {
        String METHOD_NAME = "digestByHttpRespResult(String plainText, String digestALG)";
        if (StringUtils.isBlank((String)plainText)) {
            throw new CSSException("-10701001", CLASS_NAME + "." + "digestByHttpRespResult(String plainText, String digestALG)", "\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u539f\u6587\u8f93\u5165\u4e3a\u7a7a\uff01");
        }
        byte[] plainData = null;
        if (StringUtils.isBlank((String)charSet)) {
            plainData = plainText.getBytes();
        } else {
            try {
                plainData = plainText.getBytes(charSet);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        Map<String, String> httpHeader = this.formDigestRequestHeader(plainData, digestALG, businessType);
        HttpRespResult result = HttpStreamSender.streamSend(httpHeader, plainData, new byte[0]);
        return result;
    }

    public HttpRespResult digestByHttpRespResult(byte[] plainText, String digestALG, String businessType) throws CSSException {
        String METHOD_NAME = "digestByHttpRespResult(String plainText, String digestALG)";
        if (plainText == null || plainText.length == 0) {
            throw new CSSException("-10701001", CLASS_NAME + "." + "digestByHttpRespResult(String plainText, String digestALG)", "\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u539f\u6587\u8f93\u5165\u4e3a\u7a7a\uff01");
        }
        Map<String, String> httpHeader = this.formDigestRequestHeader(plainText, digestALG, businessType);
        HttpRespResult result = HttpStreamSender.streamSend(httpHeader, plainText, new byte[0]);
        return result;
    }

    private Map<String, String> formDigestRequestHeader(byte[] plainData, String digestALG, String businessType) {
        HashMap<String, String> httpHeader = new HashMap<String, String>();
        httpHeader.put("connection", "Close");
        httpHeader.put("totallength", plainData.length + "");
        httpHeader.put("certversion", "1.0");
        httpHeader.put("businesstype", businessType);
        httpHeader.put("messagetype", "http");
        httpHeader.put("digestalg", StringUtils.isBlank((String)digestALG) ? config.getDigestAlg() : digestALG);
        return httpHeader;
    }

    public ResultSet doSign(byte[] _srcData, String _hashAlg, String _applyID, String businessType) throws CSSException {
        HttpRespResult result = this.doSignByHttpRespResult(_srcData, _hashAlg, _applyID, businessType);
        ResultSet rs = this.formResultSetByDoSign(result);
        return rs;
    }

    private ResultSet formResultSetByDoSign(HttpRespResult result) {
        ResultSet rs = new ResultSet();
        rs.setErrcode(this.getHeaderParam(result, "errorcode"));
        rs.setErrDesc(this.getHeaderParam(result, "errormsg"));
        rs.setData(result.getRespBody());
        return rs;
    }

    private HttpRespResult doSignByHttpRespResult(byte[] _srcData, String _hashAlg, String _applyID, String businessType) throws CSSException {
        String METHOD_NAME = "doSignByHttpRespResultbyte[] _srcData, String _hashAlg, String _applyID, String businessType)";
        if (CommUtil.isNull(_srcData)) {
            throw new CSSException("-10701001", CLASS_NAME + "." + "doSignByHttpRespResultbyte[] _srcData, String _hashAlg, String _applyID, String businessType)", "\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u539f\u6587\u8f93\u5165\u4e3a\u7a7a\uff01");
        }
        Map<String, String> httpHeader = this.formSignRequestHeader(_srcData, _hashAlg, _applyID, businessType);
        HttpRespResult result = HttpStreamSender.streamSend(httpHeader, _srcData, new byte[0]);
        return result;
    }

    private Map<String, String> formSignRequestHeader(byte[] _srcData, String _hashAlg, String _applyID, String businessType) {
        HashMap<String, String> httpHeader = new HashMap<String, String>();
        httpHeader.put("connection", "Close");
        httpHeader.put("totallength", _srcData.length + "");
        httpHeader.put("certversion", "1.0");
        httpHeader.put("businesstype", businessType);
        httpHeader.put("messagetype", "http");
        httpHeader.put("certid", StringUtils.isBlank((String)_applyID) ? config.getAppID() : _applyID);
        httpHeader.put("digestalg", StringUtils.isBlank((String)_hashAlg) ? config.getDigestAlg() : _hashAlg);
        return httpHeader;
    }

    private Map<String, String> formVerifyRequestHeader(byte[] srcData, byte[] srcSignedData, String _hashAlg, String businessType, String certMode, String certInfo) throws CSSException {
        HashMap<String, String> httpHeader = new HashMap<String, String>();
        httpHeader.put("connection", "Close");
        int totalLength = this.getTotalDataLength(srcData, srcSignedData);
        httpHeader.put("totallength", totalLength + "");
        httpHeader.put("certversion", "1.0");
        httpHeader.put("businesstype", businessType);
        httpHeader.put("messagetype", "http");
        httpHeader.put("digestalg", StringUtils.isBlank((String)_hashAlg) ? config.getDigestAlg() : _hashAlg);
        if (StringUtils.equals((String)businessType, (String)"p1verifysign")) {
            httpHeader.put("certmode", certMode);
            httpHeader.put("certinfo", certInfo);
        } else {
            String certInfo1 = this.getIssuerDnAndSn(srcSignedData);
            httpHeader.put("certmode", "dscert");
            httpHeader.put("certinfo", certInfo1);
        }
        if (!StringUtils.equals((String)businessType, (String)"attachverifysign")) {
            httpHeader.put("signdatalength", srcSignedData.length + "");
        }
        return httpHeader;
    }

    private String getIssuerDnAndSn(byte[] srcSignedData) throws CSSException {
        try {
            X509Cert[] getCerts;
            P7Param p7Param = PkiToolUtils.getP7Param(srcSignedData);
            StringBuffer sb = new StringBuffer();
            for (X509Cert x509Cert : getCerts = p7Param.GetCerts()) {
                sb.append(new String(Base64.encode((byte[])x509Cert.getEncoded())) + ",");
            }
            return sb.deleteCharAt(sb.length() - 1).toString();
        }
        catch (Exception e) {
            throw new CSSException("-10709125", "\u7b7e\u540d\u7ed3\u679c\u4e0d\u662f\u5408\u6cd5\u53c2\u6570", e);
        }
    }

    public ResultSet verifySign(byte[] _srcData, byte[] _signedData, String digestAlg, String certInfo, String busniessType, boolean _signedDataBase64) throws CSSException {
        if (_signedDataBase64) {
            byte[] decode = Base64.decode((byte[])_signedData);
            return this.verifySign(_srcData, decode, digestAlg, certInfo, busniessType);
        }
        return this.verifySign(_srcData, _signedData, digestAlg, certInfo, busniessType);
    }

    public ResultSet verifySign(byte[] _srcData, byte[] _signedData, String digestAlg, String certInfo, String busniessType) throws CSSException {
        HttpRespResult result = this.verifySignByHttpRespResult(_srcData, _signedData, digestAlg, certInfo, busniessType);
        ResultSet rs = this.formResultSetByVerifySign(result);
        return rs;
    }

    private ResultSet formResultSetByVerifySign(HttpRespResult result) {
        ResultSet rs = new ResultSet();
        this.formVerifyCertInfo(result, rs);
        String errorCode = this.getHeaderParam(result, "errorcode");
        rs.setErrcode(errorCode);
        if (StringUtils.equals((String)errorCode, (String)"0")) {
            rs.setSucceed(true);
        }
        rs.setErrDesc(this.getHeaderParam(result, "errormsg"));
        rs.setDigestAlgID(this.getHeaderParam(result, "digestalg"));
        PlainOfFileModel plain = UtilTool.buildFileName(result.getRespBody(), true);
        rs.setFileName(plain.getFileName());
        rs.setBase64PlainData(plain.getBase64PlainData());
        return rs;
    }

    private void formVerifyCertInfo(HttpRespResult result, ResultSet rs) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("subjectdn", this.getHeaderParam(result, "dn"));
        map.put("issuerdn", this.getHeaderParam(result, "issdn"));
        map.put("serialnumber", this.getHeaderParam(result, "sn"));
        map.put("version", this.getHeaderParam(result, "certversion"));
        map.put("notbefore", this.getHeaderParam(result, "notbefore"));
        map.put("notafter", this.getHeaderParam(result, "notafter"));
        rs.setCertInfo(map);
    }

    public HttpRespResult verifySignByHttpRespResult(byte[] _srcData, byte[] _signedData, String digestAlg, String certInfo, String busniessType) throws CSSException {
        String METHOD_NAME = "verifySignByHttpRespResult(byte[] _srcData, byte[] _signedData, String digestAlg,String certInfo, String busniessType)";
        if (_signedData == null) {
            throw new CSSException("-10701102", CLASS_NAME + "." + "verifySignByHttpRespResult(byte[] _srcData, byte[] _signedData, String digestAlg,String certInfo, String busniessType)", "\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u9a8c\u8bc1\u7b7e\u540d\u65f6\u7b7e\u540d\u7ed3\u679c\u8f93\u5165\u4e3a\u7a7a\uff01");
        }
        if (_srcData == null) {
            _srcData = new byte[]{};
        }
        Map<String, String> httpHeader = null;
        if (StringUtils.equals((String)busniessType, (String)"attachverifysign")) {
            httpHeader = this.formVerifyRequestHeader(_srcData, _signedData, digestAlg, busniessType, "", "");
        } else if (StringUtils.equals((String)busniessType, (String)"detachverifysign")) {
            httpHeader = this.formVerifyRequestHeader(_srcData, _signedData, digestAlg, busniessType, "", "");
        } else if (StringUtils.equals((String)busniessType, (String)"p1verifysign")) {
            httpHeader = this.formVerifyRequestHeader(_srcData, _signedData, digestAlg, busniessType, config.getP1VerifyCertId(), certInfo);
        }
        HttpRespResult result = HttpStreamSender.streamSend(httpHeader, _srcData, _signedData);
        ArrayList<String> base64Params = new ArrayList<String>();
        base64Params.add("dn");
        base64Params.add("issdn");
        this.DecodeBase64Params(result, base64Params);
        return result;
    }

    private void DecodeBase64Params(HttpRespResult result, List<String> base64Params) {
        Map<String, String> header = result.getRespHeader();
        for (String param : base64Params) {
            String value = header.get(param);
            if (!StringUtils.isNotBlank((String)value)) continue;
            try {
                String newValue = new String(Base64.decode((String)value), "utf-8");
                header.put(param, new String(newValue));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private String getHeaderParam(HttpRespResult result, String paramName) {
        return result.getRespHeader().get(paramName);
    }

    private int getTotalDataLength(byte[] plainData, byte[] sigedData) {
        return plainData.length + sigedData.length;
    }

    public static void main(String[] args) {
        String dn = "Q049Z3Vvd2w1MTQyLE89SklULEM9Q04=";
        System.out.println(new String(Base64.decode((byte[])dn.getBytes())));
    }
}

