/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.assp.css.client;

import cn.com.jit.assp.css.client.CSSException;
import cn.com.jit.assp.css.client.Config;
import cn.com.jit.assp.css.client.ResultSet;
import cn.com.jit.assp.css.client.communication.RequestClient;
import cn.com.jit.assp.css.client.log.ErrorProcess;
import cn.com.jit.assp.css.client.util.Base64;
import cn.com.jit.assp.css.client.util.CommUtil;
import cn.com.jit.assp.css.client.util.SecurityUtil;
import cn.com.jit.assp.css.client.util.UtilTool;
import cn.com.jit.assp.css.util.EnvelopRequestSet;
import cn.com.jit.assp.css.util.EnvelopResponseSet;
import cn.com.jit.assp.css.util.RequestSet;
import cn.com.jit.assp.css.util.ResponseSet;
import cn.com.jit.assp.css.util.parser.EnvelopSimpResponseParser;
import cn.com.jit.assp.css.util.parser.ResponseParser;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DSignClient {
    private static final Log LOGGER = LogFactory.getLog(DSignClient.class);
    public static final String CLASS_NAME = DSignClient.class.getName();
    private Config config = Config.getInstance();
    private ErrorProcess errprocess = ErrorProcess.getInstance();
    private String issuerAndSn;
    private String digestAlg;
    private String encryptAlg;
    private boolean isP1;
    private ResultSet rs = null;
    private boolean isXML = false;

    public byte[] doSign(byte[] _srcData, boolean _isContainSrc, boolean _isContainCert, boolean isSubsequentVerify, String _hashAlg, String _applyID) throws CSSException {
        String METHOD_NAME = "doSign(byte[] _srcData, boolean _isContainSrc,boolean _isContainCert, String _hashAlg, String _applyID)";
        if (CommUtil.isNull(_srcData)) {
            throw new CSSException("-10701001", CLASS_NAME + "." + "doSign(byte[] _srcData, boolean _isContainSrc,boolean _isContainCert, String _hashAlg, String _applyID)", "\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u539f\u6587\u8f93\u5165\u4e3a\u7a7a\uff01");
        }
        String vStrSrcData = null;
        RequestSet vReqset = null;
        int vContentTypeID = 0;
        byte[] vDsData = null;
        int plainDataType = 0;
        if (_isContainSrc && _isContainCert) {
            vContentTypeID = 3;
        } else if (_isContainSrc && !_isContainCert) {
            vContentTypeID = 2;
        } else if (!_isContainSrc && _isContainCert) {
            vContentTypeID = 1;
        } else if (!_isContainSrc && !_isContainCert) {
            vContentTypeID = 0;
            plainDataType = this.isP1 ? 3 : 0;
        }
        if (isSubsequentVerify) {
            vContentTypeID = 4;
        }
        if (this.isXML) {
            plainDataType = 4;
        }
        try {
            vStrSrcData = new String(Base64.encode(_srcData), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        vReqset = new RequestSet();
        vReqset.setReqDSBaseKeys(UtilTool.convertStrArrayToList(UtilTool.splitStr(this.config.getBaseInfo(), ";")));
        vReqset.setReqCertBaseKeys(UtilTool.convertStrArrayToList(UtilTool.splitStr(this.config.getCertBaseInfo(), ";")));
        vReqset.setReqCertExtKeys(UtilTool.convertStrArrayToList(UtilTool.splitStr(this.config.getCertExtendInfo(), ";")));
        vReqset.setReqTsaCertBaseKeys(UtilTool.convertStrArrayToList(UtilTool.splitStr(this.config.getTsaCertBaseInfo(), ";")));
        vReqset.setSid(1);
        vReqset.setPlainData(vStrSrcData);
        vReqset.setPlainDataType(plainDataType);
        vReqset.setDSignMode(vContentTypeID);
        if (_hashAlg != null && _hashAlg.trim().length() > 0) {
            vReqset.setDigestAlg(_hashAlg);
        }
        vReqset.setApplyID(_applyID);
        vDsData = this.requestSign(vReqset);
        vReqset = null;
        return vDsData;
    }

    private byte[] requestSign(RequestSet reqSet) throws CSSException {
        String METHOD_NAME = "requestSign(RequestSet reqSet)";
        URL vUrl = null;
        ResponseParser vRespParser = null;
        ResponseSet vRespSet = null;
        byte[] vDsData = null;
        vUrl = this.config.getServerUrl();
        switch (this.config.getSendMsgFormat()) {
            case 0: {
                String reqXmlStr = reqSet.toXMLString();
                if (this.config.isPrintLog()) {
                    System.out.println("\u5ba2\u6237\u7aef\u53d1\u9001\u7b7e\u540d\u8bf7\u6c42");
                    System.out.println("\u7b7e\u540d\u8bf7\u6c42\u62a5\u6587\uff1a");
                    System.out.println(reqXmlStr);
                }
                String vResponseXml = RequestClient.sendMessage(vUrl, reqXmlStr, "");
                if (this.config.isPrintLog()) {
                    System.out.println("\u5ba2\u6237\u7aef\u63a5\u6536\u5230\u670d\u52a1\u5668\u7aef\u8fd4\u56de\u7684\u5e94\u7b54");
                    System.out.println("\u7b7e\u540d\u5e94\u7b54\u62a5\u6587\uff1a");
                    System.out.println(vResponseXml);
                }
                if (vResponseXml == null || vResponseXml.length() == 0) {
                    throw new CSSException("-10701006", CLASS_NAME + "." + "requestSign(RequestSet reqSet)", "\u8fd4\u56de\u62a5\u6587\u4e3a\u7a7a");
                }
                vRespParser = new ResponseParser();
                vRespSet = vRespParser.parserXML(vResponseXml);
                vResponseXml = null;
                break;
            }
            case 1: {
                if (this.config.isPrintLog()) {
                    System.out.print("\u7b7e\u540d\u8bf7\u6c42\u62a5\u6587\uff1a");
                    System.out.println(reqSet.toXMLString());
                }
                try {
                    vRespSet = (ResponseSet)RequestClient.sendByObj(vUrl, reqSet);
                    if (!this.config.isPrintLog()) break;
                    System.out.print("\u7b7e\u540d\u5e94\u7b54\u62a5\u6587\uff1a");
                    System.out.println(vRespSet.toXMLString());
                    break;
                }
                catch (CSSException csse) {
                    throw csse;
                }
                catch (Exception e) {
                    LOGGER.error((Object)("error code:-10700000, message:" + e.getMessage()), (Throwable)e);
                    throw new CSSException("-10700000", CLASS_NAME + "." + "requestSign(RequestSet reqSet)", e.getMessage());
                }
            }
        }
        this.rs = new ResultSet(vRespSet);
        String errcode = vRespSet.getErrCode();
        boolean result = vRespSet.isSucceed();
        if (result) {
            String dsdata = vRespSet.getSignedData();
            try {
                if (dsdata == null) {
                    dsdata = "";
                }
                vDsData = Base64.decode(UtilTool.convertBase64(dsdata.getBytes("UTF-8")));
            }
            catch (Exception ex1) {
                LOGGER.error((Object)"errorCode: -10701007errorMessage: Base64\u89e3\u7801\u65f6\u51fa\u73b0\u9519\u8bef", (Throwable)ex1);
                throw new CSSException("-10701007", CLASS_NAME + "." + "requestSign(RequestSet reqSet)", "Base64\u89e3\u7801\u65f6\u51fa\u73b0\u9519\u8bef", ex1.toString());
            }
            finally {
                vRespSet = null;
            }
        } else {
            String errdic = this.errprocess.getErrDesc(errcode, ErrorProcess.vDefServerInfo);
            vRespSet = null;
            if (!errdic.equals("")) {
                throw new CSSException(errcode, CLASS_NAME + "." + "requestSign(RequestSet reqSet)", errdic);
            }
        }
        return vDsData;
    }

    private ResponseSet requestVerifySign(RequestSet reqSet) throws CSSException {
        String METHOD_NAME = "requestVerifySign(RequestSet reqSet)";
        URL vUrl = null;
        String reqXmlStr = null;
        String vResponseXml = null;
        ResponseParser vRespParser = null;
        ResponseSet vRespSet = null;
        vUrl = this.config.getServerUrl();
        switch (this.config.getSendMsgFormat()) {
            case 0: {
                reqXmlStr = reqSet.toXMLString();
                if (this.config.isPrintLog()) {
                    System.out.println("\u5ba2\u6237\u7aef\u53d1\u9001\u9a8c\u7b7e\u8bf7\u6c42");
                    System.out.println("\u7b7e\u540d\u9a8c\u8bc1\u8bf7\u6c42\u62a5\u6587\uff1a");
                    System.out.println(reqXmlStr);
                }
                vResponseXml = RequestClient.sendMessage(vUrl, reqXmlStr, "");
                if (this.config.isPrintLog()) {
                    System.out.println("\u5ba2\u6237\u7aef\u63a5\u6536\u5230\u670d\u52a1\u5668\u8fd4\u56de\u9a8c\u7b7e\u5e94\u7b54");
                    System.out.println("\u7b7e\u540d\u9a8c\u8bc1\u5e94\u7b54\u62a5\u6587\uff1a");
                    System.out.println(vResponseXml);
                }
                if (vResponseXml == null || vResponseXml.length() == 0) {
                    throw new CSSException("-10701006", CLASS_NAME + "." + "requestVerifySign(RequestSet reqSet)", "\u8fd4\u56de\u62a5\u6587\u4e3a\u7a7a");
                }
                vRespParser = new ResponseParser();
                vRespSet = vRespParser.parserXML(vResponseXml);
                break;
            }
            case 1: {
                if (this.config.isPrintLog()) {
                    System.out.print("\u7b7e\u540d\u9a8c\u8bc1\u8bf7\u6c42\u62a5\u6587\uff1a");
                    System.out.println(reqSet.toXMLString());
                }
                vRespSet = (ResponseSet)RequestClient.sendByObj(vUrl, reqSet);
                if (!this.config.isPrintLog()) break;
                System.out.print("\u7b7e\u540d\u9a8c\u8bc1\u5e94\u7b54\u62a5\u6587\uff1a");
                System.out.println(vRespSet.toXMLString());
                break;
            }
        }
        reqXmlStr = null;
        vRespParser = null;
        vResponseXml = null;
        return vRespSet;
    }

    public byte[] doSign(InputStream _in, boolean _isContainCert, boolean isSubsequentVerify, String _hashAlg, String _applyID) throws CSSException {
        String METHOD_NAME = "doSign(InputStream _in, boolean _isContainCert,String _hashAlg,String _applyID)";
        if (_in == null) {
            throw new CSSException("-10701001", CLASS_NAME + "." + "doSign(InputStream _in, boolean _isContainCert,String _hashAlg,String _applyID)", "\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u539f\u6587\u8f93\u5165\u4e3a\u7a7a\uff01");
        }
        byte[] vDigestData = null;
        String vStrSrcData = null;
        RequestSet vReqset = null;
        int vContentTypeID = 0;
        byte[] vDsData = null;
        vDigestData = this.doLocalDigest(_in, _hashAlg);
        vContentTypeID = _isContainCert ? 1 : 0;
        if (isSubsequentVerify) {
            vContentTypeID = 4;
        }
        if (vDigestData == null || vDigestData.length == 0) {
            throw new CSSException("-10703004", CLASS_NAME + "." + "doSign(InputStream _in, boolean _isContainCert,String _hashAlg,String _applyID)", "\u539f\u6587\u4e0d\u5408\u6cd5\uff0c\u672a\u83b7\u5f97\u6458\u8981\u4fe1\u606f\uff01");
        }
        vStrSrcData = new String(Base64.encode(vDigestData));
        vReqset = new RequestSet();
        vReqset.setReqDSBaseKeys(UtilTool.convertStrArrayToList(UtilTool.splitStr(this.config.getBaseInfo(), ";")));
        vReqset.setReqCertBaseKeys(UtilTool.convertStrArrayToList(UtilTool.splitStr(this.config.getCertBaseInfo(), ";")));
        vReqset.setReqCertExtKeys(UtilTool.convertStrArrayToList(UtilTool.splitStr(this.config.getCertExtendInfo(), ";")));
        vReqset.setReqTsaCertBaseKeys(UtilTool.convertStrArrayToList(UtilTool.splitStr(this.config.getTsaCertBaseInfo(), ";")));
        vReqset.setSid(1);
        vReqset.setPlainData(vStrSrcData);
        vReqset.setPlainDataType(1);
        vReqset.setDigestAlg(_hashAlg);
        vReqset.setDSignMode(vContentTypeID);
        if (_hashAlg != null && _hashAlg.trim().length() > 0) {
            vReqset.setDigestAlg(_hashAlg);
        }
        vReqset.setApplyID(_applyID);
        vDsData = this.requestSign(vReqset);
        return vDsData;
    }

    public byte[] doLocalDigest(InputStream _in, String _hashAlgID) throws CSSException {
        String METHOD_NAME = "doLocalDigest(InputStream _in, String _hashAlgID)";
        if (_in == null) {
            throw new CSSException("-10703001", CLASS_NAME + "." + "doLocalDigest(InputStream _in, String _hashAlgID)", "\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u8981\u505a\u6458\u8981\u7684\u539f\u6587\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        byte[] vDigestData = null;
        try {
            vDigestData = SecurityUtil.doDigest(_in, _hashAlgID);
        }
        catch (IOException ex) {
            throw new CSSException("-10703002", CLASS_NAME + "." + "doLocalDigest(InputStream _in, String _hashAlgID)", ex.getMessage());
        }
        catch (NoSuchAlgorithmException ex) {
            throw new CSSException("-10703004", CLASS_NAME + "." + "doLocalDigest(InputStream _in, String _hashAlgID)", "\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u4e0d\u652f\u6301\u6b64\u79cd\u6458\u8981\u7b97\u6cd5");
        }
        return vDigestData;
    }

    public byte[] doLocalDigest(byte[] _srcData, String _hashAlgID) throws CSSException {
        String METHOD_NAME = "doLocalDigest(byte[] _srcData, String _hashAlgID)";
        if (_srcData == null) {
            throw new CSSException("-10703001", CLASS_NAME + "." + "doLocalDigest(byte[] _srcData, String _hashAlgID)", "\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u8981\u505a\u6458\u8981\u7684\u539f\u6587\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        byte[] vDigestData = null;
        try {
            vDigestData = SecurityUtil.doDigest(_srcData, _hashAlgID);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new CSSException("-10703004", CLASS_NAME + "." + "doLocalDigest(byte[] _srcData, String _hashAlgID)", "\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u4e0d\u652f\u6301\u6b64\u79cd\u6458\u8981\u7b97\u6cd5");
        }
        return vDigestData;
    }

    public byte[] doQuickSign(byte[] _srcData, boolean _isContainCert, boolean isSubsequentVerify, String _hashAlg, String _applyID) throws CSSException {
        String METHOD_NAME = "doQuickSign(byte[] _srcData, boolean _isContainCert,String _hashAlg, String _applyID)";
        if (CommUtil.isNull(_srcData)) {
            throw new CSSException("-10701001", CLASS_NAME + "." + "doQuickSign(byte[] _srcData, boolean _isContainCert,String _hashAlg, String _applyID)", "\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u539f\u6587\u8f93\u5165\u4e3a\u7a7a\uff01");
        }
        byte[] vDigestData = null;
        String vStrSrcData = null;
        RequestSet vReqSet = null;
        int vContentTypeID = 0;
        byte[] vDsData = null;
        vDigestData = this.doLocalDigest(_srcData, _hashAlg);
        if (_isContainCert) {
            vContentTypeID = 1;
        }
        if (isSubsequentVerify) {
            vContentTypeID = 4;
        }
        vStrSrcData = new String(Base64.encode(vDigestData));
        vReqSet = new RequestSet();
        vReqSet.setSid(1);
        vReqSet.setPlainData(vStrSrcData);
        vReqSet.setPlainDataType(1);
        vReqSet.setDSignMode(vContentTypeID);
        if (_hashAlg != null && _hashAlg.trim().length() > 0) {
            vReqSet.setDigestAlg(_hashAlg);
        }
        vReqSet.setApplyID(_applyID);
        vDsData = this.requestSign(vReqSet);
        return vDsData;
    }

    public ResultSet verifySign(byte[] _srcData, byte[] _signedData, String _baseDsRtnKeyList, String _certBaseItemList, String _certExtItemList, String _tsaCertBaseItemList) throws CSSException {
        String METHOD_NAME = "verifySign(byte[] _srcData, byte[] _signedData,String _baseDsRtnKeyList, String _certBaseItemList,String _certExtItemList)";
        RequestSet vReqSet = null;
        String vStrSrcData = null;
        String vStrSignedData = null;
        Object vXmlStr = null;
        ResponseSet vRespSet = null;
        if (_signedData == null) {
            throw new CSSException("-10701102", CLASS_NAME + "." + "verifySign(byte[] _srcData, byte[] _signedData,String _baseDsRtnKeyList, String _certBaseItemList,String _certExtItemList)", "\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u9a8c\u8bc1\u7b7e\u540d\u65f6\u7b7e\u540d\u7ed3\u679c\u8f93\u5165\u4e3a\u7a7a\uff01");
        }
        vReqSet = new RequestSet();
        if (_srcData != null) {
            vStrSrcData = new String(Base64.encode(_srcData));
            vReqSet.setPlainData(vStrSrcData);
        }
        vReqSet.setReqDSBaseKeys(UtilTool.convertStrArrayToList(UtilTool.splitStr(_baseDsRtnKeyList, ";")));
        vReqSet.setReqCertBaseKeys(UtilTool.convertStrArrayToList(UtilTool.splitStr(_certBaseItemList, ";")));
        vReqSet.setReqCertExtKeys(UtilTool.convertStrArrayToList(UtilTool.splitStr(_certExtItemList, ";")));
        vReqSet.setReqTsaCertBaseKeys(UtilTool.convertStrArrayToList(UtilTool.splitStr(_tsaCertBaseItemList, ";")));
        vStrSignedData = new String(Base64.encode(_signedData));
        vReqSet.setSid(2);
        if (this.isP1) {
            vReqSet.setDigestAlg(this.digestAlg);
            vReqSet.setEncryptAlg(this.encryptAlg);
            vReqSet.setIssuerAndSn(this.issuerAndSn);
            vReqSet.setVerifyMode(3);
        }
        if (this.isXML) {
            vReqSet.setVerifyMode(4);
        }
        vReqSet.setSignedData(vStrSignedData);
        vRespSet = this.requestVerifySign(vReqSet);
        return new ResultSet(vRespSet);
    }

    public ResultSet verify4Subsequent(byte[] _srcData, byte[] _signedData, String _baseDsRtnKeyList, String _certBaseItemList, String _certExtItemList, String _tsaCertBaseItemList) throws CSSException {
        String METHOD_NAME = "verifySign(byte[] _srcData, byte[] _signedData,String _baseDsRtnKeyList, String _certBaseItemList,String _certExtItemList)";
        RequestSet vReqSet = null;
        String vStrSrcData = null;
        String vStrSignedData = null;
        Object vXmlStr = null;
        ResponseSet vRespSet = null;
        if (_signedData == null) {
            throw new CSSException("-10701102", CLASS_NAME + "." + "verifySign(byte[] _srcData, byte[] _signedData,String _baseDsRtnKeyList, String _certBaseItemList,String _certExtItemList)", "\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u9a8c\u8bc1\u7b7e\u540d\u65f6\u7b7e\u540d\u7ed3\u679c\u8f93\u5165\u4e3a\u7a7a\uff01");
        }
        vReqSet = new RequestSet();
        if (_srcData != null) {
            vStrSrcData = new String(Base64.encode(_srcData));
            vReqSet.setPlainData(vStrSrcData);
        }
        vReqSet.setReqDSBaseKeys(UtilTool.convertStrArrayToList(UtilTool.splitStr(_baseDsRtnKeyList, ";")));
        vReqSet.setReqCertBaseKeys(UtilTool.convertStrArrayToList(UtilTool.splitStr(_certBaseItemList, ";")));
        vReqSet.setReqCertExtKeys(UtilTool.convertStrArrayToList(UtilTool.splitStr(_certExtItemList, ";")));
        vReqSet.setReqTsaCertBaseKeys(UtilTool.convertStrArrayToList(UtilTool.splitStr(_tsaCertBaseItemList, ";")));
        vStrSignedData = new String(Base64.encode(_signedData));
        vReqSet.setSid(2);
        vReqSet.setVerifyMode(10);
        vReqSet.setSignedData(vStrSignedData);
        vRespSet = this.requestVerifySign(vReqSet);
        return new ResultSet(vRespSet);
    }

    public ResultSet verifyQuickSign(byte[] _srcData, byte[] _signedData, String _baseDsRtnKeyList, String _certBaseItemList, String _certExtItemList) throws CSSException {
        String METHOD_NAME = "verifySign(byte[] _srcData, byte[] _signedData,String _baseDsRtnKeyList, String _certBaseItemList,String _certExtItemList)";
        RequestSet vReqSet = null;
        String vStrSignedData = null;
        byte[] vLocalDigestData = null;
        byte[] vServerDigestData = null;
        Object vXmlStr = null;
        boolean vCompHashResult = false;
        boolean vServerRtnResult = false;
        ResponseSet vRespSet = null;
        ResultSet vResultSet = null;
        String vHashAlg = null;
        if (_signedData == null || _signedData.length == 0) {
            throw new CSSException("-10701102", CLASS_NAME + "." + "verifySign(byte[] _srcData, byte[] _signedData,String _baseDsRtnKeyList, String _certBaseItemList,String _certExtItemList)", "\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u9a8c\u8bc1\u7b7e\u540d\u65f6\u7b7e\u540d\u7ed3\u679c\u8f93\u5165\u4e3a\u7a7a\uff01");
        }
        vReqSet = new RequestSet();
        if (_srcData == null) {
            throw new CSSException("-10701101", CLASS_NAME + "." + "verifySign(byte[] _srcData, byte[] _signedData,String _baseDsRtnKeyList, String _certBaseItemList,String _certExtItemList)", "\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u9a8c\u8bc1\u7b7e\u540d\u65f6\u7b7e\u540d\u539f\u6587\u8f93\u5165\u4e3a\u7a7a\uff01");
        }
        if (_baseDsRtnKeyList == null || _baseDsRtnKeyList.length() == 0) {
            _baseDsRtnKeyList = "digestalg";
        }
        _baseDsRtnKeyList = _baseDsRtnKeyList.toLowerCase();
        ArrayList al = null;
        al = UtilTool.convertStrArrayToList(UtilTool.splitStr(_baseDsRtnKeyList, ";"));
        if (!al.contains("digestalg")) {
            al.add("digestalg");
        }
        if (!al.contains("digestdata")) {
            al.contains("digestdata");
        }
        vReqSet.setReqDSBaseKeys(al);
        vReqSet.setReqCertBaseKeys(UtilTool.convertStrArrayToList(UtilTool.splitStr(_certBaseItemList, ";")));
        vReqSet.setReqCertExtKeys(UtilTool.convertStrArrayToList(UtilTool.splitStr(_certExtItemList, ";")));
        vStrSignedData = new String(Base64.encode(_signedData));
        vReqSet.setSid(2);
        vReqSet.setSignedData(vStrSignedData);
        vReqSet.setVerifyMode(2);
        vRespSet = this.requestVerifySign(vReqSet);
        vHashAlg = vRespSet.getDigestAlg();
        vResultSet = new ResultSet(vRespSet);
        vServerRtnResult = vRespSet.isSucceed();
        if (!vServerRtnResult) {
            return vResultSet;
        }
        if (vHashAlg != null && vHashAlg.length() > 0 && vRespSet.getDigestData() != null && vRespSet.getDigestData().length() > 0) {
            vLocalDigestData = this.doLocalDigest(_srcData, vHashAlg);
            System.out.println("localHash:" + new String(Base64.encode(vLocalDigestData)));
            try {
                vServerDigestData = Base64.decode(vRespSet.getDigestData());
            }
            catch (Exception ex) {
                LOGGER.error((Object)ex.getMessage(), (Throwable)ex);
            }
            vCompHashResult = Arrays.equals(vLocalDigestData, vServerDigestData);
        }
        if (!vCompHashResult) {
            vResultSet.setSucceed(false);
            vResultSet.setErrcode(ErrorProcess.vVerifyFailErrNo);
        }
        return vResultSet;
    }

    public ResultSet verifySign(InputStream _in, byte[] _signedData, String _baseDsRtnKeyList, String _certBaseItemList, String _certExtItemList, String _tsaCertBaseItemList) throws CSSException {
        String METHOD_NAME = "verifySign(InputStream _in, byte[] _signedData,String _baseDsRtnKeyList, String _certBaseItemList,String _certExtItemList)";
        RequestSet vReqSet = null;
        String vStrSignedData = null;
        byte[] vLocalDigestData = null;
        byte[] vServerDigestData = null;
        Object vXmlStr = null;
        boolean vCompHashResult = false;
        ResponseSet vRespSet = null;
        ResultSet vResultSet = null;
        String vHashAlg = null;
        if (_signedData == null || _signedData.length == 0) {
            throw new CSSException("-10701102", CLASS_NAME + "." + "verifySign(InputStream _in, byte[] _signedData,String _baseDsRtnKeyList, String _certBaseItemList,String _certExtItemList)", "\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u9a8c\u8bc1\u7b7e\u540d\u65f6\u7b7e\u540d\u7ed3\u679c\u8f93\u5165\u4e3a\u7a7a\uff01");
        }
        vReqSet = new RequestSet();
        if (_in == null) {
            throw new CSSException("-10701101", CLASS_NAME + "." + "verifySign(InputStream _in, byte[] _signedData,String _baseDsRtnKeyList, String _certBaseItemList,String _certExtItemList)", "\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u9a8c\u8bc1\u7b7e\u540d\u65f6\u7b7e\u540d\u539f\u6587\u8f93\u5165\u4e3a\u7a7a\uff01");
        }
        if (_baseDsRtnKeyList == null || _baseDsRtnKeyList.length() == 0) {
            _baseDsRtnKeyList = "digestalg;digestdata";
        }
        _baseDsRtnKeyList = _baseDsRtnKeyList.toLowerCase();
        ArrayList al = null;
        al = UtilTool.convertStrArrayToList(UtilTool.splitStr(_baseDsRtnKeyList, ";"));
        if (!al.contains("digestalg")) {
            al.add("digestalg");
        }
        if (!al.contains("digestdata")) {
            al.contains("digestdata");
        }
        vReqSet.setReqDSBaseKeys(al);
        vReqSet.setReqCertBaseKeys(UtilTool.convertStrArrayToList(UtilTool.splitStr(_certBaseItemList, ";")));
        vReqSet.setReqCertExtKeys(UtilTool.convertStrArrayToList(UtilTool.splitStr(_certExtItemList, ";")));
        vReqSet.setReqTsaCertBaseKeys(UtilTool.convertStrArrayToList(UtilTool.splitStr(_tsaCertBaseItemList, ";")));
        vStrSignedData = new String(Base64.encode(_signedData));
        vReqSet.setSid(2);
        vReqSet.setSignedData(vStrSignedData);
        vReqSet.setVerifyMode(2);
        vRespSet = this.requestVerifySign(vReqSet);
        vResultSet = new ResultSet(vRespSet);
        if (!vRespSet.isSucceed()) {
            return vResultSet;
        }
        vHashAlg = vRespSet.getDigestAlg();
        if (vHashAlg != null && vHashAlg.length() > 0 && vRespSet.getDigestData() != null && vRespSet.getDigestData().length() > 0) {
            vLocalDigestData = this.doLocalDigest(_in, vHashAlg);
            try {
                vServerDigestData = Base64.decode(vRespSet.getDigestData());
            }
            catch (Exception ex) {
                LOGGER.error((Object)ex.getMessage(), (Throwable)ex);
            }
            vCompHashResult = Arrays.equals(vLocalDigestData, vServerDigestData);
        }
        if (vCompHashResult) {
            return vResultSet;
        }
        if (!vCompHashResult) {
            vResultSet.setSucceed(false);
            vResultSet.setErrcode(ErrorProcess.vVerifyFailErrNo);
        }
        return vResultSet;
    }

    public boolean verifySign(byte[] _srcData, byte[] _signedData) throws CSSException {
        String METHOD_NAME = "verifySign(byte[] _srcData, byte[] _signedData)";
        RequestSet vReqSet = null;
        String vStrSrcData = null;
        String vStrSignedData = null;
        Object vXmlStr = null;
        ResponseSet vRespSet = null;
        if (_signedData == null || _signedData.length == 0) {
            throw new CSSException("-10701102", CLASS_NAME + "." + "verifySign(byte[] _srcData, byte[] _signedData)", "\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u9a8c\u8bc1\u7b7e\u540d\u65f6\u7b7e\u540d\u7ed3\u679c\u8f93\u5165\u4e3a\u7a7a\uff01");
        }
        vReqSet = new RequestSet();
        if (_srcData != null || _srcData.length > 0) {
            vStrSrcData = new String(Base64.encode(_srcData));
            vReqSet.setPlainData(vStrSrcData);
        }
        vStrSignedData = new String(Base64.encode(_signedData));
        vReqSet.setSid(2);
        vReqSet.setSignedData(vStrSignedData);
        vRespSet = this.requestVerifySign(vReqSet);
        boolean result = vRespSet.isSucceed();
        if (result) {
            return true;
        }
        throw new CSSException(vRespSet.getErrCode(), CLASS_NAME + "." + "verifySign(byte[] _srcData, byte[] _signedData)", this.errprocess.getErrDesc(vRespSet.getErrCode(), ErrorProcess.vDefServerInfo));
    }

    private boolean verifySign(InputStream _in, byte[] _signedData, String _hashAlg) throws CSSException {
        String METHOD_NAME = "(InputStream _in, byte[] _signedData,String _hashAlg)";
        RequestSet vReqSet = null;
        String vStrSrcData = null;
        String vStrSignedData = null;
        byte[] vDigestData = null;
        Object vXmlStr = null;
        ResponseSet vRespSet = null;
        if (_signedData == null || _signedData.length == 0) {
            throw new CSSException("-10701102", CLASS_NAME + "." + "(InputStream _in, byte[] _signedData,String _hashAlg)", "\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u9a8c\u8bc1\u7b7e\u540d\u65f6\u7b7e\u540d\u7ed3\u679c\u8f93\u5165\u4e3a\u7a7a\uff01");
        }
        vReqSet = new RequestSet();
        if (_in == null) {
            throw new CSSException("-10701101", CLASS_NAME + "." + "(InputStream _in, byte[] _signedData,String _hashAlg)", "\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u9a8c\u8bc1\u7b7e\u540d\u65f6\u7b7e\u540d\u539f\u6587\u8f93\u5165\u4e3a\u7a7a\uff01");
        }
        if (_hashAlg == null || _hashAlg.trim().length() == 0) {
            return this.verifySign(_in, _signedData);
        }
        vDigestData = this.doLocalDigest(_in, _hashAlg);
        vStrSrcData = new String(Base64.encode(vDigestData));
        vReqSet.setPlainData(vStrSrcData);
        vStrSignedData = new String(Base64.encode(_signedData));
        vReqSet.setSid(2);
        vReqSet.setVerifyMode(1);
        vReqSet.setSignedData(vStrSignedData);
        vRespSet = this.requestVerifySign(vReqSet);
        boolean result = vRespSet.isSucceed();
        if (result) {
            return true;
        }
        throw new CSSException(vRespSet.getErrCode(), CLASS_NAME + "." + "(InputStream _in, byte[] _signedData,String _hashAlg)", this.errprocess.getErrDesc(vRespSet.getErrCode(), ErrorProcess.vDefServerInfo));
    }

    public boolean verifySign(byte[] filecontent, String filename, byte[] signedData) throws CSSException {
        if (filecontent == null || filecontent.length == 0) {
            throw new CSSException("-10700001", "cn.com.jit.assp.css.client.DSignClient.doFileSign", "\u53c2\u6570\u4e0d\u5408\u6cd5\uff01");
        }
        StringBuffer srcbuffer = new StringBuffer();
        srcbuffer.append("<?xml version=\"1.0\" encoding=\"GB2312\" standalone=\"no\"?>\r\n");
        srcbuffer.append("<DSign>");
        srcbuffer.append("\r\n").append("\t").append("<File>");
        srcbuffer.append("\r\n").append("\t\t").append("<name>");
        srcbuffer.append(new String(Base64.encode(filename.getBytes())));
        srcbuffer.append("</name>");
        srcbuffer.append("\r\n").append("\t\t").append("<content>");
        srcbuffer.append(UtilTool.processBase64Code(new String(Base64.encode(filecontent))));
        srcbuffer.append("</content>");
        srcbuffer.append("\r\n").append("\t").append("</File>");
        srcbuffer.append("\r\n").append("</DSign>");
        if (this.config.isPrintLog()) {
            System.out.print("\u591a\u6587\u4ef6\u7b7e\u540d\u539f\u6587\u7ec4\u7ec7\u683c\u5f0f:");
            System.out.println(srcbuffer.toString());
        }
        byte[] srcbyte = srcbuffer.toString().getBytes();
        return this.verifyQuickSign(srcbyte, signedData);
    }

    private boolean verifySign(InputStream _in, byte[] _signedData) throws CSSException {
        String METHOD_NAME = "verifySign(InputStream _in, byte[] _signedData)";
        RequestSet vReqSet = null;
        String vStrSignedData = null;
        byte[] vLocalDigestData = null;
        byte[] vServerDigestData = null;
        Object vXmlStr = null;
        boolean vCompHashResult = false;
        boolean vServerRtnResult = false;
        ResponseSet vRespSet = null;
        String vHashAlg = null;
        if (_signedData == null || _signedData.length == 0) {
            throw new CSSException("-10701102", CLASS_NAME + "." + "verifySign(InputStream _in, byte[] _signedData)", "\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u9a8c\u8bc1\u7b7e\u540d\u65f6\u7b7e\u540d\u7ed3\u679c\u8f93\u5165\u4e3a\u7a7a\uff01");
        }
        vReqSet = new RequestSet();
        if (_in == null) {
            throw new CSSException("-10701101", CLASS_NAME + "." + "verifySign(InputStream _in, byte[] _signedData)", "\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u9a8c\u8bc1\u7b7e\u540d\u65f6\u7b7e\u540d\u539f\u6587\u8f93\u5165\u4e3a\u7a7a\uff01");
        }
        vReqSet.setReqDSBaseKeys(UtilTool.convertStrArrayToList(UtilTool.splitStr("digestalg;digestdata", ";")));
        vStrSignedData = new String(Base64.encode(_signedData));
        vReqSet.setSid(2);
        vReqSet.setSignedData(vStrSignedData);
        vReqSet.setVerifyMode(2);
        vRespSet = this.requestVerifySign(vReqSet);
        if (!vRespSet.isSucceed()) {
            throw new CSSException(vRespSet.getErrCode(), "cn.com.jit.assp.client.DSignClient.verifySign()", this.errprocess.getErrDesc(vRespSet.getErrCode(), ErrorProcess.vDefServerInfo));
        }
        vHashAlg = vRespSet.getDigestAlg();
        if (vHashAlg != null && vHashAlg.length() > 0 && vRespSet.getDigestData() != null && vRespSet.getDigestData().length() > 0) {
            vLocalDigestData = this.doLocalDigest(_in, vHashAlg);
            try {
                vServerDigestData = Base64.decode(UtilTool.convertBase64(vRespSet.getDigestData().getBytes()));
            }
            catch (Exception ex) {
                LOGGER.error((Object)ex.getMessage(), (Throwable)ex);
            }
            vCompHashResult = Arrays.equals(vLocalDigestData, vServerDigestData);
        }
        if (vCompHashResult) {
            return true;
        }
        throw new CSSException(ErrorProcess.vVerifyFailErrNo, CLASS_NAME + "." + "verifySign(InputStream _in, byte[] _signedData)", this.errprocess.getErrDesc(ErrorProcess.vVerifyFailErrNo, ErrorProcess.vDefServerInfo));
    }

    private boolean verifyQuickSign(byte[] _srcData, byte[] _signedData) throws CSSException {
        String METHOD_NAME = "verifySign(InputStream _in, byte[] _signedData)";
        RequestSet vReqSet = null;
        String vStrSignedData = null;
        byte[] vLocalDigestData = null;
        byte[] vServerDigestData = null;
        Object vXmlStr = null;
        boolean vCompHashResult = false;
        boolean vServerRtnResult = false;
        ResponseSet vRespSet = null;
        String vHashAlg = null;
        if (_signedData == null || _signedData.length == 0) {
            throw new CSSException("-10701102", CLASS_NAME + "." + "verifySign(InputStream _in, byte[] _signedData)", "\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u9a8c\u8bc1\u7b7e\u540d\u65f6\u7b7e\u540d\u7ed3\u679c\u8f93\u5165\u4e3a\u7a7a\uff01");
        }
        vReqSet = new RequestSet();
        if (_srcData == null || _srcData.length == 0) {
            throw new CSSException("-10701101", CLASS_NAME + "." + "verifySign(InputStream _in, byte[] _signedData)", "\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u9a8c\u8bc1\u7b7e\u540d\u65f6\u7b7e\u540d\u539f\u6587\u8f93\u5165\u4e3a\u7a7a\uff01");
        }
        vReqSet.setReqDSBaseKeys(UtilTool.convertStrArrayToList(UtilTool.splitStr("digestalg;digestdata", ";")));
        vStrSignedData = new String(Base64.encode(_signedData));
        vReqSet.setSid(2);
        vReqSet.setSignedData(vStrSignedData);
        vReqSet.setVerifyMode(2);
        vRespSet = this.requestVerifySign(vReqSet);
        if (!vRespSet.isSucceed()) {
            throw new CSSException(vRespSet.getErrCode(), CLASS_NAME + "." + "verifySign(InputStream _in, byte[] _signedData)", this.errprocess.getErrDesc(vRespSet.getErrCode(), ErrorProcess.vDefServerInfo));
        }
        vHashAlg = vRespSet.getDigestAlg();
        if (vHashAlg != null && vHashAlg.length() > 0 && vRespSet.getDigestData() != null && vRespSet.getDigestData().length() > 0) {
            vLocalDigestData = this.doLocalDigest(_srcData, vHashAlg);
            try {
                vServerDigestData = Base64.decode(vRespSet.getDigestData());
            }
            catch (Exception ex) {
                LOGGER.error((Object)ex.getMessage(), (Throwable)ex);
            }
            vCompHashResult = Arrays.equals(vLocalDigestData, vServerDigestData);
        }
        if (vCompHashResult) {
            return true;
        }
        throw new CSSException(ErrorProcess.vVerifyFailErrNo, CLASS_NAME + "." + "verifySign(InputStream _in, byte[] _signedData)", this.errprocess.getErrDesc(ErrorProcess.vVerifyFailErrNo, ErrorProcess.vDefServerInfo));
    }

    public String makeSignedEnvelop(String applyID, String[] certAlias, byte[] plainData, String encAlg, String digestALG) throws CSSException {
        String METHOD_NAME = "verifySign(InputStream _in, byte[] _signedData)";
        String[] t_certAlias = certAlias;
        if (CommUtil.isNull(plainData)) {
            throw new CSSException("-10703101", CLASS_NAME + "." + "verifySign(InputStream _in, byte[] _signedData)", "\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u539f\u6587\u8f93\u5165\u4e3a\u7a7a\uff01");
        }
        if (t_certAlias == null || t_certAlias.length <= 0) {
            String cas = this.config.getCertAlias();
            if (cas == null || cas.length() <= 0) {
                throw new CSSException("-10703102", CLASS_NAME + "." + "verifySign(InputStream _in, byte[] _signedData)", "\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u8bc1\u4e66\u522b\u540d\u8f93\u5165\u4e3a\u7a7a\uff01");
            }
            t_certAlias = cas.split(";");
        }
        String vplainData = null;
        EnvelopRequestSet vReqset = null;
        String vDsData = null;
        vplainData = new String(Base64.encode(plainData));
        vReqset = new EnvelopRequestSet();
        vReqset.setSid(1);
        vReqset.setPlainData(vplainData);
        vReqset.setCertAlias(t_certAlias);
        vReqset.setEncAlg(encAlg);
        vReqset.setApplyID(applyID);
        vDsData = this.requestEnvelop(vReqset);
        vReqset = null;
        return vDsData;
    }

    public ResultSet unSignedEnvelop(byte[] signedEnvelopData) throws CSSException {
        String METHOD_NAME = "verifySign(InputStream _in, byte[] _signedData)";
        if (signedEnvelopData == null || signedEnvelopData.length == 0) {
            throw new CSSException("-10704201", CLASS_NAME + "." + "verifySign(InputStream _in, byte[] _signedData)", "\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u7b7e\u540d\u7ed3\u679c\u7684Base64\u7f16\u7801\u4e3a\u7a7a\uff01");
        }
        EnvelopRequestSet envelopRequestSet = null;
        envelopRequestSet = new EnvelopRequestSet();
        envelopRequestSet.setSid(2);
        envelopRequestSet.setSignedEnvelopData(new String(signedEnvelopData));
        EnvelopResponseSet envelopResponseSet = null;
        ResultSet rs = null;
        ResponseSet responseSet = null;
        String serverResposeXml = null;
        try {
            serverResposeXml = this.requestEnvelop(envelopRequestSet);
            if (serverResposeXml != null && serverResposeXml.length() > 0) {
                System.out.println("********************************************************");
                System.out.println(serverResposeXml);
                EnvelopSimpResponseParser esrp = new EnvelopSimpResponseParser();
                envelopResponseSet = esrp.parserXML(serverResposeXml);
                responseSet = new ResponseSet();
                responseSet.setSucceed(envelopResponseSet.isSucceed());
                responseSet.setErrCode(envelopResponseSet.getErrCode());
                responseSet.setDsCertInfo(envelopResponseSet.getCertInfo());
                responseSet.setPlainData(envelopResponseSet.getPlainData());
                responseSet.setFileName(envelopResponseSet.getFileName());
                rs = new ResultSet(responseSet);
            }
        }
        catch (CSSException e) {
            // empty catch block
        }
        return rs;
    }

    public String makeEnvelop(String[] certAlias, byte[] plainData, String encAlg) throws CSSException {
        String METHOD_NAME = "verifySign(InputStream _in, byte[] _signedData)";
        String[] t_certAlias = certAlias;
        if (CommUtil.isNull(plainData)) {
            throw new CSSException("-10703101", CLASS_NAME + "." + "verifySign(InputStream _in, byte[] _signedData)", "\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u539f\u6587\u8f93\u5165\u4e3a\u7a7a\uff01");
        }
        if (t_certAlias == null || t_certAlias.length <= 0) {
            String cas = this.config.getCertAlias();
            if (CommUtil.isNull(cas)) {
                throw new CSSException("-10703102", CLASS_NAME + "." + "verifySign(InputStream _in, byte[] _signedData)", "\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u8bc1\u4e66\u522b\u540d\u8f93\u5165\u4e3a\u7a7a\uff01");
            }
            t_certAlias = cas.split(";");
        }
        String vplainData = null;
        EnvelopRequestSet vReqset = null;
        String vDsData = null;
        vplainData = new String(Base64.encode(plainData));
        vReqset = new EnvelopRequestSet();
        vReqset.setSid(4);
        vReqset.setPlainData(vplainData);
        vReqset.setCertAlias(t_certAlias);
        vReqset.setEncAlg(encAlg);
        vReqset.setPlainDataType(this.config.getEnvelopType());
        vDsData = this.requestEnvelop(vReqset);
        vReqset = null;
        return vDsData;
    }

    public ResultSet unEnvelop(byte[] envelopData) throws CSSException {
        String METHOD_NAME = "unEnvelop(byte[] envelopData)";
        if (envelopData == null || envelopData.length == 0) {
            throw new CSSException("-10704202", CLASS_NAME + "." + "unEnvelop(byte[] envelopData)", "\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u4fe1\u5c01\u7ed3\u679c\u7684Base64\u7f16\u7801\u4e3a\u7a7a\uff01");
        }
        EnvelopRequestSet envelopRequestSet = null;
        envelopRequestSet = new EnvelopRequestSet();
        envelopRequestSet.setSid(5);
        envelopRequestSet.setEnvelopData(new String(envelopData));
        EnvelopResponseSet envelopResponseSet = null;
        ResultSet rs = null;
        ResponseSet responseSet = null;
        String serverResposeXml = null;
        serverResposeXml = this.requestEnvelop(envelopRequestSet);
        if (serverResposeXml != null && serverResposeXml.length() > 0) {
            EnvelopSimpResponseParser esrp = new EnvelopSimpResponseParser();
            envelopResponseSet = esrp.parserXML(serverResposeXml);
            responseSet = new ResponseSet();
            responseSet.setSucceed(envelopResponseSet.isSucceed());
            responseSet.setErrCode(envelopResponseSet.getErrCode());
            responseSet.setDsCertInfo(envelopResponseSet.getCertInfo());
            responseSet.setPlainData(envelopResponseSet.getPlainData());
            responseSet.setFileName(envelopResponseSet.getFileName());
            rs = new ResultSet(responseSet);
        }
        return rs;
    }

    public String digest(String plainText, String digestALG) throws CSSException {
        String METHOD_NAME = "digest(String plainText, String digestALG)";
        String vResponseData = "";
        if (this.validate(plainText)) {
            throw new CSSException("-10706102", CLASS_NAME + "." + "digest(String plainText, String digestALG)", "\u6458\u8981\u539f\u6587\u4e3a\u7a7a");
        }
        if (!this.validate(digestALG) || this.validate(digestALG = this.config.getDigestAlg())) {
            // empty if block
        }
        plainText = new String(Base64.encode(plainText.getBytes()));
        EnvelopRequestSet vReqset = null;
        vReqset = new EnvelopRequestSet();
        vReqset.setSid(3);
        vReqset.setPlainData(plainText);
        vReqset.setDigestALG(digestALG);
        try {
            vResponseData = this.requestEnvelop(vReqset);
            vReqset = null;
        }
        catch (CSSException e) {
            // empty catch block
        }
        return vResponseData;
    }

    public String digest(String plainText, String digestALG, String charSet) throws CSSException {
        String METHOD_NAME = "digest(String plainText, String digestALG, String charSet)";
        String vResponseData = "";
        if (this.validate(plainText)) {
            throw new CSSException("-10706102", CLASS_NAME + "." + "digest(String plainText, String digestALG, String charSet)", "\u6458\u8981\u539f\u6587\u4e3a\u7a7a");
        }
        if (!this.validate(digestALG) || this.validate(digestALG = this.config.getDigestAlg())) {
            // empty if block
        }
        try {
            plainText = new String(Base64.encode(plainText.getBytes(charSet)));
        }
        catch (UnsupportedEncodingException e1) {
            // empty catch block
        }
        EnvelopRequestSet vReqset = null;
        vReqset = new EnvelopRequestSet();
        vReqset.setSid(3);
        vReqset.setPlainData(plainText);
        vReqset.setDigestALG(digestALG);
        try {
            vResponseData = this.requestEnvelop(vReqset);
            vReqset = null;
        }
        catch (CSSException e) {
            // empty catch block
        }
        return vResponseData;
    }

    private String requestEnvelop(EnvelopRequestSet reqSet) throws CSSException {
        URL vUrl = null;
        vUrl = this.config.getServerUrl();
        String reqXmlStr = reqSet.toXMLString();
        if (this.config.isPrintLog()) {
            System.out.print("\u8bf7\u6c42\u62a5\u6587\uff1a");
            System.out.println(reqXmlStr);
        }
        String vResponseXml = RequestClient.sendMessage(vUrl, reqXmlStr, "");
        if (this.config.isPrintLog()) {
            System.out.print("\u8fd4\u56de\u62a5\u6587\uff1a");
            System.out.println(vResponseXml);
        }
        return vResponseXml;
    }

    private boolean validate(String data) {
        return data == null || data.length() < 1 || data.equals("");
    }

    public static void main(String[] args) {
        DSignClient.dsignModeTest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void inputTest() {
        Object out = null;
        Config config = Config.getInstance();
        String a = "1e1519cfb41dbddb";
        String filename = "c:\\a.txt";
        try {
            config.setServerURLStr("http://localhost:8000/csshandler");
            config.setSendMsgFormat(1);
        }
        catch (Exception ex) {
            LOGGER.error((Object)ex.getMessage(), (Throwable)ex);
        }
        DSignClient dsignclient = new DSignClient();
        FileInputStream in = null;
        byte[] dsdata = null;
        Object srcdata = null;
        try {
            in = new FileInputStream(filename);
            dsdata = dsignclient.doSign(in, false, false, "SHA-1", "");
            System.out.println(dsdata.length);
        }
        catch (FileNotFoundException ex1) {
        }
        catch (CSSException ex2) {
        }
        catch (Throwable tr) {
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                    in = null;
                }
                catch (IOException ex3) {}
            }
        }
        try {
            in = new FileInputStream(filename);
            boolean result = dsignclient.verifySign(in, dsdata, "SHA-1");
            System.out.println("result:" + result);
        }
        catch (FileNotFoundException ex1) {
        }
        catch (CSSException ex2) {
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                    in = null;
                }
                catch (IOException ex3) {}
            }
        }
    }

    public static void dsignModeTest() {
        Config config = Config.getInstance();
        String a = "dksfksdfkjkjafkjdsff";
        try {
            config.setServerURLStr("http://192.168.9.222:8000/cssxmlhandler");
            config.setSendMsgFormat(0);
        }
        catch (Exception ex) {
            // empty catch block
        }
        DSignClient dsignclient = new DSignClient();
        Object in = null;
        byte[] srcdata = null;
        try {
            srcdata = DSignClient.getTextFileContext("C:\\test2\\test2\\srctext1k.txt").getBytes();
            byte[] dsdata1 = dsignclient.doSign(srcdata, false, true, false, "SHA-1", "");
            System.out.println(dsdata1.length);
            System.out.println("\u7b7e\u540d\u7ed3\u679c::" + new String(Base64.encode(dsdata1)));
            ResultSet rs1 = dsignclient.verifySign(srcdata, dsdata1, "", "subject", "", "");
        }
        catch (CSSException ex2) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printlog() {
        FileOutputStream os = null;
        PrintWriter pw = null;
        try {
            os = new FileOutputStream("c:\\test.txt");
            pw = new PrintWriter(os);
            pw.flush();
        }
        catch (FileNotFoundException ex) {
        }
        finally {
            if (pw != null) {
                pw.close();
            }
            if (os != null) {
                try {
                    ((OutputStream)os).close();
                }
                catch (IOException ex1) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void testDSignVerify() {
        Config config = Config.getInstance();
        try {
            config.setServerURLStr("http://192.168.9.107:8000/csshandler");
        }
        catch (Exception ex) {
            // empty catch block
        }
        byte[] srcbyte = null;
        byte[] signedbyte = null;
        FileInputStream in = null;
        try {
            in = new FileInputStream("c:\\srcdata.txt");
            srcbyte = new byte[((InputStream)in).available()];
            ((InputStream)in).read(srcbyte);
        }
        catch (FileNotFoundException ex) {
        }
        catch (Exception ioe) {
        }
        finally {
            try {
                ((InputStream)in).close();
                in = null;
            }
            catch (IOException ex1) {}
        }
        byte[] realSignedByte = null;
        try {
            in = new FileInputStream("c:\\tstrdata.txt");
            signedbyte = new byte[((InputStream)in).available()];
            ((InputStream)in).read(signedbyte);
            realSignedByte = Base64.decode(UtilTool.convertBase64(signedbyte));
        }
        catch (FileNotFoundException ex) {
        }
        catch (Exception ioe) {
        }
        finally {
            try {
                ((InputStream)in).close();
                in = null;
            }
            catch (IOException ex1) {}
        }
        DSignClient dc = new DSignClient();
        try {
            boolean result = dc.verifySign(srcbyte, "srcData.txt_50", realSignedByte);
            System.out.println(result);
        }
        catch (CSSException ex2) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getTextFileContext(String filename) {
        String message = "";
        if (filename == null || filename.trim().length() == 0) {
            return "";
        }
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(filename));
        }
        catch (FileNotFoundException ex1) {
            System.out.println("\u672a\u627e\u5230\u6587\u4ef6\uff1a" + filename);
            return null;
        }
        StringBuffer sb = new StringBuffer();
        try {
            while (br.ready()) {
                sb.append(br.readLine());
            }
        }
        catch (IOException ex) {
            System.out.println("\u8bfb\u53d6\u6587\u4ef6" + filename + "\u5f02\u5e38");
            String string = null;
            return string;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ex2) {}
            }
        }
        message = sb.toString();
        return message;
    }

    public String getIssuerAndSn() {
        return this.issuerAndSn;
    }

    public void setIssuerAndSn(String issuerAndSn) {
        this.issuerAndSn = issuerAndSn;
    }

    public String getDigestAlg() {
        return this.digestAlg;
    }

    public void setDigestAlg(String digestAlg) {
        this.digestAlg = digestAlg;
    }

    public String getEncryptAlg() {
        return this.encryptAlg;
    }

    public void setEncryptAlg(String encryptAlg) {
        this.encryptAlg = encryptAlg;
    }

    public boolean isP1() {
        return this.isP1;
    }

    public void setP1(boolean isP1) {
        this.isP1 = isP1;
    }

    public void setXML(boolean isXML) {
        this.isXML = isXML;
    }

    public String genRandom(int length) throws CSSException {
        RequestSet vReqset = null;
        String vDsData = null;
        vReqset = new RequestSet();
        vReqset.setSid(3);
        vReqset.setRandomLength(length);
        vDsData = this.requestGenRandom(vReqset);
        vReqset = null;
        return vDsData;
    }

    private String requestGenRandom(RequestSet reqSet) throws CSSException {
        String METHOD_NAME = "requestGenRandom(RequestSet reqSet)";
        URL vUrl = null;
        ResponseParser vRespParser = null;
        ResponseSet vRespSet = null;
        String vDsData = null;
        vUrl = this.config.getServerUrl();
        switch (this.config.getSendMsgFormat()) {
            case 0: {
                String reqXmlStr = reqSet.toXMLString();
                if (this.config.isPrintLog()) {
                    System.out.println("\u5ba2\u6237\u7aef\u53d1\u9001\u7b7e\u540d\u8bf7\u6c42");
                    System.out.println("\u7b7e\u540d\u8bf7\u6c42\u62a5\u6587\uff1a");
                    System.out.println(reqXmlStr);
                }
                String vResponseXml = RequestClient.sendMessage(vUrl, reqXmlStr, "");
                if (this.config.isPrintLog()) {
                    System.out.println("\u5ba2\u6237\u7aef\u63a5\u6536\u5230\u670d\u52a1\u5668\u7aef\u8fd4\u56de\u7684\u5e94\u7b54");
                    System.out.println("\u7b7e\u540d\u5e94\u7b54\u62a5\u6587\uff1a");
                    System.out.println(vResponseXml);
                }
                if (vResponseXml == null || vResponseXml.length() == 0) {
                    throw new CSSException("-10701006", CLASS_NAME + "." + "requestGenRandom(RequestSet reqSet)", "\u8fd4\u56de\u62a5\u6587\u4e3a\u7a7a");
                }
                vRespParser = new ResponseParser();
                vRespSet = vRespParser.parserXML(vResponseXml);
                vResponseXml = null;
                break;
            }
            case 1: {
                if (this.config.isPrintLog()) {
                    System.out.print("\u7b7e\u540d\u8bf7\u6c42\u62a5\u6587\uff1a");
                    System.out.println(reqSet.toXMLString());
                }
                try {
                    vRespSet = (ResponseSet)RequestClient.sendByObj(vUrl, reqSet);
                    if (!this.config.isPrintLog()) break;
                    System.out.print("\u7b7e\u540d\u5e94\u7b54\u62a5\u6587\uff1a");
                    System.out.println(vRespSet.toXMLString());
                    break;
                }
                catch (CSSException csse) {
                    throw csse;
                }
                catch (Exception e) {
                    throw new CSSException("-10700000", CLASS_NAME + "." + "requestGenRandom(RequestSet reqSet)", e.getMessage());
                }
            }
        }
        String errcode = vRespSet.getErrCode();
        boolean result = vRespSet.isSucceed();
        if (result) {
            vDsData = vRespSet.getRandomData();
        } else {
            String errdic = this.errprocess.getErrDesc(errcode, ErrorProcess.vDefServerInfo);
            vRespSet = null;
            if (!errdic.equals("")) {
                throw new CSSException(errcode, CLASS_NAME + "." + "requestGenRandom(RequestSet reqSet)", errdic);
            }
        }
        return vDsData;
    }

    public ResultSet getRs() {
        return this.rs;
    }

    public void setRs(ResultSet rs) {
        this.rs = rs;
    }
}

