/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.assp.css.client;

import cn.com.jit.assp.css.client.log.ErrorProcess;

public class CSSException
extends Exception {
    private String code = null;
    private String position = null;
    private String description = null;
    private String stack = null;

    public CSSException() {
    }

    public CSSException(String message) {
        super(message);
    }

    public CSSException(String code, String position) {
        this.code = code;
        this.position = position;
    }

    public CSSException(String code, String position, String desc) {
        this.code = code;
        this.position = position;
        this.description = desc;
    }

    public CSSException(String code, String position, String desc, String ste) {
        this.code = code;
        this.position = position;
        this.description = desc;
        this.stack = ste;
    }

    public CSSException(String message, Throwable tr) {
        super(message, tr);
    }

    public CSSException(String code, String description, Throwable tr) {
        super(description, tr);
        this.code = code;
        this.description = description;
    }

    public String getCode() {
        return this.code;
    }

    public String getPosition() {
        return this.position;
    }

    public String getDescription() {
        if (this.description == null || this.description.trim().length() <= 0) {
            ErrorProcess processor = ErrorProcess.getInstance();
            this.description = processor.getErrDesc(this.code, ErrorProcess.vDefServerInfo);
        }
        return this.description;
    }

    public String getStackTraceElement() {
        return this.stack;
    }

    public String getMessage() {
        return this.toString();
    }

    public String getLocalizedMessage() {
        return super.getLocalizedMessage();
    }

    public String toString() {
        if (!(this.code != null && this.code.trim().length() != 0 || this.position != null && this.position.trim().length() != 0 || this.description != null && this.description.trim().length() != 0)) {
            return super.toString();
        }
        StringBuffer buffer = new StringBuffer();
        if (this.code == null || this.code.trim().length() == 0) {
            buffer.append("XXX#");
        } else {
            buffer.append(this.code);
        }
        if (this.description == null || this.description.trim().length() == 0) {
            buffer.append("XXX#");
        } else {
            buffer.append(this.description);
        }
        if (this.stack != null && this.stack.trim().length() > 0) {
            buffer.append(this.stack);
        }
        return buffer.toString();
    }
}

