/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.assp.client.request;

import cn.com.jit.assp.client.parser.VSignXMLResponseParser;
import cn.com.jit.assp.client.parser.XMLResponseParser;
import cn.com.jit.assp.client.request.AbstractRequestSet;
import cn.com.jit.assp.client.request.TSAVerifyRequestSet;
import cn.com.jit.assp.client.response.VSignResponseItems;
import cn.com.jit.assp.css.client.CSSException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VSignRequestSet
extends AbstractRequestSet {
    private static final Log LOGGER = LogFactory.getLog(TSAVerifyRequestSet.class);
    private InputStream srcIn;
    private InputStream signDataIn;
    private int verifyMode;
    private File sourceFile;
    private VSignResponseItems responseItems;

    public VSignRequestSet(InputStream srcIn, InputStream signDataIn) {
        this.srcIn = srcIn;
        this.signDataIn = signDataIn;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeIn2OutAsXml(OutputStream out) throws CSSException {
        if (this.signDataIn == null) {
            throw new CSSException("-10701106", "\u9a8c\u8bc1\u7b7e\u540d\uff0c\u7b7e\u540d\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        Writer writer = null;
        try {
            try {
                writer = this.getWriterFromOutputStream(out);
                writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\r");
                writer.write("<DSignContext Version =\"1.0\">");
                writer.write("<Request svcid=\"verifyDSign\">");
                if (this.srcIn != null) {
                    writer.write("<PlainData>");
                    writer.flush();
                    this.writeInputStream(this.srcIn, out, true);
                    writer.write("</PlainData>");
                }
                writer.write("<DSignData verifyMode=\"");
                writer.write(String.valueOf(this.verifyMode));
                writer.write("\">");
                writer.flush();
                this.writeInputStream(this.signDataIn, out, false);
                writer.write("</DSignData>");
                writer.write("<RequestRtnContent>");
                if (this.responseItems != null) {
                    int i;
                    String tmpStr = null;
                    String[] returnItems = null;
                    returnItems = this.responseItems.getDsBaseRtnItems();
                    if (returnItems != null && returnItems.length > 0) {
                        writer.write("<DSBaseInfo>");
                        for (i = 0; i < returnItems.length; ++i) {
                            tmpStr = returnItems[i];
                            if (tmpStr != null && !tmpStr.equals("")) {
                                writer.write("<Item name=\"");
                            }
                            writer.write(tmpStr.toLowerCase());
                            writer.write("\"/>");
                        }
                        writer.write("</DSBaseInfo>");
                    }
                    if ((returnItems = this.responseItems.getCertBaseItems()) != null && returnItems.length > 0) {
                        writer.write("<DSCertBaseInfo>");
                        for (i = 0; i < returnItems.length; ++i) {
                            tmpStr = returnItems[i];
                            if (tmpStr != null && !tmpStr.equals("")) {
                                writer.write("<Item name=\"");
                            }
                            writer.write(tmpStr.trim().toLowerCase());
                            writer.write("\"/>");
                        }
                        writer.write("</DSCertBaseInfo>");
                    }
                    if ((returnItems = this.responseItems.getCertExtItems()) != null && returnItems.length > 0) {
                        writer.write("<DSCertExtInfo>");
                        for (i = 0; i < returnItems.length; ++i) {
                            tmpStr = returnItems[i];
                            if (tmpStr != null) {
                                writer.write("<Item name=\"");
                            }
                            writer.write(tmpStr.toLowerCase());
                            writer.write("\"/>");
                        }
                        writer.write("</DSCertExtInfo>");
                    }
                }
                writer.write("</RequestRtnContent>");
                writer.write("</Request>");
                writer.write("</DSignContext>");
                writer.flush();
            }
            catch (IOException e) {
                LOGGER.error((Object)"errorCode: -10701107, errorMessage: \u9a8c\u8bc1\u7b7e\u540d\u65f6\u5411\u670d\u52a1\u5668\u53d1\u9001\u8bf7\u6c42\u62a5\u6587\u65f6\u4ea7\u751f\u5f02\u5e38\uff01", (Throwable)e);
                throw new CSSException("-10701107", "\u9a8c\u8bc1\u7b7e\u540d\u65f6\u5411\u670d\u52a1\u5668\u53d1\u9001\u8bf7\u6c42\u62a5\u6587\u65f6\u4ea7\u751f\u5f02\u5e38\uff01", e);
            }
            Object var7_7 = null;
            if (writer == null) return;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (writer == null) throw throwable;
            try {
                writer.close();
                throw throwable;
            }
            catch (IOException e) {
                LOGGER.error((Object)"errorCode: -10701107, errorMessage: \u9a8c\u8bc1\u7b7e\u540d\u65f6\u5411\u670d\u52a1\u5668\u53d1\u9001\u8bf7\u6c42\u62a5\u6587\u65f6\u4ea7\u751f\u5f02\u5e38\uff01", (Throwable)e);
                throw new CSSException("-10701107", "\u9a8c\u8bc1\u7b7e\u540d\u65f6\u5411\u670d\u52a1\u5668\u53d1\u9001\u8bf7\u6c42\u62a5\u6587\u65f6\u4ea7\u751f\u5f02\u5e38\uff01", e);
            }
        }
        try {}
        catch (IOException e) {
            LOGGER.error((Object)"errorCode: -10701107, errorMessage: \u9a8c\u8bc1\u7b7e\u540d\u65f6\u5411\u670d\u52a1\u5668\u53d1\u9001\u8bf7\u6c42\u62a5\u6587\u65f6\u4ea7\u751f\u5f02\u5e38\uff01", (Throwable)e);
            throw new CSSException("-10701107", "\u9a8c\u8bc1\u7b7e\u540d\u65f6\u5411\u670d\u52a1\u5668\u53d1\u9001\u8bf7\u6c42\u62a5\u6587\u65f6\u4ea7\u751f\u5f02\u5e38\uff01", e);
        }
        writer.close();
    }

    public XMLResponseParser getResponseParser() {
        return new VSignXMLResponseParser();
    }

    public InputStream getSrcIn() {
        return this.srcIn;
    }

    public void setSrcIn(InputStream srcIn) {
        this.srcIn = srcIn;
    }

    public InputStream getSignDataIn() {
        return this.signDataIn;
    }

    public void setSignDataIn(InputStream signDataIn) {
        this.signDataIn = signDataIn;
    }

    public int getVerifyMode() {
        return this.verifyMode;
    }

    public void setVerifyMode(int verifyMode) {
        this.verifyMode = verifyMode;
    }

    public File getSourceFile() {
        return this.sourceFile;
    }

    public void setSourceFile(File sourceFile) throws IOException {
        this.srcIn = new AbstractRequestSet.XMLEncapFileInputStream(sourceFile);
        this.sourceFile = sourceFile;
    }

    public VSignResponseItems getResponseItems() {
        return this.responseItems;
    }

    public void setResponseItems(VSignResponseItems responseItems) {
        this.responseItems = responseItems;
    }
}

