/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.assp.client.request;

import cn.com.jit.assp.client.parser.TSASignXMLResponseParser;
import cn.com.jit.assp.client.parser.XMLResponseParser;
import cn.com.jit.assp.client.request.AbstractRequestSet;
import cn.com.jit.assp.css.client.CSSException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TSASignRequestSet
extends AbstractRequestSet {
    private static final Log LOGGER = LogFactory.getLog(TSASignRequestSet.class);
    private String digestAlg;
    private InputStream source;
    private String tsaType = "";

    public XMLResponseParser getResponseParser() {
        return new TSASignXMLResponseParser();
    }

    public void writeIn2OutAsXml(OutputStream out) throws CSSException {
        Writer writer = null;
        try {
            writer = this.getWriterFromOutputStream(out);
            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>");
            writer.write("<DSignContext Version =\"1.0\">");
            writer.write("<Request svcid=\"doTsa\">");
            writer.write("<PlainData type=\"" + this.tsaType + "\">");
            writer.flush();
            this.writeInputStream(this.source, out, true);
            writer.write("</PlainData>");
            writer.write("<DSDigestALG>");
            writer.write(this.digestAlg);
            writer.write("</DSDigestALG>");
            writer.write("</Request>");
            writer.write("</DSignContext>");
            writer.flush();
        }
        catch (IOException e) {
            LOGGER.error((Object)("errorCode: -10701105, errorMessage: " + e.getMessage()), (Throwable)e);
            throw new CSSException("-10701105", e.getMessage(), e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)("errorCode: -10701105, errorMessage: " + e.getMessage()), (Throwable)e);
                    throw new CSSException("-10701105", e.getMessage(), e);
                }
            }
        }
    }

    public String getDigestAlg() {
        return this.digestAlg;
    }

    public void setDigestAlg(String digestAlg) {
        this.digestAlg = digestAlg;
    }

    public InputStream getSource() {
        return this.source;
    }

    public void setSource(InputStream source) {
        this.source = source;
    }

    public String getTsaType() {
        return this.tsaType;
    }

    public void setTsaType(String tsaType) {
        this.tsaType = tsaType;
    }
}

