/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.assp.client.request;

import cn.com.jit.assp.client.parser.TSAFindXMLResponseParser;
import cn.com.jit.assp.client.parser.XMLResponseParser;
import cn.com.jit.assp.client.request.AbstractRequestSet;
import cn.com.jit.assp.css.client.CSSException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TSAFindRequestSet
extends AbstractRequestSet {
    private static final Log LOGGER = LogFactory.getLog(TSAFindRequestSet.class);
    private String tsaID;

    public XMLResponseParser getResponseParser() {
        return new TSAFindXMLResponseParser();
    }

    public void writeIn2OutAsXml(OutputStream out) throws CSSException {
        Writer writer = null;
        try {
            writer = this.getWriterFromOutputStream(out);
            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>");
            writer.write("<DSignContext Version =\"1.0\">");
            writer.write("<Request svcid=\"getTsa\">");
            writer.write("<Data type=\"sid\">" + this.tsaID + "</Data>");
            writer.write("</Request>");
            writer.write("</DSignContext>");
            writer.flush();
        }
        catch (IOException e) {
            LOGGER.error((Object)("errorCode: -10701105, errorMessage: " + e.getMessage()), (Throwable)e);
            throw new CSSException("-10701105", e.getMessage(), e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)("errorCode: -10701105, errorMessage: " + e.getMessage()), (Throwable)e);
                    throw new CSSException("-10701105", e.getMessage(), e);
                }
            }
        }
    }

    public void setTsaId(String tsaID) {
        this.tsaID = tsaID;
    }

    public String getTsaID() {
        return this.tsaID;
    }

    public void setTsaID(String tsaID) {
        this.tsaID = tsaID;
    }
}

