/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.assp.client.request;

import cn.com.jit.assp.client.parser.SymmEncryptXMLResponseParser;
import cn.com.jit.assp.client.parser.XMLResponseParser;
import cn.com.jit.assp.client.request.AbstractRequestSet;
import cn.com.jit.assp.css.client.CSSException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SymmEncryptRequestSet
extends AbstractRequestSet {
    private static final Log LOGGER = LogFactory.getLog(SymmEncryptRequestSet.class);
    private String symmKeyNo;
    private InputStream plainData;

    public XMLResponseParser getResponseParser() {
        return new SymmEncryptXMLResponseParser();
    }

    public void writeIn2OutAsXml(OutputStream out) throws CSSException {
        Writer writer = null;
        try {
            writer = this.getWriterFromOutputStream(out);
            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\r");
            writer.write("<DSignContext Version =\"1.0\">");
            writer.write("<Request svcid=\"doSymEncrypt\">");
            writer.write("<PlainData>");
            writer.flush();
            this.writeInputStream(this.plainData, out, true);
            writer.write("</PlainData>");
            writer.write("<KeyID>");
            writer.write(this.symmKeyNo);
            writer.write("</KeyID>");
            writer.write("</Request>");
            writer.write("</DSignContext>");
            writer.flush();
        }
        catch (IOException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new CSSException(e.getMessage(), e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)e.getMessage(), (Throwable)e);
                    throw new CSSException(e.getMessage(), e);
                }
            }
        }
    }

    public String getSymmKeyNo() {
        return this.symmKeyNo;
    }

    public void setSymmKeyNo(String symmKeyNo) {
        this.symmKeyNo = symmKeyNo;
    }

    public InputStream getPlainData() {
        return this.plainData;
    }

    public void setPlainData(InputStream plainData) {
        this.plainData = plainData;
    }
}

