/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.assp.client.request;

import cn.com.jit.assp.client.parser.EncryptEnvelopXMLResponseParser;
import cn.com.jit.assp.client.parser.XMLResponseParser;
import cn.com.jit.assp.client.request.AbstractRequestSet;
import cn.com.jit.assp.css.client.CSSException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EncryptEnvelopRequestSet
extends AbstractRequestSet {
    private static final Log LOGGER = LogFactory.getLog(EncryptEnvelopRequestSet.class);
    private String appId;
    private String[] certAlias;
    private String encryptAlg;
    private String digestAlg;
    private InputStream srcIn;
    private File srcFile;
    private int envelopMode;

    public EncryptEnvelopRequestSet(InputStream srcIn) {
        this.srcIn = srcIn;
    }

    private void addAlias2XML(Writer writer) throws IOException {
        if (this.certAlias != null && this.certAlias.length > 0) {
            for (int i = 0; i < this.certAlias.length; ++i) {
                writer.write("<alias>");
                writer.write(this.certAlias[i]);
                writer.write("</alias>");
            }
        } else {
            writer.write("");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeIn2OutAsXml(OutputStream out) throws CSSException {
        Writer writer = null;
        try {
            try {
                writer = this.getWriterFromOutputStream(out);
                writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>");
                writer.write("<DSignContext Version =\"1.0\">");
                boolean doBase64 = false;
                if (this.envelopMode == 2) {
                    writer.write("<Request svcid=\"doSignEnvelop\">");
                    writer.write("<ApplyID>");
                    writer.write(this.appId);
                    writer.write("</ApplyID>");
                } else if (this.envelopMode == 1) {
                    writer.write("<Request svcid=\"doEnvelop\">");
                    doBase64 = true;
                }
                writer.write("<PlainData type=\"0\">");
                writer.flush();
                this.writeInputStream(this.srcIn, out, doBase64);
                writer.write("</PlainData>");
                writer.write("<CertAlias>");
                this.addAlias2XML(writer);
                writer.write("</CertAlias>");
                writer.write("<EncAlg>");
                writer.write(this.encryptAlg);
                writer.write("</EncAlg>");
                writer.write("<DSDigestALG>");
                writer.write(this.digestAlg);
                writer.write("</DSDigestALG>");
                writer.write("</Request>");
                writer.write("</DSignContext>");
                writer.flush();
            }
            catch (IOException e) {
                LOGGER.error((Object)"errorCode: -10703204, errorMessage: \u4fe1\u5c01\u64cd\u4f5c\uff1a\u6784\u9020\u5e76\u53d1\u9001XML\u8f93\u51fa\u6d41\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
                throw new CSSException("-10703204", "\u4fe1\u5c01\u64cd\u4f5c\uff1a\u6784\u9020\u5e76\u53d1\u9001XML\u8f93\u51fa\u6d41\u51fa\u73b0\u5f02\u5e38\uff01");
            }
            Object var5_5 = null;
            if (writer == null) return;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (writer == null) throw throwable;
            try {
                writer.close();
                throw throwable;
            }
            catch (IOException e) {
                LOGGER.error((Object)"errorCode: -10703204, errorMessage: \u4fe1\u5c01\u64cd\u4f5c\uff1a\u6784\u9020\u5e76\u53d1\u9001XML\u8f93\u51fa\u6d41\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
                throw new CSSException("-10703204", "\u4fe1\u5c01\u64cd\u4f5c\uff1a\u6784\u9020\u5e76\u53d1\u9001XML\u8f93\u51fa\u6d41\u51fa\u73b0\u5f02\u5e38\uff01");
            }
        }
        try {}
        catch (IOException e) {
            LOGGER.error((Object)"errorCode: -10703204, errorMessage: \u4fe1\u5c01\u64cd\u4f5c\uff1a\u6784\u9020\u5e76\u53d1\u9001XML\u8f93\u51fa\u6d41\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
            throw new CSSException("-10703204", "\u4fe1\u5c01\u64cd\u4f5c\uff1a\u6784\u9020\u5e76\u53d1\u9001XML\u8f93\u51fa\u6d41\u51fa\u73b0\u5f02\u5e38\uff01");
        }
        writer.close();
    }

    public XMLResponseParser getResponseParser() {
        return new EncryptEnvelopXMLResponseParser();
    }

    public String[] getCertAlias() {
        return this.certAlias;
    }

    public void setCertAlias(String[] certAlias) {
        this.certAlias = certAlias;
    }

    public String getEncryptAlg() {
        return this.encryptAlg;
    }

    public void setEncryptAlg(String encryptAlg) {
        this.encryptAlg = encryptAlg;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getDigestAlg() {
        return this.digestAlg;
    }

    public void setDigestAlg(String digestAlg) {
        this.digestAlg = digestAlg;
    }

    public File getSrcFile() {
        return this.srcFile;
    }

    public void setSrcFile(File srcFile) throws IOException {
        this.srcIn = new AbstractRequestSet.XMLEncapFileInputStream(srcFile);
        this.srcFile = srcFile;
    }

    public int getEnvelopMode() {
        return this.envelopMode;
    }

    public void setEnvelopMode(int envelopMode) {
        this.envelopMode = envelopMode;
    }
}

