/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.assp.client.request;

import cn.com.jit.assp.client.parser.DigestXMLResponseParser;
import cn.com.jit.assp.client.parser.XMLResponseParser;
import cn.com.jit.assp.client.request.AbstractRequestSet;
import cn.com.jit.assp.css.client.CSSException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DigestRequestSet
extends AbstractRequestSet {
    private static final Log LOGGER = LogFactory.getLog(DigestRequestSet.class);
    private String digestAlg;
    private InputStream srcIn;

    public DigestRequestSet(InputStream srcIn) {
        this.srcIn = srcIn;
    }

    public void writeIn2OutAsXml(OutputStream out) throws CSSException {
        Writer writer = null;
        try {
            writer = this.getWriterFromOutputStream(out);
            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>");
            writer.write("<DSignContext Version =\"2.0\">");
            writer.write("<Request svcid=\"doDigest\">");
            writer.write("<ParaInfo>");
            writer.write("<PlainText>");
            writer.flush();
            this.writeInputStream(this.srcIn, out, true);
            writer.write("</PlainText>");
            writer.write("<DigestALG>");
            writer.write(this.digestAlg);
            writer.write("</DigestALG>");
            writer.write("</ParaInfo>");
            writer.write("</Request>");
            writer.write("</DSignContext>");
            writer.flush();
        }
        catch (IOException e) {
            LOGGER.error((Object)"errorcode:-10704205, errorMessage: \u89e3\u4fe1\u5c01\uff1a\u6784\u9020\u8bf7\u6c42\u62a5\u6587\u5e76\u5411\u670d\u52a1\u5668\u53d1\u9001\u8bf7\u6c42\u65f6\u4ea7\u751f\u5f02\u5e38\uff01", (Throwable)e);
            throw new CSSException("-10704205", "\u89e3\u4fe1\u5c01\uff1a\u6784\u9020\u8bf7\u6c42\u62a5\u6587\u5e76\u5411\u670d\u52a1\u5668\u53d1\u9001\u8bf7\u6c42\u65f6\u4ea7\u751f\u5f02\u5e38\uff01", e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)"errorcode:-10704205, errorMessage: \u89e3\u4fe1\u5c01\uff1a\u6784\u9020\u8bf7\u6c42\u62a5\u6587\u5e76\u5411\u670d\u52a1\u5668\u53d1\u9001\u8bf7\u6c42\u65f6\u4ea7\u751f\u5f02\u5e38\uff01", (Throwable)e);
                    throw new CSSException("-10704205", "\u89e3\u4fe1\u5c01\uff1a\u6784\u9020\u8bf7\u6c42\u62a5\u6587\u5e76\u5411\u670d\u52a1\u5668\u53d1\u9001\u8bf7\u6c42\u65f6\u4ea7\u751f\u5f02\u5e38\uff01", e);
                }
            }
        }
    }

    public XMLResponseParser getResponseParser() {
        return new DigestXMLResponseParser();
    }

    public String getDigestAlg() {
        return this.digestAlg;
    }

    public void setDigestAlg(String digestAlg) {
        this.digestAlg = digestAlg;
    }

    public InputStream getSrcIn() {
        return this.srcIn;
    }

    public void setSrcIn(InputStream srcIn) {
        this.srcIn = srcIn;
    }
}

