/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.assp.client.request;

import cn.com.jit.assp.client.parser.DSignXMLResponseParser;
import cn.com.jit.assp.client.parser.XMLResponseParser;
import cn.com.jit.assp.client.request.AbstractRequestSet;
import cn.com.jit.assp.css.client.CSSException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DSignRequestSet
extends AbstractRequestSet {
    private static final Log LOGGER = LogFactory.getLog(DSignRequestSet.class);
    private String appId;
    private int dsignMode;
    private String digestAlg;
    private int plainDateType;
    private File file;
    private InputStream srcIn;

    public DSignRequestSet(InputStream srcIn) {
        this.srcIn = srcIn;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeIn2OutAsXml(OutputStream out) throws CSSException {
        if (this.srcIn == null) {
            throw new CSSException("-10701108", "\u7b7e\u540d\u65f6\u539f\u6587\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        Writer writer = null;
        try {
            try {
                writer = this.getWriterFromOutputStream(out);
                writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\r");
                writer.write("<DSignContext Version =\"1.0\">");
                writer.write("<Request svcid=\"doDSign\">");
                writer.write("<ApplyID>");
                writer.write(this.appId);
                writer.write("</ApplyID>");
                writer.write("<PlainData type=\"");
                writer.write(Integer.toString(this.plainDateType));
                writer.write("\">");
                writer.flush();
                this.writeInputStream(this.srcIn, out, true);
                writer.write("</PlainData>");
                writer.write("<DSignMode>");
                writer.write(String.valueOf(this.dsignMode));
                writer.write("</DSignMode>");
                if (this.digestAlg != null) {
                    writer.write("<DSDigestALG>");
                    writer.write(this.digestAlg);
                    writer.write("</DSDigestALG>");
                }
                writer.write("</Request>");
                writer.write("</DSignContext>");
                writer.flush();
            }
            catch (IOException e) {
                LOGGER.error((Object)"errorCode: -10701105, errorMessage: \u7b7e\u540d\u65f6\u5411\u670d\u52a1\u5668\u53d1\u9001\u8bf7\u6c42\u62a5\u6587\u65f6\u4ea7\u751f\u5f02\u5e38\uff01", (Throwable)e);
                throw new CSSException("-10701105", "\u7b7e\u540d\u65f6\u5411\u670d\u52a1\u5668\u53d1\u9001\u8bf7\u6c42\u62a5\u6587\u65f6\u4ea7\u751f\u5f02\u5e38\uff01", e);
            }
            Object var5_3 = null;
            if (writer == null) return;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (writer == null) throw throwable;
            try {
                writer.close();
                throw throwable;
            }
            catch (IOException e) {
                LOGGER.error((Object)"errorCode: -10701105, errorMessage: \u7b7e\u540d\u65f6\u5411\u670d\u52a1\u5668\u53d1\u9001\u8bf7\u6c42\u62a5\u6587\u65f6\u4ea7\u751f\u5f02\u5e38\uff01", (Throwable)e);
                throw new CSSException("-10701105", "\u7b7e\u540d\u65f6\u5411\u670d\u52a1\u5668\u53d1\u9001\u8bf7\u6c42\u62a5\u6587\u65f6\u4ea7\u751f\u5f02\u5e38\uff01", e);
            }
        }
        try {}
        catch (IOException e) {
            LOGGER.error((Object)"errorCode: -10701105, errorMessage: \u7b7e\u540d\u65f6\u5411\u670d\u52a1\u5668\u53d1\u9001\u8bf7\u6c42\u62a5\u6587\u65f6\u4ea7\u751f\u5f02\u5e38\uff01", (Throwable)e);
            throw new CSSException("-10701105", "\u7b7e\u540d\u65f6\u5411\u670d\u52a1\u5668\u53d1\u9001\u8bf7\u6c42\u62a5\u6587\u65f6\u4ea7\u751f\u5f02\u5e38\uff01", e);
        }
        writer.close();
    }

    public XMLResponseParser getResponseParser() {
        DSignXMLResponseParser parser = new DSignXMLResponseParser();
        return parser;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public int getDsignMode() {
        return this.dsignMode;
    }

    public void setDsignMode(int dsignMode) {
        this.dsignMode = dsignMode;
    }

    public String getDigestAlg() {
        return this.digestAlg;
    }

    public void setDigestAlg(String digestAlg) {
        this.digestAlg = digestAlg;
    }

    public int getPlainDateType() {
        return this.plainDateType;
    }

    public void setPlainDateType(int plainDateType) {
        this.plainDateType = plainDateType;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) throws IOException {
        this.srcIn = new AbstractRequestSet.XMLEncapFileInputStream(file);
        this.file = file;
    }
}

