/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.assp.client.processor;

import cn.com.jit.assp.client.log.DSSLog;
import cn.com.jit.assp.client.log.DSSLogFactory;
import cn.com.jit.assp.client.parser.XMLResponseParser;
import cn.com.jit.assp.client.processor.Connection;
import cn.com.jit.assp.client.processor.Processor;
import cn.com.jit.assp.client.request.RequestSet;
import cn.com.jit.assp.client.response.ResponseSet;
import cn.com.jit.assp.css.client.CSSException;
import java.io.InputStream;
import java.io.OutputStream;

public class HttpProcessor
implements Processor {
    private static DSSLog log = DSSLogFactory.newInstance().getDSSLog();
    private Connection connection = null;

    protected HttpProcessor() {
    }

    public HttpProcessor(Connection connection) {
        this.connection = connection;
    }

    private void marshalling(RequestSet request, OutputStream out) throws CSSException {
        request.writeIn2OutAsXml(out);
    }

    public ResponseSet process(RequestSet request) throws CSSException {
        if (this.connection == null) {
            throw new CSSException("-10702002", "\u53c2\u6570\u4e0d\u5408\u6cd5\uff0cxml\u62a5\u6587\u8f93\u5165\u4e3a\u7a7a\uff01");
        }
        OutputStream out = null;
        try {
            ResponseSet res;
            this.connection.open();
            out = this.connection.getOutputStream();
            if (log.isPrintLog()) {
                out = log.debug(out);
            }
            this.marshalling(request, out);
            out.flush();
            InputStream in = this.connection.getInputStream();
            if (log.isPrintLog()) {
                in = log.debug(in);
            }
            ResponseSet responseSet = res = this.unmarshalling(in, request);
            return responseSet;
        }
        catch (Exception e) {
            log.error(e.getLocalizedMessage(), e);
            throw new CSSException("-10702003", "\u53d1\u9001\u8bf7\u6c42\u8d85\u65f6\uff01", e);
        }
        finally {
            try {
                this.connection.close();
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception e3) {
                log.error(e3.getLocalizedMessage(), e3);
            }
        }
    }

    protected ResponseSet unmarshalling(InputStream in, RequestSet request) throws CSSException {
        XMLResponseParser parser = request.getResponseParser();
        return parser.parserXML(in);
    }
}

