/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.assp.client.log;

import cn.com.jit.assp.client.log.AbstractDSSLog;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import org.apache.commons.io.input.TeeInputStream;
import org.apache.commons.io.output.TeeOutputStream;

public class SystemConsoleLog
extends AbstractDSSLog {
    private void printMessage2Console(Object message, Throwable e, String logLevel) {
        PrintStream print = null;
        print = logLevel != null && logLevel.equalsIgnoreCase("ERROR") ? System.err : System.out;
        try {
            this.writeTime2Log(print, logLevel);
        }
        catch (IOException e1) {
            // empty catch block
        }
        if (message != null) {
            print.println(message.toString());
        }
        if (e != null) {
            print.println(e.getMessage());
        }
    }

    private InputStream writeInputStream2Console(InputStream in, String logLevel) {
        SystemTeeInputStream tin = null;
        try {
            System.out.println();
            this.writeTime2Log(System.out, logLevel);
            tin = new SystemTeeInputStream(in, System.out, false);
        }
        catch (IOException e) {
            // empty catch block
        }
        return tin == null ? in : tin;
    }

    private OutputStream writeOutputStream2Console(OutputStream out, String logLevel) {
        SystemTeeOutputStream tout = null;
        try {
            System.out.println();
            this.writeTime2Log(System.out, logLevel);
            tout = new SystemTeeOutputStream(out, System.out);
        }
        catch (IOException e) {
            // empty catch block
        }
        return tout == null ? out : tout;
    }

    public void debug(Object message) {
        this.printMessage2Console(message, null, "DEBUG");
    }

    public void debug(Object message, Throwable e) {
        this.printMessage2Console(message, e, "DEBUG");
    }

    public void info(Object message) {
        this.printMessage2Console(message, null, "INFO");
    }

    public void info(Object message, Throwable e) {
        this.printMessage2Console(message, e, "INFO");
    }

    public void error(Object message) {
        this.printMessage2Console(message, null, "ERROR");
    }

    public void error(Object message, Throwable e) {
        this.printMessage2Console(message, e, "ERROR");
    }

    public InputStream debug(InputStream in) {
        return this.writeInputStream2Console(in, "DEBUG");
    }

    public OutputStream debug(OutputStream out) {
        return this.writeOutputStream2Console(out, "DEBUG");
    }

    public InputStream info(InputStream in) {
        return this.writeInputStream2Console(in, "INFO");
    }

    public OutputStream info(OutputStream out) {
        return this.writeOutputStream2Console(out, "INFO");
    }

    class SystemTeeOutputStream
    extends TeeOutputStream {
        public SystemTeeOutputStream(OutputStream out, OutputStream branch) {
            super(out, branch);
        }

        public void close() throws IOException {
        }
    }

    class SystemTeeInputStream
    extends TeeInputStream {
        public SystemTeeInputStream(InputStream input, OutputStream branch) {
            super(input, branch);
        }

        public SystemTeeInputStream(InputStream input, OutputStream branch, boolean closeBranch) {
            super(input, branch, closeBranch);
        }

        public void close() throws IOException {
        }
    }
}

