/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.assp.client.log;

import cn.com.jit.assp.client.log.AbstractDSSLog;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.input.TeeInputStream;
import org.apache.commons.io.output.TeeOutputStream;

public class FileDSSLog
extends AbstractDSSLog {
    private File logFile;

    protected FileDSSLog() {
        this(null);
    }

    public FileDSSLog(File logFile) {
        this.logFile = logFile;
        try {
            if (this.logFile == null) {
                this.logFile = File.createTempFile("jit.dss.vstk.", ".log");
            } else if (this.logFile.isDirectory()) {
                this.logFile = File.createTempFile("jit.dss.vstk.", ".log", this.logFile);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void formatLogFile(OutputStream out, String logLevel) throws IOException {
        if (this.logFile.length() == 0L) {
            this.writeTime2Log(out, logLevel);
            return;
        }
        out.write("\r\n".getBytes());
        out.flush();
        this.writeTime2Log(out, logLevel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeMessage2LogFile(Object message, Throwable e, String logLevel) {
        FileOutputStream fout = null;
        fout = new FileOutputStream(this.logFile, true);
        this.formatLogFile(fout, logLevel);
        if (message != null) {
            ((OutputStream)fout).write(message.toString().getBytes("UTF-8"));
        }
        if (e != null) {
            ((OutputStream)fout).write(e.getMessage().getBytes("UTF-8"));
        }
        fout.flush();
        Object var7_5 = null;
        if (fout == null) return;
        try {
            ((OutputStream)fout).close();
            return;
        }
        catch (IOException e1) {}
        return;
        {
            catch (IOException ex) {
                Object var7_6 = null;
                if (fout == null) return;
                try {
                    ((OutputStream)fout).close();
                    return;
                }
                catch (IOException e1) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (fout == null) throw throwable;
            try {
                ((OutputStream)fout).close();
                throw throwable;
            }
            catch (IOException e1) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private InputStream writeInputStream2LogFile(InputStream in, String logLevel) {
        TeeInputStream tin = null;
        try {
            FileOutputStream out = new FileOutputStream(this.logFile, true);
            this.formatLogFile(out, logLevel);
            tin = new TeeInputStream(in, (OutputStream)out);
        }
        catch (IOException e) {
            // empty catch block
        }
        return tin == null ? in : tin;
    }

    private OutputStream writeOutputStream2LogFile(OutputStream out, String logLevel) {
        TeeOutputStream tout = null;
        try {
            FileOutputStream fout = new FileOutputStream(this.logFile, true);
            this.formatLogFile(fout, logLevel);
            tout = new TeeOutputStream(out, (OutputStream)fout);
        }
        catch (IOException e) {
            // empty catch block
        }
        return tout == null ? out : tout;
    }

    public void debug(Object message) {
        this.writeMessage2LogFile(message, null, "DEBUG");
    }

    public void debug(Object message, Throwable e) {
        this.writeMessage2LogFile(message, e, "DEBUG");
    }

    public void info(Object message) {
        this.writeMessage2LogFile(message, null, "INFO");
    }

    public void info(Object message, Throwable e) {
        this.writeMessage2LogFile(message, e, "INFO");
    }

    public void error(Object message) {
        this.writeMessage2LogFile(message, null, "ERROR");
    }

    public void error(Object message, Throwable e) {
        this.writeMessage2LogFile(message, e, "ERROR");
    }

    public InputStream debug(InputStream in) {
        return this.writeInputStream2LogFile(in, "DEBUG");
    }

    public OutputStream debug(OutputStream out) {
        return this.writeOutputStream2LogFile(out, "DEBUG");
    }

    public InputStream info(InputStream in) {
        return this.writeInputStream2LogFile(in, "INFO");
    }

    public OutputStream info(OutputStream out) {
        return this.writeOutputStream2LogFile(out, "INFO");
    }
}

