/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.assp.client.log;

import cn.com.jit.assp.client.log.DSSLog;
import cn.com.jit.assp.client.log.FileDSSLog;
import cn.com.jit.assp.client.log.Log4jDSSLog;
import cn.com.jit.assp.client.log.SystemConsoleLog;
import cn.com.jit.assp.css.client.Config;
import java.io.File;

public class DSSLogFactory {
    private String logTarget = "console";
    private String logFilePath;
    private static DSSLogFactory factory;

    protected DSSLogFactory() {
        Config config = Config.getInstance();
        this.logTarget = config.getLogTarget();
        this.logFilePath = config.getLogFilePath();
    }

    public static DSSLogFactory newInstance() {
        if (factory == null) {
            factory = new DSSLogFactory();
        }
        return factory;
    }

    public DSSLog getDSSLog() {
        if (this.logTarget == null || this.logTarget.trim().length() == 0) {
            return new SystemConsoleLog();
        }
        if (this.logTarget.equalsIgnoreCase("file")) {
            return new FileDSSLog(new File(this.logFilePath));
        }
        if (this.logTarget.equalsIgnoreCase("log4j")) {
            return new Log4jDSSLog();
        }
        return new SystemConsoleLog();
    }
}

