/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.assp.client;

import cn.com.jit.assp.client.AbstractDSign;
import cn.com.jit.assp.client.DSSClient;
import cn.com.jit.assp.client.DSign;
import cn.com.jit.assp.client.response.DecryptEnvelopResponseSet;
import cn.com.jit.assp.client.response.DigestResponseSet;
import cn.com.jit.assp.client.response.SymmDecryptResponseSet;
import cn.com.jit.assp.client.response.TSASignResponseSet;
import cn.com.jit.assp.client.response.TSAVerifyResponseSet;
import cn.com.jit.assp.client.response.VSignResponseItems;
import cn.com.jit.assp.client.response.VSignResponseSet;
import cn.com.jit.assp.client.util.StringUtils;
import cn.com.jit.assp.css.client.CSSException;
import cn.com.jit.assp.css.client.Config;
import cn.com.jit.assp.css.client.util.UtilTool;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import org.apache.commons.codec.binary.Base64InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DSignImpl
extends AbstractDSign
implements DSign {
    private static final Log LOGGER = LogFactory.getLog(DSignImpl.class);

    public DSignImpl(String configFilePath) {
        super(configFilePath);
    }

    public DSignImpl(Config config) {
        super(config);
    }

    public long attachSign(String signCertId, InputStream source, OutputStream signedDataStore) {
        return this.signature(signCertId, source, signedDataStore, 1);
    }

    public long attachSign(String signCertId, File source, OutputStream signedDataStore) {
        return this.signature(signCertId, source, signedDataStore, 1);
    }

    public long detachSign(String signCertId, InputStream source, OutputStream signedDataStore) {
        return this.signature(signCertId, source, signedDataStore, 2);
    }

    public long detachSign(String signCertId, File source, OutputStream signedDataStore) {
        return this.signature(signCertId, source, signedDataStore, 2);
    }

    public long simpleSign(String signCertId, InputStream source, OutputStream signedDataStore) {
        return this.signature(signCertId, source, signedDataStore, 3);
    }

    public long subsequentSign(String signCertId, InputStream source, OutputStream signedDataStore) {
        return this.signature(signCertId, source, signedDataStore, 4);
    }

    public long subsequentSign(String signCertId, File source, OutputStream signedDataStore) {
        return this.signature(signCertId, source, signedDataStore, 4);
    }

    public long p1Sign(String signCertId, InputStream source, OutputStream signedDataStore) {
        return this.signature(signCertId, source, signedDataStore, 5);
    }

    public VSignResponseSet verifyAttachSign(InputStream signedData, OutputStream sourceStore) {
        return (VSignResponseSet)this.verify(null, signedData, sourceStore, 1);
    }

    public VSignResponseSet verifyAttachSign(InputStream signedData, String sourceStoreDirectory) {
        return (VSignResponseSet)this.verify(null, signedData, sourceStoreDirectory, 1);
    }

    public VSignResponseSet verifyDetachSign(InputStream source, InputStream signedData, OutputStream sourceStore) {
        return (VSignResponseSet)this.verify(source, signedData, sourceStore, 2);
    }

    public VSignResponseSet verifyDetachSign(File source, InputStream signedData, String sourceStoreDirectory) {
        return (VSignResponseSet)this.verify(source, signedData, sourceStoreDirectory, 2);
    }

    public VSignResponseSet verifySimpleSign(InputStream source, InputStream signedData, OutputStream sourceStore) {
        return (VSignResponseSet)this.verify(source, signedData, sourceStore, 3);
    }

    public VSignResponseSet verifySubsequentSign(InputStream signedData, OutputStream sourceStore) {
        return (VSignResponseSet)this.verify(null, signedData, sourceStore, 4);
    }

    public VSignResponseSet verifySubsequentSign(InputStream signedData, String sourceStoreDirectory) {
        return (VSignResponseSet)this.verify(null, signedData, sourceStoreDirectory, 4);
    }

    public VSignResponseSet p1Verify(String certId, InputStream source, InputStream signedData, OutputStream sourceStore) {
        return this.p1Verify(certId, source, signedData, sourceStore, 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private VSignResponseSet p1Verify(String certId, InputStream source, InputStream signedData, OutputStream sourceStore, int serviceType) {
        VSignResponseSet reponse;
        block26: {
            InputStream returnSource;
            DSSClient client;
            block25: {
                if (StringUtils.isEmpty(certId)) {
                    this.setErrorCode(UtilTool.convertStr2Long("-10703210", -10700000L));
                    this.setErrorMessage("\u53c2\u6570\u4e0d\u5408\u6cd5\uff1ap1\u9a8c\u7b7e\u6240\u4f7f\u7528\u8bc1\u4e66\u6807\u8bc6\uff08\u9881\u53d1\u8005\u52a0\u5e8f\u5217\u53f7\u6216\u8bc1\u4e66\u5b9e\u4f53\uff09\u4e3a\u7a7a\uff01");
                    return null;
                }
                if (source == null) {
                    this.setErrorCode(UtilTool.convertStr2Long("-10701001", -10700000L));
                    this.setErrorMessage("\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u539f\u6587\u8f93\u5165\u4e3a\u7a7a\uff01");
                    return null;
                }
                if (signedData == null) {
                    this.setErrorCode(UtilTool.convertStr2Long("-10704201", -10700000L));
                    this.setErrorMessage("\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u7b7e\u540d\u7ed3\u679c\u7684Base64\u7f16\u7801\u4e3a\u7a7a\uff01");
                    return null;
                }
                reponse = null;
                Config config = DSignImpl.getConfig();
                String digestAlg = config.getDigestAlg();
                String encryptAlg = config.getEncAlg();
                client = null;
                returnSource = null;
                client = this.getClient();
                client.connect();
                VSignResponseItems responseItems = this.getVSignResponseItems();
                reponse = client.p1Verify(certId, digestAlg, encryptAlg, signedData, source, responseItems);
                returnSource = reponse.getSourceDataStream();
                if (returnSource == null || sourceStore == null) break block25;
                returnSource = new Base64InputStream(returnSource, false);
                IOUtils.copy((InputStream)returnSource, (OutputStream)sourceStore);
                sourceStore.flush();
            }
            Object var14_15 = null;
            try {
                if (returnSource != null) {
                    returnSource.close();
                }
                if (client != null) {
                    client.close();
                }
                break block26;
            }
            catch (CSSException e2) {
                this.setErrorCode(UtilTool.convertStr2Long(e2.getCode(), -10700000L));
                this.setErrorMessage(e2.getDescription());
                LOGGER.error((Object)e2.getMessage(), (Throwable)e2);
            }
            catch (Exception e3) {
                this.setErrorCode(UtilTool.convertStr2Long(e3.getMessage(), -10700000L));
                this.setErrorMessage(e3.getMessage());
                LOGGER.error((Object)e3.getMessage(), (Throwable)e3);
            }
            break block26;
            {
                catch (CSSException e) {
                    LOGGER.error((Object)e.getMessage(), (Throwable)e);
                    this.setErrorCode(UtilTool.convertStr2Long(e.getCode(), -10700000L));
                    this.setErrorMessage(e.getDescription());
                    Object var14_16 = null;
                    try {
                        if (returnSource != null) {
                            returnSource.close();
                        }
                        if (client != null) {
                            client.close();
                        }
                        break block26;
                    }
                    catch (CSSException e2) {
                        this.setErrorCode(UtilTool.convertStr2Long(e2.getCode(), -10700000L));
                        this.setErrorMessage(e2.getDescription());
                        LOGGER.error((Object)e2.getMessage(), (Throwable)e2);
                    }
                    catch (Exception e3) {
                        this.setErrorCode(UtilTool.convertStr2Long(e3.getMessage(), -10700000L));
                        this.setErrorMessage(e3.getMessage());
                        LOGGER.error((Object)e3.getMessage(), (Throwable)e3);
                    }
                    break block26;
                }
                catch (Exception e) {
                    this.setErrorCode(UtilTool.convertStr2Long(e.getMessage(), -10700000L));
                    this.setErrorMessage(e.getMessage());
                    LOGGER.error((Object)e.getMessage(), (Throwable)e);
                    Object var14_17 = null;
                    try {
                        if (returnSource != null) {
                            returnSource.close();
                        }
                        if (client != null) {
                            client.close();
                        }
                        break block26;
                    }
                    catch (CSSException e2) {
                        this.setErrorCode(UtilTool.convertStr2Long(e2.getCode(), -10700000L));
                        this.setErrorMessage(e2.getDescription());
                        LOGGER.error((Object)e2.getMessage(), (Throwable)e2);
                    }
                    catch (Exception e3) {
                        this.setErrorCode(UtilTool.convertStr2Long(e3.getMessage(), -10700000L));
                        this.setErrorMessage(e3.getMessage());
                        LOGGER.error((Object)e3.getMessage(), (Throwable)e3);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var14_18 = null;
                try {
                    if (returnSource != null) {
                        returnSource.close();
                    }
                    if (client != null) {
                        client.close();
                    }
                }
                catch (CSSException e2) {
                    this.setErrorCode(UtilTool.convertStr2Long(e2.getCode(), -10700000L));
                    this.setErrorMessage(e2.getDescription());
                    LOGGER.error((Object)e2.getMessage(), (Throwable)e2);
                }
                catch (Exception e3) {
                    this.setErrorCode(UtilTool.convertStr2Long(e3.getMessage(), -10700000L));
                    this.setErrorMessage(e3.getMessage());
                    LOGGER.error((Object)e3.getMessage(), (Throwable)e3);
                }
                throw throwable;
            }
        }
        return reponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public TSASignResponseSet signTimeStamp(String digestAlg, InputStream source, OutputStream timeStampedDataStore) {
        TSASignResponseSet response;
        block24: {
            String da = digestAlg;
            if (StringUtils.isEmpty(da)) {
                da = DSignImpl.getConfig().getDigestAlg();
            }
            if (source == null) {
                this.setErrorCode(UtilTool.convertStr2Long("-10701001", -10700000L));
                this.setErrorMessage("\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u539f\u6587\u8f93\u5165\u4e3a\u7a7a\uff01");
                return null;
            }
            response = null;
            DSSClient client = null;
            InputStream tsaData = null;
            client = this.getClient();
            client.connect();
            response = client.signTimeStamp(da, source);
            tsaData = response.getTsaDataStream();
            IOUtils.copy((InputStream)tsaData, (OutputStream)timeStampedDataStore);
            timeStampedDataStore.flush();
            Object var10_8 = null;
            try {
                if (tsaData != null) {
                    tsaData.close();
                }
                if (client != null) {
                    client.close();
                }
                break block24;
            }
            catch (CSSException e2) {
                this.setErrorCode(UtilTool.convertStr2Long(e2.getCode(), -10700000L));
                this.setErrorMessage(e2.getDescription());
                LOGGER.error((Object)e2.getMessage(), (Throwable)e2);
            }
            catch (Exception e3) {
                this.setErrorCode(UtilTool.convertStr2Long(e3.getMessage(), -10700000L));
                this.setErrorMessage(e3.getMessage());
                LOGGER.error((Object)e3.getMessage(), (Throwable)e3);
            }
            break block24;
            {
                catch (CSSException e) {
                    this.setErrorCode(UtilTool.convertStr2Long(e.getCode(), -10700000L));
                    this.setErrorMessage(e.getDescription());
                    LOGGER.error((Object)e.getMessage(), (Throwable)e);
                    Object var10_9 = null;
                    try {
                        if (tsaData != null) {
                            tsaData.close();
                        }
                        if (client != null) {
                            client.close();
                        }
                        break block24;
                    }
                    catch (CSSException e2) {
                        this.setErrorCode(UtilTool.convertStr2Long(e2.getCode(), -10700000L));
                        this.setErrorMessage(e2.getDescription());
                        LOGGER.error((Object)e2.getMessage(), (Throwable)e2);
                    }
                    catch (Exception e3) {
                        this.setErrorCode(UtilTool.convertStr2Long(e3.getMessage(), -10700000L));
                        this.setErrorMessage(e3.getMessage());
                        LOGGER.error((Object)e3.getMessage(), (Throwable)e3);
                    }
                    break block24;
                }
                catch (Exception e) {
                    this.setErrorCode(UtilTool.convertStr2Long(e.getMessage(), -10700000L));
                    this.setErrorMessage(e.getMessage());
                    LOGGER.error((Object)e.getMessage(), (Throwable)e);
                    Object var10_10 = null;
                    try {
                        if (tsaData != null) {
                            tsaData.close();
                        }
                        if (client != null) {
                            client.close();
                        }
                        break block24;
                    }
                    catch (CSSException e2) {
                        this.setErrorCode(UtilTool.convertStr2Long(e2.getCode(), -10700000L));
                        this.setErrorMessage(e2.getDescription());
                        LOGGER.error((Object)e2.getMessage(), (Throwable)e2);
                    }
                    catch (Exception e3) {
                        this.setErrorCode(UtilTool.convertStr2Long(e3.getMessage(), -10700000L));
                        this.setErrorMessage(e3.getMessage());
                        LOGGER.error((Object)e3.getMessage(), (Throwable)e3);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                try {
                    if (tsaData != null) {
                        tsaData.close();
                    }
                    if (client != null) {
                        client.close();
                    }
                }
                catch (CSSException e2) {
                    this.setErrorCode(UtilTool.convertStr2Long(e2.getCode(), -10700000L));
                    this.setErrorMessage(e2.getDescription());
                    LOGGER.error((Object)e2.getMessage(), (Throwable)e2);
                }
                catch (Exception e3) {
                    this.setErrorCode(UtilTool.convertStr2Long(e3.getMessage(), -10700000L));
                    this.setErrorMessage(e3.getMessage());
                    LOGGER.error((Object)e3.getMessage(), (Throwable)e3);
                }
                throw throwable;
            }
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public TSAVerifyResponseSet verifyTimeStamp(InputStream timeStampedData, OutputStream sourceStore) {
        TSAVerifyResponseSet response;
        block12: {
            if (timeStampedData == null) {
                this.setErrorCode(UtilTool.convertStr2Long("-10704201", -10700000L));
                this.setErrorMessage("\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u7b7e\u540d\u7ed3\u679c\u7684Base64\u7f16\u7801\u4e3a\u7a7a\uff01");
                return null;
            }
            DSSClient client = null;
            response = null;
            client = this.getClient();
            client.connect();
            response = client.verifyTimeStamp(timeStampedData);
            Object var7_5 = null;
            try {
                if (client != null) {
                    client.close();
                }
                break block12;
            }
            catch (CSSException e2) {
                this.setErrorCode(UtilTool.convertStr2Long(e2.getCode(), -10700000L));
                this.setErrorMessage(e2.getDescription());
            }
            break block12;
            {
                catch (CSSException e) {
                    this.setErrorCode(UtilTool.convertStr2Long(e.getCode(), -10700000L));
                    this.setErrorMessage(e.getDescription());
                    Object var7_6 = null;
                    try {
                        if (client != null) {
                            client.close();
                        }
                        break block12;
                    }
                    catch (CSSException e2) {
                        this.setErrorCode(UtilTool.convertStr2Long(e2.getCode(), -10700000L));
                        this.setErrorMessage(e2.getDescription());
                    }
                }
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                try {
                    if (client != null) {
                        client.close();
                    }
                }
                catch (CSSException e2) {
                    this.setErrorCode(UtilTool.convertStr2Long(e2.getCode(), -10700000L));
                    this.setErrorMessage(e2.getDescription());
                }
                throw throwable;
            }
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public long findTimeStampById(String timeStampId, OutputStream timeStampStore) {
        block23: {
            this.setErrorCode(0L);
            this.setErrorMessage("");
            if (StringUtils.isEmpty(timeStampId)) {
                this.setErrorCode(UtilTool.convertStr2Long("-10703211", -10700000L));
                this.setErrorMessage("\u53c2\u6570\u4e0d\u5408\u6cd5\uff1a\u65f6\u95f4\u6233ID\u4e3a\u7a7a\uff01");
                return this.getErrorCode();
            }
            DSSClient client = null;
            InputStream tsaData = null;
            client = this.getClient();
            client.connect();
            tsaData = client.findTimeStampByID(timeStampId);
            IOUtils.copy((InputStream)tsaData, (OutputStream)timeStampStore);
            timeStampStore.flush();
            Object var7_5 = null;
            try {
                if (tsaData != null) {
                    tsaData.close();
                }
                if (client != null) {
                    client.close();
                }
                break block23;
            }
            catch (CSSException e2) {
                this.setErrorCode(UtilTool.convertStr2Long(e2.getCode(), -10700000L));
                this.setErrorMessage(e2.getDescription());
                LOGGER.error((Object)e2.getMessage(), (Throwable)e2);
            }
            catch (Exception e3) {
                this.setErrorCode(UtilTool.convertStr2Long(e3.getMessage(), -10700000L));
                this.setErrorMessage(e3.getMessage());
                LOGGER.error((Object)e3.getMessage(), (Throwable)e3);
            }
            break block23;
            {
                catch (CSSException e) {
                    this.setErrorCode(UtilTool.convertStr2Long(e.getCode(), -10700000L));
                    this.setErrorMessage(e.getDescription());
                    LOGGER.error((Object)e.getMessage(), (Throwable)e);
                    Object var7_6 = null;
                    try {
                        if (tsaData != null) {
                            tsaData.close();
                        }
                        if (client != null) {
                            client.close();
                        }
                        break block23;
                    }
                    catch (CSSException e2) {
                        this.setErrorCode(UtilTool.convertStr2Long(e2.getCode(), -10700000L));
                        this.setErrorMessage(e2.getDescription());
                        LOGGER.error((Object)e2.getMessage(), (Throwable)e2);
                    }
                    catch (Exception e3) {
                        this.setErrorCode(UtilTool.convertStr2Long(e3.getMessage(), -10700000L));
                        this.setErrorMessage(e3.getMessage());
                        LOGGER.error((Object)e3.getMessage(), (Throwable)e3);
                    }
                    break block23;
                }
                catch (Exception e) {
                    this.setErrorCode(UtilTool.convertStr2Long(e.getMessage(), -10700000L));
                    this.setErrorMessage(e.getMessage());
                    LOGGER.error((Object)e.getMessage(), (Throwable)e);
                    Object var7_7 = null;
                    try {
                        if (tsaData != null) {
                            tsaData.close();
                        }
                        if (client != null) {
                            client.close();
                        }
                        break block23;
                    }
                    catch (CSSException e2) {
                        this.setErrorCode(UtilTool.convertStr2Long(e2.getCode(), -10700000L));
                        this.setErrorMessage(e2.getDescription());
                        LOGGER.error((Object)e2.getMessage(), (Throwable)e2);
                    }
                    catch (Exception e3) {
                        this.setErrorCode(UtilTool.convertStr2Long(e3.getMessage(), -10700000L));
                        this.setErrorMessage(e3.getMessage());
                        LOGGER.error((Object)e3.getMessage(), (Throwable)e3);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                try {
                    if (tsaData != null) {
                        tsaData.close();
                    }
                    if (client != null) {
                        client.close();
                    }
                }
                catch (CSSException e2) {
                    this.setErrorCode(UtilTool.convertStr2Long(e2.getCode(), -10700000L));
                    this.setErrorMessage(e2.getDescription());
                    LOGGER.error((Object)e2.getMessage(), (Throwable)e2);
                }
                catch (Exception e3) {
                    this.setErrorCode(UtilTool.convertStr2Long(e3.getMessage(), -10700000L));
                    this.setErrorMessage(e3.getMessage());
                    LOGGER.error((Object)e3.getMessage(), (Throwable)e3);
                }
                throw throwable;
            }
        }
        return this.getErrorCode();
    }

    public long encryptEnvelop(String[] encryptCertsId, InputStream source, OutputStream envelopedDataStore) {
        return this.encryptEnvelop(null, encryptCertsId, source, envelopedDataStore, 6);
    }

    public long encryptEnvelop(String[] encryptCertsId, File source, OutputStream envelopedDataStore) {
        return this.encryptEnvelop(null, encryptCertsId, source, envelopedDataStore, 6);
    }

    public long encryptSignedEnvelop(String signCertId, String[] encryptCertsId, InputStream source, OutputStream envelopedDataStore) {
        return this.encryptEnvelop(signCertId, encryptCertsId, source, envelopedDataStore, 7);
    }

    public long encryptSignedEnvelop(String signCertId, String[] encryptCertsId, File source, OutputStream envelopedDataStore) {
        return this.encryptEnvelop(signCertId, encryptCertsId, source, envelopedDataStore, 7);
    }

    public DecryptEnvelopResponseSet decryptEnvelop(InputStream envelopedData, OutputStream sourceStore) {
        return (DecryptEnvelopResponseSet)this.decryptEnvelop(envelopedData, sourceStore, 6);
    }

    public DecryptEnvelopResponseSet decryptEnvelop(InputStream envelopedData, String sourceStoreDirectory) {
        return (DecryptEnvelopResponseSet)this.decryptEnvelop(envelopedData, sourceStoreDirectory, 6);
    }

    public DecryptEnvelopResponseSet decryptSignedEnvelop(InputStream envelopedData, OutputStream sourceStore) {
        return (DecryptEnvelopResponseSet)this.decryptEnvelop(envelopedData, sourceStore, 7);
    }

    public DecryptEnvelopResponseSet decryptSignedEnvelop(InputStream envelopedData, String sourceStoreDirectory) {
        return (DecryptEnvelopResponseSet)this.decryptEnvelop(envelopedData, sourceStoreDirectory, 7);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public long symmEncrypt(String symmKeyId, InputStream source, OutputStream encryptedDataStore) {
        block22: {
            DSSClient client = null;
            InputStream encryptData = null;
            client = this.getClient();
            client.connect();
            encryptData = client.symmEncrypt(symmKeyId, source);
            IOUtils.copy((InputStream)encryptData, (OutputStream)encryptedDataStore);
            encryptedDataStore.flush();
            Object var8_6 = null;
            try {
                if (encryptData != null) {
                    encryptData.close();
                }
                if (client != null) {
                    client.close();
                }
                break block22;
            }
            catch (CSSException e2) {
                this.setErrorCode(UtilTool.convertStr2Long(e2.getCode(), -10700000L));
                this.setErrorMessage(e2.getDescription());
                LOGGER.error((Object)e2.getMessage(), (Throwable)e2);
            }
            catch (Exception e3) {
                this.setErrorCode(UtilTool.convertStr2Long(e3.getMessage(), -10700000L));
                this.setErrorMessage(e3.getMessage());
                LOGGER.error((Object)e3.getMessage(), (Throwable)e3);
            }
            break block22;
            {
                catch (CSSException e) {
                    this.setErrorCode(UtilTool.convertStr2Long(e.getCode(), -10700000L));
                    this.setErrorMessage(e.getDescription());
                    LOGGER.error((Object)e.getMessage(), (Throwable)e);
                    Object var8_7 = null;
                    try {
                        if (encryptData != null) {
                            encryptData.close();
                        }
                        if (client != null) {
                            client.close();
                        }
                        break block22;
                    }
                    catch (CSSException e2) {
                        this.setErrorCode(UtilTool.convertStr2Long(e2.getCode(), -10700000L));
                        this.setErrorMessage(e2.getDescription());
                        LOGGER.error((Object)e2.getMessage(), (Throwable)e2);
                    }
                    catch (Exception e3) {
                        this.setErrorCode(UtilTool.convertStr2Long(e3.getMessage(), -10700000L));
                        this.setErrorMessage(e3.getMessage());
                        LOGGER.error((Object)e3.getMessage(), (Throwable)e3);
                    }
                    break block22;
                }
                catch (Exception e) {
                    this.setErrorCode(UtilTool.convertStr2Long(e.getMessage(), -10700000L));
                    this.setErrorMessage(e.getMessage());
                    LOGGER.error((Object)e.getMessage(), (Throwable)e);
                    Object var8_8 = null;
                    try {
                        if (encryptData != null) {
                            encryptData.close();
                        }
                        if (client != null) {
                            client.close();
                        }
                        break block22;
                    }
                    catch (CSSException e2) {
                        this.setErrorCode(UtilTool.convertStr2Long(e2.getCode(), -10700000L));
                        this.setErrorMessage(e2.getDescription());
                        LOGGER.error((Object)e2.getMessage(), (Throwable)e2);
                    }
                    catch (Exception e3) {
                        this.setErrorCode(UtilTool.convertStr2Long(e3.getMessage(), -10700000L));
                        this.setErrorMessage(e3.getMessage());
                        LOGGER.error((Object)e3.getMessage(), (Throwable)e3);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                try {
                    if (encryptData != null) {
                        encryptData.close();
                    }
                    if (client != null) {
                        client.close();
                    }
                }
                catch (CSSException e2) {
                    this.setErrorCode(UtilTool.convertStr2Long(e2.getCode(), -10700000L));
                    this.setErrorMessage(e2.getDescription());
                    LOGGER.error((Object)e2.getMessage(), (Throwable)e2);
                }
                catch (Exception e3) {
                    this.setErrorCode(UtilTool.convertStr2Long(e3.getMessage(), -10700000L));
                    this.setErrorMessage(e3.getMessage());
                    LOGGER.error((Object)e3.getMessage(), (Throwable)e3);
                }
                throw throwable;
            }
        }
        return this.getErrorCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public SymmDecryptResponseSet symmDecrypt(String symmKeyId, InputStream encryptedData, OutputStream sourceStore) {
        SymmDecryptResponseSet response;
        block23: {
            InputStream sourceData;
            DSSClient client;
            block22: {
                response = null;
                client = null;
                sourceData = null;
                client = this.getClient();
                client.connect();
                response = client.symmDecrypt(symmKeyId, encryptedData);
                sourceData = response.getSourceDataStream();
                if (sourceStore == null || sourceData == null) break block22;
                sourceData = new Base64InputStream(sourceData, false);
                IOUtils.copy((InputStream)sourceData, (OutputStream)sourceStore);
                sourceStore.flush();
            }
            Object var9_7 = null;
            try {
                if (sourceData != null) {
                    sourceData.close();
                }
                if (client != null) {
                    client.close();
                }
                break block23;
            }
            catch (CSSException e2) {
                this.setErrorCode(UtilTool.convertStr2Long(e2.getCode(), -10700000L));
                this.setErrorMessage(e2.getDescription());
                LOGGER.error((Object)e2.getMessage(), (Throwable)e2);
            }
            catch (Exception e3) {
                this.setErrorCode(UtilTool.convertStr2Long(e3.getMessage(), -10700000L));
                this.setErrorMessage(e3.getMessage());
                LOGGER.error((Object)e3.getMessage(), (Throwable)e3);
            }
            break block23;
            {
                catch (CSSException e) {
                    this.setErrorCode(UtilTool.convertStr2Long(e.getCode(), -10700000L));
                    this.setErrorMessage(e.getDescription());
                    LOGGER.error((Object)e.getMessage(), (Throwable)e);
                    Object var9_8 = null;
                    try {
                        if (sourceData != null) {
                            sourceData.close();
                        }
                        if (client != null) {
                            client.close();
                        }
                        break block23;
                    }
                    catch (CSSException e2) {
                        this.setErrorCode(UtilTool.convertStr2Long(e2.getCode(), -10700000L));
                        this.setErrorMessage(e2.getDescription());
                        LOGGER.error((Object)e2.getMessage(), (Throwable)e2);
                    }
                    catch (Exception e3) {
                        this.setErrorCode(UtilTool.convertStr2Long(e3.getMessage(), -10700000L));
                        this.setErrorMessage(e3.getMessage());
                        LOGGER.error((Object)e3.getMessage(), (Throwable)e3);
                    }
                    break block23;
                }
                catch (Exception e) {
                    this.setErrorCode(UtilTool.convertStr2Long(e.getMessage(), -10700000L));
                    this.setErrorMessage(e.getMessage());
                    LOGGER.error((Object)e.getMessage(), (Throwable)e);
                    Object var9_9 = null;
                    try {
                        if (sourceData != null) {
                            sourceData.close();
                        }
                        if (client != null) {
                            client.close();
                        }
                        break block23;
                    }
                    catch (CSSException e2) {
                        this.setErrorCode(UtilTool.convertStr2Long(e2.getCode(), -10700000L));
                        this.setErrorMessage(e2.getDescription());
                        LOGGER.error((Object)e2.getMessage(), (Throwable)e2);
                    }
                    catch (Exception e3) {
                        this.setErrorCode(UtilTool.convertStr2Long(e3.getMessage(), -10700000L));
                        this.setErrorMessage(e3.getMessage());
                        LOGGER.error((Object)e3.getMessage(), (Throwable)e3);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                try {
                    if (sourceData != null) {
                        sourceData.close();
                    }
                    if (client != null) {
                        client.close();
                    }
                }
                catch (CSSException e2) {
                    this.setErrorCode(UtilTool.convertStr2Long(e2.getCode(), -10700000L));
                    this.setErrorMessage(e2.getDescription());
                    LOGGER.error((Object)e2.getMessage(), (Throwable)e2);
                }
                catch (Exception e3) {
                    this.setErrorCode(UtilTool.convertStr2Long(e3.getMessage(), -10700000L));
                    this.setErrorMessage(e3.getMessage());
                    LOGGER.error((Object)e3.getMessage(), (Throwable)e3);
                }
                throw throwable;
            }
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public DigestResponseSet doDigest(String digestAlg, InputStream source) {
        DigestResponseSet response;
        block12: {
            DSSClient client = null;
            response = null;
            String da = digestAlg;
            if (StringUtils.isEmpty(da)) {
                da = DSignImpl.getConfig().getDigestAlg();
            }
            client = this.getClient();
            client.connect();
            response = client.digest(source, da);
            Object var7_7 = null;
            try {
                if (client != null) {
                    client.close();
                }
                break block12;
            }
            catch (CSSException e2) {
                this.setErrorCode(UtilTool.convertStr2Long(e2.getCode(), -10700000L));
                this.setErrorMessage(e2.getDescription());
            }
            break block12;
            {
                catch (CSSException e) {
                    this.setErrorCode(UtilTool.convertStr2Long(e.getCode(), -10700000L));
                    this.setErrorMessage(e.getDescription());
                    Object var7_8 = null;
                    try {
                        if (client != null) {
                            client.close();
                        }
                        break block12;
                    }
                    catch (CSSException e2) {
                        this.setErrorCode(UtilTool.convertStr2Long(e2.getCode(), -10700000L));
                        this.setErrorMessage(e2.getDescription());
                    }
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                try {
                    if (client != null) {
                        client.close();
                    }
                }
                catch (CSSException e2) {
                    this.setErrorCode(UtilTool.convertStr2Long(e2.getCode(), -10700000L));
                    this.setErrorMessage(e2.getDescription());
                }
                throw throwable;
            }
        }
        return response;
    }

    public byte[] generateRandomData(int length) {
        if (length > Integer.MAX_VALUE) {
            this.setErrorCode(UtilTool.convertStr2Long("-10703212", -10700000L));
            this.setErrorMessage("\u53c2\u6570\u4e0d\u5408\u6cd5\uff1a\u968f\u673a\u6570\u957f\u5ea6\u592a\u5927\uff0c\u8bf7\u8f93\u5165\u4e0d\u5927\u4e8e 2147483647 \u7684\u6574\u6570\uff01");
            return null;
        }
        SecureRandom secureRandom = new SecureRandom();
        byte[] randomData = new byte[length];
        secureRandom.nextBytes(randomData);
        return randomData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String getServerVersion() {
        String version;
        block11: {
            version = null;
            DSSClient client = null;
            client = this.getClient();
            client.connect();
            version = client.getServerVersion();
            Object var5_3 = null;
            try {
                if (client != null) {
                    client.close();
                }
                break block11;
            }
            catch (CSSException e2) {
                this.setErrorCode(UtilTool.convertStr2Long(e2.getCode(), -10700000L));
                this.setErrorMessage(e2.getDescription());
            }
            break block11;
            {
                catch (CSSException e) {
                    this.setErrorCode(UtilTool.convertStr2Long(e.getCode(), -10700000L));
                    this.setErrorMessage(e.getDescription());
                    Object var5_4 = null;
                    try {
                        if (client != null) {
                            client.close();
                        }
                        break block11;
                    }
                    catch (CSSException e2) {
                        this.setErrorCode(UtilTool.convertStr2Long(e2.getCode(), -10700000L));
                        this.setErrorMessage(e2.getDescription());
                    }
                }
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                try {
                    if (client != null) {
                        client.close();
                    }
                }
                catch (CSSException e2) {
                    this.setErrorCode(UtilTool.convertStr2Long(e2.getCode(), -10700000L));
                    this.setErrorMessage(e2.getDescription());
                }
                throw throwable;
            }
        }
        return version;
    }
}

