/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.assp.client;

import cn.com.jit.assp.client.BaseDSSClient;
import cn.com.jit.assp.client.DSSClient;
import cn.com.jit.assp.client.processor.Connection;
import cn.com.jit.assp.css.client.CSSException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DSSClientHttpUrlConnectionImpl
extends BaseDSSClient
implements DSSClient {
    private static final Log LOGGER = LogFactory.getLog(DSSClientHttpUrlConnectionImpl.class);
    private HttpURLConnection httpUrlConnection;

    public DSSClientHttpUrlConnectionImpl() {
    }

    public DSSClientHttpUrlConnectionImpl(Properties props) {
        super(props);
    }

    public void connect() throws CSSException {
        try {
            URL url = new URL(this.getServerURL());
            this.httpUrlConnection = (HttpURLConnection)url.openConnection();
            this.httpUrlConnection.setDoOutput(true);
            this.httpUrlConnection.setUseCaches(false);
            this.httpUrlConnection.setRequestMethod("POST");
            this.httpUrlConnection.setRequestProperty("Content-Type", "text/xml;charset=UTF-8");
        }
        catch (ProtocolException e) {
            LOGGER.error((Object)("errorCode: -10700000, errorMessage: " + e.getMessage()), (Throwable)e);
            throw new CSSException("-10700000", e.getMessage(), e);
        }
        catch (MalformedURLException e) {
            LOGGER.error((Object)("errorCode: -10700000, errorMessage: " + e.getMessage()), (Throwable)e);
            throw new CSSException("-10700000", e.getMessage(), e);
        }
        catch (IOException e) {
            LOGGER.error((Object)("errorCode: -10700000, errorMessage: " + e.getMessage()), (Throwable)e);
            throw new CSSException("-10700000", e.getMessage(), e);
        }
    }

    public void close() throws CSSException {
        if (this.httpUrlConnection != null) {
            try {
                InputStream in = this.getConnection().getInputStream();
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                LOGGER.error((Object)"Close input stream occure error", (Throwable)e);
                throw new CSSException("Close input stream occure error", e);
            }
        }
        this.httpUrlConnection.disconnect();
        this.httpUrlConnection = null;
    }

    protected Connection getConnection() {
        Connection connection = new Connection(){
            private InputStream in;

            public InputStream getInputStream() throws IOException {
                return this.in == null ? DSSClientHttpUrlConnectionImpl.this.httpUrlConnection.getInputStream() : this.in;
            }

            public OutputStream getOutputStream() throws IOException {
                return DSSClientHttpUrlConnectionImpl.this.httpUrlConnection.getOutputStream();
            }

            public void open() throws IOException {
            }

            public void close() throws IOException {
            }
        };
        return connection;
    }

    public HttpURLConnection getHttpUrlConnection() {
        return this.httpUrlConnection;
    }
}

