/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.assp.client;

import cn.com.jit.assp.client.DSSClient;
import cn.com.jit.assp.client.processor.Connection;
import cn.com.jit.assp.client.processor.HttpProcessor;
import cn.com.jit.assp.client.request.DSignRequestSet;
import cn.com.jit.assp.client.request.DecryptEnvelopRequestSet;
import cn.com.jit.assp.client.request.DigestRequestSet;
import cn.com.jit.assp.client.request.EncryptEnvelopRequestSet;
import cn.com.jit.assp.client.request.P1VSignRequestSet;
import cn.com.jit.assp.client.request.ServerVersionRequestSet;
import cn.com.jit.assp.client.request.SymmDecryptRequestSet;
import cn.com.jit.assp.client.request.SymmEncryptRequestSet;
import cn.com.jit.assp.client.request.TSAFindRequestSet;
import cn.com.jit.assp.client.request.TSASignRequestSet;
import cn.com.jit.assp.client.request.TSAVerifyRequestSet;
import cn.com.jit.assp.client.request.VSignRequestSet;
import cn.com.jit.assp.client.response.DSignResponseSet;
import cn.com.jit.assp.client.response.DecryptEnvelopResponseSet;
import cn.com.jit.assp.client.response.DigestResponseSet;
import cn.com.jit.assp.client.response.EncryptEnvelopResponseSet;
import cn.com.jit.assp.client.response.ExceptionRespSet;
import cn.com.jit.assp.client.response.ResponseSet;
import cn.com.jit.assp.client.response.ServerVersionResponseSet;
import cn.com.jit.assp.client.response.SymmDecryptResponseSet;
import cn.com.jit.assp.client.response.SymmEncryptResponseSet;
import cn.com.jit.assp.client.response.TSAFindResponseSet;
import cn.com.jit.assp.client.response.TSASignResponseSet;
import cn.com.jit.assp.client.response.TSAVerifyResponseSet;
import cn.com.jit.assp.client.response.VSignResponseItems;
import cn.com.jit.assp.client.response.VSignResponseSet;
import cn.com.jit.assp.client.util.FileUtils;
import cn.com.jit.assp.css.client.CSSException;
import cn.com.jit.assp.css.client.log.ErrorProcess;
import cn.com.jit.assp.css.client.util.SecurityUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Properties;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class BaseDSSClient
implements DSSClient {
    private static final Log LOGGER = LogFactory.getLog(BaseDSSClient.class);
    private Properties properties;
    private InputStream responseDataStream;
    private Reader responseDataReader;

    public BaseDSSClient() {
    }

    public BaseDSSClient(Properties props) {
        this.properties = props;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public String getServerURL() {
        return this.properties.getProperty("ServerURL");
    }

    public InputStream getResponseDataAsStream() {
        return this.responseDataStream;
    }

    public Reader getResponseDataAsReader() {
        return this.responseDataReader;
    }

    private static InputStream sign(Connection connection, String appID, InputStream source, String digestAlgID, int signMode, int plainDateType) throws CSSException {
        DSignRequestSet request = new DSignRequestSet(source);
        request.setAppId(appID);
        request.setDigestAlg(digestAlgID);
        request.setDsignMode(signMode);
        request.setPlainDateType(plainDateType);
        HttpProcessor processor = new HttpProcessor(connection);
        ResponseSet response = processor.process(request);
        if (response instanceof ExceptionRespSet || !response.isSucceed()) {
            throw new CSSException(response.getErrorCode(), response.getErrorMessage());
        }
        return ((DSignResponseSet)response).getSignedDataStream();
    }

    private void sign(Connection connection, String appID, String digestAlgID, File sourceFile, File outputFile, int signMode, int plainDateType) throws CSSException {
        if (sourceFile == null || !sourceFile.exists()) {
            throw new CSSException(Integer.toString(-10703110), "\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u539f\u6587\u6587\u4ef6\u7684\u5168\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        try {
            DSignRequestSet request = new DSignRequestSet(null);
            request.setAppId(appID);
            request.setDigestAlg(digestAlgID);
            request.setDsignMode(signMode);
            request.setPlainDateType(plainDateType);
            request.setFile(sourceFile);
            HttpProcessor processor = new HttpProcessor(connection);
            ResponseSet response = processor.process(request);
            if (response instanceof ExceptionRespSet || !response.isSucceed()) {
                throw new CSSException(response.getErrorCode(), response.getErrorMessage());
            }
            if (outputFile == null) {
                this.responseDataReader = ((DSignResponseSet)response).getSignedDataReader();
                this.responseDataStream = ((DSignResponseSet)response).getSignedDataStream();
                return;
            }
            Reader signedData = ((DSignResponseSet)response).getSignedDataReader();
            FileUtils.wirteReader2File(outputFile, signedData);
            signedData.close();
            this.responseDataStream = null;
            this.responseDataReader = null;
        }
        catch (IOException e) {
            throw new CSSException("-10701103", "\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u7b7e\u540d\u65f6\u8f93\u5165\u539f\u6587\u6587\u4ef6\u672a\u627e\u5230\uff01", e);
        }
    }

    private static VSignResponseSet verifySign(Connection connection, InputStream source, InputStream signedResult, VSignResponseItems responseItems, int verifyMode) throws CSSException {
        VSignRequestSet request = new VSignRequestSet(source, signedResult);
        request.setResponseItems(responseItems);
        request.setVerifyMode(verifyMode);
        HttpProcessor processor = new HttpProcessor(connection);
        ResponseSet response = processor.process(request);
        if (response instanceof ExceptionRespSet || !response.isSucceed()) {
            throw new CSSException(response.getErrorCode(), response.getErrorMessage());
        }
        return (VSignResponseSet)response;
    }

    private static VSignResponseSet verifySign(Connection connection, File source, InputStream signedResult, VSignResponseItems responseItems, int verifyMode) throws CSSException {
        ResponseSet response = null;
        try {
            VSignRequestSet request = new VSignRequestSet(null, signedResult);
            request.setResponseItems(responseItems);
            request.setVerifyMode(verifyMode);
            if (source != null) {
                request.setSourceFile(source);
            }
            HttpProcessor processor = new HttpProcessor(connection);
            response = processor.process(request);
        }
        catch (IOException e) {
            throw new CSSException("-10703101", "\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u539f\u6587\u8f93\u5165\u4e3a\u7a7a\uff01", e);
        }
        if (response instanceof ExceptionRespSet || !response.isSucceed()) {
            throw new CSSException(response.getErrorCode(), response.getErrorMessage());
        }
        return (VSignResponseSet)response;
    }

    private static InputStream encryptEnvelop(Connection connection, String signCertAlias, String[] encryptCertAlias, InputStream source, String encAlg, String digestAlg, int envelopMode) throws CSSException {
        EncryptEnvelopRequestSet request = new EncryptEnvelopRequestSet(source);
        request.setCertAlias(encryptCertAlias);
        request.setEncryptAlg(encAlg);
        request.setDigestAlg(digestAlg);
        request.setEnvelopMode(envelopMode);
        request.setAppId(signCertAlias);
        HttpProcessor processor = new HttpProcessor(connection);
        ResponseSet response = processor.process(request);
        if (response instanceof ExceptionRespSet || !response.isSucceed()) {
            throw new CSSException(response.getErrorCode(), response.getErrorMessage());
        }
        EncryptEnvelopResponseSet envelopResp = (EncryptEnvelopResponseSet)response;
        return envelopResp.getEnvelopDataStream();
    }

    private void encryptEnvelop(Connection connection, String signCertAlias, String[] encryptCertAlias, File sourceFile, File outEnvelopFile, String encAlg, String digestAlgID, int envelopMode) throws CSSException {
        if (sourceFile == null || !sourceFile.exists()) {
            throw new CSSException(Integer.toString(-10703109), "\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u63a5\u6536\u65b9\u7b7e\u540d\u8bc1\u4e66\u7684ID\u6216DN\uff0c\u539f\u6587\u6587\u4ef6\u7684\u5168\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        try {
            EncryptEnvelopRequestSet request = new EncryptEnvelopRequestSet(null);
            request.setCertAlias(encryptCertAlias);
            request.setEncryptAlg(encAlg);
            request.setDigestAlg(digestAlgID);
            request.setEnvelopMode(envelopMode);
            request.setSrcFile(sourceFile);
            request.setAppId(signCertAlias);
            HttpProcessor processor = new HttpProcessor(connection);
            ResponseSet response = processor.process(request);
            if (response instanceof ExceptionRespSet || !response.isSucceed()) {
                throw new CSSException(response.getErrorCode(), response.getErrorMessage());
            }
            if (outEnvelopFile == null) {
                this.responseDataReader = ((EncryptEnvelopResponseSet)response).getEnvelopDataReader();
                this.responseDataStream = ((EncryptEnvelopResponseSet)response).getEnvelopDataStream();
                return;
            }
            Reader envelopedData = ((EncryptEnvelopResponseSet)response).getEnvelopDataReader();
            FileUtils.wirteReader2File(outEnvelopFile, envelopedData);
            envelopedData.close();
            this.responseDataStream = null;
            this.responseDataReader = null;
        }
        catch (IOException e) {
            throw new CSSException(Integer.toString(-10703109), "\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u63a5\u6536\u65b9\u7b7e\u540d\u8bc1\u4e66\u7684ID\u6216DN\uff0c\u539f\u6587\u6587\u4ef6\u7684\u5168\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a\uff01", e);
        }
    }

    private static DecryptEnvelopResponseSet decryptEnvelop(Connection connection, InputStream envelopData, int envelopMode) throws CSSException {
        DecryptEnvelopRequestSet request = new DecryptEnvelopRequestSet(envelopData);
        request.setEnvelopMode(envelopMode);
        HttpProcessor processor = new HttpProcessor(connection);
        ResponseSet response = processor.process(request);
        if (response instanceof ExceptionRespSet || !response.isSucceed()) {
            throw new CSSException(response.getErrorCode(), response.getErrorMessage());
        }
        return (DecryptEnvelopResponseSet)response;
    }

    private static void verifyLocalDigest(VSignResponseSet response, InputStream source) throws NoSuchAlgorithmException, IOException {
        String vHashAlg = response.getDigestAlg();
        boolean vCompHashResult = false;
        if (vHashAlg != null && vHashAlg.length() > 0 && response.getDigestData() != null && response.getDigestData().length > 0) {
            byte[] localDigestData = SecurityUtil.doDigest(source, vHashAlg);
            byte[] vDigestData = Base64.decodeBase64((byte[])response.getDigestData());
            vCompHashResult = Arrays.equals(localDigestData, vDigestData);
        }
        if (!vCompHashResult) {
            response.setSucceed(false);
            response.setErrorCode(ErrorProcess.vVerifyFailErrNo);
        }
    }

    private static DigestResponseSet digest(Connection connection, InputStream source, String digestAlg) throws CSSException {
        DigestRequestSet request = new DigestRequestSet(source);
        request.setDigestAlg(digestAlg);
        HttpProcessor processor = new HttpProcessor(connection);
        ResponseSet response = processor.process(request);
        if (response instanceof ExceptionRespSet || !response.isSucceed()) {
            throw new CSSException(response.getErrorCode(), response.getErrorMessage());
        }
        return (DigestResponseSet)response;
    }

    private static InputStream symmEncrypt(Connection connection, String keyId, InputStream source) throws CSSException {
        if (keyId == null || keyId.trim().length() == 0) {
            throw new CSSException("-10703200", "\u52a0\u5bc6\u64cd\u4f5c\uff1a\u5bf9\u79f0\u5bc6\u94a5\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (source == null) {
            throw new CSSException("-10703201", "\u52a0\u5bc6\u64cd\u4f5c\uff1a\u52a0\u5bc6\u539f\u6587\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SymmEncryptRequestSet request = new SymmEncryptRequestSet();
        request.setSymmKeyNo(keyId);
        request.setPlainData(source);
        HttpProcessor processor = new HttpProcessor(connection);
        ResponseSet response = processor.process(request);
        if (response instanceof ExceptionRespSet || !response.isSucceed()) {
            throw new CSSException(response.getErrorCode(), response.getErrorMessage());
        }
        return ((SymmEncryptResponseSet)response).getEncryptDataStream();
    }

    private static SymmDecryptResponseSet symmDecrypt(Connection connection, String keyId, InputStream encryptDataIn) throws CSSException {
        if (keyId == null || keyId.trim().length() == 0) {
            throw new CSSException("-10703202", "\u89e3\u5bc6\u64cd\u4f5c\uff1a\u5bf9\u79f0\u5bc6\u94a5\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (encryptDataIn == null) {
            throw new CSSException("-10703203", "\u89e3\u5bc6\u64cd\u4f5c\uff1a\u52a0\u5bc6\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SymmDecryptRequestSet request = new SymmDecryptRequestSet();
        request.setSymmKeyNo(keyId);
        request.setEncryptData(encryptDataIn);
        HttpProcessor processor = new HttpProcessor(connection);
        ResponseSet response = processor.process(request);
        if (response instanceof ExceptionRespSet || !response.isSucceed()) {
            throw new CSSException(response.getErrorCode(), response.getErrorMessage());
        }
        return (SymmDecryptResponseSet)response;
    }

    private TSASignResponseSet signTimeStamp(Connection connection, String digestAlg, InputStream source) throws CSSException {
        TSASignRequestSet request = new TSASignRequestSet();
        request.setDigestAlg(digestAlg);
        String tsaType = this.properties.getProperty("TSAType");
        if ("rfc3161".equals(tsaType)) {
            try {
                byte[] sourceDigest = SecurityUtil.doDigest(source, digestAlg);
                source = new ByteArrayInputStream(sourceDigest);
            }
            catch (Exception e) {
                LOGGER.error((Object)("TSA signature occuer error: do local digest TSAType [" + tsaType + "]"), (Throwable)e);
                throw new CSSException("TSA signature occuer error: do local digest TSAType [" + tsaType + "]", e);
            }
        }
        request.setSource(source);
        request.setTsaType(tsaType);
        HttpProcessor processor = new HttpProcessor(connection);
        ResponseSet response = processor.process(request);
        if (response instanceof ExceptionRespSet || !response.isSucceed()) {
            throw new CSSException(response.getErrorCode(), response.getErrorMessage());
        }
        return (TSASignResponseSet)response;
    }

    private TSAVerifyResponseSet verifyTimeStamp(Connection connection, InputStream tsaData) throws CSSException {
        TSAVerifyRequestSet request = new TSAVerifyRequestSet();
        request.setTsaData(tsaData);
        request.setTsaType(this.properties.getProperty("TSAType"));
        HttpProcessor processor = new HttpProcessor(connection);
        ResponseSet response = processor.process(request);
        if (response instanceof ExceptionRespSet || !response.isSucceed()) {
            throw new CSSException(response.getErrorCode(), response.getErrorMessage());
        }
        return (TSAVerifyResponseSet)response;
    }

    private static InputStream findTimeStampByID(Connection connection, String tsaID) throws CSSException {
        TSAFindRequestSet request = new TSAFindRequestSet();
        request.setTsaId(tsaID);
        HttpProcessor processor = new HttpProcessor(connection);
        ResponseSet response = processor.process(request);
        if (response instanceof ExceptionRespSet || !response.isSucceed()) {
            throw new CSSException(response.getErrorCode(), response.getErrorMessage());
        }
        return ((TSAFindResponseSet)response).getTsaData();
    }

    private VSignResponseSet verifyP1Sign(Connection connection, String issuerAndSN, String digestAlg, String encryptAlg, InputStream source, InputStream signedData, VSignResponseItems responseItems, int verifySignMode) throws CSSException {
        P1VSignRequestSet request = new P1VSignRequestSet(source, signedData);
        request.setIssuerAndSN(issuerAndSN);
        request.setDigestAlg(digestAlg);
        request.setEncryptAlg(encryptAlg);
        request.setResponseItems(responseItems);
        request.setVerifyMode(verifySignMode);
        request.setP1VerifyCertId((String)this.properties.get("p1VerifyCertId"));
        HttpProcessor processor = new HttpProcessor(connection);
        ResponseSet response = processor.process(request);
        if (response instanceof ExceptionRespSet || !response.isSucceed()) {
            throw new CSSException(response.getErrorCode(), response.getErrorMessage());
        }
        return (VSignResponseSet)response;
    }

    private String getServerVersion(Connection connection) throws CSSException {
        HttpProcessor processor = new HttpProcessor(connection);
        ServerVersionRequestSet request = new ServerVersionRequestSet(this);
        ResponseSet response = processor.process(request);
        if (response instanceof ExceptionRespSet || !response.isSucceed()) {
            throw new CSSException(response.getErrorCode(), response.getErrorMessage());
        }
        return ((ServerVersionResponseSet)response).getServerVersion();
    }

    public InputStream attachSign(String appID, String digestAlgID, InputStream source) throws CSSException {
        Connection connection = this.getConnection();
        return BaseDSSClient.sign(connection, appID, source, digestAlgID, 3, 0);
    }

    public void attachSign(String appID, String digestAlgID, File sourceFile, File outputFile) throws CSSException {
        Connection connection = this.getConnection();
        this.sign(connection, appID, digestAlgID, sourceFile, outputFile, 3, 0);
    }

    public InputStream detachSign(String appID, String digestAlgID, InputStream source) throws CSSException {
        Connection connection = this.getConnection();
        int plainDateType = 0;
        String hp = (String)this.properties.get("HashActionPosition");
        if (hp != null && !hp.equals("0")) {
            try {
                source = new ByteArrayInputStream(SecurityUtil.doDigest(source, digestAlgID));
                plainDateType = 1;
            }
            catch (NoSuchAlgorithmException e) {
                throw new CSSException(e.getMessage(), e);
            }
            catch (IOException e) {
                throw new CSSException(e.getMessage(), e);
            }
        }
        return BaseDSSClient.sign(connection, appID, source, digestAlgID, 1, plainDateType);
    }

    public void detachSign(String appID, String digestAlgID, File sourceFile, File outputFile) throws CSSException {
        Connection connection = this.getConnection();
        int plainDateType = 0;
        this.sign(connection, appID, digestAlgID, sourceFile, outputFile, 1, plainDateType);
    }

    public InputStream simpleSign(String applyID, String digestAlgID, InputStream source) throws CSSException {
        Connection connection = this.getConnection();
        int plainDateType = 0;
        String hp = (String)this.properties.get("HashActionPosition");
        if (hp != null && !hp.equals("0")) {
            try {
                source = new ByteArrayInputStream(SecurityUtil.doDigest(source, digestAlgID));
                plainDateType = 1;
            }
            catch (NoSuchAlgorithmException e) {
                throw new CSSException(e.getMessage(), e);
            }
            catch (IOException e) {
                throw new CSSException(e.getMessage(), e);
            }
        }
        return BaseDSSClient.sign(connection, applyID, source, digestAlgID, 0, plainDateType);
    }

    public InputStream sign4SubsequentVSign(String appID, String digestAlgID, InputStream source) throws CSSException {
        Connection connection = this.getConnection();
        return BaseDSSClient.sign(connection, appID, source, digestAlgID, 4, 0);
    }

    public void sign4SubsequentVSign(String appID, String digestAlgID, File sourceFile, File signDataOutFile) throws CSSException {
        Connection connection = this.getConnection();
        this.sign(connection, appID, digestAlgID, sourceFile, signDataOutFile, 4, 0);
    }

    public VSignResponseSet verifyAttachSign(InputStream signedResult, VSignResponseItems responseItems) {
        Connection connection = this.getConnection();
        VSignResponseSet response = null;
        try {
            InputStream source = null;
            response = BaseDSSClient.verifySign(connection, source, signedResult, responseItems, 0);
        }
        catch (CSSException e) {
            response = new VSignResponseSet("1.0");
            response.setSucceed(false);
            response.setErrorCode(e.getCode());
            response.setErrorMessage(e.getDescription());
        }
        return response;
    }

    public VSignResponseSet verifyDetachSign(InputStream source, InputStream signedResult, VSignResponseItems responseItems) {
        Connection connection = this.getConnection();
        VSignResponseSet response = null;
        int verifySignMode = 0;
        String hp = (String)this.properties.get("HashActionPosition");
        InputStream sourceIn = source;
        try {
            if (hp != null && !hp.equals("0")) {
                verifySignMode = 2;
                sourceIn = null;
            }
            if (!(response = BaseDSSClient.verifySign(connection, sourceIn, signedResult, responseItems, verifySignMode)).isSucceed()) {
                return response;
            }
            if (hp != null && !hp.equals("0")) {
                BaseDSSClient.verifyLocalDigest(response, source);
            }
        }
        catch (CSSException e) {
            response = new VSignResponseSet("1.0");
            response.setSucceed(false);
            response.setErrorCode(e.getCode());
            response.setErrorMessage(e.getDescription());
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            response = new VSignResponseSet("1.0");
            response.setSucceed(false);
            response.setErrorCode("-");
            response.setErrorMessage(e.getMessage());
            LOGGER.error((Object)("errorcode: 10700000, errorMessage: " + e.getMessage()), (Throwable)e);
        }
        return response;
    }

    public VSignResponseSet verifyDetachSign(File source, InputStream signedResult, VSignResponseItems responseItems) {
        Connection connection = this.getConnection();
        VSignResponseSet response = null;
        int verifySignMode = 0;
        try {
            response = BaseDSSClient.verifySign(connection, source, signedResult, responseItems, verifySignMode);
        }
        catch (CSSException e) {
            response = new VSignResponseSet("1.0");
            response.setSucceed(false);
            response.setErrorCode(e.getCode());
            response.setErrorMessage(e.getDescription());
        }
        catch (Exception e) {
            response = new VSignResponseSet("1.0");
            response.setSucceed(false);
            response.setErrorCode("-10700000");
            response.setErrorMessage(e.getMessage());
            LOGGER.error((Object)("errorcode: 10700000, errorMessage: " + e.getMessage()), (Throwable)e);
        }
        return response;
    }

    public VSignResponseSet verifySubsequent(InputStream signedData, VSignResponseItems responseItems) {
        Connection connection = this.getConnection();
        InputStream source = null;
        VSignResponseSet response = null;
        try {
            response = BaseDSSClient.verifySign(connection, source, signedData, responseItems, 0);
        }
        catch (CSSException e) {
            response = new VSignResponseSet("1.0");
            response.setSucceed(false);
            response.setErrorCode(e.getCode());
            response.setErrorMessage(e.getDescription());
        }
        return response;
    }

    public InputStream encryptEnvelop(String[] encryptCertAlias, InputStream source, String encAlg, String digestAlg) throws CSSException {
        Connection connection = this.getConnection();
        return BaseDSSClient.encryptEnvelop(connection, null, encryptCertAlias, source, encAlg, digestAlg, 1);
    }

    public void encryptSignEnvelop(String[] encryptCertAlias, File sourceFilePath, File outFile, String encAlg, String digestAlgID) throws CSSException {
        Connection connection = this.getConnection();
        try {
            InputStream envelopData = BaseDSSClient.encryptEnvelop(connection, null, encryptCertAlias, new FileInputStream(sourceFilePath), encAlg, digestAlgID, 1);
            if (envelopData == null) {
                throw new CSSException("Encrypt signEnvelop occuer error: the envelop data is null!");
            }
            FileUtils.writeStream2File(outFile, envelopData);
        }
        catch (IOException e) {
            throw new CSSException("Encrypt signEnvelop occuer error", e);
        }
    }

    public DecryptEnvelopResponseSet decryptEnvelop(InputStream envelopDataIn) {
        Connection connection = this.getConnection();
        DecryptEnvelopResponseSet response = null;
        try {
            response = BaseDSSClient.decryptEnvelop(connection, envelopDataIn, 1);
        }
        catch (CSSException e) {
            response = new DecryptEnvelopResponseSet("1.0");
            response.setSucceed(false);
            response.setErrorCode(e.getCode());
            response.setErrorMessage(e.getDescription());
        }
        return response;
    }

    public DecryptEnvelopResponseSet decryptSignEnvelop(InputStream envelopDataIn) {
        Connection connection = this.getConnection();
        DecryptEnvelopResponseSet response = null;
        try {
            response = BaseDSSClient.decryptEnvelop(connection, envelopDataIn, 2);
        }
        catch (CSSException e) {
            response = new DecryptEnvelopResponseSet("1.0");
            response.setSucceed(false);
            response.setErrorCode(e.getCode());
            response.setErrorMessage(e.getDescription());
        }
        return response;
    }

    public void encryptEnvelop(String[] encryptCertAlias, File sourceFile, File outEnvelopFile, String encAlg, String digestAlgID) throws CSSException {
        Connection connection = this.getConnection();
        this.encryptEnvelop(connection, null, encryptCertAlias, sourceFile, outEnvelopFile, encAlg, digestAlgID, 1);
    }

    public InputStream encryptSignEnvelop(String signCertAlias, String[] encryptCertAlias, InputStream source, String encAlg, String digestAlg) throws CSSException {
        Connection connection = this.getConnection();
        return BaseDSSClient.encryptEnvelop(connection, signCertAlias, encryptCertAlias, source, encAlg, digestAlg, 2);
    }

    public void encryptSignEnvelop(String signCertAlias, String[] encryptCertAlias, File sourceFile, File outEnvelopFile, String encAlg, String digestAlgID) throws CSSException {
        Connection connection = this.getConnection();
        this.encryptEnvelop(connection, signCertAlias, encryptCertAlias, sourceFile, outEnvelopFile, encAlg, digestAlgID, 2);
    }

    public DigestResponseSet digest(InputStream source, String digestAlg) throws CSSException {
        Connection connection = this.getConnection();
        return BaseDSSClient.digest(connection, source, digestAlg);
    }

    public InputStream symmEncrypt(String keyId, InputStream source) throws CSSException {
        Connection connection = this.getConnection();
        return BaseDSSClient.symmEncrypt(connection, keyId, source);
    }

    public SymmDecryptResponseSet symmDecrypt(String keyId, InputStream encryptDataIn) {
        Connection connection = this.getConnection();
        SymmDecryptResponseSet response = null;
        try {
            response = BaseDSSClient.symmDecrypt(connection, keyId, encryptDataIn);
        }
        catch (CSSException e) {
            response = new SymmDecryptResponseSet("1.0");
            response.setSucceed(false);
            response.setErrorCode(e.getCode());
            response.setErrorMessage(e.getDescription());
        }
        return response;
    }

    public TSASignResponseSet signTimeStamp(String digestAlg, InputStream source) throws CSSException {
        Connection connection = this.getConnection();
        return this.signTimeStamp(connection, digestAlg, source);
    }

    public TSAVerifyResponseSet verifyTimeStamp(InputStream tsaData) {
        Connection connection = this.getConnection();
        TSAVerifyResponseSet response = null;
        try {
            response = this.verifyTimeStamp(connection, tsaData);
        }
        catch (CSSException e) {
            response = new TSAVerifyResponseSet("1.0");
            response.setSucceed(false);
            response.setErrorCode(e.getCode());
            response.setErrorMessage(e.getDescription());
        }
        return response;
    }

    public InputStream findTimeStampByID(String tsaID) throws CSSException {
        Connection connection = this.getConnection();
        return BaseDSSClient.findTimeStampByID(connection, tsaID);
    }

    public InputStream p1Sign(String certDN, String digestAlg, InputStream source) throws CSSException {
        Connection connection = this.getConnection();
        return BaseDSSClient.sign(connection, certDN, source, digestAlg, 0, 3);
    }

    public VSignResponseSet p1Verify(String issuerAndSN, String digestAlg, String encryptAlg, InputStream signedData, InputStream source, VSignResponseItems responseItems) {
        Connection connection = this.getConnection();
        VSignResponseSet response = null;
        try {
            response = this.verifyP1Sign(connection, issuerAndSN, digestAlg, encryptAlg, source, signedData, responseItems, 3);
        }
        catch (CSSException e) {
            response = new VSignResponseSet("3");
            response.setSucceed(false);
            response.setErrorCode(e.getCode());
            response.setErrorMessage(e.getDescription());
        }
        return response;
    }

    public String getServerVersion() throws CSSException {
        Connection connection = this.getConnection();
        return this.getServerVersion(connection);
    }

    public abstract void connect() throws CSSException;

    public abstract void close() throws CSSException;

    protected abstract Connection getConnection();
}

