/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.assp.client;

import cn.com.jit.assp.client.DSSClient;
import cn.com.jit.assp.client.DSSClientFactory;
import cn.com.jit.assp.client.DSign;
import cn.com.jit.assp.client.response.AbstractRespSet;
import cn.com.jit.assp.client.response.DecryptEnvelopResponseSet;
import cn.com.jit.assp.client.response.ResponseSet;
import cn.com.jit.assp.client.response.VSignResponseItems;
import cn.com.jit.assp.client.response.VSignResponseSet;
import cn.com.jit.assp.client.util.FileUtils;
import cn.com.jit.assp.client.util.StringUtils;
import cn.com.jit.assp.css.client.CSSException;
import cn.com.jit.assp.css.client.Config;
import cn.com.jit.assp.css.client.util.UtilTool;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.codec.binary.Base64InputStream;
import org.apache.commons.codec.binary.Base64OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractDSign
implements DSign {
    private static final Log LOGGER = LogFactory.getLog(AbstractDSign.class);
    private static Config config;
    private long errorCode;
    private String errorMessage;

    public AbstractDSign(String configFilePath) {
        this.init(configFilePath);
    }

    public AbstractDSign(Config config) {
        AbstractDSign.config = config;
        AbstractDSign.config.putConfigValues2Properties();
    }

    private void init(String filePath) {
        if (config != null) {
            return;
        }
        try {
            config = Config.getInstance();
            config.loadConfig(filePath, false);
        }
        catch (CSSException cSSException) {
            // empty catch block
        }
    }

    private void writeInputStream2SourceStore(InputStream returnSource, Object sourceStore, ResponseSet response) throws IOException {
        if (sourceStore != null && returnSource != null) {
            if (sourceStore instanceof OutputStream) {
                returnSource = new Base64InputStream(returnSource, false);
                OutputStream source = (OutputStream)sourceStore;
                IOUtils.copy((InputStream)returnSource, (OutputStream)source);
                source.flush();
            } else if (sourceStore instanceof String && !StringUtils.isEmpty((String)sourceStore)) {
                String sourceStorePath = "";
                if (response instanceof VSignResponseSet) {
                    sourceStorePath = ((VSignResponseSet)response).getFileName();
                } else if (response instanceof DecryptEnvelopResponseSet) {
                    sourceStorePath = ((DecryptEnvelopResponseSet)response).getFileName();
                }
                File sourceParent = new File((String)sourceStore);
                if (!sourceParent.isDirectory() && !sourceParent.mkdir()) {
                    return;
                }
                sourceStorePath = (String)sourceStore + File.separator + sourceStorePath;
                returnSource = new Base64InputStream(returnSource, false);
                FileUtils.writeStream2File(new File(sourceStorePath), returnSource);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void encryptEnvelop(String[] encryptCertAlias, Object source, String encryptAlg, String digestAlg, OutputStream envelopedDataStore) throws CSSException, IOException {
        InputStream envelopedData;
        DSSClient client4Envelop;
        block13: {
            block11: {
                block12: {
                    client4Envelop = null;
                    envelopedData = null;
                    try {
                        client4Envelop = this.getClient();
                        client4Envelop.connect();
                        if (source instanceof InputStream) {
                            envelopedData = client4Envelop.encryptEnvelop(encryptCertAlias, (InputStream)source, encryptAlg, digestAlg);
                        } else if (source instanceof File) {
                            client4Envelop.encryptEnvelop(encryptCertAlias, (File)source, null, encryptAlg, digestAlg);
                            envelopedData = client4Envelop.getResponseDataAsStream();
                        } else {
                            Object var10_8 = null;
                            if (envelopedData == null) break block11;
                            break block12;
                        }
                        IOUtils.copy((InputStream)envelopedData, (OutputStream)envelopedDataStore);
                        envelopedDataStore.flush();
                        break block13;
                    }
                    catch (Throwable throwable) {
                        Object var10_10 = null;
                        if (envelopedData != null) {
                            envelopedData.close();
                        }
                        if (client4Envelop == null) throw throwable;
                        client4Envelop.close();
                        throw throwable;
                    }
                }
                envelopedData.close();
            }
            if (client4Envelop == null) return;
            client4Envelop.close();
            return;
        }
        Object var10_9 = null;
        if (envelopedData != null) {
            envelopedData.close();
        }
        if (client4Envelop == null) return;
        client4Envelop.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void encryptSignEnvelop(String signCertId, String[] encryptCertAlias, Object source, String encryptAlg, String digestAlg, OutputStream envelopedDataStore) throws CSSException, IOException {
        InputStream encryptSource;
        ByteArrayOutputStream signedDataStore;
        block14: {
            block12: {
                block13: {
                    signedDataStore = null;
                    encryptSource = null;
                    try {
                        signedDataStore = new ByteArrayOutputStream();
                        long res = 0L;
                        if (source instanceof InputStream) {
                            res = this.signature(signCertId, (InputStream)source, signedDataStore, 1);
                        } else if (source instanceof File) {
                            res = this.signature(signCertId, (File)source, signedDataStore, 1);
                        } else {
                            Object var12_11 = null;
                            if (signedDataStore == null) break block12;
                            break block13;
                        }
                        if (res != 0L) {
                            throw new CSSException("" + this.getErrorCode(), this.getErrorMessage());
                        }
                        encryptSource = new ByteArrayInputStream(signedDataStore.toByteArray());
                        this.encryptEnvelop(encryptCertAlias, encryptSource, encryptAlg, digestAlg, envelopedDataStore);
                        break block14;
                    }
                    catch (Throwable throwable) {
                        Object var12_13 = null;
                        if (signedDataStore != null) {
                            signedDataStore.close();
                        }
                        if (encryptSource == null) throw throwable;
                        encryptSource.close();
                        throw throwable;
                    }
                }
                signedDataStore.close();
            }
            if (encryptSource == null) return;
            encryptSource.close();
            return;
        }
        Object var12_12 = null;
        if (signedDataStore != null) {
            signedDataStore.close();
        }
        if (encryptSource == null) return;
        encryptSource.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    private ResponseSet decryptEnvelopPriv(InputStream envelopedData, Object sourceStore, boolean decode) {
        block29: {
            Object sourceS;
            DSSClient client = null;
            DecryptEnvelopResponseSet response = null;
            InputStream source = null;
            client = this.getClient();
            client.connect();
            response = client.decryptEnvelop(envelopedData);
            source = response.getSourceDataStream();
            if (response != null && response.isSucceed() && source != null) {
                if (sourceStore instanceof OutputStream) {
                    sourceS = (OutputStream)sourceStore;
                    if (decode) {
                        sourceS = new Base64OutputStream((OutputStream)sourceS, false);
                    }
                    IOUtils.copy((InputStream)source, (OutputStream)sourceS);
                    ((OutputStream)sourceS).flush();
                } else {
                    this.writeInputStream2SourceStore(source, sourceStore, response);
                }
            }
            sourceS = response;
            Object var9_10 = null;
            try {
                if (source != null) {
                    try {
                        source.close();
                    }
                    catch (IOException e2) {
                        LOGGER.error((Object)"", (Throwable)e2);
                        return null;
                    }
                }
                if (client != null) {
                    client.close();
                }
            }
            catch (CSSException e3) {
                this.errorCode = UtilTool.convertStr2Long(e3.getCode(), -10700000L);
                this.errorMessage = e3.getDescription();
            }
            {
                return sourceS;
                catch (CSSException e) {
                    this.errorCode = UtilTool.convertStr2Long(e.getCode(), -10700000L);
                    this.errorMessage = e.getDescription();
                    LOGGER.error((Object)e.getMessage(), (Throwable)e);
                    Object var9_11 = null;
                    try {
                        if (source != null) {
                            try {
                                source.close();
                            }
                            catch (IOException e2) {
                                LOGGER.error((Object)"", (Throwable)e2);
                                return null;
                            }
                        }
                        if (client != null) {
                            client.close();
                        }
                        break block29;
                    }
                    catch (CSSException e3) {
                        this.errorCode = UtilTool.convertStr2Long(e3.getCode(), -10700000L);
                        this.errorMessage = e3.getDescription();
                    }
                    break block29;
                }
                catch (Exception e) {
                    this.errorCode = UtilTool.convertStr2Long(e.getMessage(), -10700000L);
                    this.errorMessage = e.getMessage();
                    LOGGER.error((Object)("errorCode: " + this.errorCode + ", errorMessage: " + this.errorMessage), (Throwable)e);
                    Object var9_12 = null;
                    try {
                        if (source != null) {
                            try {
                                source.close();
                            }
                            catch (IOException e2) {
                                LOGGER.error((Object)"", (Throwable)e2);
                                return null;
                            }
                        }
                        if (client != null) {
                            client.close();
                        }
                        break block29;
                    }
                    catch (CSSException e3) {
                        this.errorCode = UtilTool.convertStr2Long(e3.getCode(), -10700000L);
                        this.errorMessage = e3.getDescription();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                try {
                    if (source != null) {
                        try {
                            source.close();
                        }
                        catch (IOException e2) {
                            LOGGER.error((Object)"", (Throwable)e2);
                            return null;
                        }
                    }
                    if (client != null) {
                        client.close();
                    }
                }
                catch (CSSException e3) {
                    this.errorCode = UtilTool.convertStr2Long(e3.getCode(), -10700000L);
                    this.errorMessage = e3.getDescription();
                }
                throw throwable;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private ResponseSet decryptSignEnvelop(InputStream envelopedData, Object sourceStore) {
        DecryptEnvelopResponseSet response;
        block19: {
            ByteArrayOutputStream sourceOut = new ByteArrayOutputStream();
            response = (DecryptEnvelopResponseSet)this.decryptEnvelopPriv(envelopedData, sourceOut, false);
            if (!response.isSucceed()) {
                return response;
            }
            Base64InputStream signedData = null;
            signedData = new Base64InputStream((InputStream)new ByteArrayInputStream(sourceOut.toByteArray()), false);
            AbstractRespSet res = null;
            if (sourceStore instanceof OutputStream) {
                res = (VSignResponseSet)this.verify(null, (InputStream)signedData, (OutputStream)sourceStore, 1);
            } else if (sourceStore instanceof String) {
                res = (VSignResponseSet)this.verify(null, (InputStream)signedData, (String)sourceStore, 1);
            }
            if (res.isSucceed()) {
                response.setDsCertInfo(((VSignResponseSet)res).getDsCertInfo());
                response.setFileName(((VSignResponseSet)res).getFileName());
                response.setSourceDataStream(((VSignResponseSet)res).getSourceDataStream());
                response.setDsCertBase64(((VSignResponseSet)res).getDsCertBase64());
                response.setDigestAlg(((VSignResponseSet)res).getDigestAlg());
            }
            response.setErrorCode(res.getErrorCode());
            response.setErrorMessage(res.getErrorMessage());
            response.setSucceed(res.isSucceed());
            response.setSvcType(res.getSvcType());
            response.setVersion(res.getVersion());
            Object var8_8 = null;
            try {
                if (sourceOut != null) {
                    sourceOut.close();
                }
                if (signedData != null) {
                    signedData.close();
                }
                break block19;
            }
            catch (IOException e2) {
                this.errorCode = UtilTool.convertStr2Long(e2.getMessage(), -10700000L);
                this.errorMessage = e2.getMessage();
            }
            break block19;
            {
                catch (CSSException e) {
                    this.errorCode = UtilTool.convertStr2Long(e.getCode(), -10700000L);
                    this.errorMessage = e.getDescription();
                    Object var8_9 = null;
                    try {
                        if (sourceOut != null) {
                            sourceOut.close();
                        }
                        if (signedData != null) {
                            signedData.close();
                        }
                        break block19;
                    }
                    catch (IOException e2) {
                        this.errorCode = UtilTool.convertStr2Long(e2.getMessage(), -10700000L);
                        this.errorMessage = e2.getMessage();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                try {
                    if (sourceOut != null) {
                        sourceOut.close();
                    }
                    if (signedData != null) {
                        signedData.close();
                    }
                }
                catch (IOException e2) {
                    this.errorCode = UtilTool.convertStr2Long(e2.getMessage(), -10700000L);
                    this.errorMessage = e2.getMessage();
                }
                throw throwable;
            }
        }
        return response;
    }

    protected DSSClient getClient() throws CSSException {
        try {
            DSSClientFactory factory = DSSClientFactory.newInstance(config);
            return factory.newClient();
        }
        catch (Exception e) {
            LOGGER.error((Object)(" errorMessage: " + e.getMessage()), (Throwable)e);
            throw new CSSException(e.getMessage(), e);
        }
    }

    protected VSignResponseItems getVSignResponseItems() {
        String[] returnBaseItems = UtilTool.splitStr(config.getBaseInfo(), ";");
        String[] returnCertBaseItems = UtilTool.splitStr(config.getCertBaseInfo(), ";");
        String[] returnCertExtendItems = UtilTool.splitStr(config.getCertExtendInfo(), ";");
        VSignResponseItems responseItems = new VSignResponseItems();
        responseItems.setDsBaseRtnItems(returnBaseItems);
        responseItems.setCertBaseItems(returnCertBaseItems);
        responseItems.setCertExtItems(returnCertExtendItems);
        return responseItems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected long signature(String signCertId, Object source, OutputStream signedDataStore, int serviceType) {
        block25: {
            this.errorCode = 0L;
            this.errorMessage = "";
            if (source == null) {
                this.errorCode = UtilTool.convertStr2Long("-10701001", -10700000L);
                this.errorMessage = "\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u539f\u6587\u8f93\u5165\u4e3a\u7a7a\uff01";
                return this.errorCode;
            }
            if (signedDataStore == null) {
                this.errorCode = UtilTool.convertStr2Long("-10703207", -10700000L);
                this.errorMessage = "\u53c2\u6570\u4e0d\u5408\u6cd5\uff1a\u7b7e\u540d\u7ed3\u679c\u5b58\u50a8\u7528\u6237\u8f93\u51fa\u6d41\u4e3a\u7a7a\uff01";
                return this.errorCode;
            }
            String certId = signCertId;
            if (StringUtils.isEmpty(certId)) {
                certId = config.getAppID();
            }
            String digestAlg = config.getDigestAlg();
            DSSClient client = null;
            InputStream signedData = null;
            client = this.getClient();
            client.connect();
            DSignDispatchProcessor dispatchProcessor = new DSignDispatchProcessor(client, serviceType);
            signedData = dispatchProcessor.dispatchProcessSignature(certId, digestAlg, source);
            IOUtils.copy((InputStream)signedData, (OutputStream)signedDataStore);
            signedDataStore.flush();
            Object var11_12 = null;
            try {
                if (signedData != null) {
                    signedData.close();
                }
                if (client != null) {
                    client.close();
                }
                break block25;
            }
            catch (CSSException e2) {
                this.errorCode = UtilTool.convertStr2Long(e2.getCode(), -10700000L);
                this.errorMessage = e2.getDescription();
                LOGGER.error((Object)e2.getMessage(), (Throwable)e2);
            }
            catch (Exception e3) {
                this.errorCode = UtilTool.convertStr2Long(e3.getMessage(), -10700000L);
                this.errorMessage = e3.getMessage();
                LOGGER.error((Object)("errorCode: " + this.errorCode + " errorMessage: " + e3.getMessage()), (Throwable)e3);
            }
            break block25;
            {
                catch (CSSException e) {
                    this.errorCode = UtilTool.convertStr2Long(e.getCode(), -10700000L);
                    this.errorMessage = e.getDescription();
                    Object var11_13 = null;
                    try {
                        if (signedData != null) {
                            signedData.close();
                        }
                        if (client != null) {
                            client.close();
                        }
                        break block25;
                    }
                    catch (CSSException e2) {
                        this.errorCode = UtilTool.convertStr2Long(e2.getCode(), -10700000L);
                        this.errorMessage = e2.getDescription();
                        LOGGER.error((Object)e2.getMessage(), (Throwable)e2);
                    }
                    catch (Exception e3) {
                        this.errorCode = UtilTool.convertStr2Long(e3.getMessage(), -10700000L);
                        this.errorMessage = e3.getMessage();
                        LOGGER.error((Object)("errorCode: " + this.errorCode + " errorMessage: " + e3.getMessage()), (Throwable)e3);
                    }
                    break block25;
                }
                catch (Exception e) {
                    this.errorCode = UtilTool.convertStr2Long(e.getMessage(), -10700000L);
                    this.errorMessage = e.getMessage();
                    LOGGER.error((Object)("errorCode: " + this.errorCode + " errorMessage: " + e.getMessage()), (Throwable)e);
                    Object var11_14 = null;
                    try {
                        if (signedData != null) {
                            signedData.close();
                        }
                        if (client != null) {
                            client.close();
                        }
                        break block25;
                    }
                    catch (CSSException e2) {
                        this.errorCode = UtilTool.convertStr2Long(e2.getCode(), -10700000L);
                        this.errorMessage = e2.getDescription();
                        LOGGER.error((Object)e2.getMessage(), (Throwable)e2);
                    }
                    catch (Exception e3) {
                        this.errorCode = UtilTool.convertStr2Long(e3.getMessage(), -10700000L);
                        this.errorMessage = e3.getMessage();
                        LOGGER.error((Object)("errorCode: " + this.errorCode + " errorMessage: " + e3.getMessage()), (Throwable)e3);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var11_15 = null;
                try {
                    if (signedData != null) {
                        signedData.close();
                    }
                    if (client != null) {
                        client.close();
                    }
                }
                catch (CSSException e2) {
                    this.errorCode = UtilTool.convertStr2Long(e2.getCode(), -10700000L);
                    this.errorMessage = e2.getDescription();
                    LOGGER.error((Object)e2.getMessage(), (Throwable)e2);
                }
                catch (Exception e3) {
                    this.errorCode = UtilTool.convertStr2Long(e3.getMessage(), -10700000L);
                    this.errorMessage = e3.getMessage();
                    LOGGER.error((Object)("errorCode: " + this.errorCode + " errorMessage: " + e3.getMessage()), (Throwable)e3);
                }
                throw throwable;
            }
        }
        return this.errorCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected ResponseSet verify(Object source, InputStream signedData, Object sourceStore, int serviceType) {
        VSignResponseSet response;
        block24: {
            InputStream returnSource;
            DSSClient client;
            block23: {
                this.errorCode = 0L;
                this.errorMessage = "";
                if (signedData == null) {
                    this.errorCode = UtilTool.convertStr2Long("-10704201", -10700000L);
                    this.errorMessage = "\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u7b7e\u540d\u7ed3\u679c\u7684Base64\u7f16\u7801\u4e3a\u7a7a\uff01";
                    return null;
                }
                response = null;
                client = null;
                returnSource = null;
                VSignResponseItems responseItems = this.getVSignResponseItems();
                client = this.getClient();
                client.connect();
                DSignDispatchProcessor dispatchProcessor = new DSignDispatchProcessor(client, serviceType);
                response = (VSignResponseSet)dispatchProcessor.dispatchProcessVerify(source, signedData, responseItems);
                if (!response.isSucceed() || sourceStore == null) break block23;
                returnSource = response.getSourceDataStream();
                this.writeInputStream2SourceStore(returnSource, sourceStore, response);
            }
            Object var11_12 = null;
            try {
                if (returnSource != null) {
                    returnSource.close();
                }
                if (client != null) {
                    client.close();
                }
                break block24;
            }
            catch (CSSException e2) {
                this.errorCode = UtilTool.convertStr2Long(e2.getCode(), -10700000L);
                this.errorMessage = e2.getDescription();
                LOGGER.error((Object)e2.getMessage(), (Throwable)e2);
            }
            catch (Exception e3) {
                this.errorCode = UtilTool.convertStr2Long(e3.getMessage(), -10700000L);
                this.errorMessage = e3.getMessage();
                LOGGER.error((Object)("errorCode: " + this.errorCode + " errorMessage: " + e3.getMessage()), (Throwable)e3);
            }
            break block24;
            {
                catch (CSSException e) {
                    this.errorCode = UtilTool.convertStr2Long(e.getCode(), -10700000L);
                    this.errorMessage = e.getDescription();
                    Object var11_13 = null;
                    try {
                        if (returnSource != null) {
                            returnSource.close();
                        }
                        if (client != null) {
                            client.close();
                        }
                        break block24;
                    }
                    catch (CSSException e2) {
                        this.errorCode = UtilTool.convertStr2Long(e2.getCode(), -10700000L);
                        this.errorMessage = e2.getDescription();
                        LOGGER.error((Object)e2.getMessage(), (Throwable)e2);
                    }
                    catch (Exception e3) {
                        this.errorCode = UtilTool.convertStr2Long(e3.getMessage(), -10700000L);
                        this.errorMessage = e3.getMessage();
                        LOGGER.error((Object)("errorCode: " + this.errorCode + " errorMessage: " + e3.getMessage()), (Throwable)e3);
                    }
                    break block24;
                }
                catch (Exception e) {
                    this.errorCode = UtilTool.convertStr2Long(e.getMessage(), -10700000L);
                    this.errorMessage = e.getMessage();
                    LOGGER.error((Object)("errorCode: " + this.errorCode + " errorMessage: " + e.getMessage()), (Throwable)e);
                    Object var11_14 = null;
                    try {
                        if (returnSource != null) {
                            returnSource.close();
                        }
                        if (client != null) {
                            client.close();
                        }
                        break block24;
                    }
                    catch (CSSException e2) {
                        this.errorCode = UtilTool.convertStr2Long(e2.getCode(), -10700000L);
                        this.errorMessage = e2.getDescription();
                        LOGGER.error((Object)e2.getMessage(), (Throwable)e2);
                    }
                    catch (Exception e3) {
                        this.errorCode = UtilTool.convertStr2Long(e3.getMessage(), -10700000L);
                        this.errorMessage = e3.getMessage();
                        LOGGER.error((Object)("errorCode: " + this.errorCode + " errorMessage: " + e3.getMessage()), (Throwable)e3);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var11_15 = null;
                try {
                    if (returnSource != null) {
                        returnSource.close();
                    }
                    if (client != null) {
                        client.close();
                    }
                }
                catch (CSSException e2) {
                    this.errorCode = UtilTool.convertStr2Long(e2.getCode(), -10700000L);
                    this.errorMessage = e2.getDescription();
                    LOGGER.error((Object)e2.getMessage(), (Throwable)e2);
                }
                catch (Exception e3) {
                    this.errorCode = UtilTool.convertStr2Long(e3.getMessage(), -10700000L);
                    this.errorMessage = e3.getMessage();
                    LOGGER.error((Object)("errorCode: " + this.errorCode + " errorMessage: " + e3.getMessage()), (Throwable)e3);
                }
                throw throwable;
            }
        }
        return response;
    }

    protected long encryptEnvelop(String signCertId, String[] encryptCertAlias, Object source, OutputStream envelopedDataStore, int serviceType) {
        this.errorCode = 0L;
        this.errorMessage = "";
        if (source == null) {
            this.errorCode = UtilTool.convertStr2Long("-10701001", -10700000L);
            this.errorMessage = "\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u539f\u6587\u8f93\u5165\u4e3a\u7a7a\uff01";
            return this.errorCode;
        }
        if (envelopedDataStore == null) {
            this.errorCode = UtilTool.convertStr2Long("-10703208", -10700000L);
            this.errorMessage = "\u53c2\u6570\u4e0d\u5408\u6cd5\uff1a\u4fe1\u5c01\u7ed3\u679c\u5b58\u50a8\u7528\u6237\u8f93\u51fa\u6d41\u4e3a\u7a7a\uff01";
            return this.errorCode;
        }
        String digestAlg = config.getDigestAlg();
        String encryptAlg = config.getEncAlg();
        String[] alias = encryptCertAlias;
        if (alias == null || alias.length <= 0) {
            String aliasStr = config.getCertAlias();
            if (StringUtils.isEmpty(aliasStr)) {
                this.errorCode = UtilTool.convertStr2Long("-10703209", -10700000L);
                this.errorMessage = "\u53c2\u6570\u4e0d\u5408\u6cd5\uff1a\u52a0\u5bc6\u4fe1\u5c01\u6240\u7528\u52a0\u5bc6\u8bc1\u4e66\u6807\u8bc6\u4e3a\u7a7a\uff01";
                return this.errorCode;
            }
            alias = aliasStr.split(";");
        }
        try {
            DSignDispatchProcessor dispatchProcessor = new DSignDispatchProcessor(null, serviceType);
            dispatchProcessor.dispatchProcessEncryptEnvelop(signCertId, alias, source, encryptAlg, digestAlg, envelopedDataStore);
        }
        catch (CSSException e) {
            this.errorCode = UtilTool.convertStr2Long(e.getCode(), -10700000L);
            this.errorMessage = e.getDescription();
        }
        catch (Exception e) {
            this.errorCode = UtilTool.convertStr2Long(e.getMessage(), -10700000L);
            this.errorMessage = e.getMessage();
            LOGGER.error((Object)("errorCode: " + this.errorCode + " errorMessage: " + e.getMessage()), (Throwable)e);
        }
        return this.errorCode;
    }

    protected ResponseSet decryptEnvelop(InputStream envelopedData, Object sourceStore, int serviceType) {
        this.errorCode = 0L;
        this.errorMessage = "";
        if (envelopedData == null) {
            this.errorCode = UtilTool.convertStr2Long("-10704202", -10700000L);
            this.errorMessage = "\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u4fe1\u5c01\u7ed3\u679c\u7684Base64\u7f16\u7801\u4e3a\u7a7a\uff01";
            return null;
        }
        DecryptEnvelopResponseSet response = null;
        DSignDispatchProcessor dispatchProcessor = new DSignDispatchProcessor(null, serviceType);
        response = (DecryptEnvelopResponseSet)dispatchProcessor.dispatchProcessDecryptEnvelop(envelopedData, sourceStore);
        return response;
    }

    public static Config getConfig() {
        return config;
    }

    public long getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorCode(long errorCode) {
        this.errorCode = errorCode;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    class DSignDispatchProcessor {
        private int serviceType;
        private DSSClient client;

        public DSignDispatchProcessor(DSSClient client, int serviceType) {
            this.client = client;
            this.serviceType = serviceType;
        }

        public InputStream dispatchProcessSignature(String signCertId, String digestAlg, Object source) throws CSSException {
            if (source instanceof InputStream) {
                if (this.serviceType == 1) {
                    return this.client.attachSign(signCertId, digestAlg, (InputStream)source);
                }
                if (this.serviceType == 2) {
                    return this.client.detachSign(signCertId, digestAlg, (InputStream)source);
                }
                if (this.serviceType == 3) {
                    return this.client.simpleSign(signCertId, digestAlg, (InputStream)source);
                }
                if (this.serviceType == 4) {
                    return this.client.sign4SubsequentVSign(signCertId, digestAlg, (InputStream)source);
                }
                if (this.serviceType == 5) {
                    return this.client.p1Sign(signCertId, digestAlg, (InputStream)source);
                }
                return null;
            }
            if (source instanceof File) {
                if (this.serviceType == 1) {
                    this.client.attachSign(signCertId, digestAlg, (File)source, null);
                } else if (this.serviceType == 2) {
                    this.client.detachSign(signCertId, digestAlg, (File)source, null);
                } else {
                    if (this.serviceType == 3) {
                        return null;
                    }
                    if (this.serviceType == 4) {
                        this.client.sign4SubsequentVSign(signCertId, digestAlg, (File)source, null);
                    } else {
                        if (this.serviceType == 5) {
                            return null;
                        }
                        return null;
                    }
                }
                return this.client.getResponseDataAsStream();
            }
            return null;
        }

        public ResponseSet dispatchProcessVerify(Object source, InputStream signedData, VSignResponseItems responseItems) {
            if (source instanceof File) {
                if (this.serviceType == 2) {
                    return this.client.verifyDetachSign((File)source, signedData, responseItems);
                }
                return null;
            }
            if (source instanceof InputStream || source == null) {
                if (this.serviceType == 1) {
                    return this.client.verifyAttachSign(signedData, responseItems);
                }
                if (this.serviceType == 2) {
                    return this.client.verifyDetachSign((InputStream)source, signedData, responseItems);
                }
                if (this.serviceType == 3) {
                    return this.client.verifyDetachSign((InputStream)source, signedData, responseItems);
                }
                if (this.serviceType == 4) {
                    return this.client.verifySubsequent(signedData, responseItems);
                }
                if (this.serviceType == 5) {
                    return null;
                }
                return null;
            }
            return null;
        }

        public void dispatchProcessEncryptEnvelop(String signCertId, String[] encryptCertAlias, Object source, String encryptAlg, String digestAlg, OutputStream envelopedDataStore) throws CSSException, IOException {
            if (this.serviceType == 6) {
                AbstractDSign.this.encryptEnvelop(encryptCertAlias, source, encryptAlg, digestAlg, envelopedDataStore);
            } else if (this.serviceType == 7) {
                AbstractDSign.this.encryptSignEnvelop(signCertId, encryptCertAlias, source, encryptAlg, digestAlg, envelopedDataStore);
            } else {
                return;
            }
        }

        public ResponseSet dispatchProcessDecryptEnvelop(InputStream envelopedData, Object sourceStore) {
            if (this.serviceType == 6) {
                return AbstractDSign.this.decryptEnvelopPriv(envelopedData, sourceStore, true);
            }
            if (this.serviceType == 7) {
                return AbstractDSign.this.decryptSignEnvelop(envelopedData, sourceStore);
            }
            return null;
        }
    }
}

