/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.angel.client;

import cn.com.jit.angel.exception.SOR_IOException;
import cn.com.jit.angel.exception.SOR_JDOMException;
import cn.com.jit.assp.css.client.CSSException;
import cn.com.jit.assp.css.client.log.ErrorProcess;
import cn.com.jit.assp.css.client.util.UtilTool;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WSConfig {
    private static final Log LOGGER = LogFactory.getLog(WSConfig.class);
    private Properties configFileProp = new Properties();
    private String serverURLStr = "";
    private String serverURLStr2 = "";
    private String digestAlg = "";
    private String appID = "";
    private boolean isRtnCertBaseInfo = false;
    private String certBaseInfo = "";
    private String certExtendInfo = "";
    private String baseInfo = "";
    private long localeDigestSize = 0L;
    private long msgCompTranseSize = 0L;
    private long overSizeForCompose = 3L;
    private long plainLimiteSize = 0L;
    private String commCertPath = null;
    private URL serverUrl = null;
    private URL serverUrl2 = null;
    private int sendMsgFormat = 0;
    private int hashActionPosition = 0;
    private String configFile = "";
    private String timeout = null;
    private String defaultConfigFile = "./cssconfig.properties";
    private boolean isLoadedConfig = false;
    private boolean isSuccessLoadConfig = false;
    private boolean printLog = false;
    private String logTarget;
    private String logFilePath;
    private String fileSystemCharSet;
    private String systemCharSet;
    private String certAlias = "";
    private boolean compatible = false;
    private String encAlg;
    private String tsaType;
    private String p1VerifyCertId;
    private String envelopType;
    private int packageSize;
    private String connectTimeOut = null;
    private String dssClientImpl;
    private static WSConfig config = null;
    private ErrorProcess errprocess = null;

    public String getConnectTimeOut() {
        return this.connectTimeOut;
    }

    public void setConnectTimeOut(String connectTimeOut) {
        this.connectTimeOut = connectTimeOut;
    }

    public void setP1VerifyCertId(String verifyCertId) {
        this.p1VerifyCertId = verifyCertId;
    }

    private WSConfig() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WSConfig getInstance() {
        Class<WSConfig> clazz = WSConfig.class;
        synchronized (WSConfig.class) {
            if (config == null) {
                config = new WSConfig();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return config;
        }
    }

    public void loadConfig(String filePath, boolean isReload) throws CSSException, SOR_JDOMException, SOR_IOException {
        File configfile = null;
        configfile = new File(filePath);
        this.configFile = filePath;
        InputStream is = null;
        try {
            if (!configfile.exists() || configfile.isDirectory()) {
                configfile = new File(this.defaultConfigFile);
                if (!configfile.exists() || configfile.isDirectory()) {
                    is = this.getClass().getResourceAsStream(filePath);
                }
                if (is == null) {
                    throw new SOR_JDOMException(this.errprocess.getErrDesc("-90900003", ErrorProcess.vDefServerInfo));
                }
            } else {
                is = new FileInputStream(configfile);
            }
            this.configFileProp.load(is);
            this.serverURLStr = this.configFileProp.getProperty("ServerURL");
            this.serverURLStr2 = this.configFileProp.getProperty("ServerURL2");
            this.digestAlg = this.configFileProp.getProperty("DigestAlg");
            this.appID = this.configFileProp.getProperty("AppID");
            this.certBaseInfo = this.configFileProp.getProperty("CertBaseInfo");
            this.certExtendInfo = this.configFileProp.getProperty("CertExtendInfo");
            this.certAlias = this.configFileProp.getProperty("CertAlias");
            this.baseInfo = this.configFileProp.getProperty("BaseInfo");
            this.sendMsgFormat = UtilTool.convertStr2Int(this.configFileProp.getProperty("SendMsgFormat"), 0);
            this.hashActionPosition = UtilTool.convertStr2Int(this.configFileProp.getProperty("HashActionPosition"), 0);
            this.printLog = Boolean.valueOf(this.configFileProp.getProperty("PrintLog"));
            this.logTarget = this.configFileProp.getProperty("logTarget");
            this.logFilePath = this.configFileProp.getProperty("logFilePath");
            this.commCertPath = this.configFileProp.getProperty("CommCertPath");
            this.isRtnCertBaseInfo = Boolean.valueOf(this.configFileProp.getProperty("IsRtnCertBaseInfo"));
            this.compatible = Boolean.valueOf(this.configFileProp.getProperty("Compatible"));
            this.encAlg = this.configFileProp.getProperty("EncAlg");
            this.tsaType = this.configFileProp.getProperty("TSAType");
            this.p1VerifyCertId = this.configFileProp.getProperty("p1VerifyCertId");
            this.dssClientImpl = this.configFileProp.getProperty("dss.client.class");
            this.envelopType = this.configFileProp.getProperty("envelopType");
            Properties props = System.getProperties();
            this.systemCharSet = props.getProperty("file.encoding");
            this.fileSystemCharSet = this.configFileProp.getProperty("FileSystemCharSet");
            this.packageSize = UtilTool.convertStr2Int(this.configFileProp.getProperty("packageSize"), 1024);
            this.timeout = this.configFileProp.getProperty("timeout") == null ? "10000" : this.configFileProp.getProperty("timeout");
            this.connectTimeOut = this.configFileProp.getProperty("connectTimeOut") == null ? "10000" : this.configFileProp.getProperty("connectTimeOut");
            try {
                this.serverUrl = new URL(this.serverURLStr);
            }
            catch (Exception e) {
                LOGGER.error((Object)"serverUrl is not connect ", (Throwable)e);
            }
            try {
                this.serverUrl2 = new URL(this.serverURLStr2);
            }
            catch (Exception e) {
                LOGGER.error((Object)"serverUrl2 is not connect ", (Throwable)e);
            }
        }
        catch (FileNotFoundException e) {
            throw new SOR_JDOMException(this.errprocess.getErrDesc("-90900003", ErrorProcess.vDefServerInfo));
        }
        catch (IOException e) {
            throw new SOR_IOException(this.errprocess.getErrDesc("90900002", ErrorProcess.vDefServerInfo));
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {}
        }
    }

    public void putConfigValues2Properties() {
        if (this.configFileProp != null && !this.configFileProp.isEmpty()) {
            return;
        }
        this.configFileProp.put("ServerURL", this.getServerURLStr());
        this.configFileProp.put("ServerURL2", this.getServerURLStr2());
        this.configFileProp.put("DigestAlg", this.getDigestAlg());
        this.configFileProp.put("AppID", this.getAppID());
        this.configFileProp.put("CertBaseInfo", this.getCertBaseInfo());
        this.configFileProp.put("CertExtendInfo", this.getCertExtendInfo());
        this.configFileProp.put("CertAlias", this.getCertAlias());
        this.configFileProp.put("BaseInfo", this.getBaseInfo());
        this.configFileProp.put("HashActionPosition", Integer.toString(this.getHashActionPosition()));
        this.configFileProp.put("PrintLog", Boolean.toString(this.isPrintLog()));
        this.configFileProp.put("logTarget", this.getLogTarget());
        this.configFileProp.put("logFilePath", this.getLogFilePath());
        this.configFileProp.put("Compatible", Boolean.toString(this.isCompatible()));
        this.configFileProp.put("EncAlg", this.getEncAlg());
        this.configFileProp.put("TSAType", this.getTsaType());
        this.configFileProp.put("p1VerifyCertId", this.getP1VerifyCertId());
        this.configFileProp.put("dss.client.class", this.getDssClientImpl());
    }

    public String getServerURLStr2() {
        return this.serverURLStr2;
    }

    public void setServerURL(String urlstr) {
        this.serverURLStr = urlstr;
        try {
            this.serverUrl = new URL(this.serverURLStr);
        }
        catch (MalformedURLException ex) {
            LOGGER.error((Object)"serverUrl is not connect ", (Throwable)ex);
        }
    }

    public void setServerURL2(String urlstr) {
        this.serverURLStr2 = urlstr;
        try {
            this.serverUrl2 = new URL(this.serverURLStr2);
        }
        catch (MalformedURLException ex) {
            LOGGER.error((Object)"serverUrl2 is not connect ", (Throwable)ex);
        }
    }

    public String getServerURLStr() {
        return this.serverURLStr;
    }

    public URL getServerURL() {
        return this.serverUrl;
    }

    public URL getServerURL2() {
        return this.serverUrl2;
    }

    public void setCommCertPath(String certPathStr) {
        if (certPathStr != null && certPathStr.trim().length() > 0) {
            System.setProperty("javax.net.ssl.trustStore", certPathStr);
        }
        this.commCertPath = certPathStr;
    }

    public String getCertPath() {
        return this.commCertPath;
    }

    public String getAppID() {
        return this.appID;
    }

    public void setAppID(String appID) {
        this.appID = appID;
    }

    public String getCertAlias() {
        return this.certAlias;
    }

    public void setCertAlias(String certAlias) {
        this.certAlias = certAlias;
    }

    public String getBaseInfo() {
        return this.baseInfo;
    }

    public void setBaseInfo(String baseInfo) {
        this.baseInfo = baseInfo;
    }

    public String getCertBaseInfo() {
        return this.certBaseInfo;
    }

    public void setCertBaseInfo(String certBaseInfo) {
        this.certBaseInfo = certBaseInfo;
    }

    public String getCertExtendInfo() {
        return this.certExtendInfo;
    }

    public void setCertExtendInfo(String certExtendInfo) {
        this.certExtendInfo = certExtendInfo;
    }

    public String getDigestAlg() {
        return this.digestAlg;
    }

    public void setDigestAlg(String digestAlg) {
        this.digestAlg = digestAlg;
    }

    public long getLocaleDigest() {
        return this.localeDigestSize;
    }

    public long getOverSizeForCompose() {
        return this.overSizeForCompose;
    }

    public int getSendMsgFormat() {
        return this.sendMsgFormat;
    }

    public void setSendMsgFormat(int sendMsgFormat) {
        this.sendMsgFormat = sendMsgFormat;
    }

    public int getHashActionPosition() {
        return this.hashActionPosition;
    }

    public void setHashActionPosition(int hashActionPosition) {
        this.hashActionPosition = hashActionPosition;
    }

    public long getMsgCompTranseSize() {
        return this.msgCompTranseSize;
    }

    public void setMsgCompTranseSize(long msgCompTranseSize) {
        this.msgCompTranseSize = msgCompTranseSize;
    }

    public void setOverSizeForCompose(long overSizeForCompose) {
        this.overSizeForCompose = overSizeForCompose;
    }

    public boolean isPrintLog() {
        return this.printLog;
    }

    public void setPrintLog(boolean printLog) {
        this.printLog = printLog;
    }

    public String getLogTarget() {
        return this.logTarget;
    }

    public void setLogTarget(String logTarget) {
        this.logTarget = logTarget;
    }

    public String getLogFilePath() {
        return this.logFilePath;
    }

    public void setLogFilePath(String logFilePath) {
        this.logFilePath = logFilePath;
    }

    public boolean isCompatible() {
        return this.compatible;
    }

    public void setCompatible(boolean compatible) {
        this.compatible = compatible;
    }

    public Properties getConfigFileProp() {
        return this.configFileProp;
    }

    public void setConfigFileProp(Properties configFileProp) {
        this.configFileProp = configFileProp;
    }

    public void setEncAlg(String encAlg) {
        this.encAlg = encAlg;
    }

    public String getEncAlg() {
        return this.encAlg;
    }

    public String getTsaType() {
        return this.tsaType;
    }

    public void setTsaType(String tsaType) {
        this.tsaType = tsaType;
    }

    public String getP1VerifyCertId() {
        return this.p1VerifyCertId;
    }

    public String getDssClientImpl() {
        return this.dssClientImpl;
    }

    public void setDssClientImpl(String dssClientImpl) {
        this.dssClientImpl = dssClientImpl;
    }

    public String getEnvelopType() {
        return this.envelopType;
    }

    public void setEnvelopType(String envelopType) {
        this.envelopType = envelopType;
    }

    public int getPackageSize() {
        return this.packageSize;
    }

    public void setPackageSize(int packagesize) {
        this.packageSize = packagesize;
    }

    public String getFileSystemCharSet() {
        return this.fileSystemCharSet;
    }

    public void setFileSystemCharSet(String fileSystemCharSet) {
        this.fileSystemCharSet = fileSystemCharSet;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    public String getSystemCharSet() {
        return this.systemCharSet;
    }

    public void setSystemCharSet(String systemCharSet) {
        this.systemCharSet = systemCharSet;
    }
}

