/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.angel.client;

import cn.com.jit.angel.client.WSConfig;
import cn.com.jit.angel.request.WSRequestSet;
import cn.com.jit.assp.css.client.CSSException;
import cn.com.jit.assp.css.client.communication.RequestClient;
import cn.com.jit.assp.css.util.ResponseSet;
import cn.com.jit.assp.css.util.parser.ResponseParser;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WSClinet {
    private static final Log log = LogFactory.getLog(WSClinet.class);
    private WSConfig config;

    public WSClinet(WSConfig config) {
        this.config = config;
    }

    public ResponseSet requestWS(WSRequestSet request) throws CSSException {
        String reqXML = request.write2XMLString();
        ResponseSet response = new ResponseSet();
        try {
            String resStr = RequestClient.send(this.config.getServerURL(), reqXML);
            ResponseParser parser = new ResponseParser();
            response = parser.parserXML(resStr);
        }
        catch (CSSException e) {
            response.setErrCode(e.getCode());
            response.setErrDesc(e.getDescription());
            log.error((Object)("Send request to server or parse response occure error" + e.getDescription()), (Throwable)e);
        }
        return response;
    }

    public ResponseSet requestWS(WSRequestSet request, URL url) throws CSSException {
        String reqXML = request.write2XMLString();
        ResponseSet response = new ResponseSet();
        try {
            String resStr = RequestClient.send(url, reqXML);
            ResponseParser parser = new ResponseParser();
            response = parser.parserXML(resStr);
        }
        catch (CSSException e) {
            response.setErrCode(e.getCode());
            response.setErrDesc(e.getDescription());
            log.error((Object)("Send request to server or parse response occure error" + e.getDescription()), (Throwable)e);
        }
        return response;
    }
}

