/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.angel;

import cn.com.jit.angel.SOF_SecurityEngineDeal;
import cn.com.jit.angel.WSClinetImpl;
import cn.com.jit.angel.WSClinetInterface;
import cn.com.jit.angel.WSSignTools;
import cn.com.jit.angel.client.WSClinet;
import cn.com.jit.angel.client.WSConfig;
import cn.com.jit.angel.exception.SOR_AppNotfoundException;
import cn.com.jit.angel.exception.SOR_Base64Exception;
import cn.com.jit.angel.exception.SOR_CRLException;
import cn.com.jit.angel.exception.SOR_CertEncodeException;
import cn.com.jit.angel.exception.SOR_CertificateException;
import cn.com.jit.angel.exception.SOR_DecryptDataException;
import cn.com.jit.angel.exception.SOR_EncryptDataException;
import cn.com.jit.angel.exception.SOR_GetCertInfoException;
import cn.com.jit.angel.exception.SOR_GetXMLSignInfoException;
import cn.com.jit.angel.exception.SOR_HashException;
import cn.com.jit.angel.exception.SOR_IOException;
import cn.com.jit.angel.exception.SOR_InitException;
import cn.com.jit.angel.exception.SOR_JDOMException;
import cn.com.jit.angel.exception.SOR_KeyStoreException;
import cn.com.jit.angel.exception.SOR_NoCTLsException;
import cn.com.jit.angel.exception.SOR_NoSuchAlgorithmException;
import cn.com.jit.angel.exception.SOR_NullPointerException;
import cn.com.jit.angel.exception.SOR_ParameterException;
import cn.com.jit.angel.exception.SOR_ParameterNotSupportException;
import cn.com.jit.angel.exception.SOR_ParseException;
import cn.com.jit.angel.exception.SOR_Pkcs7EncodeException;
import cn.com.jit.angel.exception.SOR_Pkcs7SignException;
import cn.com.jit.angel.exception.SOR_Pkcs7VerifySignException;
import cn.com.jit.angel.exception.SOR_RandomNumberException;
import cn.com.jit.angel.exception.SOR_ReadFileException;
import cn.com.jit.angel.exception.SOR_SignDataException;
import cn.com.jit.angel.exception.SOR_SignatureException;
import cn.com.jit.angel.exception.SOR_TsException;
import cn.com.jit.angel.exception.SOR_VerifySignDataException;
import cn.com.jit.angel.exception.SOR_WriteFileException;
import cn.com.jit.angel.exception.SOR_XmlEncodeException;
import cn.com.jit.angel.exception.SOR_XmlSignException;
import cn.com.jit.angel.exception.SOR_XmlVerifySignException;
import cn.com.jit.angel.request.CreateTimeStampRequestRequestSet;
import cn.com.jit.angel.request.CreateTimeStampResponseRequestSet;
import cn.com.jit.angel.request.GetCertInfoByOidRequestSet;
import cn.com.jit.angel.request.GetCertInfoRequestSet;
import cn.com.jit.angel.request.GetEncryptMethodRequestSet;
import cn.com.jit.angel.request.GetP7SignDataInfoRequestSet;
import cn.com.jit.angel.request.GetServerCertificateRequestSet;
import cn.com.jit.angel.request.GetSignMethodRequestSet;
import cn.com.jit.angel.request.GetTimeStampInfoRequestSet;
import cn.com.jit.angel.request.SetEncryptMethodRequestSet;
import cn.com.jit.angel.request.SetSignMethodRequestSet;
import cn.com.jit.angel.request.WSDelCertTrustListRequest;
import cn.com.jit.angel.request.WSParseXMLSignedDataRequestSet;
import cn.com.jit.angel.request.WSPriKeyDecryptRequestSet;
import cn.com.jit.angel.request.WSPubKeyEncryptRequestSet;
import cn.com.jit.angel.request.WSQueryCertTrustListAltNamesRequest;
import cn.com.jit.angel.request.WSQueryCertTrustListRequest;
import cn.com.jit.angel.request.WSSetCertTrustListRequestSet;
import cn.com.jit.angel.request.WSSymmDecryptRequestSet;
import cn.com.jit.angel.request.WSSymmEncryptRequestSet;
import cn.com.jit.angel.request.WSValidateCertRequestSet;
import cn.com.jit.angel.response.WSDelCertTrustListResponseSet;
import cn.com.jit.angel.response.WSParseXMLSignedDataResponseSet;
import cn.com.jit.angel.response.WSPriKeyDecryptResponseSet;
import cn.com.jit.angel.response.WSPubKeyEncryptResponseSet;
import cn.com.jit.angel.response.WSQueryCertTrustListAltNamesResponseSet;
import cn.com.jit.angel.response.WSQueryCertTrustListResponseSet;
import cn.com.jit.angel.response.WSResponseSet;
import cn.com.jit.angel.response.WSSetCertTrustListResponseSet;
import cn.com.jit.angel.response.WSValidateCertResponseSet;
import cn.com.jit.assp.css.client.CSSException;
import cn.com.jit.assp.css.client.Config;
import cn.com.jit.assp.css.client.DSignClient;
import cn.com.jit.assp.css.client.ResultSet;
import cn.com.jit.assp.css.client.log.ErrorProcess;
import cn.com.jit.assp.css.client.util.Base64;
import cn.com.jit.assp.css.client.util.CommUtil;
import cn.com.jit.assp.css.client.util.HelperUtil;
import cn.com.jit.assp.css.client.util.SecurityUtil;
import cn.com.jit.assp.css.client.util.UtilTool;
import cn.com.jit.assp.css.util.ResponseSet;
import cn.com.jit.assp.css.util.parser.SimpleDOMParser;
import cn.com.jit.assp.css.util.parser.SimpleElement;
import cn.com.jit.assp.dsign.DSign;
import cn.com.jit.assp.encrypt.SymmDecryptResponseSet;
import cn.com.jit.assp.encrypt.SymmEncryptResponseSet;
import cn.com.jit.tsa.client.TSAClient;
import cn.com.jit.tsa.client.TSAClientFactory;
import cn.com.jit.tsa.client.TSAException;
import cn.com.jit.tsa.client.TSAVerifyResult;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WSSign {
    private static final Log LOGGER = LogFactory.getLog(WSSign.class);
    private static WSConfig config = null;
    private static boolean IS_INITED = false;
    private long longErrCode = 0L;
    private String strErrMsg = null;
    private ResultSet rs = null;
    private DSignClient dsclient = new DSignClient();
    private WSClinet client = null;
    private String digestAlgID = null;
    private String plainData = "";
    private byte[] plainByteData = null;
    private String rndigestAlgID = "";
    private byte[] filePlainData = null;
    private String fileName = "";
    private static ErrorProcess errprocess = null;
    private static DSign ds = null;
    private static String cssconfigUrl = null;
    private String outFileName = "";
    private WSClinetInterface WSclinet = null;

    public WSClinetInterface getWSclinet() {
        return this.WSclinet;
    }

    public void setWSclinet(WSClinetInterface wSclinet) {
        this.WSclinet = wSclinet;
    }

    public WSClinet getClient() {
        return this.client;
    }

    public void setClient(WSClinet client) {
        this.client = client;
    }

    public WSSign() {
        config = WSConfig.getInstance();
        this.client = new WSClinet(config);
        this.rs = new ResultSet();
        errprocess = ErrorProcess.getInstance();
        this.WSclinet = new WSClinetImpl();
    }

    public static SOF_SecurityEngineDeal SOF_GetInstance(String appName) {
        SOF_SecurityEngineDeal sed = new SOF_SecurityEngineDeal();
        try {
            WSSign.SOF_GetInstance_bak(appName);
        }
        catch (SOR_AppNotfoundException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SOR_InitException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SOR_JDOMException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SOR_IOException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        return sed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean SOF_GetInstance_bak(String appName) throws SOR_AppNotfoundException, SOR_InitException, SOR_JDOMException, SOR_IOException {
        Class<WSSign> clazz = WSSign.class;
        synchronized (WSSign.class) {
            if (appName == null || "".equals(appName)) {
                throw new SOR_AppNotfoundException(errprocess.getErrDesc("-90900003", ErrorProcess.vDefServerInfo));
            }
            if (!IS_INITED) {
                try {
                    if (config == null) {
                        config = WSConfig.getInstance();
                    }
                    config.loadConfig(appName, false);
                }
                catch (CSSException e) {
                    throw new SOR_InitException(errprocess.getErrDesc("-90900003", ErrorProcess.vDefServerInfo));
                }
                IS_INITED = true;
            }
            cssconfigUrl = appName;
            ds = new DSign();
            DSign.init(appName);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return IS_INITED;
        }
    }

    public String SOF_SignData(String intDate) throws CSSException {
        if (CommUtil.isNull(intDate)) {
            throw new NullPointerException(errprocess.getErrDesc("90900072", ErrorProcess.vDefServerInfo));
        }
        String strRtnValue = ds.p1Sign("", "", intDate.getBytes());
        if (strRtnValue == null || "".equals(strRtnValue)) {
            throw new CSSException(String.valueOf(ds.getErrorCode()), ds.getErrorMessage());
        }
        return strRtnValue;
    }

    public boolean SOF_VerifySignedData(String base64EncodeCert, String inData, String signValue) throws CSSException {
        if (CommUtil.isNull(base64EncodeCert) || CommUtil.isNull(inData) || CommUtil.isNull(signValue)) {
            throw new NullPointerException(errprocess.getErrDesc("90900073", ErrorProcess.vDefServerInfo));
        }
        long longReturn = ds.p1Verify(base64EncodeCert, "", signValue.getBytes(), inData.getBytes());
        if (longReturn == 0L) {
            return true;
        }
        throw new CSSException(String.valueOf(ds.getErrorCode()), ds.getErrorMessage());
    }

    public String SOF_SignFile(String inFile) throws CSSException {
        if (CommUtil.isNull(inFile)) {
            throw new NullPointerException(errprocess.getErrDesc("90900072", ErrorProcess.vDefServerInfo));
        }
        String str = ds.p1Sign("", "", inFile);
        if (str == null || "".equals(str)) {
            throw new CSSException(String.valueOf(ds.getErrorCode()), ds.getErrorMessage());
        }
        return str;
    }

    public boolean SOF_VerifySignedFile(String base64EncodeCert, String inFile, String signValue) throws CSSException {
        if (CommUtil.isNull(base64EncodeCert) || CommUtil.isNull(inFile) || CommUtil.isNull(signValue)) {
            throw new NullPointerException(errprocess.getErrDesc("90900073", ErrorProcess.vDefServerInfo));
        }
        long longReturn = ds.p1Verify(base64EncodeCert, "", inFile, signValue.getBytes());
        if (longReturn == 0L) {
            return true;
        }
        throw new CSSException(String.valueOf(ds.getErrorCode()), ds.getErrorMessage());
    }

    public String SOF_EncryptData(String key, String inData) throws CSSException, SOR_AppNotfoundException, SOR_EncryptDataException {
        if (CommUtil.isNull(key) || CommUtil.isNull(inData)) {
            throw new NullPointerException(errprocess.getErrDesc("90900073", ErrorProcess.vDefServerInfo));
        }
        WSSymmEncryptRequestSet request = new WSSymmEncryptRequestSet();
        request.setSymmKey(Base64.encodeBytes(key.getBytes()));
        request.setPlainData(Base64.encodeBytes(inData.getBytes()));
        ResponseSet response = this.client.requestWS(request);
        if (response instanceof SymmEncryptResponseSet) {
            SymmEncryptResponseSet symmResponse = (SymmEncryptResponseSet)response;
            String encryptData = symmResponse.getEncryptData();
            if (encryptData != null && encryptData.trim().length() > 0) {
                return encryptData;
            }
        } else {
            throw new SOR_EncryptDataException(response.getErrCode(), errprocess.getErrDesc(response.getErrCode(), response.getErrDesc()));
        }
        return null;
    }

    public String SOF_DecryptData(String key, String inData) throws CSSException, SOR_DecryptDataException, SOR_Base64Exception {
        if (CommUtil.isNull(key) || CommUtil.isNull(inData)) {
            throw new NullPointerException(errprocess.getErrDesc("90900073", ErrorProcess.vDefServerInfo));
        }
        WSSymmDecryptRequestSet request = new WSSymmDecryptRequestSet();
        request.setSymmKey(Base64.encodeBytes(key.getBytes()));
        request.setEncryptData(inData);
        ResponseSet response = this.client.requestWS(request);
        if (response instanceof SymmDecryptResponseSet) {
            SymmDecryptResponseSet symmResponse = (SymmDecryptResponseSet)response;
            String plainData = symmResponse.getPlainData();
            if (plainData != null && plainData.length() > 0) {
                try {
                    return new String(Base64.decode(plainData));
                }
                catch (Exception e) {
                    LOGGER.error((Object)errprocess.getErrDesc("-90900004", ErrorProcess.vDefServerInfo), (Throwable)e);
                    throw new SOR_Base64Exception(errprocess.getErrDesc("-90900004", ErrorProcess.vDefServerInfo));
                }
            }
        } else {
            throw new SOR_DecryptDataException(response.getErrCode(), errprocess.getErrDesc(response.getErrCode(), response.getErrDesc()));
        }
        return null;
    }

    public boolean SOF_EncryptFile(String key, String inFile, String outFile) throws SOR_AppNotfoundException, SOR_EncryptDataException, SOR_ReadFileException, SOR_WriteFileException {
        if (CommUtil.isNull(key) || CommUtil.isNull(inFile) || CommUtil.isNull(outFile)) {
            throw new NullPointerException(errprocess.getErrDesc("90900073", ErrorProcess.vDefServerInfo));
        }
        String symmEncryptResult = null;
        try {
            WSSymmEncryptRequestSet request = new WSSymmEncryptRequestSet();
            request.setSymmKey(Base64.encodeBytes(key.getBytes()));
            request.setPlainData(Base64.encodeBytes(WSSignTools.readFile(inFile)));
            ResponseSet response = this.WSclinet.getResponseSet(request);
            if (response instanceof SymmEncryptResponseSet) {
                SymmEncryptResponseSet symmResponse = (SymmEncryptResponseSet)response;
                symmEncryptResult = symmResponse.getEncryptData();
            }
        }
        catch (Exception e1) {
            LOGGER.error((Object)errprocess.getErrDesc("90900075", ErrorProcess.vDefServerInfo), (Throwable)e1);
            throw new SOR_ReadFileException(errprocess.getErrDesc("90900075", ErrorProcess.vDefServerInfo));
        }
        if (null == outFile || 0 == outFile.length()) {
            return false;
        }
        try {
            WSSignTools.writeByteToFile(outFile, Base64.decode(symmEncryptResult.getBytes()));
        }
        catch (Exception e1) {
            LOGGER.error((Object)errprocess.getErrDesc("90900074", ErrorProcess.vDefServerInfo), (Throwable)e1);
            throw new SOR_WriteFileException(errprocess.getErrDesc("90900074", ErrorProcess.vDefServerInfo));
        }
        return true;
    }

    public boolean SOF_DecryptFile(String key, String inFile, String outFile) throws SOR_AppNotfoundException, SOR_DecryptDataException, SOR_Base64Exception, SOR_ReadFileException, SOR_WriteFileException, CSSException {
        if (CommUtil.isNull(key) || CommUtil.isNull(inFile) || CommUtil.isNull(outFile)) {
            throw new NullPointerException(errprocess.getErrDesc("90900073", ErrorProcess.vDefServerInfo));
        }
        byte[] byteSignedFileInfoData = null;
        String byteSaveFileContent = null;
        Object fileName = null;
        try {
            byteSignedFileInfoData = WSSignTools.readFile(inFile);
        }
        catch (Exception e1) {
            LOGGER.error((Object)errprocess.getErrDesc("90900075", ErrorProcess.vDefServerInfo), (Throwable)e1);
            throw new SOR_ReadFileException(errprocess.getErrDesc("90900075", ErrorProcess.vDefServerInfo));
        }
        try {
            WSSymmDecryptRequestSet request = new WSSymmDecryptRequestSet();
            request.setSymmKey(Base64.encodeBytes(key.getBytes()));
            request.setEncryptData(Base64.encodeBytes(byteSignedFileInfoData));
            ResponseSet response = this.WSclinet.getResponseSet(request);
            if (response instanceof SymmDecryptResponseSet) {
                SymmDecryptResponseSet symmResponse = (SymmDecryptResponseSet)response;
                byteSaveFileContent = symmResponse.getPlainData();
                this.setFilePlainData(Base64.decode(byteSaveFileContent.getBytes()));
            }
        }
        catch (CSSException e) {
            throw new CSSException(String.valueOf(ds.getErrorCode()), ds.getErrorMessage());
        }
        try {
            byte[] byteSaveFileContents = this.getFilePlainData();
            WSSignTools.writeByteToFile(outFile, byteSaveFileContents);
        }
        catch (Exception e1) {
            LOGGER.error((Object)errprocess.getErrDesc("90900074", ErrorProcess.vDefServerInfo), (Throwable)e1);
            throw new SOR_WriteFileException(errprocess.getErrDesc("90900074", ErrorProcess.vDefServerInfo));
        }
        return byteSaveFileContent != null && !"".equals(byteSaveFileContent);
    }

    private String getFileName(String plainData) {
        int beginIndex = plainData.indexOf("<FileName>");
        int endIndex = plainData.indexOf("</FileName>");
        String fileName = plainData.substring(beginIndex + 10, endIndex);
        return fileName;
    }

    private String getOriginal(String plainData) {
        int beginIndex = plainData.indexOf("<OriginalData>");
        int endIndex = plainData.indexOf("</OriginalData>");
        String original = plainData.substring(beginIndex + 14, endIndex);
        return original;
    }

    public String SOF_PubKeyEncrypt(String base64EncodeCert, String inData) throws CSSException {
        if (CommUtil.isNull(base64EncodeCert) || CommUtil.isNull(inData)) {
            throw new NullPointerException(errprocess.getErrDesc("90900073", ErrorProcess.vDefServerInfo));
        }
        WSPubKeyEncryptRequestSet request = new WSPubKeyEncryptRequestSet();
        request.setBase64EncodeCert(base64EncodeCert);
        request.setInData(inData);
        ResponseSet response = this.client.requestWS(request);
        if (response instanceof WSPubKeyEncryptResponseSet) {
            WSPubKeyEncryptResponseSet pubkeyResponse = (WSPubKeyEncryptResponseSet)response;
            String PubKeyEncrypt = pubkeyResponse.getPubKeyEncrypt();
            if (PubKeyEncrypt != null || !"".equals(PubKeyEncrypt)) {
                return PubKeyEncrypt;
            }
        } else {
            throw new CSSException(response.getErrCode(), response.getErrDesc());
        }
        return null;
    }

    public String SOF_PriKeyDecrypt(String inData) throws CSSException {
        if (CommUtil.isNull(inData)) {
            throw new NullPointerException(errprocess.getErrDesc("90900073", ErrorProcess.vDefServerInfo));
        }
        WSPriKeyDecryptRequestSet request = new WSPriKeyDecryptRequestSet();
        request.setInData(inData);
        ResponseSet response = this.client.requestWS(request);
        if (response instanceof WSPriKeyDecryptResponseSet) {
            WSPriKeyDecryptResponseSet prikeyResponse = (WSPriKeyDecryptResponseSet)response;
            String PriKeyDecrypt = new String(prikeyResponse.getPriKeyDecrypt());
            if (PriKeyDecrypt != null || !"".equals(PriKeyDecrypt)) {
                return PriKeyDecrypt;
            }
        } else {
            throw new CSSException(response.getErrCode(), response.getErrDesc());
        }
        return null;
    }

    public int SOF_ValidateCert(String base64EncodeCert) throws CSSException {
        WSValidateCertRequestSet request = new WSValidateCertRequestSet();
        if (CommUtil.isNull(base64EncodeCert)) {
            throw new NullPointerException(errprocess.getErrDesc("90900071", ErrorProcess.vDefServerInfo));
        }
        request.setBase64EncodeCert(base64EncodeCert);
        ResponseSet response = this.client.requestWS(request);
        if (response instanceof WSValidateCertResponseSet) {
            WSValidateCertResponseSet validateResponse = (WSValidateCertResponseSet)response;
            return Integer.valueOf(validateResponse.getValidateCert());
        }
        String strErrorCode = response.getErrCode();
        if (strErrorCode.equalsIgnoreCase("90900068")) {
            throw new NullPointerException(errprocess.getErrDesc("90900010", ErrorProcess.vDefServerInfo));
        }
        if (strErrorCode.equalsIgnoreCase("90900070")) {
            throw new NullPointerException(errprocess.getErrDesc("90900069", ErrorProcess.vDefServerInfo));
        }
        if (strErrorCode.equalsIgnoreCase("90900069")) {
            throw new NullPointerException(errprocess.getErrDesc("90900070", ErrorProcess.vDefServerInfo));
        }
        throw new CSSException(response.getErrCode(), response.getErrDesc());
    }

    public boolean SOF_SetCertTrustList(String ctlAltName, String ctlContent) throws SOR_ParameterException {
        ResponseSet response;
        if (CommUtil.isNull(ctlAltName)) {
            throw new SOR_ParameterException("9090004D", "\u8f93\u5165\u6807\u8bc6\u4e3a\u7a7a,\u8bf7\u91cd\u65b0\u8f93\u5165");
        }
        if (CommUtil.isNull(ctlContent)) {
            throw new SOR_ParameterException("90900047", "\u4fe1\u4efb\u5217\u8868\u6587\u4ef6\u4e3a\u7a7a");
        }
        WSSetCertTrustListRequestSet request = new WSSetCertTrustListRequestSet();
        request.setCtlAltName(ctlAltName);
        request.setCtlContent(ctlContent);
        try {
            response = this.client.requestWS(request);
        }
        catch (CSSException e) {
            throw new SOR_ParameterException(e.getCode(), e.getDescription());
        }
        if (response instanceof WSSetCertTrustListResponseSet) {
            WSSetCertTrustListResponseSet setCertResponse = (WSSetCertTrustListResponseSet)response;
            String setCertTrustFlag = setCertResponse.getCtlResult();
            return setCertTrustFlag.equals("true");
        }
        throw new SOR_ParameterException(response.getErrCode(), response.getErrDesc());
    }

    public String SOF_QueryCertTrustListAltNames() throws SOR_NoCTLsException {
        ResponseSet response;
        WSQueryCertTrustListAltNamesRequest request = new WSQueryCertTrustListAltNamesRequest();
        try {
            response = this.client.requestWS(request);
        }
        catch (CSSException e) {
            throw new SOR_NoCTLsException(e.getCode(), e.getDescription());
        }
        if (response instanceof WSQueryCertTrustListAltNamesResponseSet) {
            WSQueryCertTrustListAltNamesResponseSet queryResponse = (WSQueryCertTrustListAltNamesResponseSet)response;
            String queryCertTrustListAltNames = new String(queryResponse.getQueryCertTrustListAltNames());
            if (queryCertTrustListAltNames != null && !"".equals(queryCertTrustListAltNames)) {
                return queryCertTrustListAltNames;
            }
        } else {
            throw new SOR_NoCTLsException(response.getErrCode(), response.getErrDesc());
        }
        return null;
    }

    public String SOF_QueryCertTrustList(String ctlAltName) throws SOR_ParameterException, SOR_NoCTLsException {
        ResponseSet response;
        if (CommUtil.isNull(ctlAltName)) {
            throw new SOR_ParameterException("9090002A", "\u8f93\u5165\u8bc1\u4e66\u522b\u540d\u4e3a\u7a7a,\u8bf7\u91cd\u65b0\u8f93\u5165");
        }
        WSQueryCertTrustListRequest request = new WSQueryCertTrustListRequest();
        request.setCtlAltName(ctlAltName);
        try {
            response = this.client.requestWS(request);
        }
        catch (CSSException e) {
            throw new SOR_ParameterException(e.getCode(), e.getDescription());
        }
        if (response instanceof WSQueryCertTrustListResponseSet) {
            WSQueryCertTrustListResponseSet queryResponse = (WSQueryCertTrustListResponseSet)response;
            String queryCertTrustList = queryResponse.getQueryCertTrustList();
            if (queryCertTrustList != null || !"".equals(queryCertTrustList)) {
                return queryCertTrustList;
            }
        } else {
            throw new SOR_NoCTLsException(response.getErrCode(), response.getErrDesc());
        }
        return null;
    }

    public boolean SOF_DelCertTrustList(String ctlAltName) throws SOR_ParameterException, SOR_NoCTLsException {
        ResponseSet response;
        if (CommUtil.isNull(ctlAltName)) {
            throw new SOR_ParameterException("9090002A", "\u8f93\u5165\u8bc1\u4e66\u522b\u540d\u4e3a\u7a7a,\u8bf7\u91cd\u65b0\u8f93\u5165");
        }
        WSDelCertTrustListRequest request = new WSDelCertTrustListRequest();
        request.setCtlAltName(ctlAltName);
        try {
            response = this.client.requestWS(request);
        }
        catch (CSSException e) {
            throw new SOR_ParameterException(e.getCode(), e.getDescription());
        }
        if (response instanceof WSDelCertTrustListResponseSet) {
            WSDelCertTrustListResponseSet delResponse = (WSDelCertTrustListResponseSet)response;
            String delCertTrustList = delResponse.getDelCertTrustList();
            return delCertTrustList.equals("true");
        }
        throw new SOR_NoCTLsException(response.getErrCode(), response.getErrDesc());
    }

    private ResponseSet parserXML(InputStream _in) throws CSSException {
        BufferedReader vBufferedReader = null;
        InputStreamReader vInStreamReader = null;
        ResponseSet vRespSet = new ResponseSet();
        SimpleDOMParser vDOMParser = null;
        try {
            vInStreamReader = new InputStreamReader(_in, "UTF-8");
            vBufferedReader = new BufferedReader(vInStreamReader);
            vDOMParser = new SimpleDOMParser();
            SimpleElement tRootse = vDOMParser.parse(vBufferedReader);
            SimpleElement tSe = null;
            Object[] tObjse = tRootse.getChildElements();
            for (int i = 0; i < tObjse.length; ++i) {
                tSe = (SimpleElement)tObjse[i];
                this.parserSymmDecryptRespMsg(tSe);
            }
            tSe = null;
            tObjse = null;
            tRootse = null;
            vDOMParser.destroy();
            vDOMParser = null;
        }
        catch (IOException ex1) {
            throw new CSSException("");
        }
        finally {
            if (vBufferedReader != null) {
                try {
                    vBufferedReader.close();
                    vBufferedReader = null;
                }
                catch (IOException ex) {}
            }
            if (vInStreamReader != null) {
                try {
                    vInStreamReader.close();
                    vInStreamReader = null;
                }
                catch (IOException ex2) {}
            }
            if (_in != null) {
                try {
                    _in.close();
                    _in = null;
                }
                catch (IOException ex3) {}
            }
        }
        return vRespSet;
    }

    private void parserSymmDecryptRespMsg(SimpleElement se) {
        Object[] vObjse = se.getChildElements();
        SimpleElement vSimElement = null;
        for (int j = 0; j < vObjse.length; ++j) {
            vSimElement = (SimpleElement)vObjse[j];
            if (vSimElement == null) continue;
            if (vSimElement.getTagName().equals("name")) {
                String fileSystemChartSet = Config.getInstance().getFileSystemCharSet();
                if (null == fileSystemChartSet || "default".equals(fileSystemChartSet)) {
                    fileSystemChartSet = Config.getInstance().getSystemCharSet();
                }
                try {
                    this.setFileName(new String(Base64.decode(vSimElement.getText()), fileSystemChartSet));
                }
                catch (UnsupportedEncodingException e) {
                    LOGGER.error((Object)e.getMessage(), (Throwable)e);
                }
                catch (RuntimeException e) {
                    LOGGER.error((Object)e.getMessage(), (Throwable)e);
                }
                continue;
            }
            if (!vSimElement.getTagName().equals("content")) continue;
            this.setFilePlainData(Base64.decode(vSimElement.getText()));
        }
        vSimElement = null;
        vObjse = null;
    }

    private String getFile(String strSaveFilePath) {
        String strSaveFileName = null;
        byte[] byteSaveFileContent = null;
        String strSaveFileTotalPath = null;
        if (CommUtil.isNull(strSaveFilePath)) {
            return null;
        }
        byteSaveFileContent = this.getFilePlainData();
        if (null != strSaveFilePath && 0 != strSaveFilePath.trim().length()) {
            strSaveFileTotalPath = strSaveFilePath.substring(strSaveFilePath.length() - 1).equals(File.separator) ? strSaveFilePath + strSaveFileName : strSaveFilePath;
            try {
                WSSignTools.writeByteToFile(strSaveFileTotalPath, byteSaveFileContent);
            }
            catch (CSSException e) {
                strSaveFileName = null;
            }
        } else {
            return "";
        }
        return strSaveFileName;
    }

    public void SOF_SetSignMethod(int signMethod) throws SOR_NullPointerException, SOR_ParameterNotSupportException {
        if (signMethod == 0) {
            throw new SOR_NullPointerException(errprocess.getErrDesc("-90900001", ErrorProcess.vDefServerInfo));
        }
        try {
            SetSignMethodRequestSet req = new SetSignMethodRequestSet();
            req.setSignMethod(String.valueOf(signMethod));
            ResponseSet response = this.client.requestWS(req);
            if (!(response instanceof WSResponseSet)) {
                this.longErrCode = UtilTool.convertStr2Long(response.getErrCode(), -10700000L);
            }
        }
        catch (CSSException e) {
            this.longErrCode = UtilTool.convertStr2Long(e.getCode(), -10700000L);
            this.strErrMsg = e.getDescription();
        }
    }

    public void SOF_SetSignMethod(String signMethod) throws SOR_NullPointerException, SOR_ParameterNotSupportException {
        if ("".equals(signMethod) || signMethod == null) {
            throw new SOR_NullPointerException(errprocess.getErrDesc("-90900001", ErrorProcess.vDefServerInfo));
        }
        try {
            SetSignMethodRequestSet req = new SetSignMethodRequestSet();
            req.setSignMethod(String.valueOf(signMethod));
            ResponseSet response = this.client.requestWS(req);
            if (!(response instanceof WSResponseSet)) {
                this.longErrCode = UtilTool.convertStr2Long(response.getErrCode(), -10700000L);
            }
        }
        catch (CSSException e) {
            this.longErrCode = UtilTool.convertStr2Long(e.getCode(), -10700000L);
            this.strErrMsg = e.getDescription();
        }
    }

    public String SOF_GetSignMethod() {
        try {
            GetSignMethodRequestSet req = new GetSignMethodRequestSet();
            ResponseSet response = this.client.requestWS(req);
            if (response instanceof WSResponseSet) {
                return this.SOF_GetEncryptValues(((WSResponseSet)response).getSignMethodData());
            }
            this.longErrCode = UtilTool.convertStr2Long(response.getErrCode(), -10700000L);
        }
        catch (CSSException e) {
            this.longErrCode = UtilTool.convertStr2Long(e.getCode(), -10700000L);
            this.strErrMsg = e.getDescription();
        }
        return null;
    }

    public void SOF_SetEncryptMethod(int encryptMethod) throws SOR_ParameterNotSupportException, SOR_NullPointerException {
        if (encryptMethod == 0) {
            throw new SOR_NullPointerException(errprocess.getErrDesc("-90900001", ErrorProcess.vDefServerInfo));
        }
        try {
            SetEncryptMethodRequestSet req = new SetEncryptMethodRequestSet();
            req.setEncryptMethod(String.valueOf(encryptMethod));
            ResponseSet response = this.client.requestWS(req);
            if (!(response instanceof WSResponseSet)) {
                this.longErrCode = UtilTool.convertStr2Long(response.getErrCode(), -10700000L);
            }
        }
        catch (CSSException e) {
            this.longErrCode = UtilTool.convertStr2Long(e.getCode(), -10700000L);
            this.strErrMsg = e.getDescription();
        }
    }

    public String SOF_GetEncryptMethod() {
        try {
            GetEncryptMethodRequestSet req = new GetEncryptMethodRequestSet();
            ResponseSet response = this.client.requestWS(req);
            if (response instanceof WSResponseSet) {
                return this.SOF_GetEncryptValues(((WSResponseSet)response).getEncryptMethodData());
            }
            this.longErrCode = UtilTool.convertStr2Long(response.getErrCode(), -10700000L);
        }
        catch (CSSException e) {
            this.longErrCode = UtilTool.convertStr2Long(e.getCode(), -10700000L);
            this.strErrMsg = e.getDescription();
        }
        return null;
    }

    public String SOF_GetServerCertificate(int certUsage) throws SOR_ParameterNotSupportException {
        if (certUsage != 1 && certUsage != 2) {
            throw new SOR_ParameterNotSupportException(errprocess.getErrDesc("-90900007", ErrorProcess.vDefServerInfo));
        }
        try {
            GetServerCertificateRequestSet req = new GetServerCertificateRequestSet();
            req.setCertUsage(String.valueOf(certUsage));
            ResponseSet response = this.client.requestWS(req);
            if (response instanceof WSResponseSet) {
                return ((WSResponseSet)response).getServerCertificateData();
            }
            this.longErrCode = UtilTool.convertStr2Long(response.getErrCode(), -10700000L);
            this.strErrMsg = errprocess.getErrDesc(response.getErrCode(), ErrorProcess.vDefServerInfo);
        }
        catch (CSSException e) {
            this.longErrCode = UtilTool.convertStr2Long(e.getCode(), -10700000L);
            this.strErrMsg = e.getDescription();
        }
        return null;
    }

    public String SOF_GenRandom(int len) throws SOR_RandomNumberException, SOR_Base64Exception, SOR_ParameterNotSupportException {
        if (len < 1) {
            throw new SOR_ParameterNotSupportException(errprocess.getErrDesc("-90900007", ErrorProcess.vDefServerInfo));
        }
        byte[] data = ds.generateRandom(len);
        if (data == null) {
            throw new SOR_RandomNumberException(errprocess.getErrDesc("-90900008", ErrorProcess.vDefServerInfo));
        }
        String base64Data = null;
        try {
            base64Data = Base64.encodeBytes(data);
        }
        catch (Exception e) {
            LOGGER.error((Object)errprocess.getErrDesc("-90900004", ErrorProcess.vDefServerInfo), (Throwable)e);
            throw new SOR_Base64Exception(errprocess.getErrDesc("-90900004", ErrorProcess.vDefServerInfo));
        }
        return base64Data;
    }

    public String SOF_GetCertInfo(String base64EncodeCert, int type) throws SOR_NullPointerException, SOR_ParameterNotSupportException, SOR_CertEncodeException, SOR_GetCertInfoException {
        if (base64EncodeCert == null || base64EncodeCert.equals("")) {
            throw new SOR_NullPointerException(errprocess.getErrDesc("-90900001", ErrorProcess.vDefServerInfo));
        }
        if (!this.verifyType(type)) {
            throw new SOR_ParameterNotSupportException(errprocess.getErrDesc("-90900007", ErrorProcess.vDefServerInfo));
        }
        try {
            GetCertInfoRequestSet req = new GetCertInfoRequestSet();
            req.setBase64EncodeCert(base64EncodeCert);
            req.setType(String.valueOf(type));
            ResponseSet response = this.client.requestWS(req);
            if (response instanceof WSResponseSet) {
                String base64CertInfo = ((WSResponseSet)response).getCertInfo();
                String fileSystemChartSet = Config.getInstance().getFileSystemCharSet();
                if (null == fileSystemChartSet || "default".equals(fileSystemChartSet)) {
                    fileSystemChartSet = Config.getInstance().getSystemCharSet();
                }
                try {
                    return new String(Base64.decode(base64CertInfo), fileSystemChartSet);
                }
                catch (UnsupportedEncodingException e) {
                    return new String(Base64.decode(base64CertInfo));
                }
                catch (RuntimeException e) {
                    return new String(Base64.decode(base64CertInfo));
                }
            }
            this.longErrCode = UtilTool.convertStr2Long(response.getErrCode(), -10700000L);
            if (this.longErrCode == 90900004L) {
                throw new SOR_CertEncodeException(errprocess.getErrDesc(response.getErrCode(), ErrorProcess.vDefServerInfo));
            }
            throw new SOR_GetCertInfoException(errprocess.getErrDesc(response.getErrCode(), ErrorProcess.vDefServerInfo));
        }
        catch (CSSException e) {
            this.longErrCode = UtilTool.convertStr2Long(e.getCode(), -10700000L);
            this.strErrMsg = e.getDescription();
            throw new SOR_GetCertInfoException(errprocess.getErrDesc("90900009", ErrorProcess.vDefServerInfo));
        }
    }

    public String SOF_GetCertInfoByOid(String base64EncodeCert, String oid) throws SOR_NullPointerException, SOR_CertEncodeException, SOR_GetCertInfoException {
        if (base64EncodeCert == null || base64EncodeCert.equals("") || oid == null || oid.equals("")) {
            throw new SOR_NullPointerException(errprocess.getErrDesc("-90900001", ErrorProcess.vDefServerInfo));
        }
        try {
            GetCertInfoByOidRequestSet req = new GetCertInfoByOidRequestSet();
            req.setBase64EncodeCert(base64EncodeCert);
            req.setOid(oid);
            ResponseSet response = this.client.requestWS(req);
            if (response instanceof WSResponseSet) {
                String base64CertInfo = ((WSResponseSet)response).getCertInfoByOid();
                String fileSystemChartSet = Config.getInstance().getFileSystemCharSet();
                if (null == fileSystemChartSet || "default".equals(fileSystemChartSet)) {
                    fileSystemChartSet = Config.getInstance().getSystemCharSet();
                }
                try {
                    return new String(Base64.decode(base64CertInfo), fileSystemChartSet);
                }
                catch (UnsupportedEncodingException e) {
                    return new String(Base64.decode(base64CertInfo));
                }
                catch (RuntimeException e) {
                    return new String(Base64.decode(base64CertInfo));
                }
            }
            this.longErrCode = UtilTool.convertStr2Long(response.getErrCode(), -10700000L);
            if (this.longErrCode == 90900004L) {
                throw new SOR_CertEncodeException(errprocess.getErrDesc(response.getErrCode(), ErrorProcess.vDefServerInfo));
            }
            throw new SOR_GetCertInfoException(errprocess.getErrDesc(response.getErrCode(), ErrorProcess.vDefServerInfo));
        }
        catch (CSSException e) {
            this.longErrCode = UtilTool.convertStr2Long(e.getCode(), -10700000L);
            this.strErrMsg = e.getDescription();
            throw new SOR_GetCertInfoException(errprocess.getErrDesc("90900009", ErrorProcess.vDefServerInfo));
        }
    }

    public String SOF_SignDataByP7(String inData) throws SOR_NullPointerException, SOR_SignDataException, SOR_Pkcs7SignException, SOR_Pkcs7EncodeException, SOR_CertificateException, SOR_KeyStoreException, SOR_NoSuchAlgorithmException, SOR_SignatureException {
        if (inData == null || inData.equals("")) {
            throw new SOR_NullPointerException(errprocess.getErrDesc("-90900001", ErrorProcess.vDefServerInfo));
        }
        String signed = ds.attachSign("", inData.getBytes());
        if (signed != null) {
            return signed;
        }
        this.longErrCode = ds.getErrorCode();
        if (this.longErrCode == 10701003L) {
            throw new SOR_Pkcs7SignException(errprocess.getErrDesc("90900020", ErrorProcess.vDefServerInfo));
        }
        if (this.longErrCode == 10440005L) {
            throw new SOR_Pkcs7EncodeException(errprocess.getErrDesc(String.valueOf(this.longErrCode), ErrorProcess.vDefServerInfo));
        }
        if (this.longErrCode == 10480009L) {
            throw new SOR_CertificateException(errprocess.getErrDesc(String.valueOf(this.longErrCode), ErrorProcess.vDefServerInfo));
        }
        if (this.longErrCode == 10480004L) {
            throw new SOR_KeyStoreException(errprocess.getErrDesc(String.valueOf(this.longErrCode), ErrorProcess.vDefServerInfo));
        }
        if (this.longErrCode == 10701002L) {
            throw new SOR_NoSuchAlgorithmException(errprocess.getErrDesc(String.valueOf(this.longErrCode), ErrorProcess.vDefServerInfo));
        }
        throw new SOR_Pkcs7SignException(errprocess.getErrDesc("90900020", ErrorProcess.vDefServerInfo));
    }

    public boolean SOF_VerifySignedDataByP7(String pkcs7SignData) throws SOR_NullPointerException, SOR_VerifySignDataException, SOR_Pkcs7EncodeException, SOR_Pkcs7VerifySignException, SOR_CRLException, SOR_NoSuchAlgorithmException, SOR_CertificateException {
        if (pkcs7SignData == null || pkcs7SignData.equals("")) {
            throw new SOR_NullPointerException(errprocess.getErrDesc("-90900001", ErrorProcess.vDefServerInfo));
        }
        if (0L == ds.verifyAttachedSign(pkcs7SignData.getBytes())) {
            return true;
        }
        this.longErrCode = ds.getErrorCode();
        if (this.longErrCode == 10702027L) {
            throw new SOR_Pkcs7VerifySignException(errprocess.getErrDesc(String.valueOf(this.longErrCode), ErrorProcess.vDefServerInfo));
        }
        if (this.longErrCode == 10440005L) {
            throw new SOR_Pkcs7EncodeException(errprocess.getErrDesc(String.valueOf(this.longErrCode), ErrorProcess.vDefServerInfo));
        }
        if (this.longErrCode == 10706280L) {
            throw new SOR_CRLException(errprocess.getErrDesc(String.valueOf(this.longErrCode), ErrorProcess.vDefServerInfo));
        }
        if (this.longErrCode == 10701002L) {
            throw new SOR_NoSuchAlgorithmException(errprocess.getErrDesc(String.valueOf(this.longErrCode), ErrorProcess.vDefServerInfo));
        }
        if (this.longErrCode == 10480009L) {
            throw new SOR_CertificateException(errprocess.getErrDesc(String.valueOf(this.longErrCode), ErrorProcess.vDefServerInfo));
        }
        throw new SOR_VerifySignDataException(errprocess.getErrDesc("90900015", ErrorProcess.vDefServerInfo));
    }

    public boolean SOF_VerifyTimeStamp(String content, String tsResponseData) throws SOR_NullPointerException, SOR_VerifySignDataException, SOR_InitException, SOR_TsException {
        if (content == null || content.equals("") || tsResponseData == null || tsResponseData.equals("")) {
            throw new SOR_NullPointerException(errprocess.getErrDesc("-90900001", ErrorProcess.vDefServerInfo));
        }
        try {
            TSAClient client = this.getTSAClient(cssconfigUrl);
            TSAVerifyResult tsaResult = client.verifyTimeStamp(Base64.decode(tsResponseData.trim().replaceAll("\\s*", "")));
            String contentDigest = HelperUtil.bytesToHexString(SecurityUtil.doDigest(content.getBytes(), "SHA1"));
            String contentSign = HelperUtil.bytesToHexString(tsaResult.getData());
            String string = contentDigest = contentDigest != null ? contentDigest : "";
            if (contentDigest.equals(contentSign)) {
                return true;
            }
        }
        catch (IOException e) {
            throw new SOR_InitException(errprocess.getErrDesc("-90900002", ErrorProcess.vDefServerInfo));
        }
        catch (TSAException e) {
            if (e.getCode().equals("10702005")) {
                throw new SOR_VerifySignDataException(errprocess.getErrDesc("90900026", ErrorProcess.vDefServerInfo));
            }
            throw new SOR_TsException(errprocess.getErrDesc("90900027", ErrorProcess.vDefServerInfo));
        }
        catch (NoSuchAlgorithmException e) {
            throw new SOR_TsException(errprocess.getErrDesc("90900027", ErrorProcess.vDefServerInfo));
        }
        return false;
    }

    public String SOF_GetP7SignDataInfo(String pkcs7SignData, int type) throws SOR_NullPointerException, SOR_ParameterNotSupportException, SOR_Pkcs7EncodeException, SOR_CertificateException {
        if (null == pkcs7SignData || pkcs7SignData.length() == 0) {
            throw new SOR_NullPointerException(errprocess.getErrDesc("-90900001", ErrorProcess.vDefServerInfo));
        }
        if (type != 1 && type != 2 && type != 3) {
            throw new SOR_ParameterNotSupportException(errprocess.getErrDesc("-90900007", ErrorProcess.vDefServerInfo));
        }
        try {
            GetP7SignDataInfoRequestSet req = new GetP7SignDataInfoRequestSet();
            req.setPkcs7SignData(pkcs7SignData);
            req.setType(String.valueOf(type));
            ResponseSet response = this.client.requestWS(req);
            if (response instanceof WSResponseSet) {
                String rnMessage = ((WSResponseSet)response).getResultData();
                if (1 == type) {
                    return new String(Base64.decode(rnMessage));
                }
                return rnMessage;
            }
            this.longErrCode = UtilTool.convertStr2Long(response.getErrCode(), -10700000L);
            if (this.longErrCode == 10440006L) {
                throw new SOR_Pkcs7EncodeException(errprocess.getErrDesc(String.valueOf(this.longErrCode), ErrorProcess.vDefServerInfo));
            }
            throw new SOR_CertificateException(errprocess.getErrDesc(String.valueOf(this.longErrCode), ErrorProcess.vDefServerInfo));
        }
        catch (CSSException e) {
            this.longErrCode = UtilTool.convertStr2Long(e.getCode(), -10700000L);
            this.strErrMsg = e.getDescription();
            throw new SOR_CertificateException(errprocess.getErrDesc("90900010", ErrorProcess.vDefServerInfo));
        }
    }

    public String SOF_CreateTimeStampRequest(String inData) throws SOR_NullPointerException, SOR_HashException, SOR_Base64Exception, SOR_TsException {
        if (null == inData || inData.length() == 0) {
            throw new SOR_NullPointerException(errprocess.getErrDesc("-90900001", ErrorProcess.vDefServerInfo));
        }
        try {
            CreateTimeStampRequestRequestSet req = new CreateTimeStampRequestRequestSet();
            byte[] digestData = SecurityUtil.doDigest(inData.getBytes(), "SHA1");
            String base64DigestData = Base64.encodeBytes(digestData);
            if (base64DigestData == null || base64DigestData.length() == 0) {
                throw new SOR_Base64Exception(errprocess.getErrDesc("-90900004", ErrorProcess.vDefServerInfo));
            }
            req.setPlainData(base64DigestData);
            URL serverURL2 = config.getServerURL2();
            ResponseSet response = null;
            response = serverURL2 != null ? this.client.requestWS(req, serverURL2) : this.client.requestWS(req);
            if (response instanceof WSResponseSet) {
                return ((WSResponseSet)response).getTimeStampRequest();
            }
            this.longErrCode = UtilTool.convertStr2Long(response.getErrCode(), -10700000L);
            throw new SOR_TsException(errprocess.getErrDesc(String.valueOf(this.longErrCode), ErrorProcess.vDefServerInfo));
        }
        catch (CSSException e) {
            this.longErrCode = UtilTool.convertStr2Long(e.getCode(), -10700000L);
            this.strErrMsg = e.getDescription();
            throw new SOR_TsException(errprocess.getErrDesc("90900027", ErrorProcess.vDefServerInfo));
        }
        catch (NoSuchAlgorithmException e) {
            throw new SOR_HashException(errprocess.getErrDesc("-90900009", ErrorProcess.vDefServerInfo));
        }
    }

    public String SOF_CreateTimeStampResponse(String inData) throws SOR_NullPointerException, SOR_SignDataException, SOR_TsException {
        if (null == inData || inData.length() == 0) {
            throw new SOR_NullPointerException(errprocess.getErrDesc("-90900001", ErrorProcess.vDefServerInfo));
        }
        try {
            CreateTimeStampResponseRequestSet req = new CreateTimeStampResponseRequestSet();
            req.setTimeStampRequest(inData);
            URL serverURL2 = config.getServerURL2();
            ResponseSet response = null;
            response = serverURL2 != null ? this.client.requestWS(req, serverURL2) : this.client.requestWS(req);
            if (response instanceof WSResponseSet) {
                return ((WSResponseSet)response).getTimeStampResponse();
            }
            this.longErrCode = UtilTool.convertStr2Long(response.getErrCode(), -10700000L);
            if (this.longErrCode == 90900013L) {
                throw new SOR_SignDataException(errprocess.getErrDesc(String.valueOf(this.longErrCode), ErrorProcess.vDefServerInfo));
            }
            throw new SOR_TsException(errprocess.getErrDesc(String.valueOf(this.longErrCode), ErrorProcess.vDefServerInfo));
        }
        catch (CSSException e) {
            this.longErrCode = UtilTool.convertStr2Long(e.getCode(), -10700000L);
            this.strErrMsg = e.getDescription();
            throw new SOR_TsException(errprocess.getErrDesc("90900027", ErrorProcess.vDefServerInfo));
        }
    }

    public String SOF_GetTimeStampInfo(String tsResponseData, int type) throws SOR_NullPointerException, SOR_ParameterNotSupportException, SOR_Base64Exception, SOR_ParseException, SOR_TsException {
        if (null == tsResponseData || tsResponseData.length() == 0) {
            throw new SOR_NullPointerException(errprocess.getErrDesc("-90900001", ErrorProcess.vDefServerInfo));
        }
        if (type != 1 && type != 2 && type != 3) {
            throw new SOR_ParameterNotSupportException(errprocess.getErrDesc("-90900007", ErrorProcess.vDefServerInfo));
        }
        try {
            GetTimeStampInfoRequestSet req = new GetTimeStampInfoRequestSet();
            byte[] tsaData = Base64.decode(tsResponseData.trim().replaceAll("\\s*", ""));
            if (tsaData == null) {
                throw new SOR_Base64Exception(errprocess.getErrDesc("-90900004", ErrorProcess.vDefServerInfo));
            }
            req.setTimeStampResult(Base64.encodeBytes(tsaData));
            req.setType(String.valueOf(type));
            URL serverURL2 = config.getServerURL2();
            ResponseSet response = null;
            response = serverURL2 != null ? this.client.requestWS(req, serverURL2) : this.client.requestWS(req);
            if (response instanceof WSResponseSet) {
                String rnMessage = ((WSResponseSet)response).getResultData();
                if (type == 1) {
                    return new String(Base64.decode(rnMessage));
                }
                return rnMessage;
            }
            this.longErrCode = UtilTool.convertStr2Long(response.getErrCode(), -10700000L);
            if (this.longErrCode == 90900028L) {
                throw new SOR_ParseException(errprocess.getErrDesc(String.valueOf(this.longErrCode), ErrorProcess.vDefServerInfo));
            }
            throw new SOR_TsException(errprocess.getErrDesc(String.valueOf(this.longErrCode), ErrorProcess.vDefServerInfo));
        }
        catch (CSSException e) {
            this.longErrCode = UtilTool.convertStr2Long(e.getCode(), -10700000L);
            this.strErrMsg = e.getDescription();
            throw new SOR_TsException(errprocess.getErrDesc("90900027", ErrorProcess.vDefServerInfo));
        }
    }

    private TSAClient getTSAClient(String path) throws IOException {
        FileInputStream is = null;
        is = new FileInputStream(path);
        Properties configFileProp = new Properties();
        configFileProp.load(is);
        TSAClientFactory factory = TSAClientFactory.newInstance(configFileProp);
        TSAClient client = factory.getTSAClient();
        return client;
    }

    public String SOF_SignDataXML(String inData) throws SOR_NullPointerException, SOR_XmlEncodeException, SOR_SignDataException, SOR_XmlSignException {
        if (inData == null || inData.length() < 1) {
            throw new SOR_NullPointerException(errprocess.getErrDesc("-90900001", ErrorProcess.vDefServerInfo));
        }
        String retData = "";
        try {
            retData = ds.attachXMLSign("", inData.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        if (retData != null && retData.length() > 0) {
            return retData;
        }
        long errorCode = ds.getErrorCode();
        String strErrorCode = String.valueOf(errorCode);
        if (strErrorCode.equalsIgnoreCase("90900030") || strErrorCode.equalsIgnoreCase("90900031")) {
            throw new SOR_XmlEncodeException(strErrorCode, errprocess.getErrDesc(strErrorCode, ErrorProcess.vDefServerInfo));
        }
        if (strErrorCode.equalsIgnoreCase("90900045")) {
            throw new SOR_SignDataException(strErrorCode, errprocess.getErrDesc(String.valueOf(errorCode), ErrorProcess.vDefServerInfo));
        }
        if (strErrorCode.equalsIgnoreCase("90900044")) {
            throw new SOR_XmlSignException(strErrorCode, errprocess.getErrDesc(String.valueOf(errorCode), ErrorProcess.vDefServerInfo));
        }
        throw new SOR_XmlSignException(strErrorCode, errprocess.getErrDesc(strErrorCode, ErrorProcess.vDefServerInfo));
    }

    public boolean SOF_VerifySignedDataXML(String inData) throws SOR_NullPointerException, SOR_XmlEncodeException, SOR_XmlVerifySignException, SOR_VerifySignDataException {
        if (inData == null || inData.length() < 1) {
            throw new SOR_NullPointerException(errprocess.getErrDesc("-90900001", "\u539f\u6587\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        long a = 0L;
        try {
            a = ds.verifyAttachedXMLSign(inData.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        if (a == 0L) {
            return true;
        }
        long errorCode = ds.getErrorCode();
        String strErrorCode = String.valueOf(errorCode);
        if (strErrorCode != null || !"".equals(strErrorCode)) {
            if (strErrorCode.equalsIgnoreCase("10700000")) {
                return false;
            }
            throw new SOR_XmlEncodeException(strErrorCode, ds.getErrorMessage());
        }
        return false;
    }

    public String SOF_GetXMLSignatureInfo(String XMLSignedData, short type) throws SOR_NullPointerException, SOR_ParameterNotSupportException, SOR_XmlEncodeException, SOR_JDOMException, SOR_GetXMLSignInfoException {
        block8: {
            try {
                if (XMLSignedData == null || XMLSignedData.length() < 1) {
                    throw new SOR_NullPointerException("-90900001", "\u539f\u6587\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (type < 1 || type > 6) {
                    throw new SOR_ParameterNotSupportException("-90900007", "\u4e0d\u652f\u6301\u7684\u53c2\u6570");
                }
                WSParseXMLSignedDataRequestSet request = new WSParseXMLSignedDataRequestSet();
                try {
                    request.setBase64XMLSignedData(Base64.encodeBytes(XMLSignedData.getBytes("UTF-8")));
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                request.setType(type);
                ResponseSet response = this.client.requestWS(request);
                if (!response.isSucceed()) {
                    String strErrorCode = response.getErrCode();
                    if (null != strErrorCode || !"".equals(strErrorCode)) {
                        throw new SOR_GetXMLSignInfoException(strErrorCode, response.getErrDesc());
                    }
                    break block8;
                }
                String parsedInfo = ((WSParseXMLSignedDataResponseSet)response).getParsedInfo();
                return parsedInfo;
            }
            catch (CSSException e) {
                throw new SOR_GetXMLSignInfoException(e.getCode(), e.getDescription());
            }
        }
        return XMLSignedData;
    }

    public String SOF_GetEncryptValues(String encrypt) {
        if (encrypt.equals("101")) {
            return "SCB2_ECB";
        }
        if (encrypt.equals("101")) {
            return "SCB2_ECB";
        }
        if (encrypt.equals("102")) {
            return "SCB2_CBC";
        }
        if (encrypt.equals("201")) {
            return "SF33_ECB";
        }
        if (encrypt.equals("202")) {
            return "SF33_CBC";
        }
        if (encrypt.equals("301")) {
            return "DES_ECB";
        }
        if (encrypt.equals("302")) {
            return "AES_ECB";
        }
        if (encrypt.equals("303")) {
            return "DESede_ECB";
        }
        if (encrypt.equals("401")) {
            return "DES_CBC";
        }
        if (encrypt.equals("402")) {
            return "AES_CBC";
        }
        if (encrypt.equals("403")) {
            return "DESede_CBC";
        }
        if (encrypt.equals("1002")) {
            return "SHA1RSA";
        }
        return null;
    }

    public String SOF_GetSignTypeValues(int sign) {
        switch (sign) {
            case 1002: {
                return "SHA1RSA";
            }
        }
        return null;
    }

    public static boolean isIS_INITED() {
        return IS_INITED;
    }

    public static void setIS_INITED(boolean iSINITED) {
        IS_INITED = iSINITED;
    }

    public long getLongErrCode() {
        return this.longErrCode;
    }

    public void setLongErrCode(long longErrCode) {
        this.longErrCode = longErrCode;
    }

    public String getStrErrMsg() {
        return this.strErrMsg;
    }

    public void setStrErrMsg(String strErrMsg) {
        this.strErrMsg = strErrMsg;
    }

    public ResultSet getRs() {
        return this.rs;
    }

    public void setRs(ResultSet rs) {
        this.rs = rs;
    }

    public DSignClient getDsclient() {
        return this.dsclient;
    }

    public void setDsclient(DSignClient dsclient) {
        this.dsclient = dsclient;
    }

    public String getDigestAlgID() {
        return this.digestAlgID;
    }

    public void setDigestAlgID(String digestAlgID) {
        this.digestAlgID = digestAlgID;
    }

    public String getPlainData() {
        return this.plainData;
    }

    public void setPlainData(String plainData) {
        this.plainData = plainData;
    }

    public byte[] getPlainByteData() {
        return this.plainByteData;
    }

    public void setPlainByteData(byte[] plainByteData) {
        this.plainByteData = plainByteData;
    }

    public String getRndigestAlgID() {
        return this.rndigestAlgID;
    }

    public void setRndigestAlgID(String rndigestAlgID) {
        this.rndigestAlgID = rndigestAlgID;
    }

    public byte[] getFilePlainData() {
        return this.filePlainData;
    }

    public void setFilePlainData(byte[] filePlainData) {
        this.filePlainData = filePlainData;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getOutFileName() {
        return this.outFileName;
    }

    public void setOutFileName(String outFileName) {
        this.outFileName = outFileName;
    }

    private boolean verifyType(int type) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 1; i < 41; ++i) {
            list.add(String.valueOf(i));
        }
        return list.contains(String.valueOf(type));
    }

    public static WSConfig getConfig() {
        return config;
    }

    public static void setConfig(WSConfig config) {
        WSSign.config = config;
    }
}

