/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.ida.util.pki.tsp;

import cn.com.jit.ida.util.pki.PKIException;
import cn.com.jit.ida.util.pki.Parser;
import cn.com.jit.ida.util.pki.asn1.ASN1InputStream;
import cn.com.jit.ida.util.pki.asn1.ASN1Sequence;
import cn.com.jit.ida.util.pki.asn1.ASN1Set;
import cn.com.jit.ida.util.pki.asn1.DERBoolean;
import cn.com.jit.ida.util.pki.asn1.DERGeneralizedTime;
import cn.com.jit.ida.util.pki.asn1.DERInteger;
import cn.com.jit.ida.util.pki.asn1.DERObject;
import cn.com.jit.ida.util.pki.asn1.DERObjectIdentifier;
import cn.com.jit.ida.util.pki.asn1.DERSet;
import cn.com.jit.ida.util.pki.asn1.cms.AttributeTable;
import cn.com.jit.ida.util.pki.asn1.cms.IssuerAndSerialNumber;
import cn.com.jit.ida.util.pki.asn1.cms.PKIStatusInfo;
import cn.com.jit.ida.util.pki.asn1.cms.SignedData;
import cn.com.jit.ida.util.pki.asn1.cms.SignerInfo;
import cn.com.jit.ida.util.pki.asn1.pkcs.PKCSObjectIdentifiers;
import cn.com.jit.ida.util.pki.asn1.x509.AlgorithmIdentifier;
import cn.com.jit.ida.util.pki.asn1.x509.CertificateList;
import cn.com.jit.ida.util.pki.asn1.x509.GeneralName;
import cn.com.jit.ida.util.pki.asn1.x509.X509CertificateStructure;
import cn.com.jit.ida.util.pki.asn1.x509.X509Extensions;
import cn.com.jit.ida.util.pki.cert.X509Cert;
import cn.com.jit.ida.util.pki.cipher.JKey;
import cn.com.jit.ida.util.pki.cipher.Mechanism;
import cn.com.jit.ida.util.pki.cipher.Session;
import cn.com.jit.ida.util.pki.cipher.param.P7Param;
import cn.com.jit.ida.util.pki.cipher.param.p7CertInfo;
import cn.com.jit.ida.util.pki.cipher.param.p7signInfo;
import cn.com.jit.ida.util.pki.cipher.param.tspCMSRespInfo;
import cn.com.jit.ida.util.pki.cms.JITCMSSignedDataGenerator;
import cn.com.jit.ida.util.pki.crl.X509CRL;
import cn.com.jit.ida.util.pki.encoders.Base64;
import cn.com.jit.ida.util.pki.tsp.Accuracy;
import cn.com.jit.ida.util.pki.tsp.CmsTspResp;
import cn.com.jit.ida.util.pki.tsp.MessageImprint;
import cn.com.jit.ida.util.pki.tsp.TSTInfo;
import cn.com.jit.ida.util.pki.tsp.TimeStampResp;
import cn.com.jit.ida.util.pki.tsp.TspRequest;
import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.SimpleTimeZone;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;

public class TspResp {
    TspRequest req;
    Date tspTime;
    BigInteger sn;
    Accuracy timeacc;
    boolean isOrder = false;
    private Session session = null;
    TimeStampResp stampResp;
    PKIStatusInfo status;
    GeneralName tsa;
    X509Extensions extensions;
    P7Param[] param;

    public TspResp() {
    }

    public TspResp(Session session) {
        this.session = session;
    }

    public static TspResp getInstance(Object o) {
        if (o == null || o instanceof TspResp) {
            return (TspResp)o;
        }
        throw new IllegalArgumentException("unknown object in 'tspResp' factory : " + o.getClass().getName() + ".");
    }

    public DERObject genRespObj_pdf(byte[] reqdata, String policy, BigInteger sn, Date time, Accuracy acc, Boolean isOrder, PKIStatusInfo status, GeneralName tsa, X509Extensions extensions, P7Param[] param, AttributeTable attrs, Mechanism certIDMech) throws PKIException {
        this.sn = sn;
        this.tspTime = time;
        this.timeacc = acc;
        this.isOrder = isOrder;
        this.status = status;
        this.tsa = tsa;
        this.extensions = extensions;
        this.param = param;
        TSTInfo info = this.getTstInfo(reqdata, policy, sn, time, acc, isOrder, tsa, extensions, null, false);
        try {
            JITCMSSignedDataGenerator gentor = new JITCMSSignedDataGenerator(this.session);
            ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
            TspRequest req = new TspRequest(reqdata);
            Mechanism digMech = req.getDigMech();
            DEREncodableVector vCerts = new DEREncodableVector();
            int i = 0;
            while (i < param.length) {
                if (param[i].GetPrvKey() == null) {
                    throw new PKIException("8223", "\u89e3\u6790\u65f6\u95f4\u6233\u5931\u8d25prv key is null");
                }
                if (digMech == null) {
                    throw new PKIException("8223", "\u89e3\u6790\u65f6\u95f4\u6233\u5931\u8d25dig mech is null");
                }
                param[i].SetSignMech(this.getSignmech(param[i].GetPrvKey(), digMech));
                String encryptionOID = this.getSign2EncOid(param[i].GetSignMech());
                String digestOID = this.getSign2DigOid(param[i].GetSignMech());
                int j = 0;
                while (j < param[i].GetCerts().length) {
                    certList.add(Parser.convertX509Cert2JavaCert(param[i].GetCerts()[j]));
                    ++j;
                }
                if (certIDMech != null) {
                    digMech = certIDMech;
                }
                DERSequence seqCert = this.getCertIDAttr(digMech, param[i].GetCerts()[0].getEncoded());
                vCerts.add((DEREncodable)seqCert);
                org.bouncycastle.asn1.DERSet certSet = new org.bouncycastle.asn1.DERSet(vCerts);
                org.bouncycastle.asn1.DERObjectIdentifier id = new org.bouncycastle.asn1.DERObjectIdentifier("1.2.840.113549.1.9.16.2.12");
                Attribute attr = new Attribute(id, (org.bouncycastle.asn1.ASN1Set)certSet);
                DEREncodableVector vAttrs = new DEREncodableVector();
                vAttrs.add((DEREncodable)attr);
                org.bouncycastle.asn1.cms.AttributeTable signAttrs = new org.bouncycastle.asn1.cms.AttributeTable(vAttrs);
                gentor.addSigner(param[i].GetPrvKey(), Parser.convertX509Cert2JavaCert(param[i].GetCerts()[0]), encryptionOID, digestOID, signAttrs, null);
                ++i;
            }
            this.param = param;
            CertStore certStore = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(certList), "SUN");
            if (certStore != null) {
                CertStore genCertStore = null;
                genCertStore = certStore;
                gentor.addCertificatesAndCRLs(genCertStore);
            }
            CMSSignedData signedData = gentor.generate(PKCSObjectIdentifiers.id_ct_TSTInfo.getId(), (CMSProcessable)new CMSProcessableByteArray(Parser.writeDERObj2Bytes(info)), true, this.session);
            ContentInfo cntInfo = ContentInfo.getInstance((Object)signedData.getContentInfo());
            DERObject obj = Parser.writeBytes2DERObj(cntInfo.getEncoded());
            cn.com.jit.ida.util.pki.asn1.pkcs.pkcs7.ContentInfo cnt = cn.com.jit.ida.util.pki.asn1.pkcs.pkcs7.ContentInfo.getInstance(obj);
            this.stampResp = new TimeStampResp(status, cnt);
        }
        catch (Exception e) {
            throw new PKIException("8223", "\u89e3\u6790\u65f6\u95f4\u6233\u5931\u8d25", e);
        }
        return this.stampResp.getDERObject();
    }

    public byte[] genResp_pdf(byte[] reqdata, String policy, BigInteger sn, Date time, Accuracy acc, Boolean isOrder, PKIStatusInfo status, GeneralName tsa, X509Extensions extensions, P7Param[] param, AttributeTable attrs, Mechanism certIDMech) throws PKIException {
        return Parser.writeDERObj2Bytes(this.genRespObj_pdf(reqdata, policy, sn, time, acc, isOrder, status, tsa, extensions, param, attrs, certIDMech));
    }

    public DERObject genRespObj_src(byte[] reqdata, byte[] data, boolean isSrc, String policy, BigInteger sn, Date time, Accuracy acc, Boolean isOrder, PKIStatusInfo status, GeneralName tsa, X509Extensions extensions, P7Param[] param, AttributeTable attrs, Mechanism certIDMech) throws PKIException {
        this.sn = sn;
        this.tspTime = time;
        this.timeacc = acc;
        this.isOrder = isOrder;
        this.status = status;
        this.tsa = tsa;
        this.extensions = extensions;
        this.param = param;
        TSTInfo info = this.getTstInfo(reqdata, policy, sn, time, acc, isOrder, tsa, extensions, data, isSrc);
        try {
            JITCMSSignedDataGenerator gentor = new JITCMSSignedDataGenerator(this.session);
            ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
            TspRequest req = new TspRequest(reqdata);
            Mechanism digMech = req.getDigMech();
            DEREncodableVector vCerts = new DEREncodableVector();
            int i = 0;
            while (i < param.length) {
                if (param[i].GetPrvKey() == null) {
                    throw new PKIException("8223", "\u89e3\u6790\u65f6\u95f4\u6233\u5931\u8d25prv key is null");
                }
                if (digMech == null) {
                    throw new PKIException("8223", "\u89e3\u6790\u65f6\u95f4\u6233\u5931\u8d25dig mech is null");
                }
                param[i].SetSignMech(this.getSignmech(param[i].GetPrvKey(), digMech));
                String encryptionOID = this.getSign2EncOid(param[i].GetSignMech());
                String digestOID = this.getSign2DigOid(param[i].GetSignMech());
                int j = 0;
                while (j < param[i].GetCerts().length) {
                    certList.add(Parser.convertX509Cert2JavaCert(param[i].GetCerts()[j]));
                    ++j;
                }
                if (certIDMech != null) {
                    digMech = certIDMech;
                }
                DERSequence seqCert = this.getCertIDAttr(digMech, param[i].GetCerts()[0].getEncoded());
                vCerts.add((DEREncodable)seqCert);
                org.bouncycastle.asn1.DERSet certSet = new org.bouncycastle.asn1.DERSet(vCerts);
                org.bouncycastle.asn1.DERObjectIdentifier id = new org.bouncycastle.asn1.DERObjectIdentifier("1.2.840.113549.1.9.16.2.12");
                Attribute attr = new Attribute(id, (org.bouncycastle.asn1.ASN1Set)certSet);
                DEREncodableVector vAttrs = new DEREncodableVector();
                vAttrs.add((DEREncodable)attr);
                org.bouncycastle.asn1.cms.AttributeTable signAttrs = new org.bouncycastle.asn1.cms.AttributeTable(vAttrs);
                gentor.addSigner(param[i].GetPrvKey(), Parser.convertX509Cert2JavaCert(param[i].GetCerts()[0]), encryptionOID, digestOID, signAttrs, null);
                ++i;
            }
            this.param = param;
            CertStore certStore = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(certList), "SUN");
            if (certStore != null) {
                CertStore genCertStore = null;
                genCertStore = certStore;
                gentor.addCertificatesAndCRLs(genCertStore);
            }
            CMSSignedData signedData = gentor.generate(PKCSObjectIdentifiers.id_ct_TSTInfo.getId(), (CMSProcessable)new CMSProcessableByteArray(Parser.writeDERObj2Bytes(info)), true, this.session);
            ContentInfo cntInfo = ContentInfo.getInstance((Object)signedData.getContentInfo());
            DERObject obj = Parser.writeBytes2DERObj(cntInfo.getEncoded());
            cn.com.jit.ida.util.pki.asn1.pkcs.pkcs7.ContentInfo cnt = cn.com.jit.ida.util.pki.asn1.pkcs.pkcs7.ContentInfo.getInstance(obj);
            this.stampResp = new TimeStampResp(status, cnt);
        }
        catch (Exception e) {
            throw new PKIException("8223", "\u89e3\u6790\u65f6\u95f4\u6233\u5931\u8d25", e);
        }
        return this.stampResp.getDERObject();
    }

    public byte[] genResp_src(byte[] reqdata, byte[] data, boolean isSrc, String policy, BigInteger sn, Date time, Accuracy acc, Boolean isOrder, PKIStatusInfo status, GeneralName tsa, X509Extensions extensions, P7Param[] param, AttributeTable attrs, Mechanism certIDMech) throws PKIException {
        return Parser.writeDERObj2Bytes(this.genRespObj_src(reqdata, data, isSrc, policy, sn, time, acc, isOrder, status, tsa, extensions, param, attrs, certIDMech));
    }

    public DERObject genRespObj(byte[] reqdata, String policy, BigInteger sn, Date time, Accuracy acc, Boolean isOrder, PKIStatusInfo status, GeneralName tsa, X509Extensions extensions, P7Param[] param, AttributeTable attrs) throws PKIException {
        this.sn = sn;
        this.tspTime = time;
        this.timeacc = acc;
        this.isOrder = isOrder;
        this.status = status;
        this.tsa = tsa;
        this.extensions = extensions;
        this.param = param;
        TSTInfo info = this.getTstInfo(reqdata, policy, sn, time, acc, isOrder, tsa, extensions, null, false);
        try {
            JITCMSSignedDataGenerator gentor = new JITCMSSignedDataGenerator(this.session);
            ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
            TspRequest req = new TspRequest(reqdata);
            Mechanism digMech = req.getDigMech();
            DEREncodableVector vCerts = new DEREncodableVector();
            int i = 0;
            while (i < param.length) {
                if (param[i].GetPrvKey() == null) {
                    throw new PKIException("8223", "\u89e3\u6790\u65f6\u95f4\u6233\u5931\u8d25prv key is null");
                }
                if (digMech == null) {
                    throw new PKIException("8223", "\u89e3\u6790\u65f6\u95f4\u6233\u5931\u8d25dig mech is null");
                }
                param[i].SetSignMech(this.getSignmech(param[i].GetPrvKey(), digMech));
                String encryptionOID = this.getSign2EncOid(param[i].GetSignMech());
                String digestOID = this.getSign2DigOid(param[i].GetSignMech());
                int j = 0;
                while (j < param[i].GetCerts().length) {
                    certList.add(Parser.convertX509Cert2JavaCert(param[i].GetCerts()[j]));
                    ++j;
                }
                org.bouncycastle.asn1.cms.AttributeTable signAttrs = null;
                if (attrs != null) {
                    signAttrs = new org.bouncycastle.asn1.cms.AttributeTable(attrs.toHashtable());
                }
                gentor.addSigner(param[i].GetPrvKey(), Parser.convertX509Cert2JavaCert(param[i].GetCerts()[0]), encryptionOID, digestOID, signAttrs, null);
                ++i;
            }
            this.param = param;
            CertStore certStore = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(certList), "SUN");
            if (certStore != null) {
                CertStore genCertStore = null;
                genCertStore = certStore;
                gentor.addCertificatesAndCRLs(genCertStore);
            }
            CMSSignedData signedData = gentor.generate(PKCSObjectIdentifiers.id_ct_TSTInfo.getId(), (CMSProcessable)new CMSProcessableByteArray(Parser.writeDERObj2Bytes(info)), true, this.session);
            ContentInfo cntInfo = ContentInfo.getInstance((Object)signedData.getContentInfo());
            DERObject obj = Parser.writeBytes2DERObj(cntInfo.getEncoded());
            cn.com.jit.ida.util.pki.asn1.pkcs.pkcs7.ContentInfo cnt = cn.com.jit.ida.util.pki.asn1.pkcs.pkcs7.ContentInfo.getInstance(obj);
            this.stampResp = new TimeStampResp(status, cnt);
        }
        catch (Exception e) {
            throw new PKIException("8223", "\u89e3\u6790\u65f6\u95f4\u6233\u5931\u8d25", e);
        }
        return this.stampResp.getDERObject();
    }

    public byte[] genResp(byte[] reqdata, String policy, BigInteger sn, Date time, Accuracy acc, Boolean isOrder, PKIStatusInfo status, GeneralName tsa, X509Extensions extensions, P7Param[] param, AttributeTable attrs) throws PKIException {
        return Parser.writeDERObj2Bytes(this.genRespObj(reqdata, policy, sn, time, acc, isOrder, status, tsa, extensions, param, attrs));
    }

    public boolean verifyRespObj(DERObject obj, X509Cert[] certs) throws PKIException {
        this.stampResp = TimeStampResp.getInstance(obj);
        this.status = this.stampResp.getStatus();
        cn.com.jit.ida.util.pki.asn1.pkcs.pkcs7.ContentInfo cntInfo = this.stampResp.getTimeStampToken();
        cn.com.jit.ida.util.pki.cms.CMSSignedData signedData = new cn.com.jit.ida.util.pki.cms.CMSSignedData(this.session);
        signedData.load(Parser.writeDERObj2Bytes(this.stampResp.getTimeStampToken()));
        return signedData.verify();
    }

    public boolean verifyResp(byte[] data, X509Cert[] certs) throws PKIException {
        boolean isB64 = Parser.isBase64Encode(data);
        if (isB64) {
            data = Parser.convertBase64(data);
            data = Base64.decode(data);
        }
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(data);
            ASN1InputStream ais = new ASN1InputStream(bis);
            this.stampResp = TimeStampResp.getInstance((ASN1Sequence)ais.readObject());
            ais.close();
            bis.close();
            return this.verifyRespObj(this.stampResp.getDERObject(), certs);
        }
        catch (Exception ex) {
            throw new PKIException("8223", "\u89e3\u6790\u65f6\u95f4\u6233\u5931\u8d25", ex);
        }
    }

    public tspCMSRespInfo parserResp(byte[] data) throws PKIException {
        boolean isB64 = Parser.isBase64Encode(data);
        if (isB64) {
            data = Parser.convertBase64(data);
            data = Base64.decode(data);
        }
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(data);
            ASN1InputStream ais = new ASN1InputStream(bis);
            this.stampResp = TimeStampResp.getInstance((ASN1Sequence)ais.readObject());
            if (this.stampResp == null) {
                throw new PKIException("8223", "\u89e3\u6790\u65f6\u95f4\u6233\u5931\u8d25");
            }
            ais.close();
            bis.close();
            this.status = this.stampResp.getStatus();
            cn.com.jit.ida.util.pki.asn1.pkcs.pkcs7.ContentInfo cntInfo = this.stampResp.getTimeStampToken();
            CmsTspResp resp = new CmsTspResp(this.session);
            tspCMSRespInfo rspInfo = resp.parserResp(Parser.writeDERObj2Bytes(this.stampResp.getTimeStampToken()));
            return rspInfo;
        }
        catch (Exception ex) {
            throw new PKIException("8223", "\u89e3\u6790\u65f6\u95f4\u6233\u5931\u8d25", ex);
        }
    }

    public TspRequest getReq() {
        return this.req;
    }

    public void setReq(TspRequest req) {
        this.req = req;
    }

    public Date getTspTime() {
        return this.tspTime;
    }

    public void setTspTime(Date tspTime) {
        this.tspTime = tspTime;
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public BigInteger getSn() {
        return this.sn;
    }

    public void setSn(BigInteger sn) {
        this.sn = sn;
    }

    public Accuracy getTimeacc() {
        return this.timeacc;
    }

    public void setTimeacc(Accuracy timeacc) {
        this.timeacc = timeacc;
    }

    public boolean isOrder() {
        return this.isOrder;
    }

    public void setOrder(boolean isOrder) {
        this.isOrder = isOrder;
    }

    public TimeStampResp getStampResp() {
        return this.stampResp;
    }

    public void setStampResp(TimeStampResp stampResp) {
        this.stampResp = stampResp;
    }

    public PKIStatusInfo getStatus() {
        return this.status;
    }

    public void setStatus(PKIStatusInfo status) {
        this.status = status;
    }

    public GeneralName getTsa() {
        return this.tsa;
    }

    public void setTsa(GeneralName tsa) {
        this.tsa = tsa;
    }

    public X509Extensions getExtensions() {
        return this.extensions;
    }

    public void setExtensions(X509Extensions extensions) {
        this.extensions = extensions;
    }

    public P7Param[] getParam() {
        return this.param;
    }

    public void setParam(P7Param[] param) {
        this.param = param;
    }

    private TSTInfo getTstInfo(byte[] reqdata, String policy, BigInteger sn, Date time, Accuracy acc, Boolean isOrder, GeneralName tsa, X509Extensions extensions, byte[] data, boolean isSrc) throws PKIException {
        MessageImprint mImprint;
        TspRequest req = new TspRequest(reqdata);
        DERObjectIdentifier digoid = TspRequest.GetDigOid(req.getDigMech());
        AlgorithmIdentifier algoDig = new AlgorithmIdentifier(digoid);
        DERObjectIdentifier policyId = null;
        if (req.getPolicy() == null && policy == null) {
            throw new PKIException("8223", "\u89e3\u6790\u65f6\u95f4\u6233\u5931\u8d25 no policyId");
        }
        policyId = req.getPolicy() != null ? new DERObjectIdentifier(req.getPolicy()) : new DERObjectIdentifier(policy);
        byte[] dig = req.getData();
        Mechanism digMech = req.getDigMech();
        if (data != null) {
            dig = isSrc ? this.session.digest(digMech, data) : data;
        }
        if ((mImprint = new MessageImprint(algoDig, dig)) == null) {
            throw new PKIException("8223", "\u89e3\u6790\u65f6\u95f4\u6233\u5931\u8d25 no MessageImprint");
        }
        DERInteger dersn = new DERInteger(sn);
        if (dersn == null) {
            throw new PKIException("8223", "\u89e3\u6790\u65f6\u95f4\u6233\u5931\u8d25 no sn");
        }
        SimpleDateFormat dateF = new SimpleDateFormat("yyyyMMddHHmmss.SSSS'Z'");
        dateF.setTimeZone(new SimpleTimeZone(0, "Z"));
        DERGeneralizedTime dertime = new DERGeneralizedTime(dateF.format(time));
        DERBoolean derOrder = null;
        if (isOrder.booleanValue()) {
            derOrder = new DERBoolean(isOrder);
        }
        DERInteger dernonce = new DERInteger(req.getNonce());
        return new TSTInfo(policyId, mImprint, dersn, dertime, acc, derOrder, dernonce, tsa, extensions);
    }

    private void parseTstInfo(TSTInfo info) throws PKIException {
        try {
            this.tspTime = info.getGenTime().getDate();
            MessageImprint mImprint = info.getMessageImprint();
            this.sn = info.getSerialNumber().getPositiveValue();
            if (info.getAccuracy() != null) {
                this.timeacc = info.getAccuracy();
            }
            this.tsa = info.getTsa();
            this.extensions = info.getExtensions();
        }
        catch (ParseException e) {
            throw new PKIException("8223", "\u89e3\u6790\u65f6\u95f4\u6233\u5931\u8d25", e);
        }
    }

    private X509Cert[] GetCerts(ASN1Set derSet) throws PKIException {
        if (derSet == null) {
            return null;
        }
        DERSet set = (DERSet)derSet;
        X509Cert[] certs = new X509Cert[set.size()];
        int i = 0;
        while (i < set.size()) {
            certs[i] = new X509Cert(X509CertificateStructure.getInstance(set.getObjectAt(i)));
            ++i;
        }
        return certs;
    }

    private X509CRL[] GetCrls(ASN1Set derSet) throws PKIException {
        if (derSet == null) {
            return null;
        }
        DERSet set = (DERSet)derSet;
        X509CRL[] crls = new X509CRL[set.size()];
        int i = 0;
        while (i < set.size()) {
            crls[i] = new X509CRL(CertificateList.getInstance(set.getObjectAt(i)));
            ++i;
        }
        return crls;
    }

    private String GetSignMech(AlgorithmIdentifier dig, AlgorithmIdentifier enc) throws PKIException {
        if (dig == null || enc == null) {
            return null;
        }
        String strDig = dig.getObjectId().getId();
        String strEnc = enc.getObjectId().getId();
        if (strEnc.equals(PKCSObjectIdentifiers.rsaEncryption.getId())) {
            if (strDig.equals(PKCSObjectIdentifiers.sha1.getId())) {
                return "SHA1withRSAEncryption";
            }
            if (strDig.equals(PKCSObjectIdentifiers.sha224.getId())) {
                return "SHA224withRSAEncryption";
            }
            if (strDig.equals(PKCSObjectIdentifiers.sha256.getId())) {
                return "SHA256withRSAEncryption";
            }
            if (strDig.equals(PKCSObjectIdentifiers.sha384.getId())) {
                return "SHA384withRSAEncryption";
            }
            if (strDig.equals(PKCSObjectIdentifiers.sha512.getId())) {
                return "SHA512withRSAEncryption";
            }
            if (strDig.equals(PKCSObjectIdentifiers.md2.getId())) {
                return "MD2withRSAEncryption";
            }
            if (strDig.equals(PKCSObjectIdentifiers.md5.getId())) {
                return "MD5withRSAEncryption";
            }
            throw new PKIException("8212", "\u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b");
        }
        if (strEnc.equals(PKCSObjectIdentifiers.SM2_SIGN.getId())) {
            if (strDig.equals(PKCSObjectIdentifiers.SM3.getId())) {
                return "SM3withSM2Encryption";
            }
            throw new PKIException("8212", "\u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b");
        }
        throw new PKIException("8212", "\u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b");
    }

    private p7signInfo[] parserSignInfos(ASN1Set derSet) throws PKIException {
        DERSet set = (DERSet)derSet;
        p7signInfo[] infos = new p7signInfo[set.size()];
        int i = 0;
        while (i < set.size()) {
            SignerInfo info = SignerInfo.getInstance(set.getObjectAt(i));
            if (info == null) {
                throw new PKIException("8212", "\u89e3\u6790P7\u5931\u8d25");
            }
            infos[i] = new p7signInfo();
            infos[i].setSignature(info.getEncryptedDigest().getOctets());
            AlgorithmIdentifier dig = info.getDigestAlgorithm();
            AlgorithmIdentifier enc = info.getDigestEncryptionAlgorithm();
            IssuerAndSerialNumber iSN = IssuerAndSerialNumber.getInstance(info.getSID().getId());
            if (this.GetSignMech(dig, enc) == null || iSN.getName() == null || iSN.getSerialNumber() == null) {
                throw new PKIException("8212", "\u89e3\u6790P7\u5931\u8d25");
            }
            infos[i].setSignMech(this.GetSignMech(dig, enc));
            infos[i].setIssuer(iSN.getName().toString());
            infos[i].setSn(iSN.getSerialNumber().getValue().toString(16));
            infos[i].setAuths(this.get_Set2DERObject(info.getAuthenticatedAttributes()));
            infos[i].setUnauths(this.get_Set2DERObject(info.getUnauthenticatedAttributes()));
            ++i;
        }
        return infos;
    }

    private DERObject[] get_Set2DERObject(ASN1Set setData) throws PKIException {
        if (setData == null) {
            return null;
        }
        int lens = setData.size();
        DERObject[] data = new DERObject[lens];
        int i = 0;
        while (i < lens) {
            data[i] = (DERObject)setData.getObjectAt(i);
            ++i;
        }
        return data;
    }

    private p7CertInfo[] getCertInfos(p7signInfo[] infos, SignedData signData) throws PKIException {
        p7CertInfo[] certinfos = new p7CertInfo[infos.length];
        DERSet certs = (DERSet)signData.getCertificates();
        X509Cert signCert = null;
        if (signData.getCertificates() != null) {
            signCert = new X509Cert(X509CertificateStructure.getInstance(certs.getObjectAt(0)));
        }
        int i = 0;
        while (i < certinfos.length) {
            certinfos[i] = signCert == null ? new p7CertInfo(infos[i].getIssuer(), infos[i].getSn(), null, signCert) : new p7CertInfo(infos[i].getIssuer(), infos[i].getSn(), signCert.getPublicKey(), signCert);
            ++i;
        }
        return certinfos;
    }

    private String getSign2EncOid(Mechanism mech) throws PKIException {
        String type = mech.getMechanismType();
        if (type.equals("SM3withSM2Encryption")) {
            return PKCSObjectIdentifiers.SM2_ENC.getId();
        }
        return PKCSObjectIdentifiers.rsaEncryption.getId();
    }

    private String getSign2DigOid(Mechanism mech) throws PKIException {
        String type = mech.getMechanismType();
        if (type.equals("SHA1withRSAEncryption")) {
            return PKCSObjectIdentifiers.sha1.getId();
        }
        if (type.equals("SHA224withRSAEncryption")) {
            return PKCSObjectIdentifiers.sha224.getId();
        }
        if (type.equals("SHA256withRSAEncryption")) {
            return PKCSObjectIdentifiers.sha256.getId();
        }
        if (type.equals("SHA384withRSAEncryption")) {
            return PKCSObjectIdentifiers.sha384.getId();
        }
        if (type.equals("SHA512withRSAEncryption")) {
            return PKCSObjectIdentifiers.sha512.getId();
        }
        if (type.equals("SM3withSM2Encryption")) {
            return PKCSObjectIdentifiers.SM3.getId();
        }
        throw new PKIException("8212", "\u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b");
    }

    private DERSequence getCertIDAttr(Mechanism mech, byte[] derCert) throws PKIException {
        byte[] certDig = this.session.digest(mech, derCert);
        DEROctetString oct = new DEROctetString(certDig);
        DERSequence ESSCertID = new DERSequence((DEREncodable)oct);
        DEREncodableVector vIds = new DEREncodableVector();
        vIds.add((DEREncodable)ESSCertID);
        DERSequence SigningCertificate = new DERSequence(vIds);
        return new DERSequence((DEREncodable)SigningCertificate);
    }

    private Mechanism getSignmech(JKey prv, Mechanism dig) throws PKIException {
        if (prv == null || dig == null) {
            return null;
        }
        if (prv.getKeyType().equals("RSA_Private")) {
            if ("SHA1".equals(dig.getMechanismType())) {
                return new Mechanism("SHA1withRSAEncryption");
            }
            if ("SHA224".equals(dig.getMechanismType())) {
                return new Mechanism("SHA224withRSAEncryption");
            }
            if ("SHA256".equals(dig.getMechanismType())) {
                return new Mechanism("SHA256withRSAEncryption");
            }
            if ("SHA384".equals(dig.getMechanismType())) {
                return new Mechanism("SHA384withRSAEncryption");
            }
            if ("SHA512".equals(dig.getMechanismType())) {
                return new Mechanism("SHA512withRSAEncryption");
            }
        }
        if (prv.getKeyType().equals("SM2_Private") && "SM3".equals(dig.getMechanismType())) {
            return new Mechanism("SM3withSM2Encryption");
        }
        throw new PKIException("8212", "\u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b key type:" + prv.getKeyType() + ",dig mech:" + dig.getMechanismType());
    }
}

