/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.ida.util.pki.tsp;

import cn.com.jit.ida.util.pki.PKIException;
import cn.com.jit.ida.util.pki.Parser;
import cn.com.jit.ida.util.pki.asn1.ASN1InputStream;
import cn.com.jit.ida.util.pki.asn1.ASN1Sequence;
import cn.com.jit.ida.util.pki.asn1.DERBoolean;
import cn.com.jit.ida.util.pki.asn1.DERInteger;
import cn.com.jit.ida.util.pki.asn1.DERObject;
import cn.com.jit.ida.util.pki.asn1.DERObjectIdentifier;
import cn.com.jit.ida.util.pki.asn1.pkcs.PKCSObjectIdentifiers;
import cn.com.jit.ida.util.pki.asn1.x509.AlgorithmIdentifier;
import cn.com.jit.ida.util.pki.asn1.x509.X509Extensions;
import cn.com.jit.ida.util.pki.cipher.Mechanism;
import cn.com.jit.ida.util.pki.cipher.Session;
import cn.com.jit.ida.util.pki.encoders.Base64;
import cn.com.jit.ida.util.pki.tsp.MessageImprint;
import cn.com.jit.ida.util.pki.tsp.TimeStampReq;
import java.io.ByteArrayInputStream;
import java.math.BigInteger;

public class TspRequest {
    private Mechanism digMech;
    private byte[] data;
    private boolean isSource;
    private String policy = null;
    private BigInteger nonce = null;
    private boolean certReq = true;
    private boolean haveCertReq = false;
    private X509Extensions exts;
    private Session session = null;

    public TspRequest() {
    }

    public TspRequest(Session session) {
        this.session = session;
    }

    public static TspRequest getInstance(Object o) {
        if (o == null || o instanceof TspRequest) {
            return (TspRequest)o;
        }
        throw new IllegalArgumentException("unknown object in 'tspRequest' factory : " + o.getClass().getName() + ".");
    }

    public TspRequest(byte[] req) throws PKIException {
        if (Parser.isBase64Encode(req)) {
            req = Parser.convertBase64(req);
            req = Base64.decode(req);
        }
        this.parseReq(req);
    }

    public TspRequest(Session session, byte[] data, boolean isSource, Mechanism digMech) {
        this.session = session;
        this.data = data;
        this.isSource = isSource;
        this.digMech = digMech;
    }

    public DERObject genReqObject() throws PKIException {
        if (this.isSource && this.session == null) {
            throw new PKIException("8221", "\u53c2\u6570\u4e0d\u5b8c\u6574");
        }
        byte[] dig = null;
        dig = this.isSource ? this.session.digest(this.digMech, this.data) : this.data;
        DERObjectIdentifier digoid = TspRequest.GetDigOid(this.digMech);
        AlgorithmIdentifier algoDig = new AlgorithmIdentifier(digoid);
        MessageImprint mImprint = new MessageImprint(algoDig, dig);
        DERObjectIdentifier tspPolicy = null;
        if (this.policy != null) {
            tspPolicy = new DERObjectIdentifier(this.policy);
        }
        DERInteger dernonce = null;
        if (this.nonce != null) {
            dernonce = new DERInteger(this.nonce);
        }
        DERBoolean dercertReq = null;
        if (this.haveCertReq) {
            dercertReq = new DERBoolean(this.certReq);
        }
        TimeStampReq req = new TimeStampReq(mImprint, tspPolicy, dernonce, dercertReq, this.exts);
        return req.getDERObject();
    }

    public byte[] genReq() throws PKIException {
        return Parser.writeDERObj2Bytes(this.genReqObject());
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public Mechanism getDigMech() {
        return this.digMech;
    }

    public void setDigMech(Mechanism digMech) {
        this.digMech = digMech;
    }

    public byte[] getData() {
        return this.data;
    }

    public boolean isSource() {
        return this.isSource;
    }

    public void setSource(boolean isSource) {
        this.isSource = isSource;
    }

    public void setData(byte[] data, boolean isSource) {
        this.data = data;
        this.isSource = isSource;
    }

    public String getPolicy() {
        return this.policy;
    }

    public void setPolicy(String policy) {
        this.policy = policy;
    }

    public BigInteger getNonce() {
        return this.nonce;
    }

    public void setNonce(BigInteger nonce) {
        this.nonce = nonce;
    }

    public boolean isCertReq() {
        return this.certReq;
    }

    public void setCertReq(boolean certReq) {
        this.certReq = certReq;
        this.haveCertReq = true;
    }

    public boolean isHaveCertReq() {
        return this.haveCertReq;
    }

    public X509Extensions getExts() {
        return this.exts;
    }

    public void setExts(X509Extensions exts) {
        this.exts = exts;
    }

    private void parseReq(byte[] req) throws PKIException {
        ByteArrayInputStream bis = new ByteArrayInputStream(req);
        ASN1InputStream dis = new ASN1InputStream(bis);
        try {
            ASN1Sequence seq = (ASN1Sequence)dis.readObject();
            TimeStampReq derReq = new TimeStampReq(seq);
            this.isSource = false;
            this.data = derReq.getMessageImprint().getHashedMessage();
            this.digMech = this.DigAlg2Mech(derReq.getMessageImprint().hashAlgorithm);
            if (derReq.getCertReq() == null) {
                this.haveCertReq = false;
            } else {
                this.haveCertReq = true;
                this.certReq = derReq.getCertReq().isTrue();
            }
            if (derReq.getNonce() != null) {
                this.nonce = derReq.getNonce().getValue();
            }
            if (derReq.getExtensions() != null) {
                this.exts = derReq.getExtensions();
            }
            if (derReq.getReqPolicy() != null) {
                this.policy = derReq.getReqPolicy().getId();
            }
        }
        catch (Exception ex) {
            throw new PKIException("8222", "\u89e3\u6790\u65f6\u95f4\u6233\u7533\u8bf7\u4e66\u5931\u8d25", ex);
        }
    }

    public static DERObjectIdentifier GetDigOid(Mechanism digMech) throws PKIException {
        if (digMech == null) {
            return null;
        }
        if (digMech.getMechanismType().equals("MD2")) {
            return PKCSObjectIdentifiers.md2;
        }
        if (digMech.getMechanismType().equals("MD5")) {
            return PKCSObjectIdentifiers.md5;
        }
        if (digMech.getMechanismType().equals("SM3")) {
            return PKCSObjectIdentifiers.SM3;
        }
        if (digMech.getMechanismType().equals("SHA1")) {
            return PKCSObjectIdentifiers.sha1;
        }
        if (digMech.getMechanismType().equals("SHA224")) {
            return PKCSObjectIdentifiers.sha224;
        }
        if (digMech.getMechanismType().equals("SHA256")) {
            return PKCSObjectIdentifiers.sha256;
        }
        if (digMech.getMechanismType().equals("SHA384")) {
            return PKCSObjectIdentifiers.sha384;
        }
        throw new PKIException("8215", "\u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + digMech);
    }

    private Mechanism DigAlg2Mech(AlgorithmIdentifier dig) throws PKIException {
        if (dig == null) {
            return null;
        }
        String strDig = dig.getObjectId().getId();
        if (strDig.equals(PKCSObjectIdentifiers.sha1.getId())) {
            return new Mechanism("SHA1");
        }
        if (strDig.equals(PKCSObjectIdentifiers.sha224.getId())) {
            return new Mechanism("SHA224");
        }
        if (strDig.equals(PKCSObjectIdentifiers.sha256.getId())) {
            return new Mechanism("SHA256");
        }
        if (strDig.equals(PKCSObjectIdentifiers.sha384.getId())) {
            return new Mechanism("SHA384");
        }
        if (strDig.equals(PKCSObjectIdentifiers.sha512.getId())) {
            return new Mechanism("SHA512");
        }
        if (strDig.equals(PKCSObjectIdentifiers.SM3.getId())) {
            return new Mechanism("SM3");
        }
        if (strDig.equals(PKCSObjectIdentifiers.md2.getId())) {
            return new Mechanism("MD2");
        }
        if (strDig.equals(PKCSObjectIdentifiers.md5.getId())) {
            return new Mechanism("MD5");
        }
        throw new PKIException("8212", "\u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b");
    }
}

