/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.ida.util.pki.tsp;

import cn.com.jit.ida.util.pki.asn1.ASN1Encodable;
import cn.com.jit.ida.util.pki.asn1.ASN1EncodableVector;
import cn.com.jit.ida.util.pki.asn1.ASN1Sequence;
import cn.com.jit.ida.util.pki.asn1.DERObject;
import cn.com.jit.ida.util.pki.asn1.DERSequence;
import cn.com.jit.ida.util.pki.asn1.cms.PKIStatusInfo;
import cn.com.jit.ida.util.pki.asn1.pkcs.pkcs7.ContentInfo;
import java.util.Enumeration;

public class TimeStampResp
extends ASN1Encodable {
    public static final int status_granted = 0;
    public static final int status_grantedWithMods = 1;
    public static final int status_rejection = 2;
    public static final int status_waiting = 3;
    public static final int status_revocationWarning = 4;
    public static final int status_revocationNotification = 5;
    public static final int status_keyUpdateWarning = 6;
    PKIStatusInfo pkiStatusInfo;
    ContentInfo timeStampToken;

    public static TimeStampResp getInstance(Object o) {
        if (o == null || o instanceof TimeStampResp) {
            return (TimeStampResp)o;
        }
        if (o instanceof ASN1Sequence) {
            return new TimeStampResp((ASN1Sequence)o);
        }
        throw new IllegalArgumentException("unknown object in 'TimeStampResp' factory : " + o.getClass().getName() + ".");
    }

    public TimeStampResp(ASN1Sequence seq) {
        Enumeration e = seq.getObjects();
        this.pkiStatusInfo = PKIStatusInfo.getInstance(e.nextElement());
        if (e.hasMoreElements()) {
            this.timeStampToken = ContentInfo.getInstance(e.nextElement());
        }
    }

    public TimeStampResp(PKIStatusInfo pkiStatusInfo, ContentInfo timeStampToken) {
        this.pkiStatusInfo = pkiStatusInfo;
        this.timeStampToken = timeStampToken;
    }

    public PKIStatusInfo getStatus() {
        return this.pkiStatusInfo;
    }

    public ContentInfo getTimeStampToken() {
        return this.timeStampToken;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.pkiStatusInfo);
        if (this.timeStampToken != null) {
            v.add(this.timeStampToken);
        }
        return new DERSequence(v);
    }
}

