/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.ida.util.pki.tsp;

import cn.com.jit.ida.util.pki.PKIException;
import cn.com.jit.ida.util.pki.Parser;
import cn.com.jit.ida.util.pki.asn1.ASN1EncodableVector;
import cn.com.jit.ida.util.pki.asn1.ASN1InputStream;
import cn.com.jit.ida.util.pki.asn1.ASN1Sequence;
import cn.com.jit.ida.util.pki.asn1.ASN1Set;
import cn.com.jit.ida.util.pki.asn1.DERBoolean;
import cn.com.jit.ida.util.pki.asn1.DEREncodable;
import cn.com.jit.ida.util.pki.asn1.DEREncodableVector;
import cn.com.jit.ida.util.pki.asn1.DERGeneralizedTime;
import cn.com.jit.ida.util.pki.asn1.DERInteger;
import cn.com.jit.ida.util.pki.asn1.DERObject;
import cn.com.jit.ida.util.pki.asn1.DERObjectIdentifier;
import cn.com.jit.ida.util.pki.asn1.DEROctetString;
import cn.com.jit.ida.util.pki.asn1.DERSet;
import cn.com.jit.ida.util.pki.asn1.DERUTCTime;
import cn.com.jit.ida.util.pki.asn1.cms.Attribute;
import cn.com.jit.ida.util.pki.asn1.cms.AttributeTable;
import cn.com.jit.ida.util.pki.asn1.cms.ContentInfo;
import cn.com.jit.ida.util.pki.asn1.cms.IssuerAndSerialNumber;
import cn.com.jit.ida.util.pki.asn1.cms.SignedData;
import cn.com.jit.ida.util.pki.asn1.cms.SignerIdentifier;
import cn.com.jit.ida.util.pki.asn1.cms.SignerInfo;
import cn.com.jit.ida.util.pki.asn1.pkcs.PKCSObjectIdentifiers;
import cn.com.jit.ida.util.pki.asn1.x509.AlgorithmIdentifier;
import cn.com.jit.ida.util.pki.asn1.x509.GeneralName;
import cn.com.jit.ida.util.pki.asn1.x509.X509CertificateStructure;
import cn.com.jit.ida.util.pki.asn1.x509.X509Extensions;
import cn.com.jit.ida.util.pki.asn1.x509.X509Name;
import cn.com.jit.ida.util.pki.cert.X509Cert;
import cn.com.jit.ida.util.pki.cipher.Mechanism;
import cn.com.jit.ida.util.pki.cipher.Session;
import cn.com.jit.ida.util.pki.cipher.param.P7Param;
import cn.com.jit.ida.util.pki.cipher.param.p7CertInfo;
import cn.com.jit.ida.util.pki.cipher.param.p7signInfo;
import cn.com.jit.ida.util.pki.cipher.param.tspCMSRespInfo;
import cn.com.jit.ida.util.pki.cms.JITCMSSignedDataGenerator;
import cn.com.jit.ida.util.pki.encoders.Base64;
import cn.com.jit.ida.util.pki.tsp.Accuracy;
import cn.com.jit.ida.util.pki.tsp.MessageImprint;
import cn.com.jit.ida.util.pki.tsp.TSTInfo;
import cn.com.jit.ida.util.pki.tsp.TspRequest;
import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.SimpleTimeZone;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.Time;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class CmsTspResp {
    TspRequest req;
    Date tspTime;
    BigInteger sn;
    Accuracy timeacc;
    boolean isOrder = false;
    GeneralName tsa;
    X509Extensions extensions;
    private Session session = null;
    ContentInfo stampResp;
    byte[] data;
    P7Param[] param;
    public static final int PKCS7_CONTENT_INVALIDTYPE = 0;
    public static final int PKCS7_CONTENT_TYPE_DATA = 1;
    public static final int PKCS7_CONTENT_TYPE_SIGNEDDATA = 2;
    public static final int PKCS7_CONTENT_TYPE_ENVELOPEDDATA = 3;
    public static final int PKCS7_CONTENT_TYPE_SIGNEDANDENVELOPEDDATA = 4;
    public static final int PKCS7_CONTENT_TYPE_DIGESTEDDATA = 5;
    public static final int PKCS7_CONTENT_TYPE_ENCRYPTEDDATA = 6;
    public static final int PKCS7_CONTENT_TYPE_TSP = 7;

    public CmsTspResp() {
    }

    public CmsTspResp(Session session) {
        this.session = session;
    }

    public static CmsTspResp getInstance(Object o) {
        if (o == null || o instanceof CmsTspResp) {
            return (CmsTspResp)o;
        }
        return null;
    }

    public DERObject genRespObj(byte[] src, P7Param[] param, AttributeTable attrs) throws PKIException {
        if (this.session == null) {
            throw new PKIException("8216", "\u53c2\u6570\u4e0d\u5b8c\u6574");
        }
        this.param = param;
        try {
            JITCMSSignedDataGenerator gentor = new JITCMSSignedDataGenerator(this.session);
            ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
            int i = 0;
            while (i < param.length) {
                String encryptionOID = this.getSign2EncOid(param[i].GetSignMech());
                String digestOID = this.getSign2DigOid(param[i].GetSignMech());
                org.bouncycastle.asn1.cms.Attribute localObject = new org.bouncycastle.asn1.cms.Attribute(CMSAttributes.signingTime, (org.bouncycastle.asn1.ASN1Set)new org.bouncycastle.asn1.DERSet((org.bouncycastle.asn1.DEREncodable)new Time(new Date())));
                Hashtable<org.bouncycastle.asn1.DERObjectIdentifier, org.bouncycastle.asn1.cms.Attribute> localHashtable = new Hashtable<org.bouncycastle.asn1.DERObjectIdentifier, org.bouncycastle.asn1.cms.Attribute>();
                localHashtable.put(localObject.getAttrType(), localObject);
                org.bouncycastle.asn1.cms.AttributeTable signAttrs = null;
                gentor.addSigner(param[i].GetPrvKey(), Parser.convertX509Cert2JavaCert(param[i].GetCerts()[0]), encryptionOID, digestOID, signAttrs, null);
                int j = 0;
                while (j < param[i].GetCerts().length) {
                    certList.add(Parser.convertX509Cert2JavaCert(param[i].GetCerts()[j]));
                    ++j;
                }
                ++i;
            }
            if (Security.getProvider("BC") == null && Security.addProvider((Provider)new BouncyCastleProvider()) < 0) {
                throw new PKIException("8213", "\u4ea7\u751fP7\u7ed3\u6784\u5931\u8d25get bc Provider");
            }
            CertStore certStore = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(certList), "BC");
            if (certStore != null) {
                CertStore genCertStore = null;
                genCertStore = certStore;
                gentor.addCertificatesAndCRLs(genCertStore);
            }
            CMSSignedData signedData = gentor.generate(CMSObjectIdentifiers.data.getId(), (CMSProcessable)new CMSProcessableByteArray(src), true, this.session);
            return Parser.writeBytes2DERObj(signedData.getEncoded());
        }
        catch (Exception ex) {
            throw new PKIException("8213", "\u4ea7\u751fP7\u7ed3\u6784\u5931\u8d25", ex);
        }
    }

    public byte[] genResp(byte[] src, P7Param[] param, AttributeTable attrs) throws PKIException {
        return Parser.writeDERObj2Bytes(this.genRespObj(src, param, attrs));
    }

    public tspCMSRespInfo parserResp(byte[] data) throws PKIException {
        boolean isB64 = Parser.isBase64Encode(data);
        if (isB64) {
            data = Parser.convertBase64(data);
            data = Base64.decode(data);
        }
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(data);
            ASN1InputStream ais = new ASN1InputStream(bis);
            this.stampResp = ContentInfo.getInstance((ASN1Sequence)ais.readObject());
            if (this.stampResp == null) {
                throw new PKIException("8223", "\u89e3\u6790\u65f6\u95f4\u6233\u5931\u8d25");
            }
            ais.close();
            bis.close();
            ContentInfo cntInfo = this.stampResp;
            SignedData signData = SignedData.getInstance(cntInfo.getContent());
            if (PKCSObjectIdentifiers.signedData == cntInfo.getContentType() || signData == null) {
                throw new PKIException("8223", "\u89e3\u6790\u65f6\u95f4\u6233\u5931\u8d25");
            }
            DEROctetString datacntInfo = (DEROctetString)signData.getEncapContentInfo().getContent();
            if (datacntInfo == null) {
                throw new PKIException("8223", "\u89e3\u6790\u65f6\u95f4\u6233\u5931\u8d25");
            }
            this.data = datacntInfo.getOctets();
            tspCMSRespInfo rv = new tspCMSRespInfo();
            rv.setCmsData(this.data);
            TSTInfo tstInfo = TSTInfo.getInstance(signData.getEncapContentInfo().getContent());
            if (tstInfo != null) {
                rv.setDigest(tstInfo.messageImprint.getHashedMessage());
                rv.setGTime(tstInfo.genTime.getDate());
            }
            p7signInfo[] infos = this.parserSignInfos(signData.getSignerInfos());
            rv.setSingersInfo(infos);
            DERSet certs = (DERSet)signData.getCertificates();
            Object signCert = null;
            rv.setCertInfo(this.getCertInfos(infos, signData));
            rv.setAuths(infos[0].getAuths());
            int i = 0;
            while (i < infos[0].getAuths().length) {
                Attribute attr = Attribute.getInstance(infos[0].getAuths()[i]);
                String idDig = new String("1.2.840.113549.1.9.4");
                String idTime = new String("1.2.840.113549.1.9.5");
                attr.getAttrType().getId().equals(idDig);
                if (attr.getAttrType().getId().equals(idTime)) {
                    SimpleDateFormat datein;
                    String tmp;
                    if (attr.getAttrValues().getObjectAt(0) instanceof DERUTCTime) {
                        tmp = DERUTCTime.getInstance(attr.getAttrValues().getObjectAt(0)).getAdjustedTime();
                        datein = new SimpleDateFormat("yyyyMMddHHmmssz");
                    } else {
                        tmp = DERGeneralizedTime.getInstance(attr.getAttrValues().getObjectAt(0)).getTime();
                        datein = new SimpleDateFormat("yyyyMMddHHmmss.SSSS'Z'");
                    }
                    Date date = datein.parse(tmp, new ParsePosition(0));
                    rv.setDate(date);
                }
                ++i;
            }
            DEREncodableVector vDig = new DEREncodableVector(signData.getDigestAlgorithms());
            AlgorithmIdentifier digOid = AlgorithmIdentifier.getInstance(vDig.get(0));
            rv.setDigestMech(Mechanism.GetOid2Mech(digOid.getObjectId()));
            return rv;
        }
        catch (Exception ex) {
            throw new PKIException("8223", "\u89e3\u6790\u65f6\u95f4\u6233\u5931\u8d25", ex);
        }
    }

    public boolean verifyRespObj(DERObject obj, X509Cert[] certs) throws PKIException {
        cn.com.jit.ida.util.pki.cms.CMSSignedData signedData = new cn.com.jit.ida.util.pki.cms.CMSSignedData(this.session);
        signedData.load(Parser.writeDERObj2Bytes(obj));
        return signedData.verify();
    }

    public boolean verifyResp(byte[] data, X509Cert[] certs) throws PKIException {
        boolean isB64 = Parser.isBase64Encode(data);
        if (isB64) {
            data = Parser.convertBase64(data);
            data = Base64.decode(data);
        }
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(data);
            ASN1InputStream ais = new ASN1InputStream(bis);
            ais.close();
            bis.close();
            return this.verifyRespObj(ais.readObject(), certs);
        }
        catch (Exception ex) {
            throw new PKIException("8223", "\u89e3\u6790\u65f6\u95f4\u6233\u5931\u8d25", ex);
        }
    }

    public DERObjectIdentifier GetTypeOid(int lType) throws PKIException {
        Boolean isSMP7 = false;
        if (isSMP7.booleanValue()) {
            if (1 == lType) {
                return PKCSObjectIdentifiers.gm_PKCS7_data;
            }
            if (2 == lType) {
                return PKCSObjectIdentifiers.gm_PKCS7_signedData;
            }
            if (3 == lType) {
                return PKCSObjectIdentifiers.gm_PKCS7_envelopedData;
            }
            if (4 == lType) {
                return PKCSObjectIdentifiers.gm_PKCS7_signedAndEnvelopedData;
            }
            if (5 == lType) {
                return PKCSObjectIdentifiers.digestedData;
            }
            if (6 == lType) {
                return PKCSObjectIdentifiers.gm_PKCS7_encryptedData;
            }
        } else {
            if (1 == lType) {
                return PKCSObjectIdentifiers.data;
            }
            if (2 == lType) {
                return PKCSObjectIdentifiers.signedData;
            }
            if (3 == lType) {
                return PKCSObjectIdentifiers.envelopedData;
            }
            if (4 == lType) {
                return PKCSObjectIdentifiers.signedAndEnvelopedData;
            }
            if (5 == lType) {
                return PKCSObjectIdentifiers.digestedData;
            }
            if (6 == lType) {
                return PKCSObjectIdentifiers.encryptedData;
            }
        }
        if (7 == lType) {
            return PKCSObjectIdentifiers.id_ct_TSTInfo;
        }
        return null;
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public ContentInfo getStampResp() {
        return this.stampResp;
    }

    public void setStampResp(ContentInfo stampResp) {
        this.stampResp = stampResp;
    }

    public P7Param[] getParam() {
        return this.param;
    }

    public void setParam(P7Param[] param) {
        this.param = param;
    }

    private ContentInfo GetCnt(DERObjectIdentifier type, DEREncodable data) throws PKIException {
        return new ContentInfo(type, data);
    }

    private SignerInfo GetSignerInfo(P7Param param, byte[] signData) throws PKIException {
        DERObjectIdentifier digMech = Mechanism.Sign2DigOid(param.GetSignMech());
        AlgorithmIdentifier algoDig = new AlgorithmIdentifier(digMech);
        DERObjectIdentifier encMech = Mechanism.Sign2EncOid(param.GetSignMech());
        AlgorithmIdentifier algoEnc = new AlgorithmIdentifier(Mechanism.Sign2EncOid(param.GetSignMech()));
        DERObject[] auth = param.GetAuthData();
        DERObject[] unauth = param.GetunAuthData();
        IssuerAndSerialNumber issuerSN = this.GetIssuerSN(param.getSignCertInfos()[0]);
        ASN1EncodableVector vauthData = new ASN1EncodableVector();
        ASN1EncodableVector vunauthData = new ASN1EncodableVector();
        int i = 0;
        while (auth != null && i < auth.length) {
            vauthData.add(auth[i]);
            ++i;
        }
        i = 0;
        while (unauth != null && i < unauth.length) {
            vunauthData.add(unauth[i]);
            ++i;
        }
        DERSet authDatas = null;
        if (auth != null) {
            authDatas = new DERSet(vauthData);
        }
        DERSet unauthDatas = null;
        if (unauth != null) {
            unauthDatas = new DERSet(vunauthData);
        }
        DEROctetString sign = new DEROctetString(signData);
        SignerIdentifier id = new SignerIdentifier(issuerSN);
        SignerInfo info = new SignerInfo(id, algoDig, authDatas, algoEnc, sign, unauthDatas);
        return info;
    }

    private p7signInfo[] parserSignInfos(ASN1Set derSet) throws PKIException {
        DERSet set = (DERSet)derSet;
        p7signInfo[] infos = new p7signInfo[set.size()];
        int i = 0;
        while (i < set.size()) {
            SignerInfo info = SignerInfo.getInstance(set.getObjectAt(i));
            if (info == null) {
                throw new PKIException("8212", "\u89e3\u6790P7\u5931\u8d25");
            }
            infos[i] = new p7signInfo();
            infos[i].setSignature(info.getEncryptedDigest().getOctets());
            AlgorithmIdentifier dig = info.getDigestAlgorithm();
            AlgorithmIdentifier enc = info.getDigestEncryptionAlgorithm();
            IssuerAndSerialNumber iSN = IssuerAndSerialNumber.getInstance(info.getSID().getId());
            if (this.GetSignMech(enc, dig) == null || iSN.getName() == null || iSN.getSerialNumber() == null) {
                throw new PKIException("8212", "\u89e3\u6790P7\u5931\u8d25");
            }
            infos[i].setSignMech(this.GetSignMech(enc, dig));
            infos[i].setIssuer(iSN.getName().toString());
            infos[i].setSn(iSN.getSerialNumber().getValue().toString(16));
            infos[i].setAuths(this.get_Set2DERObject(info.getAuthenticatedAttributes()));
            infos[i].setUnauths(this.get_Set2DERObject(info.getUnauthenticatedAttributes()));
            ++i;
        }
        return infos;
    }

    private IssuerAndSerialNumber GetIssuerSN(X509Cert cert) throws PKIException {
        if (cert == null) {
            return null;
        }
        IssuerAndSerialNumber issuerSN = null;
        X509CertificateStructure x509cert = cert.getCertStructure();
        issuerSN = new IssuerAndSerialNumber(x509cert.getIssuer(), x509cert.getSerialNumber());
        return issuerSN;
    }

    private IssuerAndSerialNumber GetIssuerSN(p7CertInfo info) throws PKIException {
        if (info == null) {
            return null;
        }
        if (info.getCert() != null) {
            return this.GetIssuerSN(info.getCert());
        }
        IssuerAndSerialNumber issuerSN = null;
        X509Name issuer = new X509Name(info.getIssuer());
        BigInteger seriaNumber = new BigInteger(info.getSerialNumber(), 16);
        issuerSN = new IssuerAndSerialNumber(issuer, seriaNumber);
        return issuerSN;
    }

    private String GetSignMech(AlgorithmIdentifier sign, AlgorithmIdentifier dig) throws PKIException {
        if (sign == null) {
            return null;
        }
        String strSign = sign.getObjectId().getId();
        if (strSign.equals(PKCSObjectIdentifiers.sha1WithRSAEncryption.getId())) {
            return "SHA1withRSAEncryption";
        }
        if (strSign.equals(PKCSObjectIdentifiers.sha224WithRSAEncryption.getId())) {
            return "SHA224withRSAEncryption";
        }
        if (strSign.equals(PKCSObjectIdentifiers.sha256WithRSAEncryption.getId())) {
            return "SHA256withRSAEncryption";
        }
        if (strSign.equals(PKCSObjectIdentifiers.sha384WithRSAEncryption.getId())) {
            return "SHA384withRSAEncryption";
        }
        if (strSign.equals(PKCSObjectIdentifiers.sha512WithRSAEncryption.getId())) {
            return "SHA512withRSAEncryption";
        }
        if (strSign.equals(PKCSObjectIdentifiers.md2WithRSAEncryption.getId())) {
            return "MD2withRSAEncryption";
        }
        if (strSign.equals(PKCSObjectIdentifiers.md5WithRSAEncryption.getId())) {
            return "MD5withRSAEncryption";
        }
        if (strSign.equals(PKCSObjectIdentifiers.SM2_SIGN.getId())) {
            return "SM3withSM2Encryption";
        }
        String strDig = dig.getObjectId().getId();
        if (strDig.equals(PKCSObjectIdentifiers.sha1.getId())) {
            return "SHA1withRSAEncryption";
        }
        if (strDig.equals(PKCSObjectIdentifiers.sha224.getId())) {
            return "SHA224withRSAEncryption";
        }
        if (strDig.equals(PKCSObjectIdentifiers.sha256.getId())) {
            return "SHA256withRSAEncryption";
        }
        if (strDig.equals(PKCSObjectIdentifiers.sha384.getId())) {
            return "SHA384withRSAEncryption";
        }
        if (strDig.equals(PKCSObjectIdentifiers.sha512.getId())) {
            return "SHA512withRSAEncryption";
        }
        if (strDig.equals(PKCSObjectIdentifiers.md2.getId())) {
            return "MD2withRSAEncryption";
        }
        if (strDig.equals(PKCSObjectIdentifiers.md5.getId())) {
            return "MD5withRSAEncryption";
        }
        throw new PKIException("8212", "\u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b");
    }

    private DERObject[] get_Set2DERObject(ASN1Set setData) throws PKIException {
        if (setData == null) {
            return null;
        }
        int lens = setData.size();
        DERObject[] data = new DERObject[lens];
        int i = 0;
        while (i < lens) {
            data[i] = (DERObject)setData.getObjectAt(i);
            ++i;
        }
        return data;
    }

    private p7CertInfo[] getCertInfos(p7signInfo[] infos, SignedData signData) throws PKIException {
        p7CertInfo[] certinfos = new p7CertInfo[infos.length];
        DERSet certs = (DERSet)signData.getCertificates();
        X509Cert signCert = null;
        if (signData.getCertificates() != null) {
            signCert = new X509Cert(X509CertificateStructure.getInstance(certs.getObjectAt(0)));
        }
        int i = 0;
        while (i < certinfos.length) {
            certinfos[i] = signCert == null ? new p7CertInfo(infos[i].getIssuer(), infos[i].getSn(), null, signCert) : new p7CertInfo(infos[i].getIssuer(), infos[i].getSn(), signCert.getPublicKey(), signCert);
            ++i;
        }
        return certinfos;
    }

    private TSTInfo getTstInfo(byte[] reqdata, BigInteger sn, Date time, Accuracy acc, Boolean isOrder, GeneralName tsa, X509Extensions extensions) throws PKIException {
        TspRequest req = new TspRequest(reqdata);
        DERObjectIdentifier digoid = TspRequest.GetDigOid(req.getDigMech());
        AlgorithmIdentifier algoDig = new AlgorithmIdentifier(digoid);
        if (req.getPolicy() == null) {
            throw new PKIException("8223", "\u89e3\u6790\u65f6\u95f4\u6233\u5931\u8d25 no policy id");
        }
        DERObjectIdentifier policyId = new DERObjectIdentifier(req.getPolicy());
        MessageImprint mImprint = new MessageImprint(algoDig, req.getData());
        if (mImprint == null) {
            throw new PKIException("8223", "\u89e3\u6790\u65f6\u95f4\u6233\u5931\u8d25 no MessageImprint");
        }
        DERInteger dersn = new DERInteger(sn);
        if (dersn == null) {
            throw new PKIException("8223", "\u89e3\u6790\u65f6\u95f4\u6233\u5931\u8d25 no sn");
        }
        SimpleDateFormat dateF = new SimpleDateFormat("yyyyMMddHHmmss.SSSS'Z'");
        dateF.setTimeZone(new SimpleTimeZone(0, "Z"));
        DERGeneralizedTime dertime = new DERGeneralizedTime(dateF.format(time));
        DERBoolean derOrder = new DERBoolean(isOrder);
        DERInteger dernonce = new DERInteger(req.getNonce());
        return new TSTInfo(policyId, mImprint, dersn, dertime, acc, derOrder, dernonce, tsa, extensions);
    }

    private void parseTstInfo(TSTInfo info) throws PKIException {
        try {
            this.tspTime = info.getGenTime().getDate();
            MessageImprint mImprint = info.getMessageImprint();
            this.sn = info.getSerialNumber().getPositiveValue();
            if (info.getAccuracy() != null) {
                this.timeacc = info.getAccuracy();
            }
            this.tsa = info.getTsa();
            this.extensions = info.getExtensions();
        }
        catch (ParseException e) {
            throw new PKIException("8223", "\u89e3\u6790\u65f6\u95f4\u6233\u5931\u8d25", e);
        }
    }

    private String getSign2EncOid(Mechanism mech) throws PKIException {
        String type = mech.getMechanismType();
        if (type.equals("SM3withSM2Encryption")) {
            return PKCSObjectIdentifiers.SM2_ENC.getId();
        }
        return PKCSObjectIdentifiers.rsaEncryption.getId();
    }

    private String getSign2DigOid(Mechanism mech) throws PKIException {
        String type = mech.getMechanismType();
        if (type.equals("SHA1withRSAEncryption")) {
            return PKCSObjectIdentifiers.sha1.getId();
        }
        if (type.equals("SHA224withRSAEncryption")) {
            return PKCSObjectIdentifiers.sha224.getId();
        }
        if (type.equals("SHA256withRSAEncryption")) {
            return PKCSObjectIdentifiers.sha256.getId();
        }
        if (type.equals("SHA384withRSAEncryption")) {
            return PKCSObjectIdentifiers.sha384.getId();
        }
        if (type.equals("SHA512withRSAEncryption")) {
            return PKCSObjectIdentifiers.sha512.getId();
        }
        if (type.equals("SM3withSM2Encryption")) {
            return PKCSObjectIdentifiers.SM3.getId();
        }
        throw new PKIException("8212", "\u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b");
    }
}

