/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.ida.util.pki.pkcs;

import cn.com.jit.ida.util.pki.Parser;
import cn.com.jit.ida.util.pki.asn1.ASN1OctetString;
import cn.com.jit.ida.util.pki.asn1.ASN1Sequence;
import cn.com.jit.ida.util.pki.asn1.DEREncodableVector;
import cn.com.jit.ida.util.pki.asn1.DERInteger;
import cn.com.jit.ida.util.pki.asn1.DEROctetString;
import cn.com.jit.ida.util.pki.asn1.DERSequence;
import cn.com.jit.ida.util.pki.asn1.pkcs.PKCSObjectIdentifiers;
import cn.com.jit.ida.util.pki.asn1.pkcs.pkcs8.EncryptedPrivateKeyInfo;
import cn.com.jit.ida.util.pki.asn1.x509.AlgorithmIdentifier;
import cn.com.jit.ida.util.pki.cipher.JCrypto;
import cn.com.jit.ida.util.pki.cipher.JKey;
import cn.com.jit.ida.util.pki.cipher.Mechanism;
import cn.com.jit.ida.util.pki.cipher.Session;
import cn.com.jit.ida.util.pki.cipher.param.PBEParam;

public class PKCS8 {
    private Session session;

    public PKCS8() {
        try {
            JCrypto jcrypto = JCrypto.getInstance();
            jcrypto.initialize("JSOFT_LIB", null);
            this.session = jcrypto.openSession("JSOFT_LIB");
        }
        catch (Exception ex) {
            System.out.println(ex.toString());
        }
    }

    public byte[] generateEPKI(JKey prvKey, char[] password) throws Exception {
        if (prvKey.getKeyType() != "RSA_Private") {
            throw new Exception("Unsupported JKey type:" + prvKey.getKeyType());
        }
        byte[] keyData = prvKey.getKey();
        PBEParam pbeParam = new PBEParam();
        byte[] salt = pbeParam.getSalt();
        int iterations = pbeParam.getIterations();
        Mechanism keyGenM = new Mechanism("PBEWITHSHAAND3-KEYTRIPLEDES-CBC");
        JKey pbeKey = this.session.generatePBEKey(keyGenM, password);
        Mechanism encryptM = new Mechanism("PBEWITHSHAAND3-KEYTRIPLEDES-CBC", pbeParam);
        byte[] encryptedData = this.session.encrypt(encryptM, pbeKey, keyData);
        DEREncodableVector derV = new DEREncodableVector();
        DEROctetString derO = new DEROctetString(salt);
        DERInteger derI = new DERInteger(iterations);
        derV.add(derO);
        derV.add(derI);
        DERSequence derS = new DERSequence(derV);
        AlgorithmIdentifier algId = new AlgorithmIdentifier(PKCSObjectIdentifiers.pbeWithSHAAnd3DESCBC, derS);
        EncryptedPrivateKeyInfo epki = new EncryptedPrivateKeyInfo(algId, encryptedData);
        return Parser.writeDERObj2Bytes(epki);
    }

    public JKey decodeEPKI(byte[] epkiData, char[] password) throws Exception {
        ASN1Sequence asn1Seq = (ASN1Sequence)Parser.writeBytes2DERObj(epkiData);
        EncryptedPrivateKeyInfo epki = new EncryptedPrivateKeyInfo(asn1Seq);
        AlgorithmIdentifier algId = epki.getEncryptionAlgorithm();
        if (!algId.getObjectId().equals(PKCSObjectIdentifiers.pbeWithSHAAnd3DESCBC)) {
            throw new Exception("Unsupported encryption algorithm:" + algId.getObjectId().getId());
        }
        ASN1Sequence asn1Seq2 = (ASN1Sequence)algId.getParameters();
        ASN1OctetString asn1Oct = (ASN1OctetString)asn1Seq2.getObjectAt(0);
        DERInteger derInt = (DERInteger)asn1Seq2.getObjectAt(1);
        byte[] salt = asn1Oct.getOctets();
        int iterations = derInt.getValue().intValue();
        PBEParam pbeParam = new PBEParam();
        pbeParam.setSalt(salt);
        pbeParam.setIterations(iterations);
        Mechanism keyGenM = new Mechanism("PBEWITHSHAAND3-KEYTRIPLEDES-CBC");
        JKey pbeKey = this.session.generatePBEKey(keyGenM, password);
        Mechanism decryptM = new Mechanism("PBEWITHSHAAND3-KEYTRIPLEDES-CBC", pbeParam);
        byte[] encryptedData = epki.getEncryptedData();
        byte[] keyData = this.session.decrypt(decryptM, pbeKey, encryptedData);
        return new JKey("RSA_Private", keyData);
    }
}

