/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.ida.util.pki.pkcs;

import cn.com.jit.ida.util.pki.PKIException;
import cn.com.jit.ida.util.pki.Parser;
import cn.com.jit.ida.util.pki.asn1.ASN1InputStream;
import cn.com.jit.ida.util.pki.asn1.ASN1OctetString;
import cn.com.jit.ida.util.pki.asn1.ASN1Sequence;
import cn.com.jit.ida.util.pki.asn1.ASN1Set;
import cn.com.jit.ida.util.pki.asn1.DERObjectIdentifier;
import cn.com.jit.ida.util.pki.asn1.pkcs.PKCSObjectIdentifiers;
import cn.com.jit.ida.util.pki.asn1.pkcs.pkcs7.ContentInfo;
import cn.com.jit.ida.util.pki.asn1.pkcs.pkcs7.IssuerAndSerialNumber;
import cn.com.jit.ida.util.pki.asn1.pkcs.pkcs7.SignedData;
import cn.com.jit.ida.util.pki.asn1.pkcs.pkcs7.SignerInfo;
import cn.com.jit.ida.util.pki.asn1.x509.X509Name;
import cn.com.jit.ida.util.pki.cert.X509Cert;
import cn.com.jit.ida.util.pki.cipher.JCrypto;
import cn.com.jit.ida.util.pki.cipher.JKey;
import cn.com.jit.ida.util.pki.cipher.Mechanism;
import cn.com.jit.ida.util.pki.cipher.Session;
import cn.com.jit.ida.util.pki.encoders.Base64;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigInteger;

public class PKCS7SignedData {
    private Session session = null;
    private SignedData signedData = null;

    public PKCS7SignedData(Session session) {
        this.session = session;
    }

    public void load(byte[] data) throws PKIException {
        boolean isB64 = Parser.isBase64Encode(data);
        if (isB64) {
            data = Parser.convertBase64(data);
            data = Base64.decode(data);
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        this.load(bis);
    }

    public void load(SignedData signedData) throws PKIException {
        this.signedData = signedData;
    }

    public void load(String fileName) throws PKIException {
        FileInputStream fin = null;
        byte[] data = null;
        try {
            fin = new FileInputStream(fileName);
            data = new byte[fin.available()];
            fin.read(data);
            fin.close();
        }
        catch (Exception ex) {
            throw new PKIException("8175", "\u89e3\u6790PKCS7\u7b7e\u540d\u6570\u636e\u5305\u5931\u8d25", ex);
        }
        this.load(data);
    }

    public void load(InputStream ins) throws PKIException {
        ASN1InputStream ais = new ASN1InputStream(ins);
        SignedData sd = null;
        try {
            ASN1Sequence seq = (ASN1Sequence)ais.readObject();
            ContentInfo contentInfo = ContentInfo.getInstance(seq);
            sd = SignedData.getInstance(contentInfo.getContent());
            ins.close();
            ais.close();
        }
        catch (Exception ex) {
            throw new PKIException("8175", "\u89e3\u6790PKCS7\u7b7e\u540d\u6570\u636e\u5305\u5931\u8d25", ex);
        }
        catch (Throwable e) {
            throw new PKIException("8175", "\u89e3\u6790PKCS7\u7b7e\u540d\u6570\u636e\u5305\u5931\u8d25", (Exception)e);
        }
        this.signedData = sd;
    }

    public byte[] getContent(X509Cert cert) throws PKIException {
        ContentInfo contentInfo = this.signedData.getContentInfo();
        byte[] sourceData = null;
        if (contentInfo.getContentType().equals(PKCSObjectIdentifiers.data) || contentInfo.getContentType().equals(PKCSObjectIdentifiers.id_ct_TSTInfo)) {
            if (contentInfo.getContent() == null) {
                throw new PKIException("8175", "\u89e3\u6790PKCS7\u7b7e\u540d\u6570\u636e\u5305\u5931\u8d25 \u89e3\u6790PKCS7\u7b7e\u540d\u6570\u636e\u5305\u5931\u8d25", new Exception("no sourceData to be verify."));
            }
            sourceData = ((ASN1OctetString)contentInfo.getContent()).getOctets();
        } else {
            sourceData = Parser.writeDERObj2Bytes(contentInfo.getContent().getDERObject());
        }
        ASN1Set aset = this.signedData.getSignerInfos();
        SignerInfo signerInfo = SignerInfo.getInstance(aset.getObjectAt(0));
        boolean f = this.verifySignerInfo(sourceData, signerInfo, cert);
        if (!f) {
            throw new PKIException("8175", "\u89e3\u6790PKCS7\u7b7e\u540d\u6570\u636e\u5305\u5931\u8d25 \u9a8c\u8bc1PKCS7\u7b7e\u540d\u5931\u8d25");
        }
        return sourceData;
    }

    public boolean verifySignerInfo(byte[] content, SignerInfo signerInfo, X509Cert cert) {
        Mechanism signM;
        block15: {
            block14: {
                block13: {
                    try {
                        String issuer = cert.getIssuer();
                        BigInteger sn = cert.getSerialNumber();
                        IssuerAndSerialNumber userIssuerAndSN = new IssuerAndSerialNumber(new X509Name(issuer), sn);
                        IssuerAndSerialNumber actualIssuerAndSN = signerInfo.getIssuerAndSerialNumber();
                        if (userIssuerAndSN.equals(actualIssuerAndSN)) break block13;
                        return false;
                    }
                    catch (Exception ex) {
                        return false;
                    }
                }
                DERObjectIdentifier encryptionId = signerInfo.getDigestEncryptionAlgorithm().getObjectId();
                if (encryptionId.equals(PKCSObjectIdentifiers.rsaEncryption) || encryptionId.equals(PKCSObjectIdentifiers.SM2)) break block14;
                return false;
            }
            signM = null;
            DERObjectIdentifier signid = signerInfo.getDigestEncryptionAlgorithm().getObjectId();
            DERObjectIdentifier digestId = signerInfo.getDigestAlgorithm().getObjectId();
            if (digestId.equals(PKCSObjectIdentifiers.md2)) {
                signM = new Mechanism("MD2withRSAEncryption");
                break block15;
            }
            if (digestId.equals(PKCSObjectIdentifiers.md5)) {
                signM = new Mechanism("MD5withRSAEncryption");
                break block15;
            }
            if (digestId.equals(PKCSObjectIdentifiers.sha1)) {
                signM = new Mechanism("SHA1withRSAEncryption");
                break block15;
            }
            if (digestId.equals(PKCSObjectIdentifiers.SM2) || digestId.equals(PKCSObjectIdentifiers.SM2_SIGN) || digestId.equals(PKCSObjectIdentifiers.SM2_CHANGE)) {
                signM = new Mechanism("SM3withSM2Encryption");
                break block15;
            }
            if (digestId.equals(PKCSObjectIdentifiers.sha224)) {
                signM = new Mechanism("SHA224withRSAEncryption");
                break block15;
            }
            if (digestId.equals(PKCSObjectIdentifiers.sha256)) {
                signM = new Mechanism("SHA256withRSAEncryption");
                break block15;
            }
            if (digestId.equals(PKCSObjectIdentifiers.sha384)) {
                signM = new Mechanism("SHA384withRSAEncryption");
                break block15;
            }
            if (digestId.equals(PKCSObjectIdentifiers.sha512)) {
                signM = new Mechanism("SHA512withRSAEncryption");
                break block15;
            }
            return false;
        }
        byte[] signature = signerInfo.getEncryptedDigest().getOctets();
        JKey pubKey = cert.getPublicKey();
        return this.session.verifySign(signM, pubKey, content, signature);
    }

    public boolean verifySignerInfo(InputStream content, SignerInfo signerInfo, X509Cert cert) {
        Mechanism signM;
        block15: {
            block14: {
                block13: {
                    try {
                        String issuer = cert.getIssuer();
                        BigInteger sn = cert.getSerialNumber();
                        IssuerAndSerialNumber userIssuerAndSN = new IssuerAndSerialNumber(new X509Name(issuer), sn);
                        IssuerAndSerialNumber actualIssuerAndSN = signerInfo.getIssuerAndSerialNumber();
                        if (userIssuerAndSN.equals(actualIssuerAndSN)) break block13;
                        return false;
                    }
                    catch (Exception ex) {
                        return false;
                    }
                }
                DERObjectIdentifier encryptionId = signerInfo.getDigestEncryptionAlgorithm().getObjectId();
                if (encryptionId.equals(PKCSObjectIdentifiers.rsaEncryption)) break block14;
                return false;
            }
            signM = null;
            DERObjectIdentifier digestId = signerInfo.getDigestAlgorithm().getObjectId();
            if (digestId.equals(PKCSObjectIdentifiers.md2)) {
                signM = new Mechanism("MD2withRSAEncryption");
                break block15;
            }
            if (digestId.equals(PKCSObjectIdentifiers.md5)) {
                signM = new Mechanism("MD5withRSAEncryption");
                break block15;
            }
            if (digestId.equals(PKCSObjectIdentifiers.sha1)) {
                signM = new Mechanism("SHA1withRSAEncryption");
                break block15;
            }
            if (digestId.equals(PKCSObjectIdentifiers.SM2) || digestId.equals(PKCSObjectIdentifiers.SM2_SIGN) || digestId.equals(PKCSObjectIdentifiers.SM2_CHANGE)) {
                signM = new Mechanism("SM3withSM2Encryption");
                break block15;
            }
            if (digestId.equals(PKCSObjectIdentifiers.sha224)) {
                signM = new Mechanism("SHA224withRSAEncryption");
                break block15;
            }
            if (digestId.equals(PKCSObjectIdentifiers.sha256)) {
                signM = new Mechanism("SHA256withRSAEncryption");
                break block15;
            }
            if (digestId.equals(PKCSObjectIdentifiers.sha384)) {
                signM = new Mechanism("SHA384withRSAEncryption");
                break block15;
            }
            if (digestId.equals(PKCSObjectIdentifiers.sha512)) {
                signM = new Mechanism("SHA512withRSAEncryption");
                break block15;
            }
            return false;
        }
        byte[] signature = signerInfo.getEncryptedDigest().getOctets();
        JKey pubKey = cert.getPublicKey();
        return this.session.verifySign(signM, pubKey, content, signature);
    }

    public boolean verifyP7SignedData(X509Cert cert) throws PKIException {
        ContentInfo contentInfo = this.signedData.getContentInfo();
        byte[] sourceData = null;
        if (contentInfo.getContentType().equals(PKCSObjectIdentifiers.data) || contentInfo.getContentType().equals(PKCSObjectIdentifiers.id_ct_TSTInfo)) {
            if (contentInfo.getContent() == null) {
                throw new PKIException("8175", "\u89e3\u6790PKCS7\u7b7e\u540d\u6570\u636e\u5305\u5931\u8d25 \u89e3\u6790PKCS7\u7b7e\u540d\u6570\u636e\u5305\u5931\u8d25", new Exception("no sourceData to be verify."));
            }
            sourceData = ((ASN1OctetString)contentInfo.getContent()).getOctets();
        } else {
            sourceData = Parser.writeDERObj2Bytes(contentInfo.getContent().getDERObject());
        }
        ASN1Set aset = this.signedData.getSignerInfos();
        SignerInfo signerInfo = SignerInfo.getInstance(aset.getObjectAt(0));
        return this.verifySignerInfo(sourceData, signerInfo, cert);
    }

    public boolean verifyP7SignedData(byte[] sourceData, X509Cert cert) throws PKIException {
        ContentInfo contentInfo = this.signedData.getContentInfo();
        ASN1Set aset = this.signedData.getSignerInfos();
        SignerInfo signerInfo = SignerInfo.getInstance(aset.getObjectAt(0));
        return this.verifySignerInfo(sourceData, signerInfo, cert);
    }

    public boolean verifyP7SignedData(InputStream sourceData, X509Cert cert) throws PKIException {
        ContentInfo contentInfo = this.signedData.getContentInfo();
        ASN1Set aset = this.signedData.getSignerInfos();
        SignerInfo signerInfo = SignerInfo.getInstance(aset.getObjectAt(0));
        return this.verifySignerInfo(sourceData, signerInfo, cert);
    }

    public static void main(String[] args) {
        JCrypto jcrypto = JCrypto.getInstance();
        try {
            jcrypto.initialize("JSOFT_LIB", null);
            Session session = jcrypto.openSession("JSOFT_LIB");
            byte[] SOURCE = "\u4e2d\u534e\u4eba\u6c11\u5171\u548c\u56fd\u5409\u5927\u6b63\u5143\u4fe1\u606f\u6280\u672f\u80a1\u4efd\u516c\u53f8JIT327".getBytes();
            PKCS7SignedData p7 = new PKCS7SignedData(session);
            p7.load("d:/p7.sign");
            FileInputStream fin = new FileInputStream("d:/1.cer");
            X509Cert cert = new X509Cert(fin);
            boolean rv = p7.verifyP7SignedData(SOURCE, cert);
            if (rv) {
                System.out.println("verify success...");
            } else {
                System.out.println("verify failed...");
            }
            byte[] source = p7.getContent(cert);
            System.out.println(new String(source));
        }
        catch (Exception ex) {
            System.out.println(ex.toString());
        }
    }
}

