/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.ida.util.pki.pkcs;

import cn.com.jit.ida.util.pki.PKIException;
import cn.com.jit.ida.util.pki.Parser;
import cn.com.jit.ida.util.pki.asn1.ASN1EncodableVector;
import cn.com.jit.ida.util.pki.asn1.ASN1InputStream;
import cn.com.jit.ida.util.pki.asn1.ASN1OctetString;
import cn.com.jit.ida.util.pki.asn1.ASN1Sequence;
import cn.com.jit.ida.util.pki.asn1.ASN1Set;
import cn.com.jit.ida.util.pki.asn1.DEREncodable;
import cn.com.jit.ida.util.pki.asn1.DERInteger;
import cn.com.jit.ida.util.pki.asn1.DERNull;
import cn.com.jit.ida.util.pki.asn1.DERObject;
import cn.com.jit.ida.util.pki.asn1.DERObjectIdentifier;
import cn.com.jit.ida.util.pki.asn1.DEROctetString;
import cn.com.jit.ida.util.pki.asn1.DEROutputStream;
import cn.com.jit.ida.util.pki.asn1.DERSequence;
import cn.com.jit.ida.util.pki.asn1.DERSet;
import cn.com.jit.ida.util.pki.asn1.DERTaggedObject;
import cn.com.jit.ida.util.pki.asn1.pkcs.PKCSObjectIdentifiers;
import cn.com.jit.ida.util.pki.asn1.pkcs.pkcs7.ContentInfo;
import cn.com.jit.ida.util.pki.asn1.pkcs.pkcs7.DigestedData;
import cn.com.jit.ida.util.pki.asn1.pkcs.pkcs7.EncryptedContentInfo;
import cn.com.jit.ida.util.pki.asn1.pkcs.pkcs7.EncryptedData;
import cn.com.jit.ida.util.pki.asn1.pkcs.pkcs7.EnvelopedData;
import cn.com.jit.ida.util.pki.asn1.pkcs.pkcs7.IssuerAndSerialNumber;
import cn.com.jit.ida.util.pki.asn1.pkcs.pkcs7.RecipientInfo;
import cn.com.jit.ida.util.pki.asn1.pkcs.pkcs7.SignedAndEnvelopedData;
import cn.com.jit.ida.util.pki.asn1.pkcs.pkcs7.SignedData;
import cn.com.jit.ida.util.pki.asn1.pkcs.pkcs7.SignerInfo;
import cn.com.jit.ida.util.pki.asn1.x509.AlgorithmIdentifier;
import cn.com.jit.ida.util.pki.asn1.x509.CertificateList;
import cn.com.jit.ida.util.pki.asn1.x509.X509CertificateStructure;
import cn.com.jit.ida.util.pki.asn1.x509.X509Name;
import cn.com.jit.ida.util.pki.cert.X509Cert;
import cn.com.jit.ida.util.pki.cipher.JHandle;
import cn.com.jit.ida.util.pki.cipher.JKey;
import cn.com.jit.ida.util.pki.cipher.Mechanism;
import cn.com.jit.ida.util.pki.cipher.Session;
import cn.com.jit.ida.util.pki.cipher.lib.JSoftLib;
import cn.com.jit.ida.util.pki.cipher.param.CBCParam;
import cn.com.jit.ida.util.pki.cipher.param.P7Param;
import cn.com.jit.ida.util.pki.cipher.param.p7CertInfo;
import cn.com.jit.ida.util.pki.cipher.param.p7digInfo;
import cn.com.jit.ida.util.pki.cipher.param.p7encInfo;
import cn.com.jit.ida.util.pki.cipher.param.p7recCertKey;
import cn.com.jit.ida.util.pki.cipher.param.p7recInfo;
import cn.com.jit.ida.util.pki.cipher.param.p7signInfo;
import cn.com.jit.ida.util.pki.crl.X509CRL;
import cn.com.jit.ida.util.pki.encoders.Base64;
import cn.com.jit.ida.util.pki.tsp.TSTInfo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.interfaces.RSAPrivateKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PKCS7 {
    public static final int PKCS7_CONTENT_INVALIDTYPE = 0;
    public static final int PKCS7_CONTENT_TYPE_DATA = 1;
    public static final int PKCS7_CONTENT_TYPE_SIGNEDDATA = 2;
    public static final int PKCS7_CONTENT_TYPE_ENVELOPEDDATA = 3;
    public static final int PKCS7_CONTENT_TYPE_SIGNEDANDENVELOPEDDATA = 4;
    public static final int PKCS7_CONTENT_TYPE_DIGESTEDDATA = 5;
    public static final int PKCS7_CONTENT_TYPE_ENCRYPTEDDATA = 6;
    public static final int PKCS7_CONTENT_TYPE_TSP = 7;
    private ContentInfo cntInfo = null;
    private Session session = null;
    private byte[] data = null;
    private P7Param p7cnt = null;
    private boolean isSMP7 = false;
    private EnvContext envContext;
    private VerifySignContext verifySignContext;
    private SignContext signContext;

    public boolean getIsSMP7() {
        return this.isSMP7;
    }

    public void setIsSMP7(boolean isSMP7) {
        this.isSMP7 = isSMP7;
    }

    public PKCS7() {
    }

    public PKCS7(Session session) {
        this.session = session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public PKCS7(ASN1Sequence seq) {
        this.cntInfo = new ContentInfo(seq);
    }

    public static PKCS7 getInstance(Object o) throws PKIException {
        if (o instanceof PKCS7) {
            return (PKCS7)o;
        }
        if (o instanceof ASN1Sequence) {
            return new PKCS7((ASN1Sequence)o);
        }
        throw new IllegalArgumentException("unknown object");
    }

    public int load(String fileName) throws PKIException {
        try {
            FileInputStream fin = new FileInputStream(fileName);
            byte[] data = new byte[fin.available()];
            fin.read(data);
            fin.close();
            return this.load(data);
        }
        catch (Exception ex) {
            throw new PKIException("8211", "\u8f7d\u5165P7\u5bf9\u8c61\u9519\u8bef", ex);
        }
    }

    public int load(InputStream ins) throws PKIException {
        try {
            ASN1InputStream ais = new ASN1InputStream(ins);
            byte[] data = new byte[ais.available()];
            ais.read(data);
            ais.close();
            ins.close();
            return this.load(data);
        }
        catch (Exception ex) {
            throw new PKIException("8211", "\u8f7d\u5165P7\u5bf9\u8c61\u9519\u8bef", ex);
        }
    }

    public int load(InputStream ins, OutputStream src, OutputStream enc) throws PKIException {
        try {
            int readLen = this.readAsn1Hder(ins, true, 48);
            DERObjectIdentifier typeOid = (DERObjectIdentifier)this.readObj(ins, true, 6);
            int nType = this.GetType(typeOid);
            readLen = this.readAsn1Hder(ins, true, 160);
            readLen = this.readAsn1Hder(ins, true, 48);
            DERObject obj = this.readObj(ins, true, 2);
            if (obj == null) {
                throw new PKIException("8211", "\u8f7d\u5165P7\u5bf9\u8c61\u9519\u8befunkown p7 type");
            }
            this.p7cnt = new P7Param();
            switch (nType) {
                case 2: {
                    if (this.parse_Sign_os(ins, src, enc) == 0) break;
                    throw new PKIException("8211", "\u8f7d\u5165P7\u5bf9\u8c61\u9519\u8bef");
                }
                case 3: {
                    int encLen = 0;
                    encLen = this.parse_Env_os(ins, src, enc);
                    if (encLen >= 1) break;
                    throw new PKIException("8211", "\u8f7d\u5165P7\u5bf9\u8c61\u9519\u8bef");
                }
                case 1: 
                case 4: 
                case 5: 
                case 6: {
                    throw new PKIException("8211", "\u8f7d\u5165P7\u5bf9\u8c61\u9519\u8bef\u672a\u5b9e\u73b0\u7684p7\u7c7b\u578b");
                }
                default: {
                    throw new PKIException("8211", "\u8f7d\u5165P7\u5bf9\u8c61\u9519\u8bef\u65e0\u6548\u7684p7\u7c7b\u578b");
                }
            }
            return nType;
        }
        catch (Exception ex) {
            throw new PKIException("8211", "\u8f7d\u5165P7\u5bf9\u8c61\u9519\u8bef", ex);
        }
    }

    public int load(byte[] data) throws PKIException {
        boolean isB64 = Parser.isBase64Encode(data);
        if (isB64) {
            data = Parser.convertBase64(data);
            data = Base64.decode(data);
        }
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(data);
            ASN1InputStream ais = new ASN1InputStream(bis);
            this.cntInfo = new ContentInfo((ASN1Sequence)ais.readObject());
            ais.close();
            bis.close();
            return this.ParserCnt(this.cntInfo);
        }
        catch (Exception ex) {
            throw new PKIException("8211", "\u8f7d\u5165P7\u5bf9\u8c61\u9519\u8bef", ex);
        }
    }

    public P7Param GetP7Cnt() throws PKIException {
        return this.p7cnt;
    }

    public int GetType() throws PKIException {
        if (this.cntInfo == null) {
            throw new PKIException("8212", "\u89e3\u6790P7\u5931\u8d25");
        }
        DERObjectIdentifier cntType = this.cntInfo.getContentType();
        if (cntType == null) {
            throw new PKIException("8212", "\u89e3\u6790P7\u5931\u8d25");
        }
        if (cntType.equals(PKCSObjectIdentifiers.data) || cntType.equals(PKCSObjectIdentifiers.gm_PKCS7_data)) {
            return 1;
        }
        if (cntType.equals(PKCSObjectIdentifiers.signedData) || cntType.equals(PKCSObjectIdentifiers.gm_PKCS7_signedData)) {
            return 2;
        }
        if (cntType.equals(PKCSObjectIdentifiers.envelopedData) || cntType.equals(PKCSObjectIdentifiers.gm_PKCS7_envelopedData)) {
            return 3;
        }
        if (cntType.equals(PKCSObjectIdentifiers.signedAndEnvelopedData) || cntType.equals(PKCSObjectIdentifiers.gm_PKCS7_signedAndEnvelopedData)) {
            return 4;
        }
        if (cntType.equals(PKCSObjectIdentifiers.digestedData)) {
            return 5;
        }
        if (cntType.equals(PKCSObjectIdentifiers.encryptedData) || cntType.equals(PKCSObjectIdentifiers.gm_PKCS7_encryptedData)) {
            return 6;
        }
        return 0;
    }

    public DERObjectIdentifier GetTypeOid(int lType) throws PKIException {
        if (this.isSMP7) {
            if (1 == lType) {
                return PKCSObjectIdentifiers.gm_PKCS7_data;
            }
            if (2 == lType) {
                return PKCSObjectIdentifiers.gm_PKCS7_signedData;
            }
            if (3 == lType) {
                return PKCSObjectIdentifiers.gm_PKCS7_envelopedData;
            }
            if (4 == lType) {
                return PKCSObjectIdentifiers.gm_PKCS7_signedAndEnvelopedData;
            }
            if (5 == lType) {
                return PKCSObjectIdentifiers.digestedData;
            }
            if (6 == lType) {
                return PKCSObjectIdentifiers.gm_PKCS7_encryptedData;
            }
        } else {
            if (1 == lType) {
                return PKCSObjectIdentifiers.data;
            }
            if (2 == lType) {
                return PKCSObjectIdentifiers.signedData;
            }
            if (3 == lType) {
                return PKCSObjectIdentifiers.envelopedData;
            }
            if (4 == lType) {
                return PKCSObjectIdentifiers.signedAndEnvelopedData;
            }
            if (5 == lType) {
                return PKCSObjectIdentifiers.digestedData;
            }
            if (6 == lType) {
                return PKCSObjectIdentifiers.encryptedData;
            }
        }
        if (7 == lType) {
            return PKCSObjectIdentifiers.id_ct_TSTInfo;
        }
        return null;
    }

    public DERObject genP7_DataObj(byte[] data) throws PKIException {
        this.cntInfo = this.GetCnt(this.GetTypeOid(1), data);
        if (this.cntInfo == null) {
            return null;
        }
        return this.cntInfo.getDERObject();
    }

    public byte[] genP7_Data(byte[] data) throws PKIException {
        return Parser.writeDERObj2Bytes(this.genP7_DataObj(data));
    }

    public DERObject genP7_SignObj(byte[] data, P7Param[] param, boolean attach) throws PKIException {
        if (this.session == null) {
            throw new PKIException("8216", "\u53c2\u6570\u4e0d\u5b8c\u6574");
        }
        try {
            ContentInfo dataCnt = null;
            byte[] cnt = data;
            if (!attach) {
                cnt = null;
            }
            dataCnt = this.GetCnt(this.GetTypeOid(1), cnt);
            ASN1EncodableVector vdigMech = new ASN1EncodableVector();
            ASN1EncodableVector vCert = new ASN1EncodableVector();
            ASN1EncodableVector vCrl = new ASN1EncodableVector();
            ASN1EncodableVector vSignInfo = new ASN1EncodableVector();
            int i = 0;
            while (i < param.length) {
                if (param[i].GetPrvKey() == null || param[i].GetSignMech() == null) {
                    throw new PKIException("8216", "\u53c2\u6570\u4e0d\u5b8c\u6574");
                }
                DERObjectIdentifier digMech = this.Sign2DigOid(param[i].GetSignMech());
                AlgorithmIdentifier algoDig = new AlgorithmIdentifier(digMech);
                vdigMech.add(algoDig);
                byte[] sign = this.session.sign(param[i].GetSignMech(), param[i].GetPrvKey(), data);
                if (sign == null) {
                    throw new PKIException("8213", "\u4ea7\u751fP7\u7ed3\u6784\u5931\u8d25");
                }
                vSignInfo.add(this.GetSignerInfo(param[i], sign));
                X509Cert[] x509certs = param[i].GetSignCerts();
                int j = 0;
                while (x509certs != null && j < x509certs.length) {
                    vCert.add(x509certs[j].getCertStructure());
                    ++j;
                }
                X509CRL[] x509crls = param[i].GetCrls();
                int k = 0;
                while (x509crls != null && k < x509crls.length) {
                    vCrl.add(x509crls[k].getCertificateList());
                    ++k;
                }
                ++i;
            }
            DERSet algos = new DERSet(vdigMech);
            DERSet infos = new DERSet(vSignInfo);
            DERSet certs = null;
            if (vCert.size() != 0) {
                certs = new DERSet(vCert);
            }
            DERSet crls = null;
            if (vCrl.size() != 0) {
                crls = new DERSet(vCrl);
            }
            DERInteger ver = new DERInteger(1);
            SignedData signData = new SignedData(ver, algos, dataCnt, certs, crls, infos);
            this.cntInfo = this.GetCnt(this.GetTypeOid(2), signData);
        }
        catch (Exception ex) {
            throw new PKIException("8213", "\u4ea7\u751fP7\u7ed3\u6784\u5931\u8d25", ex);
        }
        if (this.cntInfo == null) {
            return null;
        }
        return this.cntInfo.getDERObject();
    }

    public byte[] genP7_Sign(byte[] data, P7Param[] param, boolean tached) throws PKIException {
        return Parser.writeDERObj2Bytes(this.genP7_SignObj(data, param, tached));
    }

    public DERObject genP7_SignTSPObj(P7Param[] param, TSTInfo info) throws PKIException {
        if (this.session == null) {
            throw new PKIException("8216", "\u53c2\u6570\u4e0d\u5b8c\u6574");
        }
        try {
            ContentInfo dataCnt = null;
            dataCnt = this.GetCnt(this.GetTypeOid(7), info.getEncoded());
            ASN1EncodableVector vdigMech = new ASN1EncodableVector();
            ASN1EncodableVector vCert = new ASN1EncodableVector();
            ASN1EncodableVector vCrl = new ASN1EncodableVector();
            ASN1EncodableVector vSignInfo = new ASN1EncodableVector();
            ASN1EncodableVector vAuth = new ASN1EncodableVector();
            int i = 0;
            while (i < param.length) {
                if (param[i].GetPrvKey() == null || param[i].GetSignMech() == null) {
                    throw new PKIException("8216", "\u53c2\u6570\u4e0d\u5b8c\u6574");
                }
                DERObjectIdentifier digMech = this.Sign2DigOid(param[i].GetSignMech());
                AlgorithmIdentifier algoDig = new AlgorithmIdentifier(digMech);
                DERObject[] auth = param[i].GetAuthData();
                if (auth.length == 0) {
                    throw new PKIException("8213", "\u4ea7\u751fP7\u7ed3\u6784\u5931\u8d25need authAttr");
                }
                int j = 0;
                while (auth != null && j < auth.length) {
                    vAuth.add(auth[j]);
                    ++j;
                }
                vdigMech.add(algoDig);
                DERSet authset = new DERSet(vAuth);
                byte[] src = Parser.writeDERObj2Bytes(authset);
                byte[] sign = null;
                sign = src != null ? this.session.sign(param[i].GetSignMech(), param[i].GetPrvKey(), src) : this.session.sign(param[i].GetSignMech(), param[i].GetPrvKey(), Parser.writeDERObj2Bytes(info));
                if (sign == null) {
                    throw new PKIException("8213", "\u4ea7\u751fP7\u7ed3\u6784\u5931\u8d25");
                }
                vSignInfo.add(this.GetSignerInfo(param[i], sign));
                X509Cert[] x509certs = param[i].GetSignCerts();
                int j2 = 0;
                while (x509certs != null && j2 < x509certs.length) {
                    vCert.add(x509certs[j2].getCertStructure());
                    ++j2;
                }
                X509CRL[] x509crls = param[i].GetCrls();
                int k = 0;
                while (x509crls != null && k < x509crls.length) {
                    vCrl.add(x509crls[k].getCertificateList());
                    ++k;
                }
                ++i;
            }
            DERSet algos = new DERSet(vdigMech);
            DERSet infos = new DERSet(vSignInfo);
            DERSet certs = null;
            if (vCert.size() != 0) {
                certs = new DERSet(vCert);
            }
            DERSet crls = null;
            if (vCrl.size() != 0) {
                crls = new DERSet(vCrl);
            }
            DERInteger ver = new DERInteger(1);
            SignedData signData = new SignedData(ver, algos, dataCnt, certs, crls, infos);
        }
        catch (Exception ex) {
            throw new PKIException("8213", "\u4ea7\u751fP7\u7ed3\u6784\u5931\u8d25", ex);
        }
        if (this.cntInfo == null) {
            return null;
        }
        return this.cntInfo.getDERObject();
    }

    public byte[] genP7_SignTSP(P7Param[] param, TSTInfo info) throws PKIException {
        return Parser.writeDERObj2Bytes(this.genP7_SignTSPObj(param, info));
    }

    public List genP7_SignAttach_os(InputStream data, int len, P7Param[] param) throws PKIException {
        if (this.session == null) {
            throw new PKIException("8216", "\u53c2\u6570\u4e0d\u5b8c\u6574");
        }
        try {
            ASN1EncodableVector vdigMech = new ASN1EncodableVector();
            ASN1EncodableVector vCert = new ASN1EncodableVector();
            ASN1EncodableVector vCrl = new ASN1EncodableVector();
            ASN1EncodableVector vSignInfo = new ASN1EncodableVector();
            int i = 0;
            while (i < param.length) {
                if (param[i].GetPrvKey() == null || param[i].GetSignMech() == null) {
                    throw new PKIException("8216", "\u53c2\u6570\u4e0d\u5b8c\u6574");
                }
                DERObjectIdentifier digMech = this.Sign2DigOid(param[i].GetSignMech());
                AlgorithmIdentifier algoDig = new AlgorithmIdentifier(digMech);
                vdigMech.add(algoDig);
                byte[] sign = this.session.sign(param[i].GetSignMech(), param[i].GetPrvKey(), data);
                if (sign == null) {
                    throw new PKIException("8213", "\u4ea7\u751fP7\u7ed3\u6784\u5931\u8d25");
                }
                vSignInfo.add(this.GetSignerInfo(param[i], sign));
                X509Cert[] x509certs = param[i].GetSignCerts();
                int j = 0;
                while (x509certs != null && j < x509certs.length) {
                    vCert.add(x509certs[j].getCertStructure());
                    ++j;
                }
                X509CRL[] x509crls = param[i].GetCrls();
                int k = 0;
                while (x509crls != null && k < x509crls.length) {
                    vCrl.add(x509crls[k].getCertificateList());
                    ++k;
                }
                ++i;
            }
            DERSet algos = new DERSet(vdigMech);
            DERSet infos = new DERSet(vSignInfo);
            DERSet certs = null;
            if (vCert.size() != 0) {
                certs = new DERSet(vCert);
            }
            DERSet crls = null;
            if (vCrl.size() != 0) {
                crls = new DERSet(vCrl);
            }
            int taillen = 0;
            byte[] binfos = Parser.writeDERObj2Bytes(infos);
            taillen = binfos.length;
            byte[] bcrl = null;
            if (crls != null) {
                DERTaggedObject crlsData = new DERTaggedObject(false, 1, crls);
                bcrl = Parser.writeDERObj2Bytes(crlsData);
                taillen += bcrl.length;
            }
            byte[] bcert = null;
            if (certs != null) {
                DERTaggedObject certsData = new DERTaggedObject(false, 0, certs);
                bcert = Parser.writeDERObj2Bytes(certsData);
                taillen += bcert.length;
            }
            byte[] tail = new byte[taillen];
            int lenpos = 0;
            if (bcert != null) {
                System.arraycopy(bcert, 0, tail, 0, bcert.length);
                lenpos += bcert.length;
            }
            if (bcrl != null) {
                System.arraycopy(bcrl, 0, tail, lenpos, bcrl.length);
                lenpos += bcrl.length;
            }
            System.arraycopy(binfos, 0, tail, lenpos, binfos.length);
            byte[] version = new byte[]{2, 1, 1};
            byte[] algo = Parser.writeDERObj2Bytes(algos);
            byte[] sourceoid = Parser.writeDERObj2Bytes(this.GetTypeOid(1));
            byte[] bitSrcHder = this.getAsn1HeadData(4, len);
            byte[] sourceHder = this.getAsn1HeadData(160, len + bitSrcHder.length);
            byte[] tmp = new byte[sourceoid.length + sourceHder.length + bitSrcHder.length];
            System.arraycopy(sourceoid, 0, tmp, 0, sourceoid.length);
            System.arraycopy(sourceHder, 0, tmp, sourceoid.length, sourceHder.length);
            System.arraycopy(bitSrcHder, 0, tmp, sourceoid.length + sourceHder.length, bitSrcHder.length);
            byte[] sourceSeqHder = this.getAsn1HeadData(48, tmp.length + len);
            byte[] sourceSeq = new byte[sourceSeqHder.length + tmp.length];
            System.arraycopy(sourceSeqHder, 0, sourceSeq, 0, sourceSeqHder.length);
            System.arraycopy(tmp, 0, sourceSeq, sourceSeqHder.length, tmp.length);
            byte[] sDataHeader = this.getAsn1HeadData(48, version.length + algo.length + sourceSeq.length + len + tail.length);
            byte[] sData = new byte[sDataHeader.length + version.length + algo.length + sourceSeq.length];
            System.arraycopy(sDataHeader, 0, sData, 0, sDataHeader.length);
            System.arraycopy(version, 0, sData, sDataHeader.length, version.length);
            System.arraycopy(algo, 0, sData, sDataHeader.length + version.length, algo.length);
            System.arraycopy(sourceSeq, 0, sData, sDataHeader.length + version.length + algo.length, sourceSeq.length);
            byte[] cntxtHder = this.getAsn1HeadData(160, sData.length + len + tail.length);
            byte[] cntxt = new byte[cntxtHder.length + sData.length];
            System.arraycopy(cntxtHder, 0, cntxt, 0, cntxtHder.length);
            System.arraycopy(sData, 0, cntxt, cntxtHder.length, sData.length);
            byte[] p7oid = Parser.writeDERObj2Bytes(this.GetTypeOid(2));
            byte[] p7hder = this.getAsn1HeadData(48, p7oid.length + cntxt.length + len + tail.length);
            byte[] header = new byte[p7hder.length + p7oid.length + cntxt.length];
            System.arraycopy(p7hder, 0, header, 0, p7hder.length);
            System.arraycopy(p7oid, 0, header, p7hder.length, p7oid.length);
            System.arraycopy(cntxt, 0, header, p7hder.length + p7oid.length, cntxt.length);
            ArrayList<byte[]> ls = new ArrayList<byte[]>();
            ls.add(header);
            ls.add(tail);
            return ls;
        }
        catch (Exception ex) {
            throw new PKIException("8213", "\u4ea7\u751fP7\u7ed3\u6784\u5931\u8d25", ex);
        }
    }

    public byte[] genP7_SignDetach_os(InputStream data, P7Param[] param) throws PKIException {
        return Parser.writeDERObj2Bytes(this.genP7_SignObjDetach_os(data, param));
    }

    public DERObject genP7_SignObjDetach_os(InputStream data, P7Param[] param) throws PKIException {
        if (this.session == null) {
            throw new PKIException("8216", "\u53c2\u6570\u4e0d\u5b8c\u6574");
        }
        try {
            ContentInfo dataCnt = null;
            byte[] cnt = null;
            dataCnt = this.GetCnt(this.GetTypeOid(1), cnt);
            ASN1EncodableVector vdigMech = new ASN1EncodableVector();
            ASN1EncodableVector vCert = new ASN1EncodableVector();
            ASN1EncodableVector vCrl = new ASN1EncodableVector();
            ASN1EncodableVector vSignInfo = new ASN1EncodableVector();
            int i = 0;
            while (i < param.length) {
                if (param[i].GetPrvKey() == null || param[i].GetSignMech() == null) {
                    throw new PKIException("8216", "\u53c2\u6570\u4e0d\u5b8c\u6574");
                }
                DERObjectIdentifier digMech = this.Sign2DigOid(param[i].GetSignMech());
                AlgorithmIdentifier algoDig = new AlgorithmIdentifier(digMech);
                vdigMech.add(algoDig);
                byte[] sign = this.session.sign(param[i].GetSignMech(), param[i].GetPrvKey(), data);
                if (sign == null) {
                    throw new PKIException("8213", "\u4ea7\u751fP7\u7ed3\u6784\u5931\u8d25");
                }
                vSignInfo.add(this.GetSignerInfo(param[i], sign));
                X509Cert[] x509certs = param[i].GetSignCerts();
                int j = 0;
                while (x509certs != null && j < x509certs.length) {
                    vCert.add(x509certs[j].getCertStructure());
                    ++j;
                }
                X509CRL[] x509crls = param[i].GetCrls();
                int k = 0;
                while (x509crls != null && k < x509crls.length) {
                    vCrl.add(x509crls[k].getCertificateList());
                    ++k;
                }
                ++i;
            }
            DERSet algos = new DERSet(vdigMech);
            DERSet infos = new DERSet(vSignInfo);
            DERSet certs = null;
            if (vCert.size() != 0) {
                certs = new DERSet(vCert);
            }
            DERSet crls = null;
            if (vCrl.size() != 0) {
                crls = new DERSet(vCrl);
            }
            DERInteger ver = new DERInteger(1);
            SignedData signData = new SignedData(ver, algos, dataCnt, certs, crls, infos);
            this.cntInfo = this.GetCnt(this.GetTypeOid(2), signData);
        }
        catch (Exception ex) {
            throw new PKIException("8213", "\u4ea7\u751fP7\u7ed3\u6784\u5931\u8d25", ex);
        }
        if (this.cntInfo == null) {
            return null;
        }
        return this.cntInfo.getDERObject();
    }

    public long genP7_Sign_os(InputStream data, long len, P7Param[] param, boolean attach, OutputStream out) throws PKIException {
        long p7len = 0L;
        if (this.session == null) {
            throw new PKIException("8216", "\u53c2\u6570\u4e0d\u5b8c\u6574");
        }
        try {
            ContentInfo dataCnt = null;
            byte[] cnt = new byte[1024];
            data.read(cnt);
            if (!attach) {
                cnt = null;
            }
            dataCnt = this.GetCnt(this.GetTypeOid(1), cnt);
            ASN1EncodableVector vdigMech = new ASN1EncodableVector();
            ASN1EncodableVector vCert = new ASN1EncodableVector();
            ASN1EncodableVector vCrl = new ASN1EncodableVector();
            ASN1EncodableVector vSignInfo = new ASN1EncodableVector();
            int i = 0;
            while (i < param.length) {
                if (param[i].GetPrvKey() == null || param[i].GetSignMech() == null) {
                    throw new PKIException("8216", "\u53c2\u6570\u4e0d\u5b8c\u6574");
                }
                DERObjectIdentifier digMech = this.Sign2DigOid(param[i].GetSignMech());
                AlgorithmIdentifier algoDig = new AlgorithmIdentifier(digMech);
                vdigMech.add(algoDig);
                byte[] sign = this.session.sign(param[i].GetSignMech(), param[i].GetPrvKey(), data);
                if (sign == null) {
                    throw new PKIException("8213", "\u4ea7\u751fP7\u7ed3\u6784\u5931\u8d25");
                }
                vSignInfo.add(this.GetSignerInfo(param[i], sign));
                X509Cert[] x509certs = param[i].GetSignCerts();
                int j = 0;
                while (x509certs != null && j < x509certs.length) {
                    vCert.add(x509certs[j].getCertStructure());
                    ++j;
                }
                X509CRL[] x509crls = param[i].GetCrls();
                int k = 0;
                while (x509crls != null && k < x509crls.length) {
                    vCrl.add(x509crls[k].getCertificateList());
                    ++k;
                }
                ++i;
            }
            DERSet algos = new DERSet(vdigMech);
            DERSet infos = new DERSet(vSignInfo);
            DERSet certs = null;
            if (vCert.size() != 0) {
                certs = new DERSet(vCert);
            }
            DERSet crls = null;
            if (vCrl.size() != 0) {
                crls = new DERSet(vCrl);
            }
            DERInteger ver = new DERInteger(1);
            SignedData signData = new SignedData(ver, algos, dataCnt, certs, crls, infos);
            this.cntInfo = this.GetCnt(this.GetTypeOid(2), signData);
            if (this.cntInfo == null) {
                throw new PKIException("8213", "\u4ea7\u751fP7\u7ed3\u6784\u5931\u8d25");
            }
        }
        catch (Exception ex) {
            throw new PKIException("8213", "\u4ea7\u751fP7\u7ed3\u6784\u5931\u8d25", ex);
        }
        this.cntInfo.getDERObject();
        return p7len;
    }

    public DERObject genP7_EnvObj(byte[] data, P7Param param) throws PKIException {
        if (this.session == null) {
            throw new PKIException("8216", "\u53c2\u6570\u4e0d\u5b8c\u6574");
        }
        X509Cert[] certs = param.GetEncCerts();
        p7CertInfo[] certInfos = param.getEncCertInfos();
        if (certs == null && certInfos == null) {
            throw new PKIException("8216", "\u53c2\u6570\u4e0d\u5b8c\u6574");
        }
        Mechanism[] mechs = param.GetEnvMech();
        ASN1EncodableVector vInfo = new ASN1EncodableVector();
        int count = 0;
        count = certs != null ? certs.length : certInfos.length;
        int i = 0;
        while (i < count) {
            byte[] encedKey = certs != null ? this.session.encrypt(mechs[i], certs[i].getPublicKey(), param.GetEncKey().getKey()) : this.session.encrypt(mechs[i], certInfos[i].getPubKey(), param.GetEncKey().getKey());
            RecipientInfo recInfo = this.GetRecInfo(certInfos[i], mechs[i], encedKey);
            vInfo.add(recInfo);
            ++i;
        }
        DERSet infos = new DERSet(vInfo);
        DERInteger ver = new DERInteger(0);
        byte[] encedData = null;
        if (data != null) {
            encedData = this.session.encrypt(param.GetEncMech(), param.GetEncKey(), data);
        }
        EncryptedContentInfo encedCntInfo = this.GetEncedCntInfo(encedData, param.GetEncMech());
        EnvelopedData envData = new EnvelopedData(ver, infos, encedCntInfo);
        this.cntInfo = this.GetCnt(this.GetTypeOid(3), envData);
        if (this.cntInfo == null) {
            return null;
        }
        return this.cntInfo.getDERObject();
    }

    public byte[] genP7_Env(byte[] data, P7Param param) throws PKIException {
        return Parser.writeDERObj2Bytes(this.genP7_EnvObj(data, param));
    }

    public byte[] genP7_Env_final(byte[] data) throws PKIException, IOException {
        if (this.session == null) {
            throw new PKIException("8216", "\u53c2\u6570\u4e0d\u5b8c\u6574");
        }
        if (this.envContext.buffer.size() == 0) {
            return this.session.encryptFinal(this.envContext.handle, this.GetP7Cnt().GetEncMech(), data);
        }
        this.envContext.buffer.put(data);
        data = this.envContext.buffer.getAll();
        return this.session.encryptFinal(this.envContext.handle, this.GetP7Cnt().GetEncMech(), data);
    }

    public byte[] genP7_Env_update(byte[] data) throws PKIException, IOException {
        if (this.session == null) {
            throw new PKIException("8216", "\u53c2\u6570\u4e0d\u5b8c\u6574");
        }
        if ((data.length & 0xF) == 0 && this.envContext.buffer.size() == 0) {
            return this.session.encryptUpdate(this.envContext.handle, this.GetP7Cnt().GetEncMech(), data);
        }
        this.envContext.buffer.put(data);
        data = this.envContext.buffer.getBlock();
        if (data != null) {
            return this.session.encryptUpdate(this.envContext.handle, this.GetP7Cnt().GetEncMech(), data);
        }
        return null;
    }

    public byte[] genP7_Env_init(long sourceLen, P7Param param) throws PKIException, IOException {
        if (this.session == null) {
            throw new PKIException("8216", "\u53c2\u6570\u4e0d\u5b8c\u6574");
        }
        this.p7cnt = param;
        this.envContext = new EnvContext();
        this.envContext.buffer = new Buffer();
        this.envContext.handle = this.session.encryptInit(param.GetEncMech(), param.GetEncKey());
        long encLen = this.getPaddingLength(param.GetEncMech(), sourceLen);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DEROutputStream dos = new DEROutputStream(bos);
        dos.writeObject(this.GetTypeOid(1));
        CBCParam cbc = (CBCParam)param.GetEncMech().getParam();
        DEROctetString cbcparam = null;
        AlgorithmIdentifier algoEnc = null;
        if (cbc == null) {
            algoEnc = new AlgorithmIdentifier(this.GetEncOid(param.GetEncMech()));
        } else {
            cbcparam = new DEROctetString(cbc.getIv());
            algoEnc = new AlgorithmIdentifier(this.GetEncOid(param.GetEncMech()), cbcparam);
        }
        dos.writeObject(algoEnc);
        dos.close();
        byte[] encHder = this.getAsn1HeadData(128, (int)encLen);
        byte[] tmp = bos.toByteArray();
        int encCntlen = tmp.length + encHder.length;
        byte[] encCntHder = this.getAsn1HeadData(48, encCntlen + (int)encLen);
        byte[] encCnt = new byte[encCntHder.length + encCntlen];
        System.arraycopy(encCntHder, 0, encCnt, 0, encCntHder.length);
        System.arraycopy(tmp, 0, encCnt, encCntHder.length, tmp.length);
        System.arraycopy(encHder, 0, encCnt, encCntHder.length + tmp.length, encHder.length);
        X509Cert[] certs = param.GetEncCerts();
        p7CertInfo[] certInfos = param.getEncCertInfos();
        if (certs == null && certInfos == null) {
            throw new PKIException("8216", "\u53c2\u6570\u4e0d\u5b8c\u6574");
        }
        Mechanism[] mechs = param.GetEnvMech();
        ASN1EncodableVector vInfo = new ASN1EncodableVector();
        int count = 0;
        count = certs != null ? certs.length : certInfos.length;
        int i = 0;
        while (i < count) {
            byte[] encedKey = certs != null ? this.session.encrypt(mechs[i], certs[i].getPublicKey(), param.GetEncKey().getKey()) : this.session.encrypt(mechs[i], certInfos[i].getPubKey(), param.GetEncKey().getKey());
            RecipientInfo recInfo = this.GetRecInfo(certInfos[i], mechs[i], encedKey);
            vInfo.add(recInfo);
            ++i;
        }
        DERSet infos = new DERSet(vInfo);
        DERInteger ver = new DERInteger(0);
        bos = new ByteArrayOutputStream();
        dos = new DEROutputStream(bos);
        dos.writeObject(ver);
        dos.writeObject(infos);
        tmp = bos.toByteArray();
        dos.close();
        byte[] envCnt = new byte[tmp.length + encCnt.length];
        System.arraycopy(tmp, 0, envCnt, 0, tmp.length);
        System.arraycopy(encCnt, 0, envCnt, tmp.length, encCnt.length);
        byte[] hder = this.getAsn1HeadData(48, envCnt.length + (int)encLen);
        byte[] envData = new byte[hder.length + envCnt.length];
        System.arraycopy(hder, 0, envData, 0, hder.length);
        System.arraycopy(envCnt, 0, envData, hder.length, envCnt.length);
        byte[] oid = Parser.writeDERObj2Bytes(this.GetTypeOid(3));
        hder = this.getAsn1HeadData(160, envData.length + (int)encLen);
        byte[] cntdata = new byte[hder.length + envData.length];
        System.arraycopy(hder, 0, cntdata, 0, hder.length);
        System.arraycopy(envData, 0, cntdata, hder.length, envData.length);
        hder = this.getAsn1HeadData(48, cntdata.length + (int)encLen + oid.length);
        byte[] rv = new byte[hder.length + cntdata.length + oid.length];
        System.arraycopy(hder, 0, rv, 0, hder.length);
        System.arraycopy(oid, 0, rv, hder.length, oid.length);
        System.arraycopy(cntdata, 0, rv, hder.length + oid.length, cntdata.length);
        return rv;
    }

    public byte[] genP7_Env_os(InputStream data, P7Param param, OutputStream enc) throws PKIException, IOException {
        if (this.session == null) {
            throw new PKIException("8216", "\u53c2\u6570\u4e0d\u5b8c\u6574");
        }
        long encLen = 0L;
        if (data != null) {
            encLen = this.session.encrypt(param.GetEncMech(), param.GetEncKey(), data, enc);
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DEROutputStream dos = new DEROutputStream(bos);
        dos.writeObject(this.GetTypeOid(1));
        CBCParam cbc = (CBCParam)param.GetEncMech().getParam();
        DEROctetString cbcparam = null;
        AlgorithmIdentifier algoEnc = null;
        if (cbc == null) {
            algoEnc = new AlgorithmIdentifier(this.GetEncOid(param.GetEncMech()));
        } else {
            cbcparam = new DEROctetString(cbc.getIv());
            algoEnc = new AlgorithmIdentifier(this.GetEncOid(param.GetEncMech()), cbcparam);
        }
        dos.writeObject(algoEnc);
        dos.close();
        byte[] encHder = this.getAsn1HeadData(128, (int)encLen);
        byte[] tmp = bos.toByteArray();
        int encCntlen = tmp.length + encHder.length;
        byte[] encCntHder = this.getAsn1HeadData(48, encCntlen + (int)encLen);
        byte[] encCnt = new byte[encCntHder.length + encCntlen];
        System.arraycopy(encCntHder, 0, encCnt, 0, encCntHder.length);
        System.arraycopy(tmp, 0, encCnt, encCntHder.length, tmp.length);
        System.arraycopy(encHder, 0, encCnt, encCntHder.length + tmp.length, encHder.length);
        X509Cert[] certs = param.GetEncCerts();
        p7CertInfo[] certInfos = param.getEncCertInfos();
        if (certs == null && certInfos == null) {
            throw new PKIException("8216", "\u53c2\u6570\u4e0d\u5b8c\u6574");
        }
        Mechanism[] mechs = param.GetEnvMech();
        ASN1EncodableVector vInfo = new ASN1EncodableVector();
        int count = 0;
        count = certs != null ? certs.length : certInfos.length;
        int i = 0;
        while (i < count) {
            byte[] encedKey = certs != null ? this.session.encrypt(mechs[i], certs[i].getPublicKey(), param.GetEncKey().getKey()) : this.session.encrypt(mechs[i], certInfos[i].getPubKey(), param.GetEncKey().getKey());
            RecipientInfo recInfo = this.GetRecInfo(certInfos[i], mechs[i], encedKey);
            vInfo.add(recInfo);
            ++i;
        }
        DERSet infos = new DERSet(vInfo);
        DERInteger ver = new DERInteger(0);
        bos = new ByteArrayOutputStream();
        dos = new DEROutputStream(bos);
        dos.writeObject(ver);
        dos.writeObject(infos);
        tmp = bos.toByteArray();
        dos.close();
        byte[] envCnt = new byte[tmp.length + encCnt.length];
        System.arraycopy(tmp, 0, envCnt, 0, tmp.length);
        System.arraycopy(encCnt, 0, envCnt, tmp.length, encCnt.length);
        byte[] hder = this.getAsn1HeadData(48, envCnt.length + (int)encLen);
        byte[] envData = new byte[hder.length + envCnt.length];
        System.arraycopy(hder, 0, envData, 0, hder.length);
        System.arraycopy(envCnt, 0, envData, hder.length, envCnt.length);
        byte[] oid = Parser.writeDERObj2Bytes(this.GetTypeOid(3));
        hder = this.getAsn1HeadData(160, envData.length + (int)encLen);
        byte[] cntdata = new byte[hder.length + envData.length];
        System.arraycopy(hder, 0, cntdata, 0, hder.length);
        System.arraycopy(envData, 0, cntdata, hder.length, envData.length);
        hder = this.getAsn1HeadData(48, cntdata.length + (int)encLen + oid.length);
        byte[] rv = new byte[hder.length + cntdata.length + oid.length];
        System.arraycopy(hder, 0, rv, 0, hder.length);
        System.arraycopy(oid, 0, rv, hder.length, oid.length);
        System.arraycopy(cntdata, 0, rv, hder.length + oid.length, cntdata.length);
        return rv;
    }

    public byte[] genP7_SignEnv(byte[] data, P7Param[] param) throws PKIException {
        return Parser.writeDERObj2Bytes(this.genP7_SignEnvObj(data, param));
    }

    public DERObject genP7_SignEnvObj(byte[] data, P7Param[] param) throws PKIException {
        if (this.session == null) {
            throw new PKIException("8216", "\u53c2\u6570\u4e0d\u5b8c\u6574");
        }
        ASN1EncodableVector vdigMech = new ASN1EncodableVector();
        ASN1EncodableVector vCert = new ASN1EncodableVector();
        ASN1EncodableVector vCrl = new ASN1EncodableVector();
        ASN1EncodableVector vSignInfo = new ASN1EncodableVector();
        ASN1EncodableVector vInfo = new ASN1EncodableVector();
        int i = 0;
        while (i < param.length) {
            RecipientInfo recInfo;
            Mechanism[] recMech;
            byte[] encedKey;
            if (param[i].GetPrvKey() == null || param[i].GetSignMech() == null) {
                throw new PKIException("8216", "\u53c2\u6570\u4e0d\u5b8c\u6574");
            }
            DERObjectIdentifier digMech = this.Sign2DigOid(param[i].GetSignMech());
            AlgorithmIdentifier algoDig = new AlgorithmIdentifier(digMech);
            vdigMech.add(algoDig);
            byte[] sign = this.session.sign(param[i].GetSignMech(), param[i].GetPrvKey(), data);
            if (sign == null) {
                throw new PKIException("8213", "\u4ea7\u751fP7\u7ed3\u6784\u5931\u8d25");
            }
            vSignInfo.add(this.GetSignerInfo(param[i], sign));
            X509Cert[] x509certs = param[i].GetEncCerts();
            p7CertInfo[] certInfos = param[i].getEncCertInfos();
            if (x509certs == null && certInfos == null) {
                throw new PKIException("8216", "\u53c2\u6570\u4e0d\u5b8c\u6574");
            }
            Mechanism[] mechs = param[i].GetEnvMech();
            if (x509certs != null) {
                encedKey = this.session.encrypt(mechs[0], x509certs[0].getPublicKey(), param[i].GetEncKey().getKey());
                recMech = param[i].GetEnvMech();
                recInfo = this.GetRecInfo(x509certs[0], recMech[0], encedKey);
                vInfo.add(recInfo);
            } else {
                encedKey = this.session.encrypt(mechs[0], certInfos[0].getPubKey(), param[i].GetEncKey().getKey());
                recMech = param[i].GetEnvMech();
                recInfo = this.GetRecInfo(certInfos[0], recMech[0], encedKey);
                vInfo.add(recInfo);
            }
            X509Cert[] signCerts = param[i].GetSignCerts();
            int j = 0;
            while (signCerts != null && j < signCerts.length) {
                vCert.add(signCerts[j].getCertStructure());
                ++j;
            }
            X509CRL[] x509crls = param[i].GetCrls();
            int k = 0;
            while (x509crls != null && k < x509crls.length) {
                vCrl.add(x509crls[k].getCertificateList());
                ++k;
            }
            ++i;
        }
        DERSet algos = new DERSet(vdigMech);
        DERSet infos = new DERSet(vSignInfo);
        DERSet certs = null;
        if (vCert.size() != 0) {
            certs = new DERSet(vCert);
        }
        DERSet crls = null;
        if (vCrl.size() != 0) {
            crls = new DERSet(vCrl);
        }
        DERSet recinfos = new DERSet(vInfo);
        byte[] encedData = this.session.encrypt(param[0].GetEncMech(), param[0].GetEncKey(), data);
        EncryptedContentInfo encedCntInfo = this.GetEncedCntInfo(encedData, param[0].GetEncMech());
        DERInteger ver = new DERInteger(1);
        SignedAndEnvelopedData SignEnv = new SignedAndEnvelopedData(ver, recinfos, algos, encedCntInfo, certs, crls, infos);
        this.cntInfo = this.GetCnt(this.GetTypeOid(4), SignEnv);
        if (this.cntInfo == null) {
            return null;
        }
        return this.cntInfo.getDERObject();
    }

    public byte[] genP7_Dig(byte[] data, Mechanism digMech) throws PKIException {
        return Parser.writeDERObj2Bytes(this.genP7_DigObj(data, digMech));
    }

    public DERObject genP7_DigObj(byte[] data, Mechanism digMech) throws PKIException {
        if (this.session == null) {
            throw new PKIException("8216", "\u53c2\u6570\u4e0d\u5b8c\u6574");
        }
        ContentInfo dataCnt = this.GetCnt(this.GetTypeOid(1), data);
        AlgorithmIdentifier algoDig = new AlgorithmIdentifier(this.GetDigOid(digMech));
        DERInteger ver = new DERInteger(0);
        byte[] digData = this.session.digest(digMech, data);
        DEROctetString oct = new DEROctetString(digData);
        DigestedData dig = new DigestedData(ver, algoDig, dataCnt, oct);
        this.cntInfo = this.GetCnt(this.GetTypeOid(5), dig);
        if (this.cntInfo == null) {
            return null;
        }
        return this.cntInfo.getDERObject();
    }

    public byte[] genP7_Enc(byte[] data, JKey key, Mechanism encMech) throws PKIException {
        return Parser.writeDERObj2Bytes(this.genP7_EncObj(data, key, encMech));
    }

    public DERObject genP7_EncObj(byte[] data, JKey key, Mechanism encMech) throws PKIException {
        if (this.session == null) {
            throw new PKIException("8216", "\u53c2\u6570\u4e0d\u5b8c\u6574");
        }
        byte[] encedData = this.session.encrypt(encMech, key, data);
        EncryptedContentInfo encedCntInfo = this.GetEncedCntInfo(encedData, encMech);
        DERInteger ver = new DERInteger(0);
        EncryptedData enc = new EncryptedData(ver, encedCntInfo);
        this.cntInfo = this.GetCnt(this.GetTypeOid(6), enc);
        if (this.cntInfo == null) {
            return null;
        }
        return this.cntInfo.getDERObject();
    }

    public boolean verifyP7Sign(p7signInfo info, byte[] src, X509Cert[] certs) throws PKIException {
        if (this.session == null) {
            throw new PKIException("8216", "\u53c2\u6570\u4e0d\u5b8c\u6574");
        }
        P7Param param = this.GetP7Cnt();
        if (param == null) {
            throw new PKIException("8216", "\u53c2\u6570\u4e0d\u5b8c\u6574");
        }
        byte[] data = param.GetSource();
        if (data == null && src == null) {
            throw new PKIException("8216", "\u53c2\u6570\u4e0d\u5b8c\u6574");
        }
        if (data == null) {
            data = src;
        }
        if (param.GetSignCerts() == null && certs == null) {
            throw new PKIException("8216", "\u53c2\u6570\u4e0d\u5b8c\u6574");
        }
        if (param.GetSignCerts() != null) {
            certs = param.GetSignCerts();
        }
        Mechanism mech = new Mechanism(info.getSignMech());
        String sn = info.getSn();
        int j = 0;
        while (j < certs.length) {
            if (sn.equals(certs[j].getSerialNumber().toString(16))) break;
            ++j;
        }
        if (j >= certs.length) {
            throw new PKIException("8216", "\u53c2\u6570\u4e0d\u5b8c\u6574");
        }
        byte[] sign = info.getSignature();
        boolean rv = this.session.verifySign(mech, certs[j].getPublicKey(), data, sign);
        return rv;
    }

    public boolean verifyP7Sign_Tsp(p7signInfo info, byte[] src, X509Cert[] certs) throws PKIException {
        if (this.session == null) {
            throw new PKIException("8216", "\u53c2\u6570\u4e0d\u5b8c\u6574");
        }
        P7Param param = this.GetP7Cnt();
        if (param == null) {
            throw new PKIException("8216", "\u53c2\u6570\u4e0d\u5b8c\u6574");
        }
        DERObject[] auth = param.GetSignInfos()[0].getAuths();
        ASN1EncodableVector vAuth = new ASN1EncodableVector();
        int j = 0;
        while (auth != null && j < auth.length) {
            vAuth.add(auth[j]);
            ++j;
        }
        DERSet authset = null;
        byte[] data = null;
        if (vAuth.size() != 0) {
            authset = new DERSet(vAuth);
            data = Parser.writeDERObj2Bytes(authset);
        }
        if (data == null && src == null) {
            throw new PKIException("8216", "\u53c2\u6570\u4e0d\u5b8c\u6574");
        }
        if (data == null) {
            data = src;
        }
        if (param.GetSignCerts() == null && certs == null) {
            throw new PKIException("8216", "\u53c2\u6570\u4e0d\u5b8c\u6574");
        }
        if (param.GetSignCerts() != null) {
            certs = param.GetSignCerts();
        }
        Mechanism mech = new Mechanism(info.getSignMech());
        String sn = info.getSn();
        int j2 = 0;
        while (j2 < certs.length) {
            if (sn.equals(certs[j2].getSerialNumber().toString(16))) break;
            ++j2;
        }
        if (j2 >= certs.length) {
            throw new PKIException("8216", "\u53c2\u6570\u4e0d\u5b8c\u6574");
        }
        byte[] sign = info.getSignature();
        boolean rv = this.session.verifySign(mech, certs[j2].getPublicKey(), data, sign);
        return rv;
    }

    public boolean verifyP7Sign_os(p7signInfo info, InputStream src, X509Cert[] certs) throws PKIException {
        if (this.session == null) {
            throw new PKIException("8216", "\u53c2\u6570\u4e0d\u5b8c\u6574");
        }
        P7Param param = this.GetP7Cnt();
        if (param == null) {
            throw new PKIException("8216", "\u53c2\u6570\u4e0d\u5b8c\u6574");
        }
        if (src == null) {
            throw new PKIException("8216", "\u53c2\u6570\u4e0d\u5b8c\u6574");
        }
        if (param.GetSignCerts() == null && certs == null) {
            throw new PKIException("8216", "\u53c2\u6570\u4e0d\u5b8c\u6574");
        }
        if (param.GetSignCerts() != null) {
            certs = param.GetSignCerts();
        }
        Mechanism mech = new Mechanism(info.getSignMech());
        String sn = info.getSn();
        int j = 0;
        while (j < certs.length) {
            if (sn.equals(certs[j].getSerialNumber().toString(16))) break;
            ++j;
        }
        if (j >= certs.length) {
            throw new PKIException("8216", "\u53c2\u6570\u4e0d\u5b8c\u6574");
        }
        byte[] sign = info.getSignature();
        boolean rv = this.session.verifySign(mech, certs[j].getPublicKey(), src, sign);
        return rv;
    }

    public boolean verifyP7Sign(byte[] src, X509Cert[] certs) throws PKIException {
        P7Param param = this.GetP7Cnt();
        if (param == null) {
            throw new PKIException("8216", "\u53c2\u6570\u4e0d\u5b8c\u6574");
        }
        p7signInfo[] infos = param.GetSignInfos();
        int i = 0;
        while (i < infos.length) {
            if (!this.verifyP7Sign(infos[i], src, certs)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean verifyP7Sign_Tsp(byte[] src, X509Cert[] certs) throws PKIException {
        P7Param param = this.GetP7Cnt();
        if (param == null) {
            throw new PKIException("8216", "\u53c2\u6570\u4e0d\u5b8c\u6574");
        }
        p7signInfo[] infos = param.GetSignInfos();
        int i = 0;
        while (i < infos.length) {
            if (!this.verifyP7Sign_Tsp(infos[i], src, certs)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean verifyP7Sign_os(InputStream src, X509Cert[] certs) throws PKIException {
        P7Param param = this.GetP7Cnt();
        if (param == null) {
            throw new PKIException("8216", "\u53c2\u6570\u4e0d\u5b8c\u6574");
        }
        p7signInfo[] infos = param.GetSignInfos();
        int i = 0;
        while (i < infos.length) {
            if (!this.verifyP7Sign_os(infos[i], src, certs)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public byte[] verifyP7Env(p7recInfo info, p7recCertKey rec, Object iv) throws PKIException {
        P7Param param = this.GetP7Cnt();
        if (param == null) {
            throw new PKIException("8216", "\u53c2\u6570\u4e0d\u5b8c\u6574");
        }
        if (param.GetEncedData() == null) {
            throw new PKIException("8216", "\u53c2\u6570\u4e0d\u5b8c\u6574");
        }
        Mechanism mech = param.GetEncMech();
        if (mech.getParam() == null && iv != null) {
            mech.setParam(iv);
        }
        String recIss = rec.getCert().getIssuer();
        String recSn = rec.getCert().getSerialNumber().toString(16);
        if (recIss.equals(info.getIssuer()) && recSn.equals(info.getSn())) {
            throw new PKIException("8216", "\u53c2\u6570\u4e0d\u5b8c\u6574");
        }
        byte[] srckey = null;
        byte[] src = null;
        Mechanism encMech = info.getEncMech();
        byte[] encKey = info.getKey();
        srckey = this.session.decrypt(encMech, rec.getPriKey(), encKey);
        if (srckey == null) {
            throw new PKIException("8216", "\u53c2\u6570\u4e0d\u5b8c\u6574");
        }
        JKey sysKey = null;
        if (this.session.getCfgTagName().equals("JSOFT_LIB")) {
            Mechanism keyMech = ((JSoftLib)this.session).encMech2genMech(mech);
            sysKey = new JKey(keyMech.getMechanismType(), srckey);
        } else {
            sysKey = new JKey("SYMMETRY", srckey);
        }
        src = this.session.decrypt(mech, sysKey, param.GetEncedData());
        info.setOutKey(sysKey);
        info.setOutSrc(src);
        return src;
    }

    public void verifyP7Env_init(p7recCertKey rec, Object iv) throws PKIException {
        this.envContext = new EnvContext();
        this.envContext.buffer = new Buffer();
        this.envContext.rec = new p7recCertKey[1];
        ((EnvContext)this.envContext).rec[0] = rec;
        this.envContext.iv = iv;
    }

    public void verifyP7Env_init(p7recCertKey[] rec, Object iv) throws PKIException {
        this.envContext = new EnvContext();
        this.envContext.buffer = new Buffer();
        this.envContext.rec = rec;
        this.envContext.iv = iv;
    }

    private void verifyP7Env_init_update(p7recInfo[] infos, p7recCertKey[] recs, Object iv) throws PKIException {
        P7Param param = this.GetP7Cnt();
        if (param == null) {
            throw new PKIException("8216", "\u53c2\u6570\u4e0d\u5b8c\u6574");
        }
        Mechanism mech = param.GetEncMech();
        if (mech.getParam() == null && iv != null) {
            mech.setParam(iv);
        }
        JKey sysKey = null;
        int i = 0;
        while (i < recs.length) {
            p7recCertKey rec = recs[i];
            p7recInfo info = this.getRec(rec, param.GetRecInfos());
            if (info == null) {
                throw new PKIException("8216", "\u53c2\u6570\u4e0d\u5b8c\u6574");
            }
            byte[] srckey = null;
            Mechanism encMech = info.getEncMech();
            byte[] encKey = info.getKey();
            srckey = this.session.decrypt(encMech, rec.getPriKey(), encKey);
            if (srckey == null) {
                throw new PKIException("8216", "\u53c2\u6570\u4e0d\u5b8c\u6574");
            }
            if (this.session.getCfgTagName().equals("JSOFT_LIB")) {
                Mechanism keyMech = ((JSoftLib)this.session).encMech2genMech(mech);
                sysKey = new JKey(keyMech.getMechanismType(), srckey);
            } else {
                sysKey = new JKey("SYMMETRY", srckey);
            }
            info.setOutKey(sysKey);
            ++i;
        }
        this.envContext.handle = this.session.decryptInit(mech, sysKey);
    }

    private int loadEnvheader(InputStream ins) throws PKIException {
        try {
            int readLen = this.readAsn1Hder(ins, true, 48);
            DERObjectIdentifier typeOid = (DERObjectIdentifier)this.readObj(ins, true, 6);
            int nType = this.GetType(typeOid);
            readLen = this.readAsn1Hder(ins, true, 160);
            readLen = this.readAsn1Hder(ins, true, 48);
            DERObject obj = this.readObj(ins, true, 2);
            if (obj == null) {
                throw new PKIException("8211", "\u8f7d\u5165P7\u5bf9\u8c61\u9519\u8befunkown p7 type");
            }
            this.p7cnt = new P7Param();
            DERSet infos = (DERSet)this.readObj(ins, true, 49);
            if (infos == null) {
                throw new PKIException("8211", "\u8f7d\u5165P7\u5bf9\u8c61\u9519\u8bef");
            }
            p7recInfo[] recInfos = this.parserRecInfos(infos);
            this.p7cnt.SetRecInfos(recInfos);
            int tmplen = this.readAsn1Hder(ins, true, 48);
            DERObject type = this.readObj(ins, true, 6);
            AlgorithmIdentifier algo = AlgorithmIdentifier.getInstance(this.readObj(ins, true, 48));
            this.p7cnt.SetEncMech(this.GetEncMech(algo));
            tmplen = this.readAsn1Hder(ins, true, 128);
            int i = 0;
            boolean len = false;
            byte[] buffer = new byte[1024];
            try {
                while ((i = ins.read(buffer)) > 0) {
                    if (i < 1024) {
                        this.envContext.buffer.put(buffer, 0, i);
                        continue;
                    }
                    this.envContext.buffer.put(buffer);
                }
            }
            catch (Exception e) {
                throw new PKIException("8211", "\u8f7d\u5165P7\u5bf9\u8c61\u9519\u8bef read InputStream Exception");
            }
            return nType;
        }
        catch (Exception ex) {
            throw new PKIException("8211", "\u8f7d\u5165P7\u5bf9\u8c61\u9519\u8bef", ex);
        }
    }

    public byte[] verifyP7Env_update(byte[] data) throws PKIException, IOException {
        if (!this.envContext.status) {
            this.envContext.buffer.put(data);
            if (this.envContext.buffer.size() >= 1024) {
                ByteArrayInputStream bis = this.envContext.buffer.getStream();
                this.envContext.buffer.clear();
                this.loadEnvheader(bis);
                this.envContext.status = true;
                P7Param param = this.GetP7Cnt();
                if (param == null) {
                    throw new PKIException("8216", "\u53c2\u6570\u4e0d\u5b8c\u6574");
                }
                this.verifyP7Env_init_update(param.GetRecInfos(), this.envContext.rec, this.envContext.iv);
                data = this.envContext.buffer.getBlock();
                if (data != null) {
                    return this.session.decryptUpdate(this.envContext.handle, param.GetEncMech(), data);
                }
                return null;
            }
            return null;
        }
        this.envContext.buffer.put(data);
        data = this.envContext.buffer.getBlock();
        if (data != null) {
            P7Param param = this.GetP7Cnt();
            if (param == null) {
                throw new PKIException("8216", "\u53c2\u6570\u4e0d\u5b8c\u6574");
            }
            return this.session.decryptUpdate(this.envContext.handle, param.GetEncMech(), data);
        }
        return null;
    }

    public byte[] verifyP7Env_final(byte[] data) throws PKIException {
        this.envContext.buffer.put(data);
        if (!this.envContext.status) {
            ByteArrayInputStream bis = this.envContext.buffer.getStream();
            this.envContext.buffer.clear();
            this.loadEnvheader(bis);
            this.envContext.status = true;
            P7Param param = this.GetP7Cnt();
            if (param == null) {
                throw new PKIException("8216", "\u53c2\u6570\u4e0d\u5b8c\u6574");
            }
            this.verifyP7Env_init_update(param.GetRecInfos(), this.envContext.rec, this.envContext.iv);
        }
        data = this.envContext.buffer.getAll();
        P7Param param = this.GetP7Cnt();
        if (param == null) {
            throw new PKIException("8216", "\u53c2\u6570\u4e0d\u5b8c\u6574");
        }
        return this.session.decryptFinal(this.envContext.handle, param.GetEncMech(), data);
    }

    public long verifyP7Env_os(p7recInfo info, p7recCertKey rec, Object iv, InputStream enc, OutputStream dec) throws PKIException {
        P7Param param = this.GetP7Cnt();
        if (param == null) {
            throw new PKIException("8216", "\u53c2\u6570\u4e0d\u5b8c\u6574");
        }
        Mechanism mech = param.GetEncMech();
        if (mech.getParam() == null && iv != null) {
            mech.setParam(iv);
        }
        String recIss = rec.getCert().getIssuer();
        String recSn = rec.getCert().getSerialNumber().toString(16);
        if (!recIss.equals(info.getIssuer()) && !recSn.equals(info.getSn())) {
            throw new PKIException("8216", "\u53c2\u6570\u4e0d\u5b8c\u6574");
        }
        byte[] srckey = null;
        Mechanism encMech = info.getEncMech();
        byte[] encKey = info.getKey();
        srckey = this.session.decrypt(encMech, rec.getPriKey(), encKey);
        if (srckey == null) {
            throw new PKIException("8216", "\u53c2\u6570\u4e0d\u5b8c\u6574");
        }
        JKey sysKey = null;
        if (this.session.getCfgTagName().equals("JSOFT_LIB")) {
            Mechanism keyMech = ((JSoftLib)this.session).encMech2genMech(mech);
            sysKey = new JKey(keyMech.getMechanismType(), srckey);
        } else {
            sysKey = new JKey("SYMMETRY", srckey);
        }
        long decLen = this.session.decrypt(mech, sysKey, enc, dec);
        info.setOutKey(sysKey);
        return decLen;
    }

    public byte[] verifyP7Env(p7recCertKey[] recs, Object iv) throws PKIException {
        return this.verifyP7Env(recs, true, iv);
    }

    public byte[] verifyP7Env(p7recCertKey[] recs, boolean isPad, Object iv) throws PKIException {
        P7Param param = this.GetP7Cnt();
        if (param == null) {
            throw new PKIException("8216", "\u53c2\u6570\u4e0d\u5b8c\u6574");
        }
        if (param.GetEncedData() == null) {
            throw new PKIException("8216", "\u53c2\u6570\u4e0d\u5b8c\u6574");
        }
        Mechanism mech = param.GetEncMech();
        mech.setPad(isPad);
        if (mech.getParam() == null && iv != null) {
            mech.setParam(iv);
        }
        p7recInfo[] infos = param.GetRecInfos();
        byte[] srckey = null;
        byte[] src = null;
        int i = 0;
        while (i < recs.length) {
            p7recInfo tmp = this.getRec(recs[i], infos);
            if (tmp == null) {
                throw new PKIException("8216", "\u53c2\u6570\u4e0d\u5b8c\u6574");
            }
            Mechanism encMech = tmp.getEncMech();
            byte[] encKey = tmp.getKey();
            srckey = this.session.decrypt(encMech, recs[i].getPriKey(), encKey);
            if (srckey == null) {
                throw new PKIException("8216", "\u53c2\u6570\u4e0d\u5b8c\u6574");
            }
            JKey sysKey = null;
            if (this.session.getCfgTagName().equals("JSOFT_LIB")) {
                Mechanism keyMech = ((JSoftLib)this.session).encMech2genMech(mech);
                sysKey = new JKey(keyMech.getMechanismType(), srckey);
            } else {
                sysKey = new JKey("SYMMETRY", srckey);
            }
            src = this.session.decrypt(mech, sysKey, param.GetEncedData());
            if (src == null) {
                return src;
            }
            tmp.setOutKey(sysKey);
            tmp.setOutSrc(src);
            ++i;
        }
        return src;
    }

    public byte[] verifyP7SignEnv(p7recCertKey[] recs, boolean isPad, Object iv) throws PKIException {
        X509Cert[] certs = new X509Cert[recs.length];
        int i = 0;
        while (i < recs.length) {
            certs[i] = recs[i].getCert();
            ++i;
        }
        byte[] dec = this.verifyP7Env(recs, isPad, iv);
        if (dec == null) {
            return null;
        }
        boolean rv = this.verifyP7Sign(dec, certs);
        if (!rv) {
            return null;
        }
        return dec;
    }

    public byte[] verifyP7Enc(byte[] src, JKey key, Object iv) throws PKIException {
        byte[] dec = null;
        P7Param param = this.GetP7Cnt();
        if (param == null) {
            throw new PKIException("8216", "\u53c2\u6570\u4e0d\u5b8c\u6574");
        }
        byte[] enc = param.GetEncedData();
        Mechanism mech = param.GetEncMech();
        if (mech.getParam() == null && iv != null) {
            mech.setParam(iv);
        }
        dec = this.session.decrypt(mech, key, enc);
        return dec;
    }

    private int GetType(DERObjectIdentifier cntType) throws PKIException {
        if (cntType == null) {
            throw new PKIException("8212", "\u89e3\u6790P7\u5931\u8d25");
        }
        if (cntType == null) {
            throw new PKIException("8212", "\u89e3\u6790P7\u5931\u8d25");
        }
        if (cntType.equals(PKCSObjectIdentifiers.data) || cntType.equals(PKCSObjectIdentifiers.gm_PKCS7_data)) {
            return 1;
        }
        if (cntType.equals(PKCSObjectIdentifiers.signedData) || cntType.equals(PKCSObjectIdentifiers.gm_PKCS7_signedData)) {
            return 2;
        }
        if (cntType.equals(PKCSObjectIdentifiers.envelopedData) || cntType.equals(PKCSObjectIdentifiers.gm_PKCS7_envelopedData)) {
            return 3;
        }
        if (cntType.equals(PKCSObjectIdentifiers.signedAndEnvelopedData) || cntType.equals(PKCSObjectIdentifiers.gm_PKCS7_signedAndEnvelopedData)) {
            return 4;
        }
        if (cntType.equals(PKCSObjectIdentifiers.digestedData)) {
            return 5;
        }
        if (cntType.equals(PKCSObjectIdentifiers.encryptedData) || cntType.equals(PKCSObjectIdentifiers.gm_PKCS7_encryptedData)) {
            return 6;
        }
        return 0;
    }

    private int GetType(ContentInfo info) throws PKIException {
        if (info == null) {
            throw new PKIException("8212", "\u89e3\u6790P7\u5931\u8d25");
        }
        DERObjectIdentifier cntType = info.getContentType();
        return this.GetType(cntType);
    }

    private ContentInfo GetCnt(DERObjectIdentifier type, byte[] data) throws PKIException {
        DEROctetString cnt = null;
        if (data != null) {
            cnt = new DEROctetString(data);
        }
        return new ContentInfo(type, cnt);
    }

    private ContentInfo GetCnt(DERObjectIdentifier type, DEREncodable data) throws PKIException {
        return new ContentInfo(type, data);
    }

    public DERObjectIdentifier Sign2DigOid(Mechanism signMech) throws PKIException {
        if (signMech == null) {
            return null;
        }
        String mech = signMech.getMechanismType().toString();
        if (mech.equals("SHA1withRSAEncryption") || mech.equals("SHA1withDSA") || mech.equals("SHA1withECDSA")) {
            return PKCSObjectIdentifiers.sha1;
        }
        if (mech.equals("SHA224withRSAEncryption") || mech.equals("SHA224withDSA") || mech.equals("SHA224withECDSA")) {
            return PKCSObjectIdentifiers.sha224;
        }
        if (mech.equals("SHA256withRSAEncryption") || mech.equals("SHA256withDSA") || mech.equals("SHA256withECDSA")) {
            return PKCSObjectIdentifiers.sha256;
        }
        if (mech.equals("SHA384withRSAEncryption")) {
            return PKCSObjectIdentifiers.sha384;
        }
        if (mech.equals("SHA512withRSAEncryption")) {
            return PKCSObjectIdentifiers.sha512;
        }
        if (mech.equals("MD2withRSAEncryption")) {
            return PKCSObjectIdentifiers.md2;
        }
        if (mech.equals("MD5withRSAEncryption")) {
            return PKCSObjectIdentifiers.md5;
        }
        if (mech.equals("SM3withSM2Encryption")) {
            return PKCSObjectIdentifiers.SM3;
        }
        throw new PKIException("8215", "\u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mech);
    }

    public DERObjectIdentifier GetDigOid(Mechanism digMech) throws PKIException {
        if (digMech == null) {
            return null;
        }
        if (digMech.getMechanismType().equals("MD2")) {
            return PKCSObjectIdentifiers.md2;
        }
        if (digMech.getMechanismType().equals("MD5")) {
            return PKCSObjectIdentifiers.md5;
        }
        if (digMech.getMechanismType().equals("SM3")) {
            return PKCSObjectIdentifiers.SM3;
        }
        if (digMech.getMechanismType().equals("SHA1")) {
            return PKCSObjectIdentifiers.sha1;
        }
        if (digMech.getMechanismType().equals("SHA224")) {
            return PKCSObjectIdentifiers.sha224;
        }
        if (digMech.getMechanismType().equals("SHA256")) {
            return PKCSObjectIdentifiers.sha256;
        }
        if (digMech.getMechanismType().equals("SHA384")) {
            return PKCSObjectIdentifiers.sha384;
        }
        throw new PKIException("2", "\u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + digMech);
    }

    private DERObjectIdentifier GetEncOid(Mechanism EncMech) throws PKIException {
        if (EncMech == null) {
            return null;
        }
        String mech = EncMech.getMechanismType().toString();
        if (mech.equals("RSA/ECB/PKCS1PADDING")) {
            return PKCSObjectIdentifiers.rsaEncryption;
        }
        if (mech.equals("SM2_RAW")) {
            return PKCSObjectIdentifiers.SM2_ENC;
        }
        if (mech.equals("DESede/ECB/PKCS7Padding")) {
            return PKCSObjectIdentifiers.des3Encryption;
        }
        if (mech.equals("DESede/CBC/PKCS7Padding")) {
            return PKCSObjectIdentifiers.des3CBCEncryption;
        }
        if (mech.equals("DES/CBC/PKCS7Padding")) {
            return PKCSObjectIdentifiers.desCBCEncryption;
        }
        if (mech.equals("DES/ECB/PKCS7Padding")) {
            return PKCSObjectIdentifiers.desEncryption;
        }
        if (mech.equals("SCB2_ECB")) {
            return PKCSObjectIdentifiers.scb2Encryption;
        }
        if (mech.equals("RC2/CBC/PKCS7Padding")) {
            return PKCSObjectIdentifiers.rc2CBCEncryption;
        }
        if (mech.equals("RC2/ECB/PKCS7Padding")) {
            return PKCSObjectIdentifiers.rc2Encryption;
        }
        if (mech.equals("SM4_ECB")) {
            return PKCSObjectIdentifiers.gm_SM4_ECB;
        }
        if (mech.equals("SF33_CBC")) {
            return PKCSObjectIdentifiers.gm_SSF33_CBC;
        }
        if (mech.equals("SF33_ECB")) {
            return PKCSObjectIdentifiers.gm_SSF33_ECB;
        }
        throw new PKIException("8215", "\u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mech);
    }

    private DERObjectIdentifier Sign2EncOid(Mechanism signMech) throws PKIException {
        String mech = signMech.getMechanismType().toString();
        if (mech.equals("SHA1withRSAEncryption") || mech.equals("SHA224withRSAEncryption") || mech.equals("SHA256withRSAEncryption") || mech.equals("SHA384withRSAEncryption") || mech.equals("SHA512withRSAEncryption") || mech.equals("MD2withRSAEncryption") || mech.equals("MD5withRSAEncryption")) {
            return PKCSObjectIdentifiers.rsaEncryption;
        }
        if (mech.equals("SM3withSM2Encryption")) {
            return PKCSObjectIdentifiers.SM2_SIGN;
        }
        throw new PKIException("8215", "\u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mech);
    }

    private IssuerAndSerialNumber GetIssuerSN(X509Cert cert) throws PKIException {
        if (cert == null) {
            return null;
        }
        IssuerAndSerialNumber issuerSN = null;
        X509CertificateStructure x509cert = cert.getCertStructure();
        issuerSN = new IssuerAndSerialNumber(x509cert.getIssuer(), x509cert.getSerialNumber());
        return issuerSN;
    }

    private IssuerAndSerialNumber GetIssuerSN(p7CertInfo info) throws PKIException {
        if (info == null) {
            return null;
        }
        if (info.getCert() != null) {
            return this.GetIssuerSN(info.getCert());
        }
        IssuerAndSerialNumber issuerSN = null;
        X509Name issuer = new X509Name(info.getIssuer());
        BigInteger seriaNumber = new BigInteger(info.getSerialNumber(), 16);
        issuerSN = new IssuerAndSerialNumber(issuer, seriaNumber);
        return issuerSN;
    }

    private SignerInfo GetSignerInfoWithSM2(P7Param param, byte[] signData) throws PKIException {
        return this.GetSignerInfo(new SM2ProxyP7Param(param, signData.length), signData);
    }

    private SignerInfo GetSignerInfo(P7Param param, byte[] signData) throws PKIException {
        DERInteger ver = new DERInteger(1);
        DERObjectIdentifier digMech = this.Sign2DigOid(param.GetSignMech());
        AlgorithmIdentifier algoDig = new AlgorithmIdentifier(digMech);
        DERObjectIdentifier encMech = this.Sign2EncOid(param.GetSignMech());
        AlgorithmIdentifier algoEnc = new AlgorithmIdentifier(encMech);
        DERObject[] auth = param.GetAuthData();
        DERObject[] unauth = param.GetunAuthData();
        IssuerAndSerialNumber issuerSN = this.GetIssuerSN(param.getSignCertInfos()[0]);
        ASN1EncodableVector vauthData = new ASN1EncodableVector();
        ASN1EncodableVector vunauthData = new ASN1EncodableVector();
        int i = 0;
        while (auth != null && i < auth.length) {
            vauthData.add(auth[i]);
            ++i;
        }
        i = 0;
        while (unauth != null && i < unauth.length) {
            vunauthData.add(unauth[i]);
            ++i;
        }
        DERSet authDatas = null;
        if (auth != null) {
            authDatas = new DERSet(vauthData);
        }
        DERSet unauthDatas = null;
        if (unauth != null) {
            unauthDatas = new DERSet(vunauthData);
        }
        DEROctetString sign = new DEROctetString(signData);
        SignerInfo info = new SignerInfo(ver, issuerSN, algoDig, authDatas, algoEnc, sign, unauthDatas);
        return info;
    }

    private EncryptedContentInfo GetEncedCntInfo(byte[] encedData, Mechanism mech) throws PKIException {
        CBCParam cbc = (CBCParam)mech.getParam();
        DEROctetString param = null;
        AlgorithmIdentifier algoEnc = null;
        if (cbc == null) {
            algoEnc = new AlgorithmIdentifier(this.GetEncOid(mech));
        } else {
            param = new DEROctetString(cbc.getIv());
            algoEnc = new AlgorithmIdentifier(this.GetEncOid(mech), param);
        }
        DEROctetString cnt = null;
        if (encedData != null) {
            cnt = new DEROctetString(encedData);
        }
        EncryptedContentInfo encedCntInfo = new EncryptedContentInfo(this.GetTypeOid(1), algoEnc, cnt);
        return encedCntInfo;
    }

    private RecipientInfo GetRecInfo(X509Cert cert, Mechanism mech, byte[] encedKey) throws PKIException {
        AlgorithmIdentifier algo = new AlgorithmIdentifier(this.GetEncOid(mech));
        IssuerAndSerialNumber issuerSN = this.GetIssuerSN(cert);
        DERInteger ver = new DERInteger(0);
        DEROctetString key = new DEROctetString(encedKey);
        RecipientInfo info = new RecipientInfo(ver, issuerSN, algo, key);
        return info;
    }

    private RecipientInfo GetRecInfo(p7CertInfo certInfo, Mechanism mech, byte[] encedKey) throws PKIException {
        AlgorithmIdentifier algo = new AlgorithmIdentifier(this.GetEncOid(mech));
        IssuerAndSerialNumber issuerSN = certInfo.getCert() != null ? this.GetIssuerSN(certInfo.getCert()) : this.GetIssuerSN(certInfo);
        DERInteger ver = new DERInteger(0);
        DEROctetString key = new DEROctetString(encedKey);
        RecipientInfo info = new RecipientInfo(ver, issuerSN, algo, key);
        return info;
    }

    private int ParserCnt(ContentInfo info) throws PKIException {
        DEROctetString oct = null;
        this.p7cnt = new P7Param();
        p7recInfo[] recInfos = null;
        p7encInfo encInfo = null;
        int nType = this.GetType(info);
        switch (nType) {
            case 1: {
                oct = (DEROctetString)info.getContent();
                if (oct == null) {
                    throw new PKIException("8212", "\u89e3\u6790P7\u5931\u8d25");
                }
                this.data = oct.getOctets();
                this.p7cnt.SetSource(this.data);
                break;
            }
            case 2: {
                SignedData signData = SignedData.getInstance(info.getContent());
                if (signData.getContentInfo().getContent() != null) {
                    DERObjectIdentifier cntType = signData.getContentInfo().getContentType();
                    if (cntType.equals(PKCSObjectIdentifiers.id_ct_TSTInfo)) {
                        this.p7cnt.setTstInfo(TSTInfo.getInstance(signData.getContentInfo().getContent()));
                    } else {
                        this.p7cnt.SetSource(((ASN1OctetString)signData.getContentInfo().getContent()).getOctets());
                    }
                }
                this.p7cnt.SetSignCerts(this.GetCerts(signData.getCertificates()));
                if (this.GetCrls(signData.getCRLs()) != null) {
                    this.p7cnt.SetCrls(this.GetCrls(signData.getCRLs()));
                }
                this.p7cnt.SetSignInfos(this.parserSignInfos(signData.getSignerInfos()));
                break;
            }
            case 3: {
                EnvelopedData envData = EnvelopedData.getInstance(info.getContent());
                encInfo = this.parserEncedInfo(envData.getEncryptedContentInfo());
                this.p7cnt.SetEncedData(encInfo.getEncData());
                this.p7cnt.SetEncMech(encInfo.getEncMech());
                recInfos = this.parserRecInfos(envData.getRecipientInfos());
                this.p7cnt.SetRecInfos(recInfos);
                break;
            }
            case 4: {
                SignedAndEnvelopedData senvData = SignedAndEnvelopedData.getInstance(info.getContent());
                this.p7cnt.SetSignCerts(this.GetCerts(senvData.getCertificates()));
                if (this.GetCrls(senvData.getCrls()) != null) {
                    this.p7cnt.SetCrls(this.GetCrls(senvData.getCrls()));
                }
                this.p7cnt.SetSignInfos(this.parserSignInfos(senvData.getSignerInfos()));
                encInfo = this.parserEncedInfo(senvData.getEncryptedContentInfo());
                this.p7cnt.SetEncedData(encInfo.getEncData());
                this.p7cnt.SetEncMech(encInfo.getEncMech());
                recInfos = this.parserRecInfos(senvData.getRecipientInfos());
                this.p7cnt.SetRecInfos(recInfos);
                break;
            }
            case 5: {
                DigestedData digData = DigestedData.getInstance(info.getContent());
                this.p7cnt.SetSource(((ASN1OctetString)digData.getContentInfo().getContent()).getOctets());
                p7digInfo dinfo = new p7digInfo(digData.getDigest().getOctets(), this.GetDigMech(digData.getDigestAlgorithm()));
                this.p7cnt.SetDigInfo(dinfo);
                break;
            }
            case 6: {
                EncryptedData encData = EncryptedData.getInstance(info.getContent());
                encInfo = this.parserEncedInfo(encData.getEncryptedContentInfo());
                this.p7cnt.SetEncedData(encInfo.getEncData());
                this.p7cnt.SetEncMech(encInfo.getEncMech());
                break;
            }
            default: {
                throw new PKIException("8211", "\u8f7d\u5165P7\u5bf9\u8c61\u9519\u8bef\u65e0\u6548\u7684p7\u7c7b\u578b");
            }
        }
        return nType;
    }

    private X509Cert[] GetCerts(ASN1Set derSet) throws PKIException {
        if (derSet == null) {
            return null;
        }
        DERSet set = (DERSet)derSet;
        X509Cert[] certs = new X509Cert[set.size()];
        int i = 0;
        while (i < set.size()) {
            certs[i] = new X509Cert(X509CertificateStructure.getInstance(set.getObjectAt(i)));
            ++i;
        }
        return certs;
    }

    private X509CRL[] GetCrls(ASN1Set derSet) {
        if (derSet == null) {
            return null;
        }
        DERSet set = (DERSet)derSet;
        X509CRL[] crls = new X509CRL[set.size()];
        int i = 0;
        while (i < set.size()) {
            crls[i] = new X509CRL(CertificateList.getInstance(set.getObjectAt(i)));
            ++i;
        }
        return crls;
    }

    private String GetSignMech(AlgorithmIdentifier dig, AlgorithmIdentifier enc) throws PKIException {
        if (dig == null || enc == null) {
            return null;
        }
        String strDig = dig.getObjectId().getId();
        String strEnc = enc.getObjectId().getId();
        if (strEnc.equals(PKCSObjectIdentifiers.rsaEncryption.getId())) {
            if (strDig.equals(PKCSObjectIdentifiers.sha1.getId())) {
                return "SHA1withRSAEncryption";
            }
            if (strDig.equals(PKCSObjectIdentifiers.sha224.getId())) {
                return "SHA224withRSAEncryption";
            }
            if (strDig.equals(PKCSObjectIdentifiers.sha256.getId())) {
                return "SHA256withRSAEncryption";
            }
            if (strDig.equals(PKCSObjectIdentifiers.sha384.getId())) {
                return "SHA384withRSAEncryption";
            }
            if (strDig.equals(PKCSObjectIdentifiers.sha512.getId())) {
                return "SHA512withRSAEncryption";
            }
            if (strDig.equals(PKCSObjectIdentifiers.md2.getId())) {
                return "MD2withRSAEncryption";
            }
            if (strDig.equals(PKCSObjectIdentifiers.md5.getId())) {
                return "MD5withRSAEncryption";
            }
            throw new PKIException("8212", "\u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b");
        }
        if (strEnc.equals(PKCSObjectIdentifiers.SM2_SIGN.getId())) {
            if (strDig.equals(PKCSObjectIdentifiers.SM3.getId())) {
                return "SM3withSM2Encryption";
            }
            throw new PKIException("8212", "\u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b");
        }
        throw new PKIException("8212", "\u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b");
    }

    private String GetDigMech(AlgorithmIdentifier dig) throws PKIException {
        if (dig == null) {
            return null;
        }
        String strDig = dig.getObjectId().getId();
        if (strDig.equals(PKCSObjectIdentifiers.sha1.getId())) {
            return "SHA1";
        }
        if (strDig.equals(PKCSObjectIdentifiers.sha224.getId())) {
            return "SHA224";
        }
        if (strDig.equals(PKCSObjectIdentifiers.sha256.getId())) {
            return "SHA256";
        }
        if (strDig.equals(PKCSObjectIdentifiers.sha384.getId())) {
            return "SHA384";
        }
        if (strDig.equals(PKCSObjectIdentifiers.sha512.getId())) {
            return "SHA512";
        }
        if (strDig.equals(PKCSObjectIdentifiers.SM3.getId())) {
            return "SM3";
        }
        if (strDig.equals(PKCSObjectIdentifiers.md2.getId())) {
            return "MD2";
        }
        if (strDig.equals(PKCSObjectIdentifiers.md5.getId())) {
            return "MD5";
        }
        throw new PKIException("8212", "\u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b");
    }

    private p7signInfo[] parserSignInfos(ASN1Set derSet) throws PKIException {
        DERSet set = (DERSet)derSet;
        p7signInfo[] infos = new p7signInfo[set.size()];
        int i = 0;
        while (i < set.size()) {
            SignerInfo info = SignerInfo.getInstance(set.getObjectAt(i));
            if (info == null) {
                throw new PKIException("8212", "\u89e3\u6790P7\u5931\u8d25");
            }
            infos[i] = new p7signInfo();
            infos[i].setSignature(info.getEncryptedDigest().getOctets());
            AlgorithmIdentifier dig = info.getDigestAlgorithm();
            AlgorithmIdentifier enc = info.getDigestEncryptionAlgorithm();
            IssuerAndSerialNumber iSN = info.getIssuerAndSerialNumber();
            if (this.GetSignMech(dig, enc) == null || iSN.getName() == null || iSN.getCertificateSerialNumber() == null) {
                throw new PKIException("8212", "\u89e3\u6790P7\u5931\u8d25");
            }
            infos[i].setSignMech(this.GetSignMech(dig, enc));
            infos[i].setIssuer(iSN.getName().toString());
            infos[i].setSn(iSN.getCertificateSerialNumber().getValue().toString(16));
            infos[i].setAuths(this.get_Set2DERObject(info.getAuthenticatedAttributes()));
            infos[i].setUnauths(this.get_Set2DERObject(info.getUnauthenticatedAttributes()));
            ++i;
        }
        return infos;
    }

    private DERObject[] get_Set2DERObject(ASN1Set setData) throws PKIException {
        if (setData == null) {
            return null;
        }
        int lens = setData.size();
        DERObject[] data = new DERObject[lens];
        int i = 0;
        while (i < lens) {
            data[i] = (DERObject)setData.getObjectAt(i);
            ++i;
        }
        return data;
    }

    private Mechanism GetEncMech(AlgorithmIdentifier enc) throws PKIException {
        if (enc == null) {
            return null;
        }
        String strEnc = enc.getObjectId().getId();
        byte[] iv = null;
        CBCParam param = new CBCParam();
        DERNull dernull = new DERNull();
        if (enc.getParameters() != null && !dernull.equals(enc.getParameters())) {
            DEROctetString obj = (DEROctetString)enc.getParameters();
            iv = obj.getOctets();
            param.setIv(iv);
        }
        Mechanism mech = null;
        if (strEnc.equals(PKCSObjectIdentifiers.des3Encryption.getId())) {
            mech = new Mechanism("DESede/ECB/PKCS7Padding");
            return mech;
        }
        if (strEnc.equals(PKCSObjectIdentifiers.des3CBCEncryption.getId())) {
            mech = new Mechanism("DESede/CBC/PKCS7Padding", param);
            return mech;
        }
        if (strEnc.equals(PKCSObjectIdentifiers.desEncryption.getId())) {
            mech = new Mechanism("DES/ECB/PKCS7Padding");
            return mech;
        }
        if (strEnc.equals(PKCSObjectIdentifiers.desCBCEncryption.getId())) {
            mech = new Mechanism("DESede/CBC/PKCS7Padding", param);
            return mech;
        }
        if (strEnc.equals(PKCSObjectIdentifiers.scb2Encryption.getId())) {
            mech = new Mechanism("SCB2_ECB");
            return mech;
        }
        if (strEnc.equals(PKCSObjectIdentifiers.SM2_ENC.getId())) {
            mech = new Mechanism("SM2_RAW");
            return mech;
        }
        if (strEnc.equals(PKCSObjectIdentifiers.rsaEncryption.getId())) {
            mech = new Mechanism("RSA/ECB/PKCS1PADDING");
            return mech;
        }
        if (strEnc.equals(PKCSObjectIdentifiers.gm_SM4_ECB.getId())) {
            mech = new Mechanism("SM4_ECB");
            return mech;
        }
        if (strEnc.equals(PKCSObjectIdentifiers.gm_SSF33_ECB.getId())) {
            mech = new Mechanism("SF33_ECB");
            return mech;
        }
        if (strEnc.equals(PKCSObjectIdentifiers.gm_SSF33_CBC.getId())) {
            mech = new Mechanism("SF33_CBC");
            return mech;
        }
        throw new PKIException("8212", "\u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b");
    }

    private p7encInfo parserEncedInfo(EncryptedContentInfo info) throws PKIException {
        ArrayList ls = new ArrayList();
        p7encInfo encInfo = new p7encInfo();
        encInfo.setEncData(info.getEncryptedContent().getOctets());
        encInfo.setEncMech(this.GetEncMech(info.getContentEncryptionAlgorithm()));
        return encInfo;
    }

    private p7recInfo[] parserRecInfos(ASN1Set derSet) throws PKIException {
        DERSet set = (DERSet)derSet;
        p7recInfo[] recs = new p7recInfo[set.size()];
        int i = 0;
        while (i < set.size()) {
            RecipientInfo info = RecipientInfo.getInstance(set.getObjectAt(i));
            if (info == null) {
                throw new PKIException("8212", "\u89e3\u6790P7\u5931\u8d25");
            }
            recs[i] = new p7recInfo();
            recs[i].setKey(info.getEncryptedKey().getOctets());
            recs[i].setEncMech(this.GetEncMech(info.getKeyEncryptionAlgorithm()));
            IssuerAndSerialNumber iSN = info.getIssuerAndSerialNumber();
            if (iSN.getName() == null || iSN.getCertificateSerialNumber() == null) {
                throw new PKIException("8212", "\u89e3\u6790P7\u5931\u8d25");
            }
            recs[i].setIssuer(iSN.getName().toString());
            recs[i].setSn(iSN.getCertificateSerialNumber().getValue().toString(16));
            ++i;
        }
        return recs;
    }

    private p7recInfo getRec(p7recCertKey recs, p7recInfo[] infos) throws PKIException {
        String recIss = recs.getCert().getIssuer();
        String recSn = recs.getCert().getSerialNumber().toString(16);
        int i = 0;
        while (i < infos.length) {
            String issuer = infos[i].getIssuer();
            String sn = infos[i].getSn();
            if (recIss.equals(issuer) && recSn.equals(sn)) {
                return infos[i];
            }
            ++i;
        }
        return null;
    }

    private byte[] getAsn1LenData(int len) throws PKIException {
        byte[] rv = null;
        if (len > 127) {
            int size = 1;
            int pos = 1;
            int val = len;
            while ((val >>>= 8) != 0) {
                ++size;
            }
            rv = new byte[size + 1];
            rv[0] = (byte)(size | 0x80);
            int i = (size - 1) * 8;
            while (i >= 0) {
                rv[pos++] = (byte)(len >> i);
                i -= 8;
            }
        } else {
            rv = new byte[]{(byte)len};
        }
        return rv;
    }

    private int readAsn1Len(InputStream ins) throws PKIException {
        byte[] tag = new byte[1];
        try {
            int readLen = ins.read(tag);
            if (1 != readLen) {
                throw new PKIException("8211", "\u8f7d\u5165P7\u5bf9\u8c61\u9519\u8befunkown p7 type");
            }
            byte len = tag[0];
            if (len < 128 && len > 0) {
                return len;
            }
            int size = tag[0] & 0x7F;
            byte[] data = new byte[size];
            int lens = 0;
            int i = 0;
            while (i < size) {
                int tmp = ins.read();
                lens = (lens << 8) + tmp;
                ++i;
            }
            return lens;
        }
        catch (Exception e) {
            throw new PKIException("8211", "\u8f7d\u5165P7\u5bf9\u8c61\u9519\u8befunkown p7 type");
        }
    }

    private int readAsn1Hder(InputStream ins, boolean isVerifyType, int ans1Type) throws PKIException {
        byte[] type = new byte[1];
        int readLen = 0;
        int len = 0;
        try {
            readLen = ins.read(type);
            if (1 != readLen || isVerifyType && (byte)ans1Type != type[0]) {
                throw new PKIException("8211", "\u8f7d\u5165P7\u5bf9\u8c61\u9519\u8befunkown p7 type");
            }
            len = this.readAsn1Len(ins);
            if (len < 1) {
                throw new PKIException("8211", "\u8f7d\u5165P7\u5bf9\u8c61\u9519\u8befunkown p7 type");
            }
        }
        catch (Exception e) {
            throw new PKIException("8211", "\u8f7d\u5165P7\u5bf9\u8c61\u9519\u8bef read p7 InputStream exception");
        }
        return len;
    }

    private Asn1Hder readAsn1Hder(InputStream ins) throws PKIException {
        byte[] type = new byte[1];
        int readLen = 0;
        int len = 0;
        try {
            readLen = ins.read(type);
            if (1 != readLen) {
                throw new PKIException("8211", "\u8f7d\u5165P7\u5bf9\u8c61\u9519\u8befunkown p7 type");
            }
            len = this.readAsn1Len(ins);
            if (len < 1) {
                throw new PKIException("8211", "\u8f7d\u5165P7\u5bf9\u8c61\u9519\u8befunkown p7 type");
            }
        }
        catch (Exception e) {
            throw new PKIException("8211", "\u8f7d\u5165P7\u5bf9\u8c61\u9519\u8bef read p7 InputStream exception");
        }
        Asn1Hder hder = new Asn1Hder();
        hder.setTag(type[0]);
        hder.setHderLen(len);
        hder.setLenData(this.getAsn1LenData(len));
        return hder;
    }

    private DERObject readObj(InputStream ins, boolean isVerifyType, int ans1Type) throws PKIException {
        int readLen;
        block3: {
            byte[] tag = new byte[1];
            try {
                readLen = this.readAsn1Hder(ins, isVerifyType, ans1Type);
                if (readLen <= 0x300000) break block3;
                return null;
            }
            catch (Exception e) {
                throw new PKIException("8211", "\u8f7d\u5165P7\u5bf9\u8c61\u9519\u8befunkown p7 type");
            }
        }
        byte[] hder = this.getAsn1HeadData(ans1Type, readLen);
        byte[] data = new byte[readLen];
        readLen = ins.read(data);
        byte[] derdata = new byte[hder.length + readLen];
        System.arraycopy(hder, 0, derdata, 0, hder.length);
        System.arraycopy(data, 0, derdata, hder.length, data.length);
        return Parser.writeBytes2DERObj(derdata);
    }

    private DERObject readObj(InputStream ins) throws PKIException {
        Asn1Hder hder;
        block3: {
            try {
                hder = this.readAsn1Hder(ins);
                if (hder.getHderLen() <= 0x300000) break block3;
                return null;
            }
            catch (Exception e) {
                throw new PKIException("8211", "\u8f7d\u5165P7\u5bf9\u8c61\u9519\u8befunkown p7 type");
            }
        }
        byte[] data = new byte[hder.getHderLen()];
        int readLen = ins.read(data);
        byte[] derdata = new byte[1 + hder.getHderLen() + readLen];
        derdata[0] = hder.getTag();
        System.arraycopy(hder.getLenData(), 0, derdata, 1, hder.getLenData().length);
        System.arraycopy(data, 0, derdata, hder.getLenData().length + 1, data.length);
        return Parser.writeBytes2DERObj(derdata);
    }

    private byte[] getAsn1HeadData(int tag, int len) throws PKIException {
        byte[] hd = null;
        byte[] lens = this.getAsn1LenData(len);
        hd = new byte[1 + lens.length];
        hd[0] = (byte)tag;
        System.arraycopy(lens, 0, hd, 1, lens.length);
        return hd;
    }

    private int parse_Env_os(InputStream ins, OutputStream src, OutputStream enc) throws PKIException {
        DERSet infos = (DERSet)this.readObj(ins, true, 49);
        if (infos == null) {
            throw new PKIException("8211", "\u8f7d\u5165P7\u5bf9\u8c61\u9519\u8bef");
        }
        p7recInfo[] recInfos = this.parserRecInfos(infos);
        this.p7cnt.SetRecInfos(recInfos);
        int tmplen = this.readAsn1Hder(ins, true, 48);
        DERObject type = this.readObj(ins, true, 6);
        AlgorithmIdentifier algo = AlgorithmIdentifier.getInstance(this.readObj(ins, true, 48));
        this.p7cnt.SetEncMech(this.GetEncMech(algo));
        tmplen = this.readAsn1Hder(ins, true, 128);
        int i = 0;
        int len = 0;
        byte[] buffer = new byte[1024];
        try {
            while ((i = ins.read(buffer)) > 0) {
                if (i < 1024) {
                    enc.write(buffer, 0, i);
                } else {
                    enc.write(buffer);
                }
                len += i;
            }
            if (tmplen != len) {
                throw new PKIException("8211", "\u8f7d\u5165P7\u5bf9\u8c61\u9519\u8bef EncryptedContent len not equal");
            }
        }
        catch (Exception e) {
            throw new PKIException("8211", "\u8f7d\u5165P7\u5bf9\u8c61\u9519\u8bef read InputStream Exception");
        }
        return len;
    }

    /*
     * Unable to fully structure code
     */
    private int parse_Sign_os(InputStream ins, OutputStream src, OutputStream enc) throws PKIException {
        digAlgos = (DERSet)this.readObj(ins, true, 49);
        if (digAlgos == null) {
            throw new PKIException("8211", "\u8f7d\u5165P7\u5bf9\u8c61\u9519\u8bef");
        }
        hder = this.readAsn1Hder(ins);
        typeOid = (DERObjectIdentifier)this.readObj(ins, true, 6);
        oidlen = Parser.writeDERObj2Bytes(typeOid).length;
        srcLen = 0;
        if (hder.getHderLen() <= oidlen) ** GOTO lbl37
        len = this.readAsn1Hder(ins, true, 160);
        if (len < 3) {
            throw new PKIException("8211", "\u8f7d\u5165P7\u5bf9\u8c61\u9519\u8befsrc len error");
        }
        srcLen = this.readAsn1Hder(ins, true, 4);
        try {
            do {
                buf = null;
                buf = srcLen > 1024 ? new byte[1024] : new byte[srcLen];
                ins.read(buf);
                src.write(buf);
            } while ((srcLen -= buf.length) > 0);
            if (true) ** GOTO lbl37
        }
        catch (Exception ex) {
            throw new PKIException("8211", "\u8f7d\u5165P7\u5bf9\u8c61\u9519\u8befread src");
        }
        {
            block8: do {
                if ((o = this.readObj(ins)) instanceof DERTaggedObject) {
                    tagged = (DERTaggedObject)o;
                    switch (tagged.getTagNo()) {
                        case 0: {
                            this.p7cnt.SetSignCerts(this.GetCerts(ASN1Set.getInstance(tagged, false)));
                            continue block8;
                        }
                        case 1: {
                            this.p7cnt.SetCrls(this.GetCrls(ASN1Set.getInstance(tagged, false)));
                            continue block8;
                        }
                        default: {
                            throw new PKIException("8211", "unknown tag value " + tagged.getTagNo());
                        }
                    }
                }
                this.p7cnt.SetSignInfos(this.parserSignInfos((ASN1Set)o));
lbl37:
                // 5 sources

            } while (ins.available() > 0);
        }
        return 0;
    }

    private long getPaddingLength(Mechanism mech, long len) throws PKIException {
        if (len == 0L) {
            return 0L;
        }
        String mType = mech.getMechanismType();
        long pad = 0L;
        pad = mType.equals("SF33_ECB") || mType.equals("SF33_CBC") || mType.equals("SCB2_ECB") || mType.equals("SCB2_CBC") || mType.equals("AES/ECB/PKCS7Padding") || mType.equals("AES/CBC/PKCS7Padding") || mType.equals("SM4_ECB") || mType.equals("SM4_CBC") ? (0L == len % 16L ? 16L : 16L - len % 16L) : (0L == len % 8L ? 8L : 8L - len % 8L);
        return len + pad;
    }

    public void genP7_SignDetachInit(P7Param[] params) throws PKIException {
        this.signContext = new SignContext();
        this.signContext.handle = new JHandle[params.length];
        int i = 0;
        while (i < params.length) {
            ((SignContext)this.signContext).handle[i] = this.session.SignInit(params[i].GetSignMech(), params[i].GetPrvKey());
            ++i;
        }
        this.signContext.params = params;
    }

    public void genP7_SignDetachUpdate(byte[] sourceData) throws PKIException {
        int i = 0;
        while (i < this.signContext.handle.length) {
            this.session.SignUpdate(this.signContext.handle[i], sourceData);
            ++i;
        }
    }

    public byte[] genP7_SignDetachFinal() throws PKIException {
        if (this.session == null) {
            throw new PKIException("8216", "\u53c2\u6570\u4e0d\u5b8c\u6574");
        }
        try {
            ContentInfo dataCnt = null;
            byte[] cnt = null;
            dataCnt = this.GetCnt(this.GetTypeOid(1), cnt);
            ASN1EncodableVector vdigMech = new ASN1EncodableVector();
            ASN1EncodableVector vCert = new ASN1EncodableVector();
            ASN1EncodableVector vCrl = new ASN1EncodableVector();
            ASN1EncodableVector vSignInfo = new ASN1EncodableVector();
            P7Param[] params = this.signContext.params;
            int i = 0;
            while (i < params.length) {
                if (params[i].GetPrvKey() == null || params[i].GetSignMech() == null) {
                    throw new PKIException("8216", "\u53c2\u6570\u4e0d\u5b8c\u6574");
                }
                DERObjectIdentifier digMech = this.Sign2DigOid(params[i].GetSignMech());
                AlgorithmIdentifier algoDig = new AlgorithmIdentifier(digMech);
                vdigMech.add(algoDig);
                byte[] sign = this.session.SignFinal(this.signContext.handle[i]);
                if (sign == null) {
                    throw new PKIException("8213", "\u4ea7\u751fP7\u7ed3\u6784\u5931\u8d25");
                }
                vSignInfo.add(this.GetSignerInfo(params[i], sign));
                X509Cert[] x509certs = params[i].GetSignCerts();
                int j = 0;
                while (x509certs != null && j < x509certs.length) {
                    vCert.add(x509certs[j].getCertStructure());
                    ++j;
                }
                X509CRL[] x509crls = params[i].GetCrls();
                int k = 0;
                while (x509crls != null && k < x509crls.length) {
                    vCrl.add(x509crls[k].getCertificateList());
                    ++k;
                }
                ++i;
            }
            DERSet algos = new DERSet(vdigMech);
            DERSet infos = new DERSet(vSignInfo);
            DERSet certs = null;
            if (vCert.size() != 0) {
                certs = new DERSet(vCert);
            }
            DERSet crls = null;
            if (vCrl.size() != 0) {
                crls = new DERSet(vCrl);
            }
            DERInteger ver = new DERInteger(1);
            SignedData signData = new SignedData(ver, algos, dataCnt, certs, crls, infos);
            this.cntInfo = this.GetCnt(this.GetTypeOid(2), signData);
        }
        catch (Exception ex) {
            throw new PKIException("8213", "\u4ea7\u751fP7\u7ed3\u6784\u5931\u8d25", ex);
        }
        if (this.cntInfo == null) {
            return null;
        }
        return Parser.writeDERObj2Bytes(this.cntInfo.getDERObject());
    }

    public byte[] genP7_SignAttachInit(P7Param[] params, int len) throws PKIException {
        try {
            this.signContext = new SignContext();
            this.signContext.handle = new JHandle[params.length];
            int i = 0;
            while (i < params.length) {
                ((SignContext)this.signContext).handle[i] = this.session.SignInit(params[i].GetSignMech(), params[i].GetPrvKey());
                ++i;
            }
            this.signContext.params = params;
            return this.getSignAttachOSHead(params, len);
        }
        catch (Exception ex) {
            throw new PKIException("8213", "\u4ea7\u751fP7\u7ed3\u6784\u5931\u8d25", ex);
        }
    }

    public byte[] genP7_SignAttachUpdate(byte[] sourceData) throws PKIException {
        int i = 0;
        while (i < this.signContext.handle.length) {
            this.session.SignUpdate(this.signContext.handle[i], sourceData);
            ++i;
        }
        return sourceData;
    }

    public byte[] genP7_SignAttachFinal() throws PKIException {
        try {
            ASN1EncodableVector vdigMech = new ASN1EncodableVector();
            ASN1EncodableVector vCert = new ASN1EncodableVector();
            ASN1EncodableVector vCrl = new ASN1EncodableVector();
            ASN1EncodableVector vSignInfo = new ASN1EncodableVector();
            P7Param[] param = this.signContext.params;
            int i = 0;
            while (i < param.length) {
                if (param[i].GetPrvKey() == null || param[i].GetSignMech() == null) {
                    throw new PKIException("8216", "\u53c2\u6570\u4e0d\u5b8c\u6574");
                }
                DERObjectIdentifier digMech = this.Sign2DigOid(param[i].GetSignMech());
                AlgorithmIdentifier algoDig = new AlgorithmIdentifier(digMech);
                vdigMech.add(algoDig);
                byte[] sign = this.session.SignFinal(this.signContext.handle[i]);
                if (sign == null) {
                    throw new PKIException("8213", "\u4ea7\u751fP7\u7ed3\u6784\u5931\u8d25");
                }
                if ("SM3withSM2Encryption".equals(param[i].GetSignMech().getMechanismType())) {
                    vSignInfo.add(this.GetSignerInfoWithSM2(param[i], sign));
                } else {
                    vSignInfo.add(this.GetSignerInfo(param[i], sign));
                }
                X509Cert[] x509certs = param[i].GetSignCerts();
                int j = 0;
                while (x509certs != null && j < x509certs.length) {
                    vCert.add(x509certs[j].getCertStructure());
                    ++j;
                }
                X509CRL[] x509crls = param[i].GetCrls();
                int k = 0;
                while (x509crls != null && k < x509crls.length) {
                    vCrl.add(x509crls[k].getCertificateList());
                    ++k;
                }
                ++i;
            }
            DERSet infos = new DERSet(vSignInfo);
            DERSet certs = null;
            if (vCert.size() != 0) {
                certs = new DERSet(vCert);
            }
            DERSet crls = null;
            if (vCrl.size() != 0) {
                crls = new DERSet(vCrl);
            }
            int taillen = 0;
            byte[] binfos = Parser.writeDERObj2Bytes(infos);
            taillen = binfos.length;
            byte[] bcrl = null;
            if (crls != null) {
                DERTaggedObject crlsData = new DERTaggedObject(false, 1, crls);
                bcrl = Parser.writeDERObj2Bytes(crlsData);
                taillen += bcrl.length;
            }
            byte[] bcert = null;
            if (certs != null) {
                DERTaggedObject certsData = new DERTaggedObject(false, 0, certs);
                bcert = Parser.writeDERObj2Bytes(certsData);
                taillen += bcert.length;
            }
            byte[] tail = new byte[taillen];
            int lenpos = 0;
            if (bcert != null) {
                System.arraycopy(bcert, 0, tail, 0, bcert.length);
                lenpos += bcert.length;
            }
            if (bcrl != null) {
                System.arraycopy(bcrl, 0, tail, lenpos, bcrl.length);
                lenpos += bcrl.length;
            }
            System.arraycopy(binfos, 0, tail, lenpos, binfos.length);
            return tail;
        }
        catch (Exception ex) {
            throw new PKIException("8213", "\u4ea7\u751fP7\u7ed3\u6784\u5931\u8d25", ex);
        }
    }

    private byte[] getSignAttachOSHead(P7Param[] param, int len) throws PKIException {
        if (this.session == null) {
            throw new PKIException("8216", "\u53c2\u6570\u4e0d\u5b8c\u6574");
        }
        try {
            ASN1EncodableVector vdigMech = new ASN1EncodableVector();
            ASN1EncodableVector vCert = new ASN1EncodableVector();
            ASN1EncodableVector vCrl = new ASN1EncodableVector();
            ASN1EncodableVector vSignInfo = new ASN1EncodableVector();
            int i = 0;
            while (i < param.length) {
                byte[] sign;
                if (param[i].GetPrvKey() == null || param[i].GetSignMech() == null) {
                    throw new PKIException("8216", "\u53c2\u6570\u4e0d\u5b8c\u6574");
                }
                DERObjectIdentifier digMech = this.Sign2DigOid(param[i].GetSignMech());
                AlgorithmIdentifier algoDig = new AlgorithmIdentifier(digMech);
                vdigMech.add(algoDig);
                if ("SM3withSM2Encryption".equals(param[i].GetSignMech().getMechanismType())) {
                    sign = new byte[72];
                    vSignInfo.add(this.GetSignerInfoWithSM2(param[i], sign));
                } else {
                    sign = new byte[((RSAPrivateKey)Parser.convertPrivateKey(param[i].GetPrvKey())).getModulus().bitLength() / 8];
                    vSignInfo.add(this.GetSignerInfo(param[i], sign));
                }
                X509Cert[] x509certs = param[i].GetSignCerts();
                int j = 0;
                while (x509certs != null && j < x509certs.length) {
                    vCert.add(x509certs[j].getCertStructure());
                    ++j;
                }
                X509CRL[] x509crls = param[i].GetCrls();
                int k = 0;
                while (x509crls != null && k < x509crls.length) {
                    vCrl.add(x509crls[k].getCertificateList());
                    ++k;
                }
                ++i;
            }
            DERSet algos = new DERSet(vdigMech);
            DERSet infos = new DERSet(vSignInfo);
            DERSet certs = null;
            if (vCert.size() != 0) {
                certs = new DERSet(vCert);
            }
            DERSet crls = null;
            if (vCrl.size() != 0) {
                crls = new DERSet(vCrl);
            }
            int taillen = 0;
            byte[] binfos = Parser.writeDERObj2Bytes(infos);
            taillen = binfos.length;
            byte[] bcrl = null;
            if (crls != null) {
                DERTaggedObject crlsData = new DERTaggedObject(false, 1, crls);
                bcrl = Parser.writeDERObj2Bytes(crlsData);
                taillen += bcrl.length;
            }
            byte[] bcert = null;
            if (certs != null) {
                DERTaggedObject certsData = new DERTaggedObject(false, 0, certs);
                bcert = Parser.writeDERObj2Bytes(certsData);
                taillen += bcert.length;
            }
            byte[] version = new byte[]{2, 1, 1};
            byte[] algo = Parser.writeDERObj2Bytes(algos);
            byte[] sourceoid = Parser.writeDERObj2Bytes(this.GetTypeOid(1));
            byte[] bitSrcHder = this.getAsn1HeadData(4, len);
            byte[] sourceHder = this.getAsn1HeadData(160, len + bitSrcHder.length);
            byte[] tmp = new byte[sourceoid.length + sourceHder.length + bitSrcHder.length];
            System.arraycopy(sourceoid, 0, tmp, 0, sourceoid.length);
            System.arraycopy(sourceHder, 0, tmp, sourceoid.length, sourceHder.length);
            System.arraycopy(bitSrcHder, 0, tmp, sourceoid.length + sourceHder.length, bitSrcHder.length);
            byte[] sourceSeqHder = this.getAsn1HeadData(48, tmp.length + len);
            byte[] sourceSeq = new byte[sourceSeqHder.length + tmp.length];
            System.arraycopy(sourceSeqHder, 0, sourceSeq, 0, sourceSeqHder.length);
            System.arraycopy(tmp, 0, sourceSeq, sourceSeqHder.length, tmp.length);
            byte[] sDataHeader = this.getAsn1HeadData(48, version.length + algo.length + sourceSeq.length + len + taillen);
            byte[] sData = new byte[sDataHeader.length + version.length + algo.length + sourceSeq.length];
            System.arraycopy(sDataHeader, 0, sData, 0, sDataHeader.length);
            System.arraycopy(version, 0, sData, sDataHeader.length, version.length);
            System.arraycopy(algo, 0, sData, sDataHeader.length + version.length, algo.length);
            System.arraycopy(sourceSeq, 0, sData, sDataHeader.length + version.length + algo.length, sourceSeq.length);
            byte[] cntxtHder = this.getAsn1HeadData(160, sData.length + len + taillen);
            byte[] cntxt = new byte[cntxtHder.length + sData.length];
            System.arraycopy(cntxtHder, 0, cntxt, 0, cntxtHder.length);
            System.arraycopy(sData, 0, cntxt, cntxtHder.length, sData.length);
            byte[] p7oid = Parser.writeDERObj2Bytes(this.GetTypeOid(2));
            byte[] p7hder = this.getAsn1HeadData(48, p7oid.length + cntxt.length + len + taillen);
            byte[] header = new byte[p7hder.length + p7oid.length + cntxt.length];
            System.arraycopy(p7hder, 0, header, 0, p7hder.length);
            System.arraycopy(p7oid, 0, header, p7hder.length, p7oid.length);
            System.arraycopy(cntxt, 0, header, p7hder.length + p7oid.length, cntxt.length);
            return header;
        }
        catch (Exception ex) {
            throw new PKIException("8213", "\u4ea7\u751fP7\u7ed3\u6784\u5931\u8d25", ex);
        }
    }

    public void verifyP7SignDetachInit(byte[] signData) throws PKIException {
        this.verifyP7SignDetachInit(signData, (X509Cert[])null);
    }

    public void verifyP7SignDetachInit(byte[] signData, X509Cert x509Cert) throws PKIException {
        this.verifySignContext = new VerifySignContext();
        this.verifySignContext.attach = false;
        this.load(signData);
        if (x509Cert != null) {
            this.verifySignContext.x509Certs = new X509Cert[1];
            ((VerifySignContext)this.verifySignContext).x509Certs[0] = x509Cert;
        } else {
            this.verifySignContext.x509Certs = this.p7cnt.GetSignCerts();
        }
        p7signInfo[] infos = this.p7cnt.GetSignInfos();
        this.verifySignContext.handle = new JHandle[1];
        boolean b = false;
        int i = 0;
        while (i < infos.length) {
            String sn = infos[i].getSn();
            if (sn.equals(this.verifySignContext.x509Certs[0].getSerialNumber().toString(16))) {
                Mechanism mechanism = new Mechanism(infos[i].getSignMech());
                ((VerifySignContext)this.verifySignContext).handle[0] = this.session.VerifyInit(mechanism, this.verifySignContext.x509Certs[0].getPublicKey());
                b = true;
                break;
            }
            ++i;
        }
        if (!b) {
            throw new PKIException("8216", "\u53c2\u6570\u4e0d\u5b8c\u6574");
        }
    }

    public void verifyP7SignDetachInit(byte[] signData, X509Cert[] x509Cert) throws PKIException {
        this.verifySignContext = new VerifySignContext();
        this.verifySignContext.attach = false;
        this.load(signData);
        if (x509Cert != null && x509Cert.length > 0) {
            this.verifySignContext.x509Certs = x509Cert;
        } else {
            this.verifySignContext.x509Certs = this.p7cnt.GetSignCerts();
        }
        p7signInfo[] infos = this.p7cnt.GetSignInfos();
        this.verifySignContext.handle = new JHandle[infos.length];
        int i = 0;
        while (i < infos.length) {
            String sn = infos[i].getSn();
            boolean b = false;
            int j = 0;
            while (j < this.verifySignContext.x509Certs.length) {
                if (sn.equals(this.verifySignContext.x509Certs[j].getSerialNumber().toString(16))) {
                    JHandle handle;
                    Mechanism mechanism = new Mechanism(infos[i].getSignMech());
                    ((VerifySignContext)this.verifySignContext).handle[i] = handle = this.session.VerifyInit(mechanism, this.verifySignContext.x509Certs[j].getPublicKey());
                    b = true;
                    break;
                }
                ++j;
            }
            if (!b) {
                throw new PKIException("8216", "\u53c2\u6570\u4e0d\u5b8c\u6574");
            }
            ++i;
        }
    }

    public void verifyP7SignAttachInit() throws PKIException {
        this.verifyP7SignAttachInit(null);
    }

    public void verifyP7SignAttachInit(X509Cert x509Cert) throws PKIException {
        this.verifySignContext = new VerifySignContext();
        if (x509Cert != null) {
            this.verifySignContext.x509Certs = new X509Cert[1];
            ((VerifySignContext)this.verifySignContext).x509Certs[0] = x509Cert;
        } else {
            this.verifySignContext.digestType = true;
        }
        this.verifySignContext.buffer = new ByteArrayOutputStream();
        this.verifySignContext.attach = true;
    }

    public byte[] verifyP7SignUpdate(byte[] data) throws PKIException, IOException {
        if (this.verifySignContext.attach) {
            this.verifyP7SignUpdateAttach(data);
            return this.verifySignContext.getData();
        }
        this.verifyP7SignUpdateDetach(data);
        return data;
    }

    private void verifyP7SignUpdateDetach(byte[] data) throws PKIException, IOException {
        int i = 0;
        while (i < this.verifySignContext.handle.length) {
            this.session.VerifyUpdate(this.verifySignContext.handle[i], data);
            ++i;
        }
    }

    private void verifyP7SignUpdateAttach(byte[] data) throws PKIException, IOException {
        if (this.verifySignContext.status < 2) {
            this.verifySignContext.buffer.write(data);
            if (this.verifySignContext.buffer.size() >= 1024) {
                ByteArrayInputStream input = new ByteArrayInputStream(this.verifySignContext.buffer.toByteArray());
                this.readAsn1SignHder(input);
                this.verifySignContext.status = 2;
                int available = input.available();
                if (available > 0) {
                    byte[] temp = new byte[available];
                    input.read(temp);
                    this.verifySignContext.buffer = null;
                    this.verifyP7SignUpdateAttach(temp);
                }
            }
        } else if (this.verifySignContext.status == 2) {
            int num = this.verifySignContext.srcLen - this.verifySignContext.scrPos;
            if (data.length <= num) {
                if (this.verifySignContext.digestType) {
                    this.session.DigestUpdate(this.verifySignContext.handle[0], data);
                } else {
                    this.session.VerifyUpdate(this.verifySignContext.handle[0], data);
                }
                this.verifySignContext.addSourceData(data);
                VerifySignContext verifySignContext = this.verifySignContext;
                verifySignContext.scrPos = verifySignContext.scrPos + data.length;
            } else {
                byte[] temp = null;
                temp = new byte[num];
                System.arraycopy(data, 0, temp, 0, num);
                this.verifyP7SignUpdateAttach(temp);
                this.verifySignContext.status = 3;
                this.verifySignContext.buffer = new ByteArrayOutputStream();
                this.verifySignContext.status = 4;
                temp = new byte[data.length - num];
                System.arraycopy(data, num, temp, 0, temp.length);
                this.verifyP7SignUpdateAttach(temp);
            }
        } else if (this.verifySignContext.status == 4) {
            this.verifySignContext.buffer.write(data);
        } else {
            throw new PKIException("verifySignStatus", "\u65e0\u6548\u7684verifySignContext.status\u503c" + this.verifySignContext.status);
        }
    }

    public boolean verifyP7SignFinal() throws PKIException {
        if (this.verifySignContext.attach) {
            return this.verifyP7SignAttachFinal();
        }
        return this.verifyP7SignDetachFinal();
    }

    private boolean verifyP7SignDetachFinal() throws PKIException {
        p7signInfo[] infos = this.p7cnt.GetSignInfos();
        int i = 0;
        while (i < infos.length) {
            boolean verify = this.session.VerifyFinal(this.verifySignContext.handle[i], infos[i].getSignature());
            if (!verify) {
                return verify;
            }
            ++i;
        }
        return true;
    }

    private boolean verifyP7SignAttachFinal() throws PKIException {
        if (this.verifySignContext.status < 2) {
            this.load(this.verifySignContext.buffer.toByteArray());
            this.verifySignContext.status = 6;
            return this.verifyP7Sign(this.p7cnt.GetSource(), this.verifySignContext.x509Certs);
        }
        if (this.verifySignContext.status == 4) {
            ByteArrayInputStream ins = new ByteArrayInputStream(this.verifySignContext.buffer.toByteArray());
            this.p7cnt = new P7Param();
            p7signInfo[] info = null;
            block4: while (ins.available() > 0) {
                DERObject o = this.readObj(ins);
                if (o instanceof DERTaggedObject) {
                    DERTaggedObject tagged = (DERTaggedObject)o;
                    switch (tagged.getTagNo()) {
                        case 0: {
                            this.p7cnt.SetSignCerts(this.GetCerts(ASN1Set.getInstance(tagged, false)));
                            this.verifySignContext.x509Certs = this.p7cnt.GetSignCerts();
                            continue block4;
                        }
                        case 1: {
                            this.p7cnt.SetCrls(this.GetCrls(ASN1Set.getInstance(tagged, false)));
                            continue block4;
                        }
                        default: {
                            throw new PKIException("8211", "unknown tag value " + tagged.getTagNo());
                        }
                    }
                }
                info = this.parserSignInfos((ASN1Set)o);
                this.p7cnt.SetSignInfos(info);
            }
            this.verifySignContext.status = 6;
            if (this.verifySignContext.digestType) {
                if ("SM3withSM2Encryption".equals(this.verifySignContext.mechanism.getMechanismType())) {
                    throw new PKIException("6", "\u672c\u64cd\u4f5c\u4e0d\u652f\u6301SM2\u9a8c\u7b7e,\u5728\u8c03\u7528verifyP7SignInit(X509Cert x509Cert)\u65b9\u6cd5\u65f6,\u5fc5\u987b\u6307\u5b9a\u7528\u6237\u8bc1\u4e66.");
                }
                return this.verifyP7SignAttachByDigest(info);
            }
            return this.session.VerifyFinal(this.verifySignContext.handle[0], info[0].getSignature());
        }
        throw new PKIException("8211", "\u8f7d\u5165P7\u5bf9\u8c61\u9519\u8bef");
    }

    private boolean verifyP7SignAttachByDigest(p7signInfo[] info) throws PKIException {
        byte[] digestBytes = this.session.DigestFinal(this.verifySignContext.handle[0]);
        byte[] srcBytes = this.session.decrypt(new Mechanism("RSA/ECB/PKCS1PADDING"), this.verifySignContext.x509Certs[0].getPublicKey(), info[0].getSignature());
        byte type = 4;
        if (srcBytes.length >= digestBytes.length + 2 && srcBytes[srcBytes.length - digestBytes.length - 2] == type && srcBytes[srcBytes.length - digestBytes.length - 1] == digestBytes.length) {
            byte[] src = new byte[digestBytes.length];
            System.arraycopy(srcBytes, srcBytes.length - digestBytes.length, src, 0, digestBytes.length);
            return Arrays.equals(src, digestBytes);
        }
        return false;
    }

    private DERObjectIdentifier getDERObjectIdentifier(DERSet digAlgos) {
        DERSequence sequence = (DERSequence)digAlgos.getObjectAt(0);
        return (DERObjectIdentifier)sequence.getObjectAt(0);
    }

    private void readAsn1SignHder(InputStream input) throws PKIException {
        int readLen = 0;
        int len = 0;
        readLen = this.readAsn1Hder(input, true, 48);
        DERObjectIdentifier typeOidType = (DERObjectIdentifier)this.readObj(input, true, 6);
        int nType = this.GetType(typeOidType);
        readLen = this.readAsn1Hder(input, true, 160);
        readLen = this.readAsn1Hder(input, true, 48);
        DERObject obj = this.readObj(input, true, 2);
        if (obj == null) {
            throw new PKIException("8211", "\u8f7d\u5165P7\u5bf9\u8c61\u9519\u8befunkown p7 type");
        }
        if (2 != nType) {
            throw new PKIException("8211", "\u65e0\u6548\u7684p7\u7c7b\u578b " + nType);
        }
        DERSet digAlgos = (DERSet)this.readObj(input, true, 49);
        if (digAlgos == null) {
            throw new PKIException("8211", "\u8f7d\u5165P7\u5bf9\u8c61\u9519\u8bef");
        }
        Mechanism mechanism = this.DigOid2SignMechanism(this.getDERObjectIdentifier(digAlgos));
        this.verifySignContext.mechanism = mechanism;
        Asn1Hder hder = this.readAsn1Hder(input);
        DERObjectIdentifier typeOid = (DERObjectIdentifier)this.readObj(input, true, 6);
        int oidlen = Parser.writeDERObj2Bytes(typeOid).length;
        int srcLen = 0;
        if (hder.getHderLen() > oidlen) {
            len = this.readAsn1Hder(input, true, 160);
            if (len < 3) {
                throw new PKIException("8211", "\u8f7d\u5165P7\u5bf9\u8c61\u9519\u8befsrc len error");
            }
            srcLen = this.readAsn1Hder(input, true, 4);
            this.verifySignContext.srcLen = srcLen;
            this.verifySignContext.status = 1;
            this.verifySignContext.handle = new JHandle[1];
            ((VerifySignContext)this.verifySignContext).handle[0] = this.verifySignContext.digestType ? this.session.DigestInit(this.SignMechToDigMech(this.verifySignContext.mechanism)) : this.session.VerifyInit(this.verifySignContext.mechanism, this.verifySignContext.x509Certs[0].getPublicKey());
        } else {
            throw new PKIException("8211", "\u8f7d\u5165P7\u5bf9\u8c61\u9519\u8bef hder.getHderLen() < oidLen");
        }
    }

    private Mechanism SignMechToDigMech(Mechanism mechanism) throws PKIException {
        if (mechanism == null) {
            return null;
        }
        if ("SHA1withRSAEncryption".equals(mechanism.getMechanismType())) {
            return new Mechanism("SHA1");
        }
        if ("SHA224withRSAEncryption".equals(mechanism.getMechanismType())) {
            return new Mechanism("SHA224");
        }
        if ("SHA256withRSAEncryption".equals(mechanism.getMechanismType())) {
            return new Mechanism("SHA256");
        }
        if ("SHA384withRSAEncryption".equals(mechanism.getMechanismType())) {
            return new Mechanism("SHA384");
        }
        if ("SHA512withRSAEncryption".equals(mechanism.getMechanismType())) {
            return new Mechanism("SHA512");
        }
        if ("MD2withRSAEncryption".equals(mechanism.getMechanismType())) {
            return new Mechanism("MD2");
        }
        if ("MD5withRSAEncryption".equals(mechanism.getMechanismType())) {
            return new Mechanism("MD5");
        }
        throw new PKIException("6", "\u672c\u64cd\u4f5c\u4e0d\u652f\u6301SM2\u9a8c\u7b7e,\u5728\u8c03\u7528verifyP7SignInit(X509Cert x509Cert)\u65b9\u6cd5\u65f6,\u5fc5\u987b\u6307\u5b9a\u7528\u6237\u8bc1\u4e66.");
    }

    private Mechanism DigOid2SignMechanism(DERObjectIdentifier oid) throws PKIException {
        if (PKCSObjectIdentifiers.sha1.equals(oid)) {
            return new Mechanism("SHA1withRSAEncryption");
        }
        if (PKCSObjectIdentifiers.sha224.equals(oid)) {
            return new Mechanism("SHA224withRSAEncryption");
        }
        if (PKCSObjectIdentifiers.sha256.equals(oid)) {
            return new Mechanism("SHA256withRSAEncryption");
        }
        if (PKCSObjectIdentifiers.sha384.equals(oid)) {
            return new Mechanism("SHA384withRSAEncryption");
        }
        if (PKCSObjectIdentifiers.sha512.equals(oid)) {
            return new Mechanism("SHA512withRSAEncryption");
        }
        if (PKCSObjectIdentifiers.md2.equals(oid)) {
            return new Mechanism("MD2withRSAEncryption");
        }
        if (PKCSObjectIdentifiers.md5.equals(oid)) {
            return new Mechanism("MD5withRSAEncryption");
        }
        if (PKCSObjectIdentifiers.SM3.equals(oid)) {
            return new Mechanism("SM3withSM2Encryption");
        }
        throw new PKIException("8215", "\u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + oid.toString());
    }

    public static void main(String[] args) {
        System.out.println(15);
    }

    class Asn1Hder {
        private byte tag;
        private int hderLen;
        private byte[] lenData;

        Asn1Hder() {
        }

        public byte getTag() {
            return this.tag;
        }

        public void setTag(byte tag) {
            this.tag = tag;
        }

        public int getHderLen() {
            return this.hderLen;
        }

        public void setHderLen(int hderLen) {
            this.hderLen = hderLen;
        }

        public byte[] getLenData() {
            return this.lenData;
        }

        public void setLenData(byte[] lenData) {
            this.lenData = lenData;
        }
    }

    private class Buffer {
        private byte[] buf;

        private Buffer() {
        }

        public int size() {
            if (this.buf == null) {
                return 0;
            }
            return this.buf.length;
        }

        public int put(byte[] data) {
            if (data != null && data.length != 0) {
                if (this.buf == null) {
                    this.buf = new byte[data.length];
                    System.arraycopy(data, 0, this.buf, 0, data.length);
                } else {
                    byte[] tmp = new byte[this.buf.length + data.length];
                    System.arraycopy(this.buf, 0, tmp, 0, this.buf.length);
                    System.arraycopy(data, 0, tmp, this.buf.length, data.length);
                    this.buf = tmp;
                }
            }
            return this.size();
        }

        public int put(byte[] data, int pos, int len) {
            byte[] tmp = new byte[len];
            System.arraycopy(data, pos, tmp, 0, len);
            return this.put(tmp);
        }

        public byte[] getBlock() {
            int size = this.size() >> 4 << 4;
            if (size > 16) {
                size -= 16;
            }
            return this.get(size);
        }

        public byte[] get(int len) {
            if (this.buf == null || len == 0) {
                return null;
            }
            if (this.buf.length <= len) {
                byte[] tmp = this.buf;
                this.buf = null;
                return tmp;
            }
            byte[] tmp = new byte[len];
            byte[] left = new byte[this.buf.length - len];
            System.arraycopy(this.buf, 0, tmp, 0, len);
            System.arraycopy(this.buf, len, left, 0, left.length);
            this.buf = left;
            return tmp;
        }

        public byte[] getAll() {
            if (this.buf == null) {
                return new byte[0];
            }
            byte[] tmp = this.buf;
            this.buf = null;
            return tmp;
        }

        public ByteArrayInputStream getStream() {
            return new ByteArrayInputStream(this.buf);
        }

        public void clear() {
            this.buf = null;
        }
    }

    private class EnvContext {
        private JHandle handle;
        private Buffer buffer;
        private p7recCertKey[] rec;
        private Object iv;
        private boolean status = false;

        private EnvContext() {
        }
    }

    private static class SM2ProxyP7Param
    extends P7Param {
        private static DERObject[] UN_AUTH_PADDING_DATA = new DERObject[]{new DEROctetString(new byte[]{1}), new DEROctetString(new byte[]{2, 2}), new DEROctetString(new byte[]{3, 3, 3})};
        private P7Param proxy;
        private int signLen;

        public SM2ProxyP7Param(P7Param proxy, int signLen) {
            this.proxy = proxy;
            this.signLen = signLen;
        }

        public byte[] GetSource() {
            return this.proxy.GetSource();
        }

        public X509Cert[] GetCerts() {
            return this.proxy.GetCerts();
        }

        public X509Cert[] GetSignCerts() {
            return this.proxy.GetSignCerts();
        }

        public X509Cert[] GetEncCerts() {
            return this.proxy.GetEncCerts();
        }

        public X509CRL[] GetCrls() {
            return this.proxy.GetCrls();
        }

        public p7signInfo[] GetSignInfos() {
            return this.proxy.GetSignInfos();
        }

        public p7digInfo GetdigInfo() {
            return this.proxy.GetdigInfo();
        }

        public byte[] GetEncedData() {
            return this.proxy.GetEncedData();
        }

        public Mechanism GetEncMech() {
            return this.proxy.GetEncMech();
        }

        public p7recInfo[] GetRecInfos() {
            return this.proxy.GetRecInfos();
        }

        public Mechanism[] GetEnvMech() {
            return this.proxy.GetEnvMech();
        }

        public JKey GetPrvKey() {
            return this.proxy.GetPrvKey();
        }

        public Mechanism GetSignMech() {
            return this.proxy.GetSignMech();
        }

        public DERObject[] GetAuthData() {
            return this.proxy.GetAuthData();
        }

        public DERObject[] GetunAuthData() {
            DERObject[] unAuthData = this.proxy.GetunAuthData();
            DERObject padding = UN_AUTH_PADDING_DATA[72 - this.signLen];
            if (unAuthData == null || unAuthData.length == 0) {
                return new DERObject[]{padding};
            }
            DERObject[] data = new DERObject[unAuthData.length + 1];
            System.arraycopy(unAuthData, 0, data, 0, unAuthData.length);
            data[unAuthData.length] = padding;
            return data;
        }

        public JKey GetEncKey() {
            return this.proxy.GetEncKey();
        }

        public TSTInfo getTstInfo() {
            return this.proxy.getTstInfo();
        }

        public p7CertInfo[] getSignCertInfos() {
            return this.proxy.getSignCertInfos();
        }

        public p7CertInfo[] getEncCertInfos() {
            return this.proxy.getEncCertInfos();
        }
    }

    private class SignContext {
        private JHandle[] handle;
        private P7Param[] params;

        private SignContext() {
        }
    }

    private class VerifySignContext {
        private boolean attach;
        private JHandle[] handle;
        private int srcLen;
        private int scrPos;
        private X509Cert[] x509Certs;
        private boolean digestType;
        private Mechanism mechanism;
        private List<byte[]> srcData = new ArrayList<byte[]>(3);
        private ByteArrayOutputStream buffer;
        private int status;

        private VerifySignContext() {
        }

        public void addSourceData(byte[] data) {
            if (data != null && data.length > 0) {
                this.srcData.add(data);
            }
        }

        public byte[] getData() {
            if (this.srcData.size() == 0) {
                return null;
            }
            if (this.srcData.size() == 1) {
                byte[] temp = this.srcData.get(0);
                this.srcData.clear();
                return temp;
            }
            int len = 0;
            for (byte[] v : this.srcData) {
                len += v.length;
            }
            byte[] result = new byte[len];
            int post = 0;
            for (byte[] v : this.srcData) {
                System.arraycopy(v, 0, result, post, v.length);
                post += v.length;
            }
            this.srcData.clear();
            return result;
        }
    }
}

