/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.ida.util.pki.pkcs;

import cn.com.jit.ida.util.pki.PKIException;
import cn.com.jit.ida.util.pki.Parser;
import cn.com.jit.ida.util.pki.asn1.ASN1Sequence;
import cn.com.jit.ida.util.pki.asn1.ASN1Set;
import cn.com.jit.ida.util.pki.asn1.DERBitString;
import cn.com.jit.ida.util.pki.asn1.DERObjectIdentifier;
import cn.com.jit.ida.util.pki.asn1.DERPrintableString;
import cn.com.jit.ida.util.pki.asn1.DERUTF8String;
import cn.com.jit.ida.util.pki.asn1.pkcs.PKCSObjectIdentifiers;
import cn.com.jit.ida.util.pki.asn1.pkcs.pkcs10.CertificationRequest;
import cn.com.jit.ida.util.pki.asn1.pkcs.pkcs10.CertificationRequestInfo;
import cn.com.jit.ida.util.pki.asn1.x509.AlgorithmIdentifier;
import cn.com.jit.ida.util.pki.asn1.x509.SubjectPublicKeyInfo;
import cn.com.jit.ida.util.pki.asn1.x509.X509Name;
import cn.com.jit.ida.util.pki.asn1.x9.X9ObjectIdentifiers;
import cn.com.jit.ida.util.pki.cipher.JCrypto;
import cn.com.jit.ida.util.pki.cipher.JKey;
import cn.com.jit.ida.util.pki.cipher.Mechanism;
import cn.com.jit.ida.util.pki.cipher.Session;
import cn.com.jit.ida.util.pki.encoders.Base64;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Hashtable;

public class PKCS10 {
    private String subject = null;
    private JKey pubKey = null;
    private ASN1Set attributes = null;
    private Session session = null;
    private boolean needVerify = false;
    private static Hashtable algs = new Hashtable();
    private static Hashtable oids = new Hashtable();
    public static final String SHA1_RSA = "SHA1withRSAEncryption";
    public static final String MD2_RSA = "MD2withRSAEncryption";
    public static final String MD5_RSA = "MD5withRSAEncryption";
    public static final String SHA1_DSA = "SHA1withDSA";
    public static final String SHA1_EC_DSA = "SHA1withECDSA";
    public static final String SHA224_EC_DSA = "SHA224withECDSA";
    public static final String SHA256_EC_DSA = "SHA256withECDSA";
    public static final String SHA384_RSA = "SHA384withRSAEncryption";
    public static final String SHA256_RSA = "SHA256withRSAEncryption";
    public static final String SHA512_RSA = "SHA512withRSAEncryption";
    public static boolean LoadedConfigFile = false;
    private X509Name xSub = null;

    static {
        algs.put(SHA1_RSA, PKCSObjectIdentifiers.sha1WithRSAEncryption);
        algs.put(MD5_RSA, PKCSObjectIdentifiers.md5WithRSAEncryption);
        algs.put(MD2_RSA, PKCSObjectIdentifiers.md2WithRSAEncryption);
        algs.put(SHA1_DSA, PKCSObjectIdentifiers.sha1WithDSA);
        algs.put(SHA1_EC_DSA, PKCSObjectIdentifiers.sha1WithECEncryption);
        algs.put(SHA224_EC_DSA, X9ObjectIdentifiers.ecdsa_with_SHA224);
        algs.put(SHA256_EC_DSA, X9ObjectIdentifiers.ecdsa_with_SHA256);
        algs.put(SHA256_RSA, PKCSObjectIdentifiers.sha256WithRSAEncryption);
        algs.put(SHA384_RSA, PKCSObjectIdentifiers.sha384WithRSAEncryption);
        algs.put(SHA512_RSA, PKCSObjectIdentifiers.sha512WithRSAEncryption);
        algs.put("SM3withSM2Encryption", PKCSObjectIdentifiers.sm2_with_sm3);
        oids.put(PKCSObjectIdentifiers.sha1WithRSAEncryption, new Mechanism(SHA1_RSA));
        oids.put(PKCSObjectIdentifiers.md5WithRSAEncryption, new Mechanism(MD5_RSA));
        oids.put(PKCSObjectIdentifiers.md2WithRSAEncryption, new Mechanism(MD2_RSA));
        oids.put(PKCSObjectIdentifiers.sha1WithDSA, new Mechanism(SHA1_DSA));
        oids.put(PKCSObjectIdentifiers.sha1WithECEncryption, new Mechanism(SHA1_EC_DSA));
        oids.put(X9ObjectIdentifiers.ecdsa_with_SHA224, new Mechanism(SHA224_EC_DSA));
        oids.put(X9ObjectIdentifiers.ecdsa_with_SHA256, new Mechanism(SHA256_EC_DSA));
        oids.put(PKCSObjectIdentifiers.sha256WithRSAEncryption, new Mechanism(SHA256_RSA));
        oids.put(PKCSObjectIdentifiers.sha384WithRSAEncryption, new Mechanism(SHA384_RSA));
        oids.put(PKCSObjectIdentifiers.sha512WithRSAEncryption, new Mechanism(SHA512_RSA));
        oids.put(PKCSObjectIdentifiers.sm2_with_sm3, new Mechanism("SM3withSM2Encryption"));
    }

    public PKCS10(Session session) {
        if (session == null) {
            try {
                this.session = JCrypto.getInstance().openSession("JSOFT_LIB");
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        this.session = session;
    }

    public CertificationRequest generateCertificationRequest(String signatureAlgorithm, String subject, JKey pubKey, ASN1Set attributes, JKey signingKey) throws PKIException {
        this.subject = subject;
        this.pubKey = pubKey;
        this.attributes = attributes;
        X509Name p10Subject = new X509Name(subject);
        DERObjectIdentifier signOID = (DERObjectIdentifier)algs.get(signatureAlgorithm);
        if (signOID == null) {
            throw new PKIException("8173", "\u4ea7\u751fP10\u7533\u8bf7\u4e66\u5931\u8d25 \u4e0d\u652f\u6301\u7684\u7b7e\u540d\u7b97\u6cd5 " + signatureAlgorithm);
        }
        if (subject == null) {
            throw new PKIException("8173", "\u4ea7\u751fP10\u7533\u8bf7\u4e66\u5931\u8d25 \u4e3b\u9898\u4fe1\u606f\u5fc5\u987b\u4e0d\u4e3a\u7a7a");
        }
        if (pubKey == null) {
            throw new PKIException("8173", "\u4ea7\u751fP10\u7533\u8bf7\u4e66\u5931\u8d25 \u516c\u94a5\u5fc5\u987b\u4e0d\u4e3a\u7a7a");
        }
        if (signingKey == null) {
            throw new PKIException("8173", "\u4ea7\u751fP10\u7533\u8bf7\u4e66\u5931\u8d25 \u7b7e\u540d\u79c1\u94a5\u5fc5\u987b\u4e0d\u4e3a\u7a7a");
        }
        AlgorithmIdentifier algID = new AlgorithmIdentifier(signOID, null);
        SubjectPublicKeyInfo spki = Parser.key2SPKI(pubKey);
        CertificationRequestInfo crqInfo = new CertificationRequestInfo(p10Subject, spki, attributes);
        byte[] b_crqInfo = Parser.writeDERObj2Bytes(crqInfo.getDERObject());
        Mechanism mech = (Mechanism)oids.get(signOID);
        byte[] signData = this.session.sign(mech, signingKey, b_crqInfo);
        DERBitString signature = new DERBitString(signData);
        return new CertificationRequest(crqInfo, algID, signature);
    }

    public byte[] generateCertificationRequestData_DER(String signatureAlgorithm, String subject, JKey pubKey, ASN1Set attributes, JKey signingKey) throws PKIException {
        CertificationRequest certReq = this.generateCertificationRequest(signatureAlgorithm, subject, pubKey, attributes, signingKey);
        byte[] data = Parser.writeDERObj2Bytes(certReq.getDERObject());
        return data;
    }

    public byte[] generateCertificationRequestData_B64(String signatureAlgorithm, String subject, JKey pubKey, ASN1Set attributes, JKey signingKey) throws PKIException {
        CertificationRequest certReq = this.generateCertificationRequest(signatureAlgorithm, subject, pubKey, attributes, signingKey);
        byte[] data = Parser.writeDERObj2Bytes(certReq.getDERObject());
        data = Base64.encode(data);
        return data;
    }

    public void load(CertificationRequest certficationRequest) throws PKIException {
        boolean f;
        DERObjectIdentifier signOID = certficationRequest.getSignatureAlgorithm().getObjectId();
        Mechanism signM = (Mechanism)oids.get(signOID);
        if (signM == null) {
            throw new PKIException("8173", "\u4ea7\u751fP10\u7533\u8bf7\u4e66\u5931\u8d25 \u4e0d\u652f\u6301\u7684\u7b7e\u540d\u7b97\u6cd5 " + signOID.toString());
        }
        byte[] signData = certficationRequest.getSignature().getBytes();
        CertificationRequestInfo crqInfo = certficationRequest.getCertificationRequestInfo();
        byte[] b_crqInfo = Parser.writeDERObj2Bytes(crqInfo.getDERObject());
        SubjectPublicKeyInfo spki = crqInfo.getSubjectPublicKeyInfo();
        this.pubKey = Parser.SPKI2Key(spki);
        this.needVerify = this.session.getCfgTag() != null ? this.session.getCfgTag().isVerifyP10Signature() : false;
        if (this.needVerify && !(f = this.session.verifySign(signM, this.pubKey, b_crqInfo, signData))) {
            throw new PKIException("8174", "\u89e3\u6790P10\u7533\u8bf7\u4e66\u5931\u8d25 \u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25");
        }
        this.xSub = crqInfo.getSubject();
        this.subject = crqInfo.getSubject().toString();
        this.attributes = crqInfo.getAttributes();
    }

    public void load(byte[] data) throws PKIException {
        BufferedReader bufferReader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(data)));
        try {
            String str = bufferReader.readLine();
            if (str.toUpperCase().indexOf("BEGIN NEW CERTIFICATE REQUEST") != -1) {
                StringBuffer strBuffer = new StringBuffer();
                while ((str = bufferReader.readLine()) != null) {
                    if (str.toUpperCase().indexOf("END NEW CERTIFICATE REQUEST") != -1) break;
                    strBuffer.append(str);
                }
                data = strBuffer.toString().getBytes();
                data = Parser.convertBase64(data);
                data = Base64.decode(data);
            } else {
                boolean isB64 = Parser.isBase64Encode(data);
                if (isB64) {
                    data = Parser.convertBase64(data);
                    data = Base64.decode(data);
                }
            }
        }
        catch (IOException ex1) {
            throw new PKIException("8174", "\u89e3\u6790P10\u7533\u8bf7\u4e66\u5931\u8d25", ex1);
        }
        CertificationRequest certificationRequest = null;
        try {
            if (data[0] != 48) {
                throw new Exception();
            }
            ASN1Sequence sequence = (ASN1Sequence)Parser.writeBytes2DERObj(data);
            certificationRequest = new CertificationRequest(sequence);
        }
        catch (Exception ex) {
            throw new PKIException("8174", "\u89e3\u6790P10\u7533\u8bf7\u4e66\u5931\u8d25", new Exception("The PKCS10 CertificationRequest content error."));
        }
        this.load(certificationRequest);
    }

    public ASN1Set getAttributes() {
        return this.attributes;
    }

    public JKey getPubKey() {
        return this.pubKey;
    }

    public String getSubject() {
        return this.subject;
    }

    public boolean checkSubRules() throws Exception {
        ASN1Sequence seq = (ASN1Sequence)this.xSub.getDERObject();
        Enumeration e = seq.getObjects();
        while (e.hasMoreElements()) {
            ASN1Set set = (ASN1Set)e.nextElement();
            int i = 0;
            while (i < set.size()) {
                ASN1Sequence s = (ASN1Sequence)set.getObjectAt(i);
                if (X509Name.C.equals(s.getObjectAt(0)) ? !(s.getObjectAt(1) instanceof DERPrintableString) : !(s.getObjectAt(1) instanceof DERUTF8String)) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public static void main(String[] args) {
        JCrypto jcrypto = null;
        Session session = null;
        try {
            jcrypto = JCrypto.getInstance();
            jcrypto.initialize("JSOFT_LIB", null);
            jcrypto.initialize("JSJY05B_LIB", null);
            session = jcrypto.openSession("JSOFT_LIB");
            PKCS10 p10 = new PKCS10(null);
            FileInputStream fis = new FileInputStream("d:\\p10.req");
            byte[] data = new byte[fis.available()];
            fis.read(data);
            fis.close();
            p10.load(data);
            p10.checkSubRules();
            JKey pubKey = p10.getPubKey();
            System.out.println("key len:" + pubKey.getKey().length);
            System.out.println("PKCS10 success!");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

