/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.ida.util.pki.pkcs;

import cn.com.jit.ida.util.pki.PKIException;
import cn.com.jit.ida.util.pki.Parser;
import cn.com.jit.ida.util.pki.asn1.ASN1EncodableVector;
import cn.com.jit.ida.util.pki.asn1.ASN1Sequence;
import cn.com.jit.ida.util.pki.asn1.ASN1Set;
import cn.com.jit.ida.util.pki.asn1.DERInteger;
import cn.com.jit.ida.util.pki.asn1.DEROutputStream;
import cn.com.jit.ida.util.pki.asn1.DERSet;
import cn.com.jit.ida.util.pki.asn1.pkcs.PKCSObjectIdentifiers;
import cn.com.jit.ida.util.pki.asn1.pkcs.pkcs7.ContentInfo;
import cn.com.jit.ida.util.pki.asn1.pkcs.pkcs7.SignedData;
import cn.com.jit.ida.util.pki.asn1.x509.X509CertificateStructure;
import cn.com.jit.ida.util.pki.cert.X509Cert;
import cn.com.jit.ida.util.pki.cipher.JCrypto;
import cn.com.jit.ida.util.pki.cipher.Session;
import cn.com.jit.ida.util.pki.encoders.Base64;
import cn.com.jit.ida.util.pki.pkcs.PKCS7SignedData;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;

public class P7B {
    public X509Cert[] parseP7b(ContentInfo contentInfo) throws PKIException {
        if (!contentInfo.getContentType().equals(PKCSObjectIdentifiers.signedData)) {
            throw new PKIException("8172", "\u89e3\u6790P7B\u8bc1\u4e66\u94fe\u7ed3\u6784\u5931\u8d25 \u8bc1\u4e66\u94fe\u7c7b\u578b\u4e0d\u5339\u914d " + contentInfo.getContentType().getId());
        }
        SignedData signedData = SignedData.getInstance(contentInfo.getContent());
        ASN1Set certSet = signedData.getCertificates();
        Enumeration enumeration = certSet.getObjects();
        Vector<X509Cert> v = new Vector<X509Cert>();
        X509Cert cert = null;
        while (enumeration.hasMoreElements()) {
            X509CertificateStructure certStruc = X509CertificateStructure.getInstance(enumeration.nextElement());
            cert = new X509Cert(certStruc);
            v.add(cert);
        }
        X509Cert[] certs = new X509Cert[v.size()];
        v.toArray(certs);
        return certs;
    }

    public X509Cert[] parseP7b(String fileName) throws PKIException {
        FileInputStream fin = null;
        byte[] data = null;
        try {
            fin = new FileInputStream(fileName);
            data = new byte[fin.available()];
            fin.read(data);
            fin.close();
        }
        catch (Exception ex) {
            throw new PKIException("8172", "\u89e3\u6790P7B\u8bc1\u4e66\u94fe\u7ed3\u6784\u5931\u8d25", ex);
        }
        return this.parseP7b(data);
    }

    private X509Cert[] parseP7b(InputStream ins) throws PKIException {
        try {
            byte[] content = new byte[ins.available()];
            ins.read(content);
            ins.close();
            return this.parseP7b(content);
        }
        catch (Exception ex) {
            throw new PKIException("8172", "\u89e3\u6790P7B\u8bc1\u4e66\u94fe\u7ed3\u6784\u5931\u8d25", ex);
        }
    }

    public X509Cert[] parseP7b(byte[] data) throws PKIException {
        boolean isB64 = Parser.isBase64Encode(data);
        if (isB64) {
            data = Parser.convertBase64(data);
            data = Base64.decode(data);
        }
        if (data[0] != 48) {
            throw new PKIException("8172", "\u89e3\u6790P7B\u8bc1\u4e66\u94fe\u7ed3\u6784\u5931\u8d25", new Exception("The P7B certification chain content error."));
        }
        try {
            ASN1Sequence sequence = (ASN1Sequence)Parser.writeBytes2DERObj(data);
            ContentInfo contentInfo = ContentInfo.getInstance(sequence);
            return this.parseP7b(contentInfo);
        }
        catch (Exception ex) {
            throw new PKIException("8172", "\u89e3\u6790P7B\u8bc1\u4e66\u94fe\u7ed3\u6784\u5931\u8d25", ex);
        }
    }

    public ContentInfo generateP7b(X509Cert[] certs) {
        ASN1EncodableVector v = new ASN1EncodableVector();
        int i = 0;
        while (i < certs.length) {
            X509CertificateStructure certStruc = certs[i].getCertStructure();
            v.add(certStruc);
            ++i;
        }
        DERSet certSet = new DERSet(v);
        DERSet algs = new DERSet();
        DERSet signerInfos = new DERSet();
        ContentInfo ci = new ContentInfo(PKCSObjectIdentifiers.data, null);
        SignedData signedData = new SignedData(new DERInteger(1), algs, ci, certSet, null, signerInfos);
        ContentInfo contentInfo = new ContentInfo(PKCSObjectIdentifiers.signedData, signedData);
        return contentInfo;
    }

    public void generateP7bFile(X509Cert[] certs, String fileName) throws PKIException {
        ContentInfo contentInfo = this.generateP7b(certs);
        try {
            FileOutputStream fos = new FileOutputStream(fileName);
            DEROutputStream dos = new DEROutputStream(fos);
            dos.writeObject(contentInfo.getDERObject());
            dos.close();
            fos.close();
        }
        catch (Exception ex) {
            throw new PKIException("8171", "\u4ea7\u751fP7B\u8bc1\u4e66\u94fe\u7ed3\u6784\u5931\u8d25", ex);
        }
    }

    public byte[] generateP7bData_DER(X509Cert[] certs) throws PKIException {
        ContentInfo contentInfo = this.generateP7b(certs);
        return Parser.writeDERObj2Bytes(contentInfo.getDERObject());
    }

    public byte[] generateP7bData_B64(X509Cert[] certs) throws PKIException {
        byte[] data = this.generateP7bData_DER(certs);
        data = Base64.encode(data);
        return data;
    }

    public static void main(String[] args) {
        try {
            P7B p7b = new P7B();
            FileInputStream fis = new FileInputStream("d:\\1.p7b");
            byte[] data = new byte[fis.available()];
            fis.read(data, 0, data.length);
            X509Cert[] certs = p7b.parseP7b(data);
            X509Cert x509Cert = certs[0];
            System.out.println(certs.length);
            JCrypto jc = JCrypto.getInstance();
            jc.initialize("JSOFT_LIB", null);
            Session s = jc.openSession("JSOFT_LIB", null);
            PKCS7SignedData signedData = new PKCS7SignedData(s);
            signedData.load(data);
            boolean bv = signedData.verifyP7SignedData("2c908d293966f5f7013967066b9d0004".getBytes(), x509Cert);
            byte[] b = "abc".getBytes();
            if (Parser.isBase64Encode(b)) {
                System.out.println(new String(Base64.decode(b)));
            }
        }
        catch (Exception ex) {
            System.err.println(ex.toString());
        }
    }
}

