/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.ida.util.pki.pkcs;

import cn.com.jit.ida.util.pki.PKIException;
import cn.com.jit.ida.util.pki.Parser;
import cn.com.jit.ida.util.pki.asn1.ASN1EncodableVector;
import cn.com.jit.ida.util.pki.asn1.ASN1InputStream;
import cn.com.jit.ida.util.pki.asn1.ASN1OctetString;
import cn.com.jit.ida.util.pki.asn1.ASN1Sequence;
import cn.com.jit.ida.util.pki.asn1.ASN1Set;
import cn.com.jit.ida.util.pki.asn1.DERInteger;
import cn.com.jit.ida.util.pki.asn1.DERNull;
import cn.com.jit.ida.util.pki.asn1.DERObject;
import cn.com.jit.ida.util.pki.asn1.DERObjectIdentifier;
import cn.com.jit.ida.util.pki.asn1.DEROctetString;
import cn.com.jit.ida.util.pki.asn1.DEROutputStream;
import cn.com.jit.ida.util.pki.asn1.DERSequence;
import cn.com.jit.ida.util.pki.asn1.DERSet;
import cn.com.jit.ida.util.pki.asn1.DERUTCTime;
import cn.com.jit.ida.util.pki.asn1.cms.Attribute;
import cn.com.jit.ida.util.pki.asn1.cms.AttributeTable;
import cn.com.jit.ida.util.pki.asn1.cms.CMSAttributes;
import cn.com.jit.ida.util.pki.asn1.cms.IssuerAndSerialNumber;
import cn.com.jit.ida.util.pki.asn1.cms.SignerIdentifier;
import cn.com.jit.ida.util.pki.asn1.cms.SignerInfo;
import cn.com.jit.ida.util.pki.asn1.cms.Time;
import cn.com.jit.ida.util.pki.asn1.pkcs.PKCSObjectIdentifiers;
import cn.com.jit.ida.util.pki.asn1.pkcs.pkcs7.ContentInfo;
import cn.com.jit.ida.util.pki.asn1.pkcs.pkcs7.SignedData;
import cn.com.jit.ida.util.pki.asn1.x509.AlgorithmIdentifier;
import cn.com.jit.ida.util.pki.asn1.x509.CRLEntry;
import cn.com.jit.ida.util.pki.asn1.x509.SubjectKeyIdentifier;
import cn.com.jit.ida.util.pki.asn1.x509.SubjectPublicKeyInfo;
import cn.com.jit.ida.util.pki.asn1.x509.TBSCertificateStructure;
import cn.com.jit.ida.util.pki.asn1.x509.X509CertificateStructure;
import cn.com.jit.ida.util.pki.cert.X509Cert;
import cn.com.jit.ida.util.pki.cipher.JCrypto;
import cn.com.jit.ida.util.pki.cipher.JKey;
import cn.com.jit.ida.util.pki.cipher.Mechanism;
import cn.com.jit.ida.util.pki.cipher.Session;
import cn.com.jit.ida.util.pki.crl.X509CRL;
import cn.com.jit.ida.util.pki.encoders.Base64;
import cn.com.jit.ida.util.pki.extension.ExtendedKeyUsageExt;
import cn.com.jit.ida.util.pki.pkcs.PKCS12;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;

public class CTL {
    private ASN1EncodableVector certs = new ASN1EncodableVector();
    private ASN1EncodableVector crls = new ASN1EncodableVector();
    private ArrayList signers = new ArrayList();
    private Session session = null;
    private X509Cert[] xcerts = null;
    private X509CRL[] xcrls = null;
    private DERObject digObj = null;
    private DERSet digSet = null;
    private ExtendedKeyUsageExt keyUsg = null;
    private String ctlName = null;
    private Date validDate = null;

    public CTL() {
    }

    public CTL(Session sess) {
        this.session = sess;
    }

    public void AddCert(X509Cert value) throws PKIException {
        this.certs.add(Parser.convertJITCertStruct2BCCertStruct(value.getCertStructure()));
        this.xcerts = new X509Cert[this.certs.size()];
        int i = 0;
        while (i < this.certs.size()) {
            this.xcerts[i] = new X509Cert(Parser.writeDERObj2Bytes(this.certs.get(i)));
            ++i;
        }
    }

    public X509Cert[] getCert() throws PKIException {
        return this.xcerts;
    }

    public void AddCRL(X509CRL value) throws PKIException {
        this.crls.add(Parser.convertJITCertList2BCCertList(value.getCertificateList()));
        this.xcrls = new X509CRL[this.crls.size()];
        int i = 0;
        while (i < this.crls.size()) {
            this.xcrls[i] = new X509CRL(Parser.writeDERObj2Bytes(this.crls.get(i)));
            ++i;
        }
    }

    public X509CRL[] getCRL() throws PKIException {
        return this.xcrls;
    }

    public void SetSess(Session sess) {
        this.session = sess;
    }

    public void AddSigner(JKey privatekey, X509Cert cert, Mechanism sign_Mechanism) {
        this.signers.add(new Signer(this.session, privatekey, cert, sign_Mechanism));
    }

    public void AddSigner(JKey privatekey, X509Cert cert, Mechanism sign_Mechanism, AttributeTable sAttr, AttributeTable unsAttr) {
        this.signers.add(new Signer(this.session, privatekey, cert, sign_Mechanism, sAttr, unsAttr));
    }

    public ArrayList getSigner() throws PKIException {
        return this.signers;
    }

    public void AddDig(Mechanism dig) throws PKIException {
        String digestTypeOID = null;
        if (dig.getMechanismType().equals("MD2")) {
            digestTypeOID = "1.2.840.113549.2.2";
        } else if (dig.getMechanismType().equals("MD5")) {
            digestTypeOID = "1.2.840.113549.2.5";
        } else if (dig.getMechanismType().equals("SHA1")) {
            digestTypeOID = "1.3.14.3.2.26";
        } else if (dig.getMechanismType().equals("SHA256")) {
            digestTypeOID = "2.16.840.1.101.3.4.2.1";
        } else if (dig.getMechanismType().equals("SHA384")) {
            digestTypeOID = "2.16.840.1.101.3.4.2.2";
        } else if (dig.getMechanismType().equals("SHA512")) {
            digestTypeOID = "2.16.840.1.101.3.4.2.2";
        } else if (dig.getMechanismType().equals("SHA224")) {
            digestTypeOID = "2.16.840.1.101.3.4.2.1";
        } else {
            StringBuffer error = new StringBuffer();
            error.append("\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25");
            error.append(" ");
            error.append("\u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b");
            error.append(" ");
            error.append(dig.getMechanismType());
            throw new PKIException("8122", error.toString());
        }
        AlgorithmIdentifier digAlgId = new AlgorithmIdentifier(new DERObjectIdentifier(digestTypeOID), new DERNull());
        this.digObj = digAlgId.toASN1Object();
        this.digSet = new DERSet(digAlgId);
    }

    public Mechanism getDig() throws PKIException {
        Mechanism mech = null;
        AlgorithmIdentifier digAlgId = AlgorithmIdentifier.getInstance(this.digObj);
        String digstr = digAlgId.getObjectId().getId();
        if (digstr.equals("1.2.840.113549.2.2".toString())) {
            mech = new Mechanism("MD2");
        } else if (digstr.equals("1.2.840.113549.2.5".toString())) {
            mech = new Mechanism("MD5");
        } else if (digstr.equals("1.3.14.3.2.26".toString())) {
            mech = new Mechanism("SHA1");
        } else if (digstr.equals("2.16.840.1.101.3.4.2.1".toString())) {
            mech = new Mechanism("SHA256");
        } else if (digstr.equals("2.16.840.1.101.3.4.2.2".toString())) {
            mech = new Mechanism("SHA384");
        } else if (digstr.equals("2.16.840.1.101.3.4.2.2".toString())) {
            mech = new Mechanism("SHA512");
        } else if (digstr.equals("2.16.840.1.101.3.4.2.1".toString())) {
            mech = new Mechanism("SHA224");
        } else {
            StringBuffer error = new StringBuffer();
            error.append("2");
            error.append(" ");
            error.append("\u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b");
            error.append(" ");
            error.append(digstr);
            throw new PKIException("8122", error.toString());
        }
        return mech;
    }

    public void AddKeyUsg(ExtendedKeyUsageExt usg) throws PKIException {
        this.keyUsg = usg;
    }

    public ExtendedKeyUsageExt getKeyUsg() throws PKIException {
        return this.keyUsg;
    }

    public void SetName(String name) throws PKIException {
        this.ctlName = name;
    }

    public String getName() throws PKIException {
        return this.ctlName;
    }

    public void SetValidDate(Date date) throws PKIException {
        this.validDate = date;
    }

    public Date getValidDate() throws PKIException {
        return this.validDate;
    }

    public void parseCTL(ContentInfo contentInfo) throws PKIException {
        ContentInfo cnt;
        ASN1Set signersSet;
        ASN1Set crlSet;
        if (!contentInfo.getContentType().equals(PKCSObjectIdentifiers.signedData)) {
            throw new PKIException("8172", "\u89e3\u6790P7B\u8bc1\u4e66\u94fe\u7ed3\u6784\u5931\u8d25 \u8bc1\u4e66\u94fe\u7c7b\u578b\u4e0d\u5339\u914d " + contentInfo.getContentType().getId());
        }
        SignedData signedData = SignedData.getInstance(contentInfo.getContent());
        ASN1Set certSet = signedData.getCertificates();
        Enumeration enumeration = null;
        if (certSet != null) {
            enumeration = certSet.getObjects();
            X509Cert cert = null;
            while (enumeration.hasMoreElements()) {
                X509CertificateStructure certStruc = X509CertificateStructure.getInstance(enumeration.nextElement());
                cert = new X509Cert(certStruc);
                this.certs.add(Parser.convertJITCertStruct2BCCertStruct(cert.getCertStructure()));
            }
            this.xcerts = new X509Cert[this.certs.size()];
            int i = 0;
            while (i < this.certs.size()) {
                this.xcerts[i] = new X509Cert(Parser.writeDERObj2Bytes(this.certs.get(i)));
                ++i;
            }
        }
        if ((crlSet = signedData.getCRLs()) != null) {
            enumeration = crlSet.getObjects();
            X509CRL crl = null;
            while (enumeration.hasMoreElements()) {
                CRLEntry crlStruc = new CRLEntry((ASN1Sequence)enumeration.nextElement());
                crl = new X509CRL(Parser.writeDERObj2Bytes(crlStruc.getDERObject()));
                this.crls.add(Parser.convertJITCertList2BCCertList(crl.getCertificateList()));
            }
            this.xcrls = new X509CRL[this.crls.size()];
            int i = 0;
            while (i < this.crls.size()) {
                this.xcrls[i] = new X509CRL(Parser.writeDERObj2Bytes(this.crls.get(i)));
                ++i;
            }
        }
        if ((signersSet = signedData.getSignerInfos()) != null) {
            enumeration = signersSet.getObjects();
            this.signers.clear();
            while (enumeration.hasMoreElements()) {
                this.signers.add(enumeration.nextElement());
            }
        }
        if ((cnt = signedData.getContentInfo()) != null) {
            DERSequence tmpseq = new DERSequence(cnt.getContent());
            DERSequence derseq = (DERSequence)tmpseq.getObjectAt(0);
            if (derseq.size() > 0) {
                this.keyUsg = new ExtendedKeyUsageExt(ASN1Sequence.getInstance(derseq.getObjectAt(0)));
            }
            if (derseq.size() > 1) {
                this.ctlName = new String(DEROctetString.getInstance(derseq.getObjectAt(1)).getOctets());
            }
            if (derseq.size() > 2) {
                Time time = Time.getInstance(derseq.getObjectAt(2));
                this.validDate = time.getDate();
            }
            if (derseq.size() > 3) {
                DERSequence digSeq = new DERSequence(derseq.getObjectAt(3).getDERObject());
                DERSequence seq = (DERSequence)digSeq.getObjectAt(0);
                this.digObj = seq.getObjectAt(0).getDERObject();
                this.digSet = new DERSet(seq.getObjectAt(0).getDERObject());
            }
            derseq.size();
        }
    }

    public void parseCTL(String fileName) throws PKIException {
        FileInputStream fin = null;
        byte[] data = null;
        try {
            fin = new FileInputStream(fileName);
            data = new byte[fin.available()];
            fin.read(data);
            fin.close();
        }
        catch (Exception ex) {
            throw new PKIException("8172", "\u89e3\u6790P7B\u8bc1\u4e66\u94fe\u7ed3\u6784\u5931\u8d25", ex);
        }
        this.parseCTL(data);
    }

    private void parseCTL(InputStream ins) throws PKIException {
        try {
            byte[] content = new byte[ins.available()];
            ins.read(content);
            ins.close();
            this.parseCTL(content);
        }
        catch (Exception ex) {
            throw new PKIException("8172", "\u89e3\u6790P7B\u8bc1\u4e66\u94fe\u7ed3\u6784\u5931\u8d25", ex);
        }
    }

    public void parseCTL(byte[] data) throws PKIException {
        boolean isB64 = Parser.isBase64Encode(data);
        if (isB64) {
            data = Parser.convertBase64(data);
            data = Base64.decode(data);
        }
        if (data[0] != 48) {
            throw new PKIException("8172", "\u89e3\u6790P7B\u8bc1\u4e66\u94fe\u7ed3\u6784\u5931\u8d25", new Exception("The P7B certification chain content error."));
        }
        try {
            ASN1Sequence sequence = (ASN1Sequence)Parser.writeBytes2DERObj(data);
            ContentInfo contentInfo = ContentInfo.getInstance(sequence);
            this.parseCTL(contentInfo);
        }
        catch (Exception ex) {
            throw new PKIException("8172", "\u89e3\u6790P7B\u8bc1\u4e66\u94fe\u7ed3\u6784\u5931\u8d25", ex);
        }
    }

    public ContentInfo generateCTL() throws PKIException, IOException {
        int i;
        DERSet algs = new DERSet();
        if (this.certs == null || this.signers == null) {
            return null;
        }
        DERSet certificates = new DERSet(this.certs);
        DERSet certrevlist = null;
        if (this.crls != null && this.crls.size() != 0) {
            certrevlist = new DERSet(this.crls);
        }
        ASN1EncodableVector signerInfos = new ASN1EncodableVector();
        ASN1EncodableVector digestAlgs = new ASN1EncodableVector();
        Iterator it = this.signers.iterator();
        Signer signer = null;
        DERObjectIdentifier contentTypeOID = new DERObjectIdentifier(PKCSObjectIdentifiers.data.getId());
        while (it.hasNext()) {
            signer = (Signer)it.next();
            AlgorithmIdentifier digAlgId = new AlgorithmIdentifier(new DERObjectIdentifier(signer.GetDigestTypeOID()), new DERNull());
            digestAlgs.add(digAlgId);
            signerInfos.add(signer.toSignerInfo(contentTypeOID, "hello word".getBytes(), true, false));
        }
        ASN1EncodableVector cnt = new ASN1EncodableVector();
        if (this.keyUsg != null) {
            cnt.add(Parser.writeBytes2DERObj(this.keyUsg.encode()));
        }
        if (this.ctlName != null) {
            cnt.add(new DEROctetString(this.ctlName.getBytes()));
        }
        if (this.validDate != null) {
            cnt.add(Parser.writeBytes2DERObj(new Time(this.validDate).getEncoded()));
        }
        if (this.digObj != null) {
            cnt.add(this.digObj);
        }
        ASN1EncodableVector digvec = new ASN1EncodableVector();
        Mechanism mech = this.getDig();
        byte[] dig = null;
        DERSequence tmp = null;
        if (this.xcerts != null) {
            i = 0;
            while (i < this.xcerts.length) {
                dig = this.session.digest(mech, this.xcerts[i].getEncoded());
                tmp = new DERSequence(new DEROctetString(dig));
                digvec.add(tmp.getDERObject());
                ++i;
            }
        }
        if (this.xcrls != null) {
            i = 0;
            while (i < this.xcrls.length) {
                dig = this.session.digest(mech, this.xcrls[i].getEncoded());
                tmp = new DERSequence(new DEROctetString(dig));
                digvec.add(tmp.getDERObject());
                ++i;
            }
        }
        if (this.xcerts != null || this.xcrls != null) {
            cnt.add(new DERSequence(digvec));
        }
        ContentInfo ci = new ContentInfo(PKCSObjectIdentifiers.CTLContentData, new DERSequence(cnt));
        SignedData signedData = new SignedData(new DERInteger(1), this.digSet, ci, certificates, certrevlist, new DERSet(signerInfos));
        ContentInfo contentInfo = new ContentInfo(PKCSObjectIdentifiers.signedData, signedData);
        return contentInfo;
    }

    public void generateCTLFile(String fileName) throws PKIException, IOException {
        ContentInfo contentInfo = this.generateCTL();
        try {
            FileOutputStream fos = new FileOutputStream(fileName);
            DEROutputStream dos = new DEROutputStream(fos);
            dos.writeObject(contentInfo.getDERObject());
            dos.close();
            fos.close();
        }
        catch (Exception ex) {
            throw new PKIException("8171", "\u4ea7\u751fP7B\u8bc1\u4e66\u94fe\u7ed3\u6784\u5931\u8d25", ex);
        }
    }

    public byte[] generateCTLData_DER() throws PKIException, IOException {
        ContentInfo contentInfo = this.generateCTL();
        return Parser.writeDERObj2Bytes(contentInfo.getDERObject());
    }

    public byte[] generateCTLData_B64() throws PKIException, IOException {
        byte[] data = this.generateCTLData_DER();
        data = Base64.encode(data);
        return data;
    }

    public static void main(String[] args) {
        try {
            JCrypto cry = JCrypto.getInstance();
            cry.initialize("JSJY05B_LIB", null);
            Session sess = cry.openSession("JSJY05B_LIB");
            CTL ctl = new CTL(sess);
            X509Certificate cert = null;
            try {
                CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
                FileInputStream fis = new FileInputStream("d:\\root.cer");
                cert = (X509Certificate)certFactory.generateCertificate(fis);
                fis.close();
                cert.getEncoded();
                X509Cert x509 = new X509Cert(cert.getEncoded());
                PKCS12 p12 = new PKCS12();
                FileInputStream fin = new FileInputStream("d:\\key080903.pfx");
                p12.load(fin);
                p12.decrypt("111".toCharArray());
                JKey prvKey = p12.getPrivateKey();
                X509Cert[] certs = p12.getCerts();
                Mechanism sign = new Mechanism("SHA1withRSAEncryption");
                ctl.AddCert(x509);
                ctl.AddDig(new Mechanism("SHA1"));
                ctl.AddSigner(prvKey, certs[0], sign);
                ctl.SetName("this is test");
                Date date = new Date(System.currentTimeMillis() + 86400000L);
                ctl.SetValidDate(date);
                ExtendedKeyUsageExt keyusg = new ExtendedKeyUsageExt();
                keyusg.addExtendedKeyUsage(ExtendedKeyUsageExt.SERVER_AUTH);
                ctl.AddKeyUsg(keyusg);
                ctl.generateCTLFile("d:\\test.stl".toString());
                System.out.println("to generate success...");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Exception ex) {
            System.err.println(ex.toString());
        }
    }

    private class Signer {
        JKey privateKey = null;
        X509Cert cert = null;
        Mechanism sign_Mechanism = null;
        AttributeTable sAttr = null;
        AttributeTable unsAttr = null;
        Session session = null;

        Signer(Session session, JKey key, X509Cert cert, Mechanism sign_Mechanism) {
            this.session = session;
            this.privateKey = key;
            this.cert = cert;
            this.sign_Mechanism = sign_Mechanism;
        }

        Signer(Session session, JKey key, X509Cert cert, Mechanism sign_Mechanism, AttributeTable sAttr, AttributeTable unsAttr) {
            this.session = session;
            this.privateKey = key;
            this.cert = cert;
            this.sign_Mechanism = sign_Mechanism;
            this.sAttr = sAttr;
            this.unsAttr = unsAttr;
        }

        AttributeTable getSignedAttributes() {
            return this.sAttr;
        }

        AttributeTable getUnsignedAttributes() {
            return this.unsAttr;
        }

        JKey getKey() {
            return this.privateKey;
        }

        X509Cert getCertificate() {
            return this.cert;
        }

        Mechanism getSignMechanism() {
            return this.sign_Mechanism;
        }

        String GetDigestTypeName() throws PKIException {
            String digestTypeName = null;
            if (this.sign_Mechanism.getMechanismType().equals("MD2withRSAEncryption")) {
                digestTypeName = "MD2";
            } else if (this.sign_Mechanism.getMechanismType().equals("MD5withRSAEncryption")) {
                digestTypeName = "MD5";
            } else if (this.sign_Mechanism.getMechanismType().equals("SHA1withRSAEncryption")) {
                digestTypeName = "SHA1";
            } else if (this.sign_Mechanism.getMechanismType().equals("SHA1withDSA")) {
                digestTypeName = "SHA1";
            } else if (this.sign_Mechanism.getMechanismType().equals("SHA256withRSAEncryption")) {
                digestTypeName = "SHA256";
            } else if (this.sign_Mechanism.getMechanismType().equals("SHA384withRSAEncryption")) {
                digestTypeName = "SHA384";
            } else if (this.sign_Mechanism.getMechanismType().equals("SHA512withRSAEncryption")) {
                digestTypeName = "SHA512";
            } else if (this.sign_Mechanism.getMechanismType().equals("SHA1withECDSA")) {
                digestTypeName = "SHA1";
            } else if (this.sign_Mechanism.getMechanismType().equals("SHA224withECDSA")) {
                digestTypeName = "SHA224";
            } else if (this.sign_Mechanism.getMechanismType().equals("SHA256withECDSA")) {
                digestTypeName = "SHA256";
            } else if (this.sign_Mechanism.getMechanismType().equals("SM3withSM2Encryption")) {
                digestTypeName = "SM3";
            } else {
                StringBuffer error = new StringBuffer();
                error.append("\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25");
                error.append(" ");
                error.append("\u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b");
                error.append(" ");
                error.append(this.sign_Mechanism.getMechanismType());
                throw new PKIException("8125", error.toString());
            }
            return digestTypeName;
        }

        String GetEncTypeName() throws PKIException {
            String EncTypeName = null;
            if (this.sign_Mechanism.getMechanismType().equals("MD2withRSAEncryption")) {
                EncTypeName = "RSA";
            } else if (this.sign_Mechanism.getMechanismType().equals("MD5withRSAEncryption")) {
                EncTypeName = "RSA";
            } else if (this.sign_Mechanism.getMechanismType().equals("SHA1withRSAEncryption")) {
                EncTypeName = "RSA";
            } else if (this.sign_Mechanism.getMechanismType().equals("SHA1withDSA")) {
                EncTypeName = "DSA";
            } else if (this.sign_Mechanism.getMechanismType().equals("SHA224withDSA")) {
                EncTypeName = "DSA";
            } else if (this.sign_Mechanism.getMechanismType().equals("SHA256withDSA")) {
                EncTypeName = "DSA";
            } else if (this.sign_Mechanism.getMechanismType().equals("SHA1withECDSA")) {
                EncTypeName = "ECDSA";
            } else if (this.sign_Mechanism.getMechanismType().equals("SHA224withECDSA")) {
                EncTypeName = "ECDSA";
            } else if (this.sign_Mechanism.getMechanismType().equals("SHA256withECDSA")) {
                EncTypeName = "ECDSA";
            } else if (this.sign_Mechanism.getMechanismType().equals("SM3withSM2Encryption")) {
                EncTypeName = "SM2";
            } else {
                StringBuffer error = new StringBuffer();
                error.append("\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25");
                error.append(" ");
                error.append("\u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b");
                error.append(" ");
                error.append(this.sign_Mechanism.getMechanismType());
                throw new PKIException("8125", error.toString());
            }
            return EncTypeName;
        }

        private String GetSignatureAlgTypeOID() {
            String SignatureAlgorithm = this.sign_Mechanism.getMechanismType();
            if (SignatureAlgorithm.equals("SHA1withRSAEncryption")) {
                return "1.2.840.113549.1.1.5";
            }
            if (SignatureAlgorithm.equals("SHA256withRSAEncryption")) {
                return "1.2.840.113549.1.1.11";
            }
            if (SignatureAlgorithm.equals("SHA384withRSAEncryption")) {
                return "1.2.840.113549.1.1.12";
            }
            if (SignatureAlgorithm.equals("SHA512withRSAEncryption")) {
                return "1.2.840.113549.1.1.13";
            }
            if (SignatureAlgorithm.equals("MD5withRSAEncryption")) {
                return "1.2.840.113549.1.1.4";
            }
            if (SignatureAlgorithm.equals("MD2withRSAEncryption")) {
                return "1.2.840.113549.1.1.2";
            }
            if (SignatureAlgorithm.equals("SHA1withECDSA")) {
                return "1.2.840.10045.4.1";
            }
            if (SignatureAlgorithm.equals("SHA224withECDSA")) {
                return "1.2.840.10045.4.3.1";
            }
            if (SignatureAlgorithm.equals("SHA256withECDSA")) {
                return "1.2.840.10045.4.3.2";
            }
            if (SignatureAlgorithm.equals("SHA1withDSA")) {
                return "1.2.840.10040.4.3";
            }
            if (SignatureAlgorithm.equals("SHA224withDSA")) {
                return "2.16.840.1.101.3.4.3.1";
            }
            if (SignatureAlgorithm.equals("SHA256withDSA")) {
                return "2.16.840.1.101.3.4.3.2";
            }
            if (SignatureAlgorithm.equals("SM3withSM2Encryption")) {
                return "1.2.156.10197.1.501";
            }
            return null;
        }

        String GetDigestTypeOID() throws PKIException {
            String digestTypeOID = null;
            if (this.sign_Mechanism.getMechanismType().equals("MD2withRSAEncryption")) {
                digestTypeOID = "1.2.840.113549.2.2";
            } else if (this.sign_Mechanism.getMechanismType().equals("MD5withRSAEncryption")) {
                digestTypeOID = "1.2.840.113549.2.5";
            } else if (this.sign_Mechanism.getMechanismType().equals("SHA1withRSAEncryption")) {
                digestTypeOID = "1.3.14.3.2.26";
            } else if (this.sign_Mechanism.getMechanismType().equals("SHA1withDSA")) {
                digestTypeOID = "1.3.14.3.2.26";
            } else if (this.sign_Mechanism.getMechanismType().equals("SHA256withRSAEncryption")) {
                digestTypeOID = "2.16.840.1.101.3.4.2.1";
            } else if (this.sign_Mechanism.getMechanismType().equals("SHA384withRSAEncryption")) {
                digestTypeOID = "2.16.840.1.101.3.4.2.2";
            } else if (this.sign_Mechanism.getMechanismType().equals("SHA512withRSAEncryption")) {
                digestTypeOID = "2.16.840.1.101.3.4.2.2";
            } else if (this.sign_Mechanism.getMechanismType().equals("SHA1withECDSA")) {
                digestTypeOID = "1.3.14.3.2.26";
            } else if (this.sign_Mechanism.getMechanismType().equals("SHA224withECDSA")) {
                digestTypeOID = "2.16.840.1.101.3.4.2.4";
            } else if (this.sign_Mechanism.getMechanismType().equals("SHA256withECDSA")) {
                digestTypeOID = "2.16.840.1.101.3.4.2.1";
            } else if (this.sign_Mechanism.getMechanismType().equals("SHA224withDSA")) {
                digestTypeOID = "2.16.840.1.101.3.4.2.4";
            } else if (this.sign_Mechanism.getMechanismType().equals("SHA256withDSA")) {
                digestTypeOID = "2.16.840.1.101.3.4.2.1";
            } else {
                StringBuffer error = new StringBuffer();
                error.append("\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25");
                error.append(" ");
                error.append("\u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b");
                error.append(" ");
                error.append(this.sign_Mechanism.getMechanismType());
                throw new PKIException("8125", error.toString());
            }
            return digestTypeOID;
        }

        String GetEncTypeOID() throws PKIException {
            String EncTypeOID = null;
            if (this.sign_Mechanism.getMechanismType().equals("MD2withRSAEncryption")) {
                EncTypeOID = "1.2.840.113549.1.1.1";
            } else if (this.sign_Mechanism.getMechanismType().equals("MD5withRSAEncryption")) {
                EncTypeOID = "1.2.840.113549.1.1.1";
            } else if (this.sign_Mechanism.getMechanismType().equals("SHA1withRSAEncryption")) {
                EncTypeOID = "1.2.840.113549.1.1.1";
            } else if (this.sign_Mechanism.getMechanismType().equals("SHA1withDSA")) {
                EncTypeOID = "1.2.840.10040.4.3";
            } else if (this.sign_Mechanism.getMechanismType().equals("SHA256withRSAEncryption")) {
                EncTypeOID = "1.2.840.113549.1.1.1";
            } else if (this.sign_Mechanism.getMechanismType().equals("SHA384withRSAEncryption")) {
                EncTypeOID = "1.2.840.113549.1.1.1";
            } else if (this.sign_Mechanism.getMechanismType().equals("SHA512withRSAEncryption")) {
                EncTypeOID = "1.2.840.113549.1.1.1";
            } else if (this.sign_Mechanism.getMechanismType().equals("SHA1withECDSA")) {
                EncTypeOID = "1.2.840.10045.4.1";
            } else if (this.sign_Mechanism.getMechanismType().equals("SHA224withECDSA")) {
                EncTypeOID = "1.2.840.10045.4.3.1";
            } else if (this.sign_Mechanism.getMechanismType().equals("SHA256withECDSA")) {
                EncTypeOID = "1.2.840.10045.4.3.2";
            } else if (this.sign_Mechanism.getMechanismType().equals("SHA224withDSA")) {
                EncTypeOID = "2.16.840.1.101.3.4.3.1";
            } else if (this.sign_Mechanism.getMechanismType().equals("SHA256withDSA")) {
                EncTypeOID = "2.16.840.1.101.3.4.3.2";
            } else {
                StringBuffer error = new StringBuffer();
                error.append("\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25");
                error.append(" ");
                error.append("\u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b");
                error.append(" ");
                error.append(this.sign_Mechanism.getMechanismType());
                throw new PKIException("8125", error.toString());
            }
            return EncTypeOID;
        }

        SignerInfo toSignerInfo(DERObjectIdentifier contentType, byte[] content, boolean addDefaultAttributes, boolean setIssuerAndSN) throws PKIException, IOException {
            ASN1EncodableVector v;
            AlgorithmIdentifier digAlgId = new AlgorithmIdentifier(new DERObjectIdentifier(this.GetDigestTypeOID()), new DERNull());
            AlgorithmIdentifier encAlgId = this.GetEncTypeOID().equals("1.2.840.10040.4.3") ? new AlgorithmIdentifier(new DERObjectIdentifier(this.GetEncTypeOID())) : new AlgorithmIdentifier(new DERObjectIdentifier(this.GetEncTypeOID()), new DERNull());
            AlgorithmIdentifier digEncAlgId = new AlgorithmIdentifier(new DERObjectIdentifier(this.GetSignatureAlgTypeOID()), new DERNull());
            DERSet signedAttr = null;
            DERSet unsignedAttr = null;
            Object sig = null;
            Object dig = null;
            byte[] hash = this.session.digest(new Mechanism(this.GetDigestTypeName()), content);
            AttributeTable attr = this.getSignedAttributes();
            if (attr != null) {
                v = new ASN1EncodableVector();
                if (attr.get(CMSAttributes.contentType) == null) {
                    v.add(new Attribute(CMSAttributes.contentType, new DERSet(contentType)));
                } else {
                    v.add(attr.get(CMSAttributes.contentType));
                }
                if (attr.get(CMSAttributes.signingTime) == null) {
                    v.add(new Attribute(CMSAttributes.signingTime, new DERSet(new Time(new Date()))));
                } else {
                    v.add(attr.get(CMSAttributes.signingTime));
                }
                v.add(new Attribute(CMSAttributes.messageDigest, new DERSet(new DEROctetString(hash))));
                Hashtable ats = attr.toHashtable();
                ats.remove(CMSAttributes.contentType);
                ats.remove(CMSAttributes.signingTime);
                ats.remove(CMSAttributes.messageDigest);
                Iterator it = ats.values().iterator();
                while (it.hasNext()) {
                    v.add(Attribute.getInstance(it.next()));
                }
                signedAttr = new DERSet(v);
            } else if (addDefaultAttributes) {
                v = new ASN1EncodableVector();
                v.add(new Attribute(CMSAttributes.contentType, new DERSet(contentType)));
                v.add(new Attribute(CMSAttributes.signingTime, new DERSet(new DERUTCTime(new Date()))));
                v.add(new Attribute(CMSAttributes.messageDigest, new DERSet(new DEROctetString(hash))));
                signedAttr = new DERSet(v);
            }
            attr = this.getUnsignedAttributes();
            if (attr != null) {
                Hashtable ats = attr.toHashtable();
                Iterator it = ats.values().iterator();
                ASN1EncodableVector v2 = new ASN1EncodableVector();
                while (it.hasNext()) {
                    v2.add(Attribute.getInstance(it.next()));
                }
                unsignedAttr = new DERSet(v2);
            }
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            if (signedAttr != null) {
                DEROutputStream dOut = new DEROutputStream(bOut);
                dOut.writeObject(signedAttr);
                dOut.flush();
                dOut.close();
            } else {
                bOut.write(content);
            }
            DEROctetString encDigest = new DEROctetString(this.session.sign(this.sign_Mechanism, this.privateKey, bOut.toByteArray()));
            ByteArrayInputStream bIn = new ByteArrayInputStream(this.cert.getTBSCertificate());
            ASN1InputStream aIn = new ASN1InputStream(bIn);
            TBSCertificateStructure tbs = TBSCertificateStructure.getInstance(aIn.readObject());
            SignerInfo signerInfo = null;
            if (setIssuerAndSN) {
                IssuerAndSerialNumber encSid = new IssuerAndSerialNumber(tbs.getIssuer(), tbs.getSerialNumber().getValue());
                signerInfo = new SignerInfo(new SignerIdentifier(encSid), digAlgId, signedAttr, digEncAlgId, encDigest, unsignedAttr);
            } else {
                X509CertificateStructure certificateStructure = this.cert.getCertStructure();
                SubjectPublicKeyInfo subjectKeyInfo = certificateStructure.getSubjectPublicKeyInfo();
                SubjectKeyIdentifier sujectKeyIdentifer = new SubjectKeyIdentifier(subjectKeyInfo);
                ASN1OctetString encSid = (ASN1OctetString)sujectKeyIdentifer.getDERObject();
                signerInfo = new SignerInfo(new SignerIdentifier(encSid), digAlgId, signedAttr, encAlgId, encDigest, unsignedAttr);
            }
            bOut.flush();
            bOut.close();
            aIn.close();
            bIn.close();
            return signerInfo;
        }
    }
}

