/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.ida.util.pki.km;

import cn.com.jit.ida.util.pki.PKIException;
import cn.com.jit.ida.util.pki.cert.X509Cert;
import cn.com.jit.ida.util.pki.cipher.JKey;
import cn.com.jit.ida.util.pki.cipher.Mechanism;
import cn.com.jit.ida.util.pki.cipher.Session;
import cn.com.jit.ida.util.pki.cipher.param.P7Param;
import cn.com.jit.ida.util.pki.cipher.softsm.Util;
import cn.com.jit.ida.util.pki.pkcs.PKCS7;
import java.math.BigInteger;

public class KMSM2EncKey {
    public static byte[] genWrapPriKey_gm(JKey priKey, Mechanism signMech, JKey sysKey, Mechanism sysEncMech, Mechanism pubenvMech, X509Cert signCert, X509Cert encCert, JKey priData, Session sess) throws PKIException {
        BigInteger sftd;
        try {
            sftd = Util.hardKey2SoftPrivKey(priData);
        }
        catch (Exception ex) {
            throw new PKIException("8190", ex.getMessage());
        }
        byte[] tmpData = Util.byteconvert32(sftd);
        if (tmpData == null) {
            throw new PKIException("8190data convert error");
        }
        byte[] priKeyData = new byte[32 + tmpData.length];
        int i = 0;
        while (i < 32) {
            priKeyData[i] = 0;
            ++i;
        }
        System.arraycopy(tmpData, 0, priKeyData, 32, tmpData.length);
        if (sysKey == null) {
            Mechanism sysMech;
            String type = sysEncMech.getMechanismType();
            if (type.equals("SM4_ECB") || type.equals("SM4_CBC")) {
                sysMech = new Mechanism("SM4");
            } else if (type.equals("SCB2_ECB") || type.equals("SCB2_CBC")) {
                sysMech = new Mechanism("SCB2");
            } else {
                throw new PKIException("8190invalid sys key mech");
            }
            sysKey = sess.generateKey(sysMech, 128);
        }
        sysEncMech.setPad(false);
        X509Cert[] certs = new X509Cert[]{encCert};
        X509Cert[] signCerts = new X509Cert[]{signCert};
        P7Param[] params = new P7Param[]{new P7Param()};
        params[0].SetSignEnvParam(priKey, signMech, certs, null, null, null, sysKey, sysEncMech, pubenvMech, signCerts);
        PKCS7 p7 = new PKCS7(sess);
        p7.setIsSMP7(true);
        return p7.genP7_SignEnv(priKeyData, params);
    }
}

